/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.LimeWireCoreModule;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.version.UpdateInformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Set;
import java.util.Vector;
import org.limewire.io.IpPort;
import org.limewire.net.SocketsManager;

public class Main {
    public static void main(String[] args) {
        Injector injector = Guice.createInjector(new LimeWireCoreModule(MainCallback.class));
        LimeWireCore core = injector.getInstance(LimeWireCore.class);
        core.getLifecycleManager().start();
        NetworkManager networkManager = core.getNetworkManager();
        System.out.println("For a command list type help.");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("LimeRouter> ");
            try {
                String command = in.readLine();
                if (command == null) break;
                if (command.equals("help")) {
                    System.out.println("catcher                  Print host catcher.");
                    System.out.println("connect <host> [<port>]  Connect to a host[:port].");
                    System.out.println("help                     Print this message.");
                    System.out.println("listen <port>            Set the port you are listening on.");
                    System.out.println("query <string>           Send a query to the network.");
                    System.out.println("quit                     Quit the application.");
                    System.out.println("update                   Send pings to update the statistics.");
                } else if (command.equals("quit")) break;
                String[] commands = Main.split(command);
                if (commands.length >= 2 && commands[0].equals("connect")) {
                    try {
                        int port = 6346;
                        if (commands.length >= 3) {
                            port = Integer.parseInt(commands[2]);
                        }
                        System.out.println("Connecting...");
                        core.getConnectionServices().connectToHostAsynchronously(commands[1], port, SocketsManager.ConnectType.PLAIN);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Please specify a valid port.");
                    }
                    continue;
                }
                if (commands.length >= 2 && commands[0].equals("query")) {
                    int i = command.indexOf(32);
                    assert (i != -1 && i < command.length());
                    String query = command.substring(i + 1);
                    SearchServices searchServices = core.getSearchServices();
                    searchServices.query(searchServices.newQueryGUID(), query);
                    continue;
                }
                if (commands.length != 2 || !commands[0].equals("listen")) continue;
                try {
                    int port = Integer.parseInt(commands[1]);
                    networkManager.setListeningPort(port);
                }
                catch (NumberFormatException e) {
                    System.out.println("Please specify a valid port.");
                }
                catch (IOException e) {
                    System.out.println("Couldn't change port.  Try another value.");
                }
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
        System.out.println("Good bye.");
        core.getLifecycleManager().shutdown();
    }

    public static String[] split(String s) {
        int n = (s = s.trim()).length();
        if (n == 0) {
            return new String[0];
        }
        Vector<String> buf = new Vector<String>();
        int i = 0;
        while (i < n) {
            assert (s.charAt(i) != ' ');
            int j = s.indexOf(32, i + 1);
            if (j == -1) {
                j = n;
            }
            buf.add(s.substring(i, j));
            i = j + 1;
            while (j < n && s.charAt(i) == ' ') {
                ++i;
            }
        }
        String[] ret = new String[buf.size()];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = (String)buf.get(i2);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class MainCallback
    implements ActivityCallback {
        private MainCallback() {
        }

        public void connectionInitializing(RoutedConnection c) {
        }

        public void connectionInitialized(RoutedConnection c) {
        }

        public void connectionClosed(RoutedConnection c) {
        }

        public void knownHost(Endpoint e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleQueryResult(RemoteFileDesc rfd, HostData data, Set<? extends IpPort> loc) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("Query hit from " + rfd.getHost() + ":" + rfd.getPort() + ":");
                System.out.println("   " + rfd.getFileName());
            }
        }

        @Override
        public void handleQueryString(String query) {
        }

        public void error(int errorCode) {
            this.error(errorCode, null);
        }

        public void error(Throwable problem, String msg) {
            problem.printStackTrace();
            System.out.println(msg);
        }

        public void error(Throwable problem) {
            problem.printStackTrace();
        }

        public void error(int message, Throwable t) {
            System.out.println("Error: " + message);
            t.printStackTrace();
        }

        @Override
        public void addDownload(Downloader mgr) {
        }

        @Override
        public void removeDownload(Downloader mgr) {
        }

        @Override
        public void addUpload(Uploader mgr) {
        }

        @Override
        public void removeUpload(Uploader mgr) {
        }

        @Override
        public boolean warnAboutSharingSensitiveDirectory(File dir) {
            return false;
        }

        @Override
        public void handleFileEvent(FileManagerEvent evt) {
        }

        @Override
        public void handleSharedFileUpdate(File file) {
        }

        @Override
        public void fileManagerLoading() {
        }

        @Override
        public void acceptChat(InstantMessenger chat) {
        }

        @Override
        public void receiveMessage(InstantMessenger chat, String message) {
        }

        @Override
        public void chatUnavailable(InstantMessenger chatter) {
        }

        @Override
        public void chatErrorMessage(InstantMessenger chatter, String st) {
        }

        @Override
        public void downloadsComplete() {
        }

        @Override
        public void fileManagerLoaded() {
        }

        @Override
        public void uploadsComplete() {
        }

        @Override
        public void promptAboutCorruptDownload(Downloader dloader) {
            dloader.discardCorruptDownload(false);
        }

        @Override
        public void restoreApplication() {
        }

        @Override
        public void showDownloads() {
        }

        @Override
        public String getHostValue(String key) {
            return null;
        }

        @Override
        public void browseHostFailed(GUID guid) {
        }

        @Override
        public void setAnnotateEnabled(boolean enabled) {
        }

        @Override
        public void updateAvailable(UpdateInformation update) {
            if (update.getUpdateCommand() != null) {
                System.out.println("there's a new version out " + update.getUpdateVersion() + ", to get it shutdown limewire and run " + update.getUpdateCommand());
            } else {
                System.out.println("You're running an older version.  Get " + update.getUpdateVersion() + ", from " + update.getUpdateURL());
            }
        }

        @Override
        public boolean isQueryAlive(GUID guid) {
            return false;
        }

        @Override
        public void componentLoading(String component) {
            System.out.println("Loading component: " + component);
        }

        @Override
        public boolean handleMagnets(MagnetOptions[] magnets) {
            return false;
        }

        @Override
        public void handleTorrent(File torrentFile) {
        }

        @Override
        public void acceptedIncomingChanged(boolean status) {
        }

        @Override
        public void handleAddressStateChanged() {
        }

        @Override
        public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent evt) {
        }

        @Override
        public void installationCorrupted() {
        }
    }
}

