/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.io.IOException;
import java.util.Properties;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class NetworkManagerImpl
implements NetworkManager {
    private final Provider<UDPService> udpService;
    private final Provider<Acceptor> acceptor;
    private final Provider<DHTManager> dhtManager;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<ActivityCallback> activityCallback;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public NetworkManagerImpl(Provider<UDPService> udpService, Provider<Acceptor> acceptor, Provider<DHTManager> dhtManager, Provider<ConnectionManager> connectionManager, Provider<ActivityCallback> activityCallback, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.udpService = udpService;
        this.acceptor = acceptor;
        this.dhtManager = dhtManager;
        this.connectionManager = connectionManager;
        this.activityCallback = activityCallback;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(this.getAddress()) && NetworkUtils.isValidPort(this.getPort());
    }

    @Override
    public GUID getUDPConnectBackGUID() {
        return this.udpService.get().getConnectBackGUID();
    }

    @Override
    public boolean isOOBCapable() {
        return this.isGUESSCapable() && this.outOfBandStatistics.isSuccessRateGood() && !this.networkInstanceUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && this.acceptor.get().isAddressExternal() && this.isIpPortValid();
    }

    @Override
    public boolean isGUESSCapable() {
        return this.udpService.get().isGUESSCapable();
    }

    @Override
    public int getNonForcedPort() {
        return this.acceptor.get().getPort(false);
    }

    @Override
    public int getPort() {
        return this.acceptor.get().getPort(true);
    }

    @Override
    public byte[] getNonForcedAddress() {
        return this.acceptor.get().getAddress(false);
    }

    @Override
    public byte[] getAddress() {
        return this.acceptor.get().getAddress(true);
    }

    @Override
    public byte[] getExternalAddress() {
        return this.acceptor.get().getExternalAddress();
    }

    @Override
    public boolean incomingStatusChanged() {
        this.activityCallback.get().handleAddressStateChanged();
        byte[] addr = this.getAddress();
        int port = this.getPort();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(addr)) {
            return false;
        }
        return NetworkUtils.isValidPort(port);
    }

    @Override
    public boolean addressChanged() {
        this.activityCallback.get().handleAddressStateChanged();
        byte[] addr = this.getAddress();
        int port = this.getPort();
        if (!NetworkUtils.isValidAddress(addr)) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(addr)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(port)) {
            return false;
        }
        this.acceptor.get().resetLastConnectBackTime();
        this.dhtManager.get().addressChanged();
        Properties props = new Properties();
        props.put("Listen-IP", NetworkUtils.ip2string(addr) + ":" + port);
        HeaderUpdateVendorMessage huvm = new HeaderUpdateVendorMessage(props);
        for (RoutedConnection c : this.connectionManager.get().getInitializedConnections()) {
            if (c.getConnectionCapabilities().remoteHostSupportsHeaderUpdate() < 1) continue;
            c.send(huvm);
        }
        for (RoutedConnection c : this.connectionManager.get().getInitializedClientConnections()) {
            if (c.getConnectionCapabilities().remoteHostSupportsHeaderUpdate() < 1) continue;
            c.send(huvm);
        }
        return true;
    }

    @Override
    public boolean acceptedIncomingConnection() {
        return this.acceptor.get().acceptedIncoming();
    }

    @Override
    public void setListeningPort(int port) throws IOException {
        this.acceptor.get().setListeningPort(port);
    }

    @Override
    public boolean canReceiveUnsolicited() {
        return this.udpService.get().canReceiveUnsolicited();
    }

    @Override
    public boolean canReceiveSolicited() {
        return this.udpService.get().canReceiveSolicited();
    }

    @Override
    public boolean canDoFWT() {
        return this.udpService.get().canDoFWT();
    }

    @Override
    public int getStableUDPPort() {
        return this.udpService.get().getStableUDPPort();
    }

    @Override
    public GUID getSolicitedGUID() {
        return this.udpService.get().getSolicitedGUID();
    }

    @Override
    public int supportsFWTVersion() {
        return this.udpService.get().canDoFWT() ? 1 : 0;
    }

    @Override
    public boolean isPrivateAddress(byte[] addr) {
        return this.networkInstanceUtils.isPrivateAddress(addr);
    }
}

