/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.PingPongSettings;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class Pinger
implements Runnable {
    public static final int PING_INTERVAL = 3000;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public Pinger(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, ConnectionServices connectionServices, Provider<MessageRouter> messageRouter, PingRequestFactory pingRequestFactory) {
        this.backgroundExecutor = backgroundExecutor;
        this.connectionServices = connectionServices;
        this.messageRouter = messageRouter;
        this.pingRequestFactory = pingRequestFactory;
    }

    public void start() {
        this.backgroundExecutor.scheduleWithFixedDelay(this, 3000L, 3000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (this.connectionServices.isSupernode() && PingPongSettings.PINGS_ACTIVE.getValue()) {
            this.messageRouter.get().broadcastPingRequest(this.pingRequestFactory.createPingRequest((byte)3));
        }
    }
}

