/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushEndpoint
implements HTTPHeaderValue,
IpPort {
    public static final int HEADER_SIZE = 17;
    public static final int PROXY_SIZE = 6;
    public static final byte PLAIN = 0;
    public static final byte PPTLS_BINARY = -128;
    static final byte SIZE_MASK = 7;
    static final byte FWT_VERSION_MASK = 24;
    static final byte FEATURES_MASK = -32;
    public static final String PPTLS_HTTP = "pptls";
    public static final int MAX_PROXIES = 4;
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set<? extends IpPort> _proxies;
    private final IpPort _externalAddr;
    private final PushEndpointCache pushEndpointCache;
    private final NetworkInstanceUtils networkInstanceUtils;

    public PushEndpoint(byte[] guid, Set<? extends IpPort> proxies, byte features, int version, IpPort addr, PushEndpointCache pushEndpointCache, NetworkInstanceUtils networkInstanceUtils) {
        this.pushEndpointCache = pushEndpointCache;
        this.networkInstanceUtils = networkInstanceUtils;
        this._features = features & 0xFFFFFFE0 | version << 3;
        this._fwtVersion = version;
        this._clientGUID = guid;
        this._guid = new GUID(this._clientGUID);
        this._proxies = proxies != null ? (proxies instanceof IpPortSet ? Collections.unmodifiableSet(proxies) : Collections.unmodifiableSet(new IpPortSet((Collection<? extends IpPort>)proxies))) : Collections.emptySet();
        this._externalAddr = addr;
    }

    public byte[] toBytes(boolean includeTLS) {
        Set<? extends IpPort> proxies = this.getProxies();
        int payloadSize = PushEndpoint.getSizeBytes(proxies, includeTLS);
        IpPort addr = this.getValidExternalAddress();
        int FWTVersion = this.supportsFWTVersion();
        if (addr != null && FWTVersion > 0) {
            payloadSize += 6;
        }
        byte[] ret = new byte[payloadSize];
        this.toBytes(ret, 0, proxies, addr, FWTVersion, includeTLS);
        return ret;
    }

    public void toBytes(byte[] where, int offset, boolean includeTLS) {
        this.toBytes(where, offset, this.getProxies(), this.getValidExternalAddress(), this.supportsFWTVersion(), includeTLS);
    }

    private void toBytes(byte[] where, int offset, Set<? extends IpPort> proxies, IpPort address, int FWTVersion, boolean includeTLS) {
        BitNumbers bn;
        int neededSpace = PushEndpoint.getSizeBytes(proxies, includeTLS);
        if (address != null) {
            if (FWTVersion > 0) {
                neededSpace += 6;
            }
        } else {
            FWTVersion = 0;
        }
        if (where.length - offset < neededSpace) {
            throw new IllegalArgumentException("target array too small");
        }
        int featureIdx = offset;
        where[offset] = (byte)(Math.min(4, proxies.size()) | this.getFeatures() | FWTVersion << 3);
        System.arraycopy(this._clientGUID, 0, where, ++offset, 16);
        offset += 16;
        if (address != null && FWTVersion > 0) {
            byte[] addr = address.getInetAddress().getAddress();
            int port = address.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteOrder.short2leb((short)port, where, offset += 4);
            offset += 2;
        }
        int pptlsIdx = offset;
        int i = 0;
        if (includeTLS) {
            for (IpPort ipPort : proxies) {
                if (i >= 4) break;
                if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                    ++offset;
                    break;
                }
                ++i;
            }
        }
        i = 0;
        for (IpPort ipPort : proxies) {
            if (i >= 4) break;
            byte[] addr = ipPort.getInetAddress().getAddress();
            short port = (short)ipPort.getPort();
            System.arraycopy(addr, 0, where, offset, 4);
            ByteOrder.short2leb(port, where, offset += 4);
            offset += 2;
            ++i;
        }
        BitNumbers bitNumbers = bn = includeTLS ? HTTPHeaderUtils.getTLSIndices(proxies, Math.min(proxies.size(), 4)) : BitNumbers.EMPTY_BN;
        if (!bn.isEmpty()) {
            byte[] byArray = bn.toByteArray();
            assert (byArray.length == 1);
            where[pptlsIdx] = byArray[0];
            int n = featureIdx;
            where[n] = (byte)(where[n] | 0xFFFFFF80);
        } else {
            int n = featureIdx;
            where[n] = (byte)(where[n] & 0x7F);
        }
    }

    protected IpPort getValidExternalAddress() {
        IpPort ret = this.getIpPort();
        if (ret == null || !this.networkInstanceUtils.isValidExternalIpPort(ret)) {
            return null;
        }
        assert (!ret.getAddress().equals("1.1.1.1")) : "bogus ip address leaked, field is " + this._externalAddr + " cache contains " + this.pushEndpointCache.getCached(this._guid);
        return ret;
    }

    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends IpPort> getProxies() {
        PushEndpoint pushEndpoint = this;
        synchronized (pushEndpoint) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        PushEndpointCache.CachedPushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        if (current == null) {
            return Collections.emptySet();
        }
        return current.getProxies();
    }

    public static int getSizeBytes(Set<? extends IpPort> proxies, boolean includeTLS) {
        boolean hasTLS = false;
        if (includeTLS) {
            int i = 0;
            for (IpPort ipPort : proxies) {
                if (i >= 4) break;
                if (ipPort instanceof ConnectableImpl && ((Connectable)ipPort).isTLSCapable()) {
                    hasTLS = true;
                    break;
                }
                ++i;
            }
        }
        return 17 + (hasTLS ? 1 : 0) + Math.min(proxies.size(), 4) * 6;
    }

    public int supportsFWTVersion() {
        PushEndpointCache.CachedPushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        int currentVersion = current == null ? this._fwtVersion : current.getFWTVersion();
        return currentVersion;
    }

    public int hashCode() {
        return this._guid.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof PushEndpoint)) {
            return false;
        }
        PushEndpoint o = (PushEndpoint)other;
        return this._guid.equals(o._guid);
    }

    public String toString() {
        String ret = "PE [FEATURES:" + this.getFeatures() + ", FWT Version:" + this.supportsFWTVersion() + ", GUID:" + this._guid + ", address: " + this.getAddress() + ":" + this.getPort() + ", proxies:{ ";
        for (IpPort ipPort : this.getProxies()) {
            ret = ret + ipPort.getInetAddress() + ":" + ipPort.getPort() + " ";
        }
        ret = ret + "}]";
        return ret;
    }

    @Override
    public String httpStringValue() {
        Set<? extends IpPort> proxies;
        StringBuilder httpString = new StringBuilder(this._guid.toHexString()).append(";");
        int fwtVersion = this.supportsFWTVersion();
        if (fwtVersion != 0) {
            httpString.append("fwt").append("/").append(fwtVersion).append(";");
            IpPort address = this.getValidExternalAddress();
            if (address != null) {
                String addr = this.getAddress();
                int port = this.getPort();
                if (!addr.equals("1.1.1.1") && NetworkUtils.isValidPort(port)) {
                    httpString.append(port).append(":").append(addr).append(";");
                }
            }
        }
        if (!(proxies = this.getProxies()).isEmpty()) {
            httpString.append(HTTPHeaderUtils.encodePushProxies(proxies, ";", 4));
        } else {
            httpString.deleteCharAt(httpString.length() - 1);
        }
        return httpString.toString();
    }

    public byte getFeatures() {
        PushEndpointCache.CachedPushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        int currentFeatures = current == null ? this._features : current.getFeatures();
        return (byte)(currentFeatures & 0xFFFFFFE0);
    }

    private IpPort getIpPort() {
        PushEndpointCache.CachedPushEndpoint current = this.pushEndpointCache.getCached(this._guid);
        return current == null || current.getIpPort() == null ? this._externalAddr : current.getIpPort();
    }

    @Override
    public String getAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getAddress() : "1.1.1.1";
    }

    @Override
    public InetAddress getInetAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getInetAddress() : null;
    }

    @Override
    public int getPort() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getPort() : 6346;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        IpPort addr = this.getIpPort();
        return addr != null ? addr.getInetSocketAddress() : null;
    }

    public boolean isLocal() {
        return false;
    }

    public synchronized void updateProxies(boolean good) {
        this._guid = this.pushEndpointCache.updateProxiesFor(this._guid, this, good);
        this._proxies = null;
    }

    public PushEndpoint createClone() {
        return new PushEndpoint(this._guid.bytes(), this.getProxies(), this.getFeatures(), this.supportsFWTVersion(), this.getIpPort(), this.pushEndpointCache, this.networkInstanceUtils);
    }
}

