/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushEndpointCacheImpl
implements PushEndpointCache {
    private final Map<GUID, PushEndpointCache.CachedPushEndpoint> GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final HTTPHeaderUtils httpHeaderUtils;

    @Inject
    PushEndpointCacheImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, HTTPHeaderUtils httpHeaderUtils) {
        backgroundExecutor.scheduleWithFixedDelay(new WeakCleaner(), 30000L, 30000L, TimeUnit.MILLISECONDS);
        this.httpHeaderUtils = httpHeaderUtils;
    }

    @Override
    public void overwriteProxies(byte[] guid, String httpString) {
        Set<Connectable> newSet = this.httpHeaderUtils.decodePushProxies(httpString, ",");
        this.overwriteProxies(guid, newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteProxies(byte[] guid, Set<? extends IpPort> newSet) {
        GUID g = new GUID(guid);
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            PushEndpointCache.CachedPushEndpoint wrapper = this.GUID_PROXY_MAP.get(g);
            if (wrapper == null) {
                wrapper = new CachedPushEndpointImpl(g);
                this.GUID_PROXY_MAP.put(g, wrapper);
            }
            wrapper.overwriteProxies(newSet);
        }
    }

    @Override
    public void setAddr(byte[] guid, IpPort addr) {
        GUID g = new GUID(guid);
        PushEndpointCache.CachedPushEndpoint current = this.getCached(g);
        if (current != null) {
            current.setIpPort(addr);
        }
    }

    @Override
    public void setFeatures(byte[] guid, int features) {
        GUID g = new GUID(guid);
        PushEndpointCache.CachedPushEndpoint current = this.getCached(g);
        if (current != null) {
            current.setFeatures(features);
        }
    }

    @Override
    public void setFWTVersionSupported(byte[] guid, int version) {
        GUID g = new GUID(guid);
        PushEndpointCache.CachedPushEndpoint current = this.getCached(g);
        if (current != null) {
            current.setFWTVersion(version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushEndpointCache.CachedPushEndpoint getCached(GUID guid) {
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            return this.GUID_PROXY_MAP.get(guid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID updateProxiesFor(GUID guid, PushEndpoint pushEndpoint, boolean valid) {
        PushEndpointCache.CachedPushEndpoint existing;
        GUID guidRef = null;
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            existing = this.GUID_PROXY_MAP.get(guid);
            if (existing != null) {
                guidRef = existing.getGuid();
            }
            if (existing == null || guidRef == null) {
                existing = new CachedPushEndpointImpl(guid, pushEndpoint.getFeatures(), pushEndpoint.supportsFWTVersion());
                if (valid) {
                    existing.updateProxies(pushEndpoint.getProxies(), true);
                } else {
                    existing.updateProxies(IpPort.EMPTY_SET, true);
                }
                this.GUID_PROXY_MAP.put(guid, existing);
                return guid;
            }
        }
        existing.updateProxies(pushEndpoint.getProxies(), valid);
        return guidRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<GUID, PushEndpointCache.CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            this.GUID_PROXY_MAP.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedPushEndpointImpl
    implements PushEndpointCache.CachedPushEndpoint {
        private final WeakReference<GUID> _guidRef;
        private Set<IpPort> _proxies;
        private int _features;
        private int _fwtVersion;
        private IpPort _externalAddr;

        CachedPushEndpointImpl(GUID guid) {
            this(guid, 0, 0);
        }

        CachedPushEndpointImpl(GUID guid, int features, int version) {
            this._guidRef = new WeakReference<GUID>(guid);
            this._features = features;
            this._fwtVersion = version;
        }

        @Override
        public synchronized void updateProxies(Set<? extends IpPort> s, boolean add) {
            IpPortSet existing = new IpPortSet();
            if (s == null) {
                s = this._proxies;
            }
            if (this._proxies != null) {
                existing.addAll(this._proxies);
            }
            if (add) {
                existing.addAll(s);
            } else {
                existing.removeAll(s);
            }
            this.overwriteProxies(existing);
        }

        @Override
        public synchronized void overwriteProxies(Set<? extends IpPort> s) {
            this._proxies = Collections.unmodifiableSet(s);
        }

        @Override
        public synchronized Set<IpPort> getProxies() {
            return this._proxies != null ? this._proxies : IpPort.EMPTY_SET;
        }

        @Override
        public synchronized int getFeatures() {
            return this._features;
        }

        @Override
        public synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        @Override
        public synchronized void setFeatures(int features) {
            this._features = features;
        }

        @Override
        public synchronized void setFWTVersion(int version) {
            this._fwtVersion = version;
        }

        @Override
        public synchronized void setIpPort(IpPort addr) {
            this._externalAddr = addr;
        }

        @Override
        public synchronized IpPort getIpPort() {
            return this._externalAddr;
        }

        @Override
        public GUID getGuid() {
            return (GUID)this._guidRef.get();
        }
    }

    private final class WeakCleaner
    implements Runnable {
        private WeakCleaner() {
        }

        public void run() {
            PushEndpointCacheImpl.this.GUID_PROXY_MAP.size();
        }
    }
}

