/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.SelfEndpoint;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IPPortCombo;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushEndpointFactoryImpl
implements PushEndpointFactory {
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final Provider<SelfEndpoint> selfProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public PushEndpointFactoryImpl(Provider<PushEndpointCache> pushEndpointCache, Provider<SelfEndpoint> selfProvider, NetworkInstanceUtils networkInstanceUtils) {
        this.pushEndpointCache = pushEndpointCache;
        this.selfProvider = selfProvider;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid) {
        return this.createPushEndpoint(guid, IpPort.EMPTY_SET);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid, Set<? extends IpPort> proxies) {
        return this.createPushEndpoint(guid, proxies, (byte)0, 0);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid, Set<? extends IpPort> proxies, byte features, int version) {
        return this.createPushEndpoint(guid, proxies, features, version, null);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] guid, Set<? extends IpPort> proxies, byte features, int version, IpPort addr) {
        return new PushEndpoint(guid, proxies, features, version, addr, this.pushEndpointCache.get(), this.networkInstanceUtils);
    }

    @Override
    public PushEndpoint createPushEndpoint(String httpString) throws IOException {
        byte[] guid;
        if (httpString.length() < 32 || httpString.indexOf(";") > 32) {
            throw new IOException("http string does not contain valid guid");
        }
        String guidS = httpString.substring(0, 32);
        httpString = httpString.substring(32);
        try {
            guid = GUID.fromHexString(guidS);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
        StringTokenizer tok = new StringTokenizer(httpString, ";");
        IpPortSet proxies = new IpPortSet();
        int fwtVersion = 0;
        IpPort addr = null;
        BitNumbers tlsProxies = null;
        while (tok.hasMoreTokens()) {
            String current = tok.nextToken().trim();
            if (current.startsWith("fwt")) {
                fwtVersion = (int)HTTPUtils.parseFeatureToken(current);
                continue;
            }
            if (proxies.size() == 0 && current.startsWith("pptls")) {
                String value = HTTPUtils.parseValue(current);
                if (value == null) continue;
                try {
                    tlsProxies = new BitNumbers(value);
                    continue;
                }
                catch (IllegalArgumentException invalid) {
                    throw (IOException)new IOException().initCause(invalid);
                }
            }
            if (proxies.size() < 4) {
                boolean tlsCapable = tlsProxies != null && tlsProxies.isSet(proxies.size());
                try {
                    Connectable ipp = NetworkUtils.parseIpPort(current, tlsCapable);
                    if (this.networkInstanceUtils.isPrivateAddress(ipp.getInetAddress())) continue;
                    proxies.add(ipp);
                    continue;
                }
                catch (IOException ohWell) {
                    tlsProxies = null;
                }
            }
            if (addr != null) continue;
            try {
                IpPort ipp = NetworkUtils.parsePortIp(current);
                if (this.networkInstanceUtils.isPrivateAddress(ipp.getInetAddress())) continue;
                addr = ipp;
            }
            catch (IOException notBad) {}
        }
        if (addr == null || !this.networkInstanceUtils.isValidExternalIpPort(addr)) {
            fwtVersion = 0;
            addr = null;
        }
        return this.createPushEndpoint(guid, proxies, (byte)(proxies.size() | fwtVersion << 3), fwtVersion, addr);
    }

    @Override
    public PushEndpoint createFromBytes(DataInputStream dais) throws BadPacketException, IOException {
        byte[] guid = new byte[16];
        IpPortSet proxies = new IpPortSet();
        IPPortCombo addr = null;
        byte header = (byte)(dais.read() & 0xFF);
        int number = header & 7;
        byte features = (byte)(header & 0xFFFFFFE0);
        byte version = (byte)((header & 0x18) >> 3);
        dais.readFully(guid);
        if (version > 0) {
            byte[] host = new byte[6];
            dais.readFully(host);
            try {
                addr = IPPortCombo.getCombo(host);
            }
            catch (InvalidDataException ide) {
                throw new BadPacketException(ide);
            }
            if (addr.getAddress().equals("1.1.1.1")) {
                addr = null;
                version = 0;
            }
        }
        BitNumbers bn = null;
        if ((features & 0xFFFFFF80) != 0) {
            byte[] tlsIndexes = new byte[1];
            dais.readFully(tlsIndexes);
            bn = new BitNumbers(tlsIndexes);
        }
        byte[] tmp = new byte[6];
        for (int i = 0; i < number; ++i) {
            dais.readFully(tmp);
            try {
                IpPort ipp = IPPortCombo.getCombo(tmp);
                if (bn != null && bn.isSet(i)) {
                    ipp = new ConnectableImpl(ipp, true);
                }
                proxies.add(ipp);
                continue;
            }
            catch (InvalidDataException ide) {
                throw new BadPacketException(ide);
            }
        }
        PushEndpoint pe = this.createPushEndpoint(guid, proxies, features, version, addr);
        pe.updateProxies(true);
        return pe;
    }

    @Override
    public PushEndpoint createForSelf() {
        return this.selfProvider.get();
    }
}

