/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.http.HTTPConnectionData;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NBSocket;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.rudp.UDPSelectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class PushManager {
    private static final Log LOG = LogFactory.getLog(PushManager.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private final Provider<FileManager> fileManager;
    private final Provider<SocketsManager> socketsManager;
    private final Provider<HTTPAcceptor> httpAcceptor;
    private final Provider<UDPSelectorProvider> udpSelectorProvider;

    @Inject
    public PushManager(Provider<FileManager> fileManager, Provider<SocketsManager> socketsManager, Provider<HTTPAcceptor> httpAcceptor, Provider<UDPSelectorProvider> udpSelectorProvider) {
        this.fileManager = fileManager;
        this.socketsManager = socketsManager;
        this.httpAcceptor = httpAcceptor;
        this.udpSelectorProvider = udpSelectorProvider;
    }

    public void acceptPushUpload(String host, int port, String guid, boolean lan, boolean isFWTransfer, boolean tlsCapable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accepting Push Upload from ip:" + host + " port:" + port + " FW:" + isFWTransfer);
        }
        if (host == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (this.fileManager.get().getNumFiles() < 1 && this.fileManager.get().getNumIncompleteFiles() < 1) {
            return;
        }
        PushData data = new PushData(host, port, guid, lan);
        if (isFWTransfer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding push observer FW-FW to host: " + host + ":" + port);
            }
            AbstractNBSocket socket = this.udpSelectorProvider.get().openSocketChannel().socket();
            ((NBSocket)socket).connect(new InetSocketAddress(host, port), 20000, new PushObserver(data, true, this.httpAcceptor.get()));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding push observer to host: " + host + ":" + port);
            }
            try {
                SocketsManager.ConnectType type = tlsCapable && SSLSettings.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
                this.socketsManager.get().connect(new InetSocketAddress(host, port), 10000, new PushObserver(data, false, this.httpAcceptor.get()), type);
            }
            catch (IOException iox) {
                // empty catch block
            }
        }
    }

    private static class PushConnector
    implements ChannelWriter {
        private InterestWritableByteChannel channel;
        private final ByteBuffer buffer;
        private final Socket socket;
        private HTTPConnectionData data;
        private HTTPAcceptor httpAcceptor;

        public PushConnector(Socket socket, PushData data, boolean fwTransfer, HTTPAcceptor httpAcceptor) throws IOException {
            this.socket = socket;
            this.data = new HTTPConnectionData();
            this.data.setPush(true);
            this.data.setLocal(data.isLan());
            this.data.setFirewalled(fwTransfer);
            this.httpAcceptor = httpAcceptor;
            socket.setSoTimeout(30000);
            String giv = "GIV 0:" + data.getGuid() + "/file\n\n";
            this.buffer = ByteBuffer.wrap(giv.getBytes());
        }

        public boolean handleWrite() throws IOException {
            if (!this.buffer.hasRemaining()) {
                return false;
            }
            while (this.buffer.hasRemaining()) {
                int written = this.channel.write(this.buffer);
                if (written != 0) continue;
                return true;
            }
            this.httpAcceptor.acceptConnection(this.socket, this.data);
            return false;
        }

        public void handleIOException(IOException iox) {
            throw new RuntimeException();
        }

        public void shutdown() {
        }

        public InterestWritableByteChannel getWriteChannel() {
            return this.channel;
        }

        public void setWriteChannel(InterestWritableByteChannel newChannel) {
            this.channel = newChannel;
            if (newChannel != null) {
                newChannel.interestWrite(this, true);
            }
        }
    }

    private static class PushObserver
    implements ConnectObserver {
        private final PushData data;
        private final boolean fwt;
        private final HTTPAcceptor httpAcceptor;

        PushObserver(PushData data, boolean fwt, HTTPAcceptor httpAcceptor) {
            this.data = data;
            this.fwt = fwt;
            this.httpAcceptor = httpAcceptor;
        }

        public void handleIOException(IOException iox) {
        }

        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " failed");
            }
        }

        public void handleConnect(Socket socket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " succeeded");
            }
            ((NIOMultiplexor)((Object)socket)).setWriteObserver(new PushConnector(socket, this.data, this.fwt, this.httpAcceptor));
        }
    }

    private static class PushData {
        private final String host;
        private final int port;
        private final String guid;
        private final boolean lan;

        PushData(String host, int port, String guid, boolean lan) {
            this.host = host;
            this.port = port;
            this.guid = guid;
            this.lan = lan;
        }

        public boolean isLan() {
            return this.lan;
        }

        public String getGuid() {
            return this.guid;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

