/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import com.limegroup.gnutella.statistics.QueryStats;
import java.util.Set;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SearchServicesImpl
implements SearchServices {
    private final Provider<ResponseVerifier> responseVerifier;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<ConnectionServices> connectionServices;
    private final Provider<QueryDispatcher> queryDispatcher;
    private final Provider<MutableGUIDFilter> mutableGUIDFilter;
    private final Provider<QueryStats> queryStats;
    private final Provider<NetworkManager> networkManager;
    private final Provider<QueryRequestFactory> queryRequestFactory;
    private final BrowseHostHandlerManager browseHostHandlerManager;
    private final OutOfBandStatistics outOfBandStatistics;

    @Inject
    public SearchServicesImpl(Provider<ResponseVerifier> responseVerifier, Provider<QueryUnicaster> queryUnicaster, Provider<SearchResultHandler> searchResultHandler, Provider<MessageRouter> messageRouter, Provider<ConnectionServices> connectionServices, Provider<QueryDispatcher> queryDispatcher, Provider<MutableGUIDFilter> mutableGUIDFilter, Provider<QueryStats> queryStats, Provider<NetworkManager> networkManager, Provider<QueryRequestFactory> queryRequestFactory, BrowseHostHandlerManager browseHostHandlerManager, OutOfBandStatistics outOfBandStatistics) {
        this.responseVerifier = responseVerifier;
        this.queryUnicaster = queryUnicaster;
        this.searchResultHandler = searchResultHandler;
        this.messageRouter = messageRouter;
        this.connectionServices = connectionServices;
        this.queryDispatcher = queryDispatcher;
        this.mutableGUIDFilter = mutableGUIDFilter;
        this.queryStats = queryStats;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.browseHostHandlerManager = browseHostHandlerManager;
        this.outOfBandStatistics = outOfBandStatistics;
    }

    @Override
    public BrowseHostHandler doAsynchronousBrowseHost(final Connectable host, GUID guid, GUID serventID, final Set<? extends IpPort> proxies, final boolean canDoFWTransfer) {
        final BrowseHostHandler handler = this.browseHostHandlerManager.createBrowseHostHandler(guid, serventID);
        ThreadExecutor.startThread(new Runnable(){

            public void run() {
                handler.browseHost(host, proxies, canDoFWTransfer);
            }
        }, "BrowseHoster");
        return handler;
    }

    @Override
    public boolean isMandragoreWorm(byte[] guid, Response response) {
        return this.responseVerifier.get().isMandragoreWorm(guid, response);
    }

    @Override
    public boolean matchesQuery(byte[] guid, Response response) {
        return this.responseVerifier.get().matchesQuery(guid, response);
    }

    @Override
    public boolean matchesType(byte[] guid, Response response) {
        return this.responseVerifier.get().matchesType(guid, response);
    }

    @Override
    public void stopQuery(GUID guid) {
        this.queryUnicaster.get().purgeQuery(guid);
        this.searchResultHandler.get().removeQuery(guid);
        this.messageRouter.get().queryKilled(guid);
        if (this.connectionServices.get().isSupernode()) {
            this.queryDispatcher.get().addToRemove(guid);
        }
        this.mutableGUIDFilter.get().removeGUID(guid.bytes());
    }

    @Override
    public long getLastQueryTime() {
        return this.queryStats.get().getLastQueryTime();
    }

    private void recordAndSendQuery(QueryRequest qr, MediaType type) {
        this.queryStats.get().recordQuery();
        this.responseVerifier.get().record(qr, type);
        this.searchResultHandler.get().addQuery(qr);
        this.messageRouter.get().sendDynamicQuery(qr);
    }

    @Override
    public void queryWhatIsNew(byte[] guid, MediaType type) {
        try {
            QueryRequest qr = null;
            if (GUID.addressesMatch(guid, this.networkManager.get().getAddress(), this.networkManager.get().getPort())) {
                qr = this.queryRequestFactory.get().createWhatIsNewOOBQuery(guid, (byte)2, type);
                this.outOfBandStatistics.addSentQuery();
            } else {
                qr = this.queryRequestFactory.get().createWhatIsNewQuery(guid, (byte)2, type);
            }
            if (FilterSettings.FILTER_WHATS_NEW_ADULT.getValue()) {
                this.mutableGUIDFilter.get().addGUID(guid);
            }
            this.recordAndSendQuery(qr, type);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    @Override
    public void query(byte[] guid, String query, String richQuery, MediaType type) {
        try {
            QueryRequest qr = null;
            if (this.networkManager.get().isIpPortValid() && new GUID(guid).addressesMatch(this.networkManager.get().getAddress(), this.networkManager.get().getPort())) {
                qr = this.queryRequestFactory.get().createOutOfBandQuery(guid, query, richQuery, type);
                this.outOfBandStatistics.addSentQuery();
            } else {
                qr = this.queryRequestFactory.get().createQuery(guid, query, richQuery, type);
            }
            this.recordAndSendQuery(qr, type);
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    @Override
    public void query(byte[] guid, String query) {
        this.query(guid, query, null);
    }

    @Override
    public void query(byte[] guid, String query, MediaType type) {
        this.query(guid, query, "", type);
    }

    @Override
    public byte[] newQueryGUID() {
        byte[] ret = this.networkManager.get().isOOBCapable() && this.outOfBandStatistics.isOOBEffectiveForMe() ? GUID.makeAddressEncodedGuid(this.networkManager.get().getAddress(), this.networkManager.get().getPort()) : GUID.makeGuid();
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(ret);
        }
        return ret;
    }
}

