/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.DataUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.limewire.io.NetworkUtils;

public final class UDPReplyHandler
implements ReplyHandler {
    private final InetSocketAddress addr;
    private final SpamFilter personalFilter;
    private final UDPService udpService;

    UDPReplyHandler(InetSocketAddress addr, SpamFilter personalFilter, UDPService udpService) {
        this.udpService = udpService;
        if (!NetworkUtils.isValidSocketAddress(addr)) {
            throw new IllegalArgumentException("invalid addr: " + addr);
        }
        this.addr = addr;
        this.personalFilter = personalFilter;
    }

    UDPReplyHandler(InetAddress addr, int port, SpamFilter personalFilter, UDPService udpService) {
        this(new InetSocketAddress(addr, port), personalFilter, udpService);
    }

    public void handlePingReply(PingReply pong, ReplyHandler handler) {
        this.udpService.send((Message)pong, this.addr);
    }

    public void handleQueryReply(QueryReply hit, ReplyHandler handler) {
        this.udpService.send((Message)hit, this.addr);
    }

    public void handlePushRequest(PushRequest request, ReplyHandler handler) {
        this.udpService.send((Message)request, this.addr);
    }

    public void countDroppedMessage() {
    }

    public boolean isPersonalSpam(Message m) {
        return !this.personalFilter.allow(m);
    }

    public boolean isOpen() {
        return true;
    }

    public int getNumMessagesReceived() {
        return 0;
    }

    public boolean isOutgoing() {
        return false;
    }

    public boolean isKillable() {
        return false;
    }

    public boolean isSupernodeClientConnection() {
        return false;
    }

    public boolean isLeafConnection() {
        return false;
    }

    public boolean isHighDegreeConnection() {
        return false;
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    public boolean isGoodUltrapeer() {
        return false;
    }

    public boolean isGoodLeaf() {
        return false;
    }

    public boolean supportsPongCaching() {
        return false;
    }

    public boolean allowNewPings() {
        return true;
    }

    public void handleSimppVM(SimppVM simppVM) {
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    public String getAddress() {
        return this.addr.getAddress().getHostAddress();
    }

    public boolean isStable() {
        return false;
    }

    public String getLocalePref() {
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    public String toString() {
        return this.addr.toString();
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong m) {
        this.udpService.send((Message)m, this.addr);
    }

    public void reply(Message m) {
        this.udpService.send(m, this.addr);
    }

    public int getPort() {
        return this.addr.getPort();
    }

    public byte[] getClientGUID() {
        return DataUtils.EMPTY_GUID;
    }
}

