/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.UrnSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class UrnCache {
    private static final Log LOG = LogFactory.getLog(UrnCache.class);
    private static final File URN_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.cache");
    private static final File URN_CACHE_BACKUP_FILE = new File(CommonUtils.getUserSettingsDir(), "fileurns.bak");
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("Hasher");
    private Map<File, List<UrnCallback>> pendingHashing = new HashMap<File, List<UrnCallback>>();
    private volatile boolean dirty = false;
    private final Future<Map<UrnSetKey, Set<URN>>> deserializer = this.QUEUE.submit(new Callable<Map<UrnSetKey, Set<URN>>>(){

        @Override
        public Map<UrnSetKey, Set<URN>> call() {
            Map map = UrnCache.createMap();
            UrnCache.this.dirty = UrnCache.scanAndRemoveOldEntries(map);
            return map;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateAndCacheUrns(File file, UrnCallback callback) {
        Set<URN> urns;
        UrnCache urnCache = this;
        synchronized (urnCache) {
            urns = this.getUrns(file);
            if (urns.isEmpty()) {
                List<UrnCallback> list;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding: " + file + " to be hashed.");
                }
                if ((list = this.pendingHashing.get(file)) == null) {
                    list = new ArrayList<UrnCallback>(1);
                    this.pendingHashing.put(file, list);
                }
                list.add(callback);
                this.QUEUE.execute(new Processor(file));
            }
        }
        if (!urns.isEmpty()) {
            callback.urnsCalculated(file, urns);
        }
    }

    public synchronized void clearPendingHashes(Object owner) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all pending hashes owned by: " + owner);
        }
        Iterator<List<UrnCallback>> i = this.pendingHashing.values().iterator();
        while (i.hasNext()) {
            List<UrnCallback> callbacks = i.next();
            for (int j = callbacks.size() - 1; j >= 0; --j) {
                UrnCallback c = callbacks.get(j);
                if (!c.isOwner(owner)) continue;
                callbacks.remove(j);
            }
            if (!callbacks.isEmpty()) continue;
            i.remove();
        }
    }

    public synchronized void clearPendingHashesFor(File file, Object owner) {
        List<UrnCallback> callbacks;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all pending hashes for: " + file + ", owned by: " + owner);
        }
        if ((callbacks = this.pendingHashing.get(file)) != null) {
            for (int j = callbacks.size() - 1; j >= 0; --j) {
                UrnCallback c = callbacks.get(j);
                if (!c.isOwner(owner)) continue;
                callbacks.remove(j);
            }
            if (callbacks.isEmpty()) {
                this.pendingHashing.remove(file);
            }
        }
    }

    public Set<URN> calculateUrns(File file) throws IOException, InterruptedException {
        return URN.createSHA1AndTTRootUrns(file);
    }

    public synchronized Set<URN> getUrns(File file) {
        if (file.lastModified() == 0L) {
            return Collections.emptySet();
        }
        UrnSetKey key = new UrnSetKey(file);
        Set<URN> cachedUrns = this.getUrnMap().get(key);
        if (cachedUrns == null) {
            return Collections.emptySet();
        }
        return cachedUrns;
    }

    public synchronized void removeUrns(File f) {
        UrnSetKey k = new UrnSetKey(f);
        this.getUrnMap().remove(k);
        this.dirty = true;
    }

    public synchronized void addUrns(File file, Set<? extends URN> urns) {
        UrnSetKey key = new UrnSetKey(file);
        this.getUrnMap().put(key, Collections.unmodifiableSet(urns));
        this.dirty = true;
    }

    private static Map createMap() {
        HashMap result = UrnCache.readMap(URN_CACHE_FILE);
        if (result == null) {
            result = UrnCache.readMap(URN_CACHE_BACKUP_FILE);
        }
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map readMap(File file) {
        Map map;
        if (!file.exists()) {
            return null;
        }
        ConverterObjectInputStream ois = null;
        try {
            ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            map = (Map)ois.readObject();
        }
        catch (Throwable t) {
            Map map2;
            try {
                LOG.error("Unable to read UrnCache", t);
                map2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(ois);
                throw throwable;
            }
            IOUtils.close(ois);
            return map2;
        }
        IOUtils.close(ois);
        return map;
    }

    private static boolean scanAndRemoveOldEntries(Map<Object, Object> map) {
        boolean dirty = false;
        Iterator<Map.Entry<Object, Object>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            if (!(entry.getKey() instanceof UrnSetKey)) {
                i.remove();
                dirty = true;
                continue;
            }
            UrnSetKey key = (UrnSetKey)entry.getKey();
            File f = new File(key._path);
            if (!f.exists() || f.lastModified() != key._modTime) {
                dirty = true;
                i.remove();
                continue;
            }
            if (!(entry.getValue() instanceof Set)) {
                i.remove();
                dirty = true;
                continue;
            }
            Set<URN> set = GenericsUtils.scanForSet(entry.getValue(), URN.class, GenericsUtils.ScanMode.NEW_COPY_REMOVED, UrnSet.class);
            if (set.isEmpty()) {
                i.remove();
                dirty = true;
                continue;
            }
            if (set == entry.getValue()) continue;
            dirty = true;
            entry.setValue(Collections.unmodifiableSet(set));
        }
        return dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        this.getUrnMap();
        if (!this.dirty) {
            return;
        }
        URN_CACHE_FILE.renameTo(URN_CACHE_BACKUP_FILE);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(URN_CACHE_FILE)));
            oos.writeObject(this.getUrnMap());
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException e) {
            LOG.error("Unable to persist cache", e);
        }
        finally {
            IOUtils.close(oos);
        }
        this.dirty = false;
    }

    private Map<UrnSetKey, Set<URN>> getUrnMap() {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                Map<UrnSetKey, Set<URN>> map = this.deserializer.get();
                return map;
            }
            catch (InterruptedException tryAgain) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class UrnSetKey
    implements Serializable {
        static final long serialVersionUID = -7183232365833531645L;
        transient long _modTime;
        transient String _path;
        transient int _hashCode;

        UrnSetKey(File file) {
            this._modTime = file.lastModified();
            this._path = file.getAbsolutePath();
            this._hashCode = this.calculateHashCode();
        }

        int calculateHashCode() {
            int result = 17;
            result = result * 37 + (int)(this._modTime ^ this._modTime >>> 32);
            result = result * 37 + this._path.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UrnSetKey)) {
                return false;
            }
            UrnSetKey key = (UrnSetKey)o;
            return this._modTime == key._modTime && this._path.equals(key._path);
        }

        public int hashCode() {
            return this._hashCode;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            s.writeLong(this._modTime);
            s.writeObject(this._path);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this._modTime = s.readLong();
            this._path = (String)s.readObject();
            this._hashCode = this.calculateHashCode();
        }
    }

    private class Processor
    implements Runnable {
        private final File file;

        Processor(File f) {
            this.file = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set<URN> urns;
            List callbacks;
            UrnCache urnCache = UrnCache.this;
            synchronized (urnCache) {
                callbacks = (List)UrnCache.this.pendingHashing.remove(this.file);
                urns = UrnCache.this.getUrns(this.file);
            }
            if (callbacks != null && !callbacks.isEmpty()) {
                if (urns.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Hashing file: " + this.file);
                    }
                    try {
                        urns = UrnCache.this.calculateUrns(this.file);
                        UrnCache.this.addUrns(this.file, urns);
                    }
                    catch (IOException ignored) {
                        LOG.warn("Unable to calculate URNs", ignored);
                    }
                    catch (InterruptedException ignored) {
                        LOG.warn("Unable to calculate URNs", ignored);
                    }
                }
                for (int i = 0; i < callbacks.size(); ++i) {
                    ((UrnCallback)callbacks.get(i)).urnsCalculated(this.file, urns);
                }
            }
        }
    }
}

