/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrnSet
implements Set<URN>,
Iterable<URN>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1065284624401321676L;
    private URN sha1;
    private URN ttroot;

    public UrnSet() {
    }

    public UrnSet(URN urn) {
        this.add(urn);
    }

    public UrnSet(Collection<? extends URN> c) {
        this.addAll(c);
    }

    public String toString() {
        return this.isEmpty() ? "{Empty UrnSet}" : "UrnSet of: " + this.sha1;
    }

    public UrnSet clone() {
        UrnSet c = new UrnSet();
        c.sha1 = this.sha1;
        return c;
    }

    @Override
    public int hashCode() {
        return this.sha1 == null ? 0 : this.sha1.hashCode();
    }

    URN getSHA1() {
        return this.sha1;
    }

    URN getTTRoot() {
        return this.ttroot;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public boolean add(URN o) {
        if (o.isSHA1() && this.sha1 == null) {
            this.sha1 = o;
            return true;
        }
        if (o.isTTRoot() && this.ttroot == null) {
            this.ttroot = o;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends URN> c) {
        boolean ret = false;
        for (URN uRN : c) {
            ret |= this.add(uRN);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.sha1 = null;
        this.ttroot = null;
    }

    @Override
    public boolean contains(Object o) {
        return o.equals(this.sha1) || o.equals(this.ttroot);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.size() > 2) {
            return false;
        }
        if (c.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean ret = true;
        for (Object o : c) {
            ret &= this.contains(o);
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.sha1 == null && this.ttroot == null;
    }

    @Override
    public Iterator<URN> iterator() {
        return new UrnIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (this.sha1 != null && o.equals(this.sha1)) {
            this.sha1 = null;
            return true;
        }
        if (this.ttroot != null && o.equals(this.ttroot)) {
            this.ttroot = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.sha1 == null && this.ttroot == null || c.isEmpty()) {
            return false;
        }
        boolean ret = false;
        for (Object o : c) {
            ret |= this.remove(o);
            if (!this.isEmpty()) continue;
            break;
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = false;
        if (this.sha1 != null && !c.contains(this.sha1)) {
            this.sha1 = null;
            ret = true;
        }
        if (this.ttroot != null && !c.contains(this.ttroot)) {
            this.ttroot = null;
            ret = true;
        }
        return ret;
    }

    @Override
    public int size() {
        int ret = 0;
        if (this.sha1 != null) {
            ++ret;
        }
        if (this.ttroot != null) {
            ++ret;
        }
        return ret;
    }

    @Override
    public Object[] toArray() {
        switch (this.size()) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                URN o = this.sha1 != null ? this.sha1 : this.ttroot;
                return new Object[]{o};
            }
            case 2: {
                return new Object[]{this.sha1, this.ttroot};
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        switch (size) {
            case 1: {
                URN present = this.sha1 != null ? this.sha1 : this.ttroot;
                a[0] = present;
                break;
            }
            case 2: {
                a[0] = this.sha1;
                a[1] = this.ttroot;
            }
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UrnIterator
    implements Iterator<URN> {
        private boolean givenSHA1;
        private boolean givenTTRoot;

        private UrnIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.givenSHA1 && UrnSet.this.sha1 != null || !this.givenTTRoot && UrnSet.this.ttroot != null;
        }

        @Override
        public URN next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.givenSHA1 && UrnSet.this.sha1 != null) {
                this.givenSHA1 = true;
                return UrnSet.this.sha1;
            }
            if (!this.givenTTRoot && UrnSet.this.ttroot != null) {
                this.givenTTRoot = true;
                return UrnSet.this.ttroot;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (!this.givenSHA1 && !this.givenTTRoot) {
                throw new IllegalStateException();
            }
            if (this.givenTTRoot) {
                UrnSet.this.ttroot = null;
            } else if (this.givenSHA1) {
                UrnSet.this.sha1 = null;
            }
        }
    }
}

