/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.messages.Message;
import java.net.UnknownHostException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

public class IpPortContentAuthority
implements ContentAuthority {
    private IpPort authority;
    private String host;
    private int port;
    private final UDPService udpService;

    IpPortContentAuthority(IpPort host, UDPService udpService) {
        this.authority = host;
        this.udpService = udpService;
        this.host = host.getAddress();
        this.port = host.getPort();
    }

    IpPortContentAuthority(String host, int port, UDPService udpService) {
        this.host = host;
        this.port = port;
        this.udpService = udpService;
    }

    public void send(Message m) {
        this.udpService.send(m, this.authority);
    }

    public boolean initialize() {
        if (this.authority == null) {
            try {
                this.authority = new IpPortImpl(this.host, this.port);
            }
            catch (UnknownHostException uhe) {
                return false;
            }
        }
        return true;
    }

    public IpPort getIpPort() {
        return this.authority;
    }
}

