/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.google.inject.Inject;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.auth.IpPortContentAuthority;
import com.limegroup.gnutella.auth.IpPortContentAuthorityFactory;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.ContentSettings;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import org.limewire.io.IpPortImpl;

public class SettingsBasedContentAuthority
implements ContentAuthority {
    private ContentAuthority[] authorities;
    private Random RNG = this.newRandom();
    private final IpPortContentAuthorityFactory ipPortContentAuthorityFactory;

    @Inject
    public SettingsBasedContentAuthority(IpPortContentAuthorityFactory ipPortContentAuthorityFactory) {
        this.ipPortContentAuthorityFactory = ipPortContentAuthorityFactory;
    }

    public boolean initialize() {
        String[] hosts = ContentSettings.AUTHORITIES.getValue();
        ArrayList<IpPortContentAuthority> dns = new ArrayList<IpPortContentAuthority>(hosts.length);
        for (int i = 0; i < hosts.length; ++i) {
            try {
                dns.add(this.ipPortContentAuthorityFactory.createIpPortContentAuthority(new IpPortImpl(hosts[i])));
                continue;
            }
            catch (UnknownHostException uhe) {
                // empty catch block
            }
        }
        this.authorities = dns.toArray(new ContentAuthority[dns.size()]);
        return !dns.isEmpty();
    }

    public ContentAuthority[] getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(ContentAuthority[] authorities) {
        this.authorities = authorities;
    }

    public void send(Message m) {
        int idx = this.RNG.nextInt(this.authorities.length);
        this.authorities[idx].send(m);
    }

    protected Random newRandom() {
        return new Random();
    }
}

