/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.ByteReader;
import org.limewire.io.IOUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;
import org.limewire.service.MessageService;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ExternalControl {
    private static final Log LOG = LogFactory.getLog(ExternalControl.class);
    private final String LOCALHOST = "127.0.0.1";
    private boolean initialized = false;
    private volatile String enqueuedRequest = null;
    private final DownloadServices downloadServices;
    private final Provider<ActivityCallback> activityCallback;
    private final SocketsManager socketsManager;

    @Inject
    public ExternalControl(DownloadServices downloadServices, Provider<ActivityCallback> activityCallback, SocketsManager socketsManager) {
        this.downloadServices = downloadServices;
        this.activityCallback = activityCallback;
        this.socketsManager = socketsManager;
    }

    public String preprocessArgs(String[] args) {
        LOG.trace("enter proprocessArgs");
        StringBuilder arg = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            arg.append(args[i]);
        }
        return arg.toString();
    }

    public void checkForActiveLimeWire() {
        if (this.testForLimeWire(null)) {
            System.exit(0);
        }
    }

    public void checkForActiveLimeWire(String arg) {
        if ((OSUtils.isWindows() || OSUtils.isLinux()) && this.testForLimeWire(arg)) {
            System.exit(0);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void enqueueControlRequest(String arg) {
        LOG.trace("enter enqueueControlRequest");
        this.enqueuedRequest = arg;
    }

    public void runQueuedControlRequest() {
        this.initialized = true;
        if (this.enqueuedRequest != null) {
            String request = this.enqueuedRequest;
            this.enqueuedRequest = null;
            if (this.isTorrentRequest(request)) {
                this.handleTorrentRequest(request);
            } else {
                this.handleMagnetRequest(request);
            }
        }
    }

    private boolean isTorrentRequest(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase()).endsWith(".torrent") && !arg.startsWith("magnet:");
    }

    public void handleMagnetRequest(String arg) {
        LOG.trace("enter handleMagnetRequest");
        ActivityCallback callback = this.restoreApplication();
        MagnetOptions[] options = MagnetOptions.parseMagnet(arg);
        if (options.length == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid magnet, ignoring: " + arg);
            }
            return;
        }
        if (!callback.handleMagnets(options)) {
            this.downloadMagnet(options);
        }
    }

    private ActivityCallback restoreApplication() {
        this.activityCallback.get().restoreApplication();
        this.activityCallback.get().showDownloads();
        return this.activityCallback.get();
    }

    private void handleTorrentRequest(String arg) {
        LOG.trace("enter handleTorrentRequest");
        ActivityCallback callback = this.restoreApplication();
        File torrentFile = new File(arg.trim());
        callback.handleTorrent(torrentFile);
    }

    public void downloadMagnet(MagnetOptions[] options) {
        int i;
        if (LOG.isDebugEnabled()) {
            for (i = 0; i < options.length; ++i) {
                LOG.debug("Kicking off downloader for option " + i + " " + options[i]);
            }
        }
        for (i = 0; i < options.length; ++i) {
            MagnetOptions curOpt = options[i];
            if (LOG.isDebugEnabled()) {
                URN urn = curOpt.getSHA1Urn();
                LOG.debug("Processing magnet with params:\nurn [" + urn + "]\n" + "options [" + curOpt + "]");
            }
            String msg = curOpt.getErrorMessage();
            if (!curOpt.isDownloadable()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid magnet: " + curOpt);
                }
                msg = msg != null ? msg : curOpt.toString();
                MessageService.showFormattedError(I18nMarker.marktr("Could not process bad MAGNET link {0}"), msg);
                return;
            }
            if (msg != null) {
                MessageService.showError(I18nMarker.marktr("One or more URLs in the MAGNET link were invalid. Your file may not download correctly."));
            }
            try {
                this.downloadServices.download(curOpt, false);
                continue;
            }
            catch (IllegalArgumentException il) {
                ErrorService.error(il);
                continue;
            }
            catch (SaveLocationException sle) {
                if (sle.getErrorCode() == 5) {
                    MessageService.showFormattedError(I18nMarker.marktr("You have already downloaded {0}"), sle.getFile().getName());
                    continue;
                }
                if (sle.getErrorCode() != 10) continue;
                MessageService.showFormattedError(I18nMarker.marktr("You are already downloading this file to {0}"), sle.getFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlThread(Socket socket, boolean magnet) {
        LOG.trace("enter fireControl");
        Thread.currentThread().setName("IncomingControlThread");
        try {
            if (!NetworkUtils.isLocalHost(socket)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Invalid control request from: " + socket.getInetAddress().getHostAddress());
                }
                return;
            }
            socket.setSoTimeout(8000);
            ByteReader br = new ByteReader(socket.getInputStream());
            String line = br.readLine();
            socket.setSoTimeout(0);
            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
            String s = CommonUtils.getUserName() + "\r\n";
            byte[] bytes = s.getBytes();
            out.write(bytes);
            out.flush();
            if (magnet) {
                this.handleMagnetRequest(line);
            } else {
                this.handleTorrentRequest(line);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception while responding to control request", e);
        }
        finally {
            IOUtils.close(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testForLimeWire(String arg) {
        String type;
        Socket socket = null;
        int port = ConnectionSettings.PORT.getValue();
        String string = type = this.isTorrentRequest(arg) ? "TORRENT" : "MAGNET";
        if (!NetworkUtils.isValidPort(port)) {
            ConnectionSettings.PORT.revertToDefault();
            port = ConnectionSettings.PORT.getValue();
        }
        try {
            socket = this.socketsManager.connect(new InetSocketAddress("127.0.0.1", port), 1000);
            InputStream istream = socket.getInputStream();
            socket.setSoTimeout(1000);
            ByteReader byteReader = new ByteReader(istream);
            OutputStream os = socket.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            BufferedWriter out = new BufferedWriter(osw);
            out.write(type + " " + arg + " ");
            out.write("\r\n");
            out.flush();
            String str = byteReader.readLine();
            boolean bl = str != null && str.startsWith(CommonUtils.getUserName());
            return bl;
        }
        catch (IOException e2) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

