/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class HTTPHandler {
    private Socket _socket;
    private OutputStream _ostream;

    public static HTTPHandler createPage(Socket socket, String content) {
        HTTPHandler handler = new HTTPHandler(socket);
        handler.handlePage(content);
        return handler;
    }

    public HTTPHandler(Socket socket) {
        this._socket = socket;
    }

    public void handlePage(String page) {
        this.setupIO();
        this.uploadPage(page);
    }

    private void setupIO() {
        try {
            this._ostream = this._socket.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void uploadPage(String page) {
        int length = page.length();
        try {
            this.writeHeader(length, this.getMimeType(".html"));
            byte[] content = page.getBytes();
            this._ostream.write(content);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this._ostream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getMimeType(String filename) {
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".img")) {
            return "image/gif";
        }
        if (filename.endsWith(".js")) {
            return "application/x-javascript";
        }
        if (filename.endsWith(".css")) {
            return "text/css";
        }
        return "text/html";
    }

    private void writeHeader(int length, String mimeType) throws IOException {
        String str = "HTTP/1.1 200 OK \r\n";
        this._ostream.write(str.getBytes());
        str = "Server: " + LimeWireUtils.getVendor() + "\r\n";
        this._ostream.write(str.getBytes());
        str = "Content-type:" + mimeType + "\r\n";
        this._ostream.write(str.getBytes());
        str = "Content-length:" + length + "\r\n";
        this._ostream.write(str.getBytes());
        str = "\r\n";
        this._ostream.write(str.getBytes());
    }

    public void writeError() {
        try {
            String str = "HTTP/1.1 404 Not Found\r\n";
            this._ostream.write(str.getBytes());
            this._ostream.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this._ostream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

