/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import org.limewire.i18n.I18nMarker;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.net.SocketAcceptor;
import org.limewire.service.MessageService;

@Singleton
public class LocalAcceptor {
    private static final int FIRST_PORT = 45100;
    private final SocketAcceptor acceptor;

    @Inject
    public LocalAcceptor(@Named(value="local") ConnectionDispatcher connectionDispatcher) {
        this.acceptor = new SocketAcceptor(connectionDispatcher);
    }

    public void start() {
        if (!this.bind(45100)) {
            MessageService.showError(I18nMarker.marktr("FrostWire was unable to set up a port to listen for incoming connections. Some features of FrostWire may not work as expected."));
        }
    }

    public void stop() {
        this.acceptor.unbind();
    }

    private boolean bind(int listeningPort) {
        for (int i = 0; i < 20; ++i) {
            try {
                this.acceptor.bind(listeningPort + i);
                return true;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return false;
    }

    public int getPort() {
        return this.acceptor.getPort();
    }

    public ConnectionDispatcher getDispatcher() {
        return this.acceptor.getDispatcher();
    }
}

