/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.browser;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.MagnetHTML;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.AsyncHttpRequestHandler;
import org.limewire.http.BasicHttpAcceptor;

@Singleton
public class LocalHTTPAcceptor
extends BasicHttpAcceptor {
    private static final Log LOG = LogFactory.getLog(LocalHTTPAcceptor.class);
    private static final String[] SUPPORTED_METHODS = new String[]{"GET", "HEAD"};
    private static final String MAGNET = "magnet:?";
    private static final String MAGNET_DETAIL = "magcmd/detail?";
    private String lastCommand;
    private long lastCommandTime;
    private long MIN_REQUEST_INTERVAL = 1500L;
    private final ExternalControl externalControl;

    @Inject
    public LocalHTTPAcceptor(ExternalControl externalControl) {
        super(LocalHTTPAcceptor.createDefaultParams(LimeWireUtils.getHttpServer(), 8000), SUPPORTED_METHODS);
        this.externalControl = externalControl;
        this.registerHandler("magnet:", new MagnetCommandRequestHandler());
        this.registerHandler("/magnet10/default.js", new MagnetCommandRequestHandler());
        this.registerHandler("/magnet10/pause", new MagnetPauseRequestHandler());
        this.registerHandler("/magcmd/detail", new MagnetDetailRequestHandler());
    }

    private synchronized void triggerMagnetHandling(String uri) throws IOException {
        int i = uri.indexOf("?");
        if (i == -1) {
            throw new IOException("Invalid command");
        }
        String command = uri.substring(i + 1);
        long currentTime = System.currentTimeMillis();
        if (!command.equals(this.lastCommand) || currentTime - this.lastCommandTime >= this.MIN_REQUEST_INTERVAL) {
            this.externalControl.handleMagnetRequest(MAGNET + command);
            this.lastCommand = command;
            this.lastCommandTime = currentTime;
        } else {
            LOG.warn("Ignoring duplicate request: " + command);
        }
    }

    private class MagnetDetailRequestHandler
    implements AsyncHttpRequestHandler {
        private MagnetDetailRequestHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String uri = request.getRequestLine().getUri();
            int i = uri.indexOf(LocalHTTPAcceptor.MAGNET_DETAIL);
            String command = uri.substring(i + LocalHTTPAcceptor.MAGNET_DETAIL.length());
            String page = MagnetHTML.buildMagnetDetailPage(command);
            StringEntity entity = new StringEntity(page);
            entity.setContentType("text/html");
            response.setEntity(entity);
        }
    }

    private class MagnetPauseRequestHandler
    implements AsyncHttpRequestHandler {
        private MagnetPauseRequestHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            response.setStatusCode(204);
        }
    }

    private class MagnetCommandRequestHandler
    implements AsyncHttpRequestHandler {
        private MagnetCommandRequestHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            LocalHTTPAcceptor.this.triggerMagnetHandling(request.getRequestLine().getUri());
        }
    }
}

