/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.DeadlockException;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.ServletAccessor;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public class DeadlockBugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;

    private DeadlockBugManager() {
    }

    public static void handleDeadlock(DeadlockException bug, String threadName, String message) {
        bug.printStackTrace();
        System.err.println("Detail: " + message);
        LocalClientInfo info = localClientInfoFactory.createLocalClientInfo(bug, threadName, message, false);
        if (DeadlockBugManager.isSendableVersion() && (LimeWireUtils.isBetaRelease() || BugSettings.SEND_DEADLOCK_BUGS.getValue())) {
            DeadlockBugManager.sendToServlet(info);
        }
    }

    private static boolean isSendableVersion() {
        Version lastVersion;
        Version myVersion;
        try {
            myVersion = new Version(LimeWireUtils.getLimeWireVersion());
            lastVersion = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.getValue());
        }
        catch (VersionFormatException vfe) {
            return false;
        }
        return myVersion.compareTo(lastVersion) >= 0;
    }

    private static void sendToServlet(LocalClientInfo info) {
        new ServletAccessor(false).getRemoteBugInfo(info);
    }
}

