/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.bugs.ServletAccessor;
import com.limegroup.gnutella.bugs.SessionInfo;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.LocalClientInfoFactoryImpl;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.SplashWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.limewire.inject.Providers;

public final class FatalBugManager {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;

    private FatalBugManager() {
    }

    public static void handleFatalBug(Throwable bug) {
        if (bug instanceof ThreadDeath) {
            throw (ThreadDeath)bug;
        }
        bug.printStackTrace();
        LocalClientInfoFactory factoryToUse = localClientInfoFactory;
        if (factoryToUse == null) {
            factoryToUse = new LocalClientInfoFactoryImpl(Providers.of(new FatalSessionInfo()));
        }
        LocalClientInfo info = factoryToUse.createLocalClientInfo(bug, Thread.currentThread().getName(), null, true);
        FatalBugManager.reviewBug(info);
    }

    private static String warning() {
        return "You are using FrostWire. www.frostwire.com";
    }

    public static void reviewBug(final LocalClientInfo info) {
        final JDialog DIALOG = new JDialog();
        DIALOG.setTitle("Fatal Error");
        Dimension DIALOG_DIMENSION = new Dimension(100, 300);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        MultiLineLabel label = new MultiLineLabel(FatalBugManager.warning() + "\n\n" + "FrostWire has encountered a fatal internal error and will now exit. " + "This is generally caused by a corrupted installation.  Please try " + "downloading and installing FrostWire again.\n\n" + "To aid with debugging, please click 'Send' to notify FrostWire about the problem. " + "If desired, you can click 'Review' to look at the information that will be sent. " + "If the problem persists, please visit www.frostwire.com and click the 'Support' " + "link.\n\n" + "Thank You.", 400);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(label);
        JPanel buttonPanel = new JPanel();
        JButton sendButton = new JButton("Send");
        sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FatalBugManager.sendToServlet(info);
                DIALOG.dispose();
                System.exit(1);
            }
        });
        JButton reviewButton = new JButton("Review");
        reviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextArea textArea = new JTextArea(info.toBugReport());
                textArea.setColumns(50);
                textArea.setEditable(false);
                textArea.selectAll();
                textArea.copy();
                textArea.setCaretPosition(0);
                JScrollPane scroller = new JScrollPane(textArea);
                scroller.setBorder(BorderFactory.createEtchedBorder());
                scroller.setPreferredSize(new Dimension(500, 200));
                FatalBugManager.showMessage(DIALOG, scroller);
            }
        });
        JButton discardButton = new JButton("Discard");
        discardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
                System.exit(1);
            }
        });
        buttonPanel.add(sendButton);
        buttonPanel.add(reviewButton);
        buttonPanel.add(discardButton);
        mainPanel.add(labelPanel);
        mainPanel.add(buttonPanel);
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = DIALOG.getSize();
        DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        DIALOG.setVisible(true);
        try {
            SplashWindow.instance().setVisible(false);
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        DIALOG.toFront();
    }

    private static void sendToServlet(LocalClientInfo info) {
        new ServletAccessor().getRemoteBugInfo(info);
    }

    private static void showMessage(Component parent, Component toDisplay) {
        JOptionPane.showMessageDialog(parent, toDisplay, "Fatal Error - Review", 1);
    }

    private static class FatalSessionInfo
    implements SessionInfo {
        private FatalSessionInfo() {
        }

        public boolean acceptedIncomingConnection() {
            return false;
        }

        public boolean canReceiveSolicited() {
            return false;
        }

        public long getByteBufferCacheSize() {
            return 0L;
        }

        public long getContentResponsesSize() {
            return 0L;
        }

        public long getCreationCacheSize() {
            return 0L;
        }

        public long getCurrentUptime() {
            return 0L;
        }

        public long getDiskControllerByteCacheSize() {
            return 0L;
        }

        public int getDiskControllerQueueSize() {
            return 0;
        }

        public long getDiskControllerVerifyingCacheSize() {
            return 0L;
        }

        public int getNumIndividualDownloaders() {
            return 0;
        }

        public int getNumLeafToUltrapeerConnections() {
            return 0;
        }

        public int getNumOldConnections() {
            return 0;
        }

        public int getNumUltrapeerToLeafConnections() {
            return 0;
        }

        public int getNumUltrapeerToUltrapeerConnections() {
            return 0;
        }

        public int getNumWaitingDownloads() {
            return 0;
        }

        public int getNumberOfPendingTimeouts() {
            return 0;
        }

        public int getNumberOfWaitingSockets() {
            return 0;
        }

        public int getPort() {
            return 0;
        }

        public boolean isGUESSCapable() {
            return false;
        }
    }
}

