/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;

abstract class LocalAbstractInfo {
    protected static final String LIMEWIRE_VERSION = "1";
    protected String _limewireVersion;
    protected static final String JAVA_VERSION = "2";
    protected String _javaVersion;
    protected static final String OS = "3";
    protected String _os;
    protected static final String OS_VERSION = "4";
    protected String _osVersion;
    protected static final String ARCHITECTURE = "5";
    protected String _architecture;
    protected static final String FREE_MEMORY = "6";
    protected String _freeMemory;
    protected static final String TOTAL_MEMORY = "7";
    protected String _totalMemory;
    protected static final String BUG = "8";
    protected String _bug;
    protected static final String CURRENT_THREAD = "9";
    protected String _currentThread;
    protected static final String PROPS = "10";
    protected String _props;
    protected static final String UPTIME = "11";
    protected String _upTime;
    protected static final String CONNECTED = "12";
    protected String _connected;
    protected static final String UP_TO_UP = "13";
    protected String _upToUp;
    protected static final String UP_TO_LEAF = "14";
    protected String _upToLeaf;
    protected static final String LEAF_TO_UP = "15";
    protected String _leafToUp;
    protected static final String OLD_CONNECTIONS = "16";
    protected String _oldConnections;
    protected static final String ULTRAPEER = "17";
    protected String _ultrapeer;
    protected static final String LEAF = "18";
    protected String _leaf;
    protected static final String ACTIVE_UPLOADS = "19";
    protected String _activeUploads;
    protected static final String QUEUED_UPLOADS = "20";
    protected String _queuedUploads;
    protected static final String ACTIVE_DOWNLOADS = "21";
    protected String _activeDownloads;
    protected static final String HTTP_DOWNLOADERS = "22";
    protected String _httpDownloaders;
    protected static final String WAITING_DOWNLOADERS = "23";
    protected String _waitingDownloaders;
    protected static final String ACCEPTED_INCOMING = "24";
    protected String _acceptedIncoming;
    protected static final String SHARED_FILES = "25";
    protected String _sharedFiles;
    protected static final String OTHER_THREADS = "26";
    protected String _otherThreads;
    protected static final String DETAIL = "27";
    protected String _detail;
    protected static final String OTHER_BUG = "28";
    protected String _otherBug;
    protected static final String JAVA_VENDOR = "29";
    protected String _javaVendor;
    protected static final String THREAD_COUNT = "30";
    protected String _threadCount;
    protected static final String BUG_NAME = "31";
    protected String _bugName;
    protected static final String GUESS_CAPABLE = "32";
    protected String _guessCapable;
    protected static final String SOLICITED_CAPABLE = "33";
    protected String _solicitedCapable;
    protected static final String LATEST_SIMPP = "34";
    protected String _latestSIMPP;
    protected static final String PORT_STABLE = "36";
    protected String _portStable;
    protected static final String CAN_DO_FWT = "37";
    protected String _canDoFWT;
    protected static final String LAST_REPORTED_PORT = "38";
    protected String _lastReportedPort;
    protected static final String EXTERNAL_PORT = "39";
    protected String _externalPort;
    protected static final String RECEIVED_IP_PONG = "40";
    protected String _receivedIpPong;
    protected static final String FATAL_ERROR = "41";
    protected String _fatalError;
    protected static final String RESPONSE_SIZE = "42";
    protected String _responseSize;
    protected static final String CT_SIZE = "43";
    protected String _creationCacheSize;
    protected static final String VF_VERIFY_SIZE = "44";
    protected String _vfVerifyingSize;
    protected static final String VF_BYTE_SIZE = "45";
    protected String _vfByteSize;
    protected static final String BB_BYTE_SIZE = "46";
    protected String _bbSize;
    protected static final String VF_QUEUE_SIZE = "47";
    protected String _vfQueueSize;
    protected static final String WAITING_SOCKETS = "48";
    protected String _waitingSockets;
    protected static final String PENDING_TIMEOUTS = "49";
    protected String _pendingTimeouts;
    protected static final String PEAK_THREADS = "50";
    protected String _peakThreads;
    protected static final String SP2_WORKAROUNDS = "51";
    protected String _sp2Workarounds;
    protected static final String LOAD_AVERAGE = "52";
    protected String _loadAverage;
    protected static final String PENDING_GCOBJ = "53";
    protected String _pendingObjects;
    protected static final String SETTINGS_FREE_SPACE = "54";
    protected String _settingsFreeSpace;
    protected static final String INCOMPLETES_FREE_SPACE = "55";
    protected String _incompleteFreeSpace;
    protected static final String DOWNLOAD_FREE_SPACE = "56";
    protected String _downloadFreeSpace;
    protected static final String HEAP_USAGE = "57";
    protected String _heapUsage;
    protected static final String NON_HEAP_USAGE = "58";
    protected String _nonHeapUsage;
    protected static final String SLOT_MANAGER = "59";
    protected String _slotManager;
    protected static final String NUM_SELECTS = "60";
    protected String _numSelects;
    protected static final String NUM_IMMEDIATE_SELECTS = "61";
    protected String _numImmediateSelects;
    protected static final String AVG_SELECT_TIME = "62";
    protected String _avgSelectTime;
    protected static final String USER_COMMENTS = "63";
    protected String _userComments;

    LocalAbstractInfo() {
    }

    public void addUserComments(String comments) {
        this._userComments = comments;
    }

    public String toBugReport() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("FrostWire version " + this._limewireVersion);
        pw.println("Java version " + this._javaVersion + " from " + this._javaVendor);
        pw.println(this._os + " v. " + this._osVersion + " on " + this._architecture);
        pw.println("Free/total memory: " + this._freeMemory + "/" + this._totalMemory);
        pw.println();
        if (this.isFatalError()) {
            pw.println("FATAL ERROR!");
            pw.println();
        }
        pw.println(this._bug);
        pw.println();
        if (this._detail != null) {
            pw.println("Detail: " + this._detail);
            pw.println();
        }
        pw.println("-- listing session information --");
        pw.println("Current thread: " + this._currentThread);
        pw.println("Active Threads: " + this._threadCount);
        this.append(pw, "Uptime", this._upTime);
        this.append(pw, "Is Connected", this._connected);
        this.append(pw, "Number of Ultrapeer -> Ultrapeer Connections", this._upToUp);
        this.append(pw, "Number of Ultrapeer -> Leaf Connections", this._upToLeaf);
        this.append(pw, "Number of Leaf -> Ultrapeer Connections", this._leafToUp);
        this.append(pw, "Number of Old Connections", this._oldConnections);
        this.append(pw, "Acting as Ultrapeer", this._ultrapeer);
        this.append(pw, "Acting as Shielded Leaf", this._leaf);
        this.append(pw, "Number of Active Uploads", this._activeUploads);
        this.append(pw, "Number of Queued Uploads", this._queuedUploads);
        this.append(pw, "Number of Active Managed Downloads", this._activeDownloads);
        this.append(pw, "Number of Active HTTP Downloaders", this._httpDownloaders);
        this.append(pw, "Number of Waiting Downloads", this._waitingDownloaders);
        this.append(pw, "Received incoming this session", this._acceptedIncoming);
        this.append(pw, "Number of Shared Files", this._sharedFiles);
        this.append(pw, "Guess Capable", this._guessCapable);
        this.append(pw, "Received Solicited UDP", this._solicitedCapable);
        this.append(pw, "SIMPP version", this._latestSIMPP);
        this.append(pw, "Port Stable", this._portStable);
        this.append(pw, "FWT Capable", this._canDoFWT);
        this.append(pw, "Last Reported Port", this._lastReportedPort);
        this.append(pw, "External Port", this._externalPort);
        this.append(pw, "IP Pongs Received", this._receivedIpPong);
        this.append(pw, "Number of Content Response URNs", this._responseSize);
        this.append(pw, "Number of CreationTimeCache URNs", this._creationCacheSize);
        this.append(pw, "VF Byte Cache Size", this._vfByteSize);
        this.append(pw, "VF Verify Cache Size", this._vfVerifyingSize);
        this.append(pw, "VF Queue Size", this._vfQueueSize);
        this.append(pw, "ByteBuffer Cache Size", this._bbSize);
        this.append(pw, "Number of Waiting Sockets", this._waitingSockets);
        this.append(pw, "Number of Pending Timeouts", this._pendingTimeouts);
        this.append(pw, "Peak Number of Thread", this._peakThreads);
        this.append(pw, "Number of SP2 Workarounds", this._sp2Workarounds);
        this.append(pw, "System Load Avg", this._loadAverage);
        this.append(pw, "Objects Pending GC", this._pendingObjects);
        this.append(pw, "Free Space In Settings", this._settingsFreeSpace);
        this.append(pw, "Free Space In Incomplete", this._incompleteFreeSpace);
        this.append(pw, "Free Space In Downloads", this._downloadFreeSpace);
        this.append(pw, "Heap Memory Usage", this._heapUsage);
        this.append(pw, "Non-Heap Memory Usage", this._nonHeapUsage);
        this.append(pw, "SlotManager dump:", this._slotManager);
        this.append(pw, "Number of select calls", this._numSelects);
        this.append(pw, "Number of immediate selects", this._numImmediateSelects);
        this.append(pw, "Average time in select", this._avgSelectTime);
        pw.println();
        if (this._otherThreads != null) {
            pw.println("-- listing threads --");
            pw.println(this._otherThreads);
            pw.println();
        }
        pw.println(this._props);
        pw.println();
        pw.println("**************** Comments from the user ****************\n" + this._userComments);
        pw.flush();
        return sw.toString();
    }

    private void append(PrintWriter pw, String k, String v) {
        if (v != null) {
            pw.println(k + ": " + v);
        }
    }

    public final String getParsedBug() {
        int colon = this._bug.indexOf(58);
        if (colon == -1) {
            return this._bug;
        }
        if (colon - 4 >= 0 && this._bug.substring(colon - 4, colon).equals("java")) {
            return this._bug;
        }
        int ntat = this._bug.indexOf("\n\tat", colon);
        if (ntat == -1) {
            return this._bug;
        }
        String parsedBug = this._bug.substring(0, colon) + this._bug.substring(ntat);
        return parsedBug;
    }

    public String toString() {
        return this._bugName;
    }

    public boolean isFatalError() {
        return this._fatalError != null && this._fatalError.equalsIgnoreCase("true");
    }
}

