/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.LocalAbstractInfo;
import com.limegroup.gnutella.bugs.SessionInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.limewire.mojito.settings.MojitoProps;
import org.limewire.nio.NIODispatcher;
import org.limewire.setting.AbstractSetting;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalClientInfo
extends LocalAbstractInfo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalClientInfo(Throwable bug, String threadName, String detail, boolean fatal, SessionInfo sessionInfo) {
        SettingsFactory sf;
        this._limewireVersion = LimeWireUtils.getLimeWireVersion();
        this._javaVersion = VersionUtils.getJavaVersion();
        this._javaVendor = this.prop("java.vendor");
        this._os = OSUtils.getOS();
        this._osVersion = this.prop("os.version");
        this._architecture = this.prop("os.arch");
        this._freeMemory = "" + Runtime.getRuntime().freeMemory();
        this._totalMemory = "" + Runtime.getRuntime().totalMemory();
        this._peakThreads = "" + ManagementFactory.getThreadMXBean().getPeakThreadCount();
        this._loadAverage = LocalClientInfo.getLoadAvg();
        this._pendingObjects = "" + ManagementFactory.getMemoryMXBean().getObjectPendingFinalizationCount();
        this._heapUsage = "" + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this._nonHeapUsage = "" + ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        this._settingsFreeSpace = LocalClientInfo.getFreeSpace(CommonUtils.getUserSettingsDir());
        this._incompleteFreeSpace = LocalClientInfo.getFreeSpace(SharingSettings.INCOMPLETE_DIRECTORY.getValue());
        this._downloadFreeSpace = LocalClientInfo.getFreeSpace(SharingSettings.getSaveDirectory());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        bug.printStackTrace(pw);
        pw.flush();
        this._bug = sw.toString();
        this._currentThread = threadName;
        this._bugName = bug.getClass().getName();
        this._fatalError = "" + fatal;
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        Properties props = new Properties();
        SettingsFactory settingsFactory = sf = LimeProps.instance().getFactory();
        synchronized (settingsFactory) {
            for (AbstractSetting set : sf) {
                if (set.isPrivate() || set.isDefault()) continue;
                props.put(set.getKey(), set.getValueAsString());
            }
        }
        settingsFactory = sf = MojitoProps.instance().getFactory();
        synchronized (settingsFactory) {
            for (AbstractSetting set : sf) {
                if (set.isPrivate() || set.isDefault()) continue;
                props.put(set.getKey(), set.getValueAsString());
            }
        }
        props.list(pw);
        pw.flush();
        this._props = sw.toString();
        if (GUIMediator.isConstructed() && GuiCoreMediator.getCore() != null && GuiCoreMediator.getLifecycleManager().isLoaded()) {
            this._upTime = CommonUtils.seconds2time((int)(sessionInfo.getCurrentUptime() / 1000L));
            this._connected = "" + GuiCoreMediator.getConnectionServices().isConnected();
            this._upToUp = "" + sessionInfo.getNumUltrapeerToUltrapeerConnections();
            this._upToLeaf = "" + sessionInfo.getNumUltrapeerToLeafConnections();
            this._leafToUp = "" + sessionInfo.getNumLeafToUltrapeerConnections();
            this._oldConnections = "" + sessionInfo.getNumOldConnections();
            this._ultrapeer = "" + GuiCoreMediator.getConnectionServices().isSupernode();
            this._leaf = "" + GuiCoreMediator.getConnectionServices().isShieldedLeaf();
            this._activeUploads = "" + GuiCoreMediator.getUploadServices().getNumUploads();
            this._queuedUploads = "" + GuiCoreMediator.getUploadServices().getNumQueuedUploads();
            this._activeDownloads = "" + GuiCoreMediator.getDownloadServices().getNumActiveDownloads();
            this._httpDownloaders = "" + sessionInfo.getNumIndividualDownloaders();
            this._waitingDownloaders = "" + sessionInfo.getNumWaitingDownloads();
            this._acceptedIncoming = "" + sessionInfo.acceptedIncomingConnection();
            this._sharedFiles = "" + GuiCoreMediator.getFileManager().getNumFiles();
            this._guessCapable = "" + sessionInfo.isGUESSCapable();
            this._solicitedCapable = "" + sessionInfo.canReceiveSolicited();
            this._latestSIMPP = "" + GuiCoreMediator.getSimppManager().getVersion();
            this._portStable = "" + GuiCoreMediator.getUdpService().portStable();
            this._canDoFWT = "" + GuiCoreMediator.getUdpService().canDoFWT();
            this._lastReportedPort = "" + GuiCoreMediator.getUdpService().lastReportedPort();
            this._externalPort = "" + sessionInfo.getPort();
            this._receivedIpPong = "" + GuiCoreMediator.getUdpService().receivedIpPong();
            this._responseSize = "" + sessionInfo.getContentResponsesSize();
            this._creationCacheSize = "" + sessionInfo.getCreationCacheSize();
            this._vfByteSize = "" + sessionInfo.getDiskControllerByteCacheSize();
            this._vfVerifyingSize = "" + sessionInfo.getDiskControllerVerifyingCacheSize();
            this._bbSize = "" + sessionInfo.getByteBufferCacheSize();
            this._vfQueueSize = "" + sessionInfo.getDiskControllerQueueSize();
            this._waitingSockets = "" + sessionInfo.getNumberOfWaitingSockets();
            this._pendingTimeouts = "" + sessionInfo.getNumberOfPendingTimeouts();
            this._sp2Workarounds = "" + GuiCoreMediator.getConnectionCheckerManager().getNumWorkarounds();
            this._slotManager = "" + GuiCoreMediator.getUploadSlotManager();
            long[] selectStats = NIODispatcher.instance().getSelectStats();
            this._numSelects = "" + selectStats[0];
            this._numImmediateSelects = "" + selectStats[1];
            this._avgSelectTime = "" + selectStats[2];
        }
        this._detail = detail;
        Thread[] allThreads = new Thread[Thread.activeCount()];
        int copied = Thread.enumerate(allThreads);
        this._threadCount = "" + copied;
        HashMap<String, Integer> threads = new HashMap<String, Integer>();
        for (int i = 0; i < copied; ++i) {
            String name = allThreads[i].getName();
            Integer val = (Integer)threads.get(name);
            if (val == null) {
                threads.put(name, new Integer(1));
                continue;
            }
            int num = val + 1;
            threads.put(name, new Integer(num));
        }
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        for (Map.Entry info : threads.entrySet()) {
            pw.println((String)info.getKey() + ": " + info.getValue());
        }
        pw.flush();
        this._otherThreads = sw.toString();
    }

    private static String getFreeSpace(File f) {
        return LocalClientInfo.invoke16Method(f, File.class, "getUsableSpace", Long.class);
    }

    private static String getLoadAvg() {
        return LocalClientInfo.invoke16Method(ManagementFactory.getOperatingSystemMXBean(), OperatingSystemMXBean.class, "getSystemLoadAverage", Double.class);
    }

    private static String invoke16Method(Object obj, Class<?> type, String method, Class<?> retType) {
        if (!VersionUtils.isJava16OrAbove()) {
            return "-1";
        }
        try {
            Method m = type.getMethod(method, new Class[0]);
            Object ret = m.invoke(obj, new Object[0]);
            if (ret == null) {
                return "-7";
            }
            if (!retType.isAssignableFrom(ret.getClass())) {
                return "-5";
            }
            return ret.toString();
        }
        catch (NoSuchMethodException bail) {
            return "-2";
        }
        catch (IllegalAccessException bail) {
            return "-3";
        }
        catch (InvocationTargetException bail) {
            return "-4";
        }
        catch (Throwable bad) {
            return "-6";
        }
    }

    private final String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }

    public final NameValuePair[] getPostRequestParams() {
        LinkedList params = new LinkedList();
        this.append(params, "1", this._limewireVersion);
        this.append(params, "2", this._javaVersion);
        this.append(params, "3", this._os);
        this.append(params, "4", this._osVersion);
        this.append(params, "5", this._architecture);
        this.append(params, "6", this._freeMemory);
        this.append(params, "7", this._totalMemory);
        this.append(params, "8", this._bug);
        this.append(params, "9", this._currentThread);
        this.append(params, "10", this._props);
        this.append(params, "11", this._upTime);
        this.append(params, "12", this._connected);
        this.append(params, "13", this._upToUp);
        this.append(params, "14", this._upToLeaf);
        this.append(params, "15", this._leafToUp);
        this.append(params, "16", this._oldConnections);
        this.append(params, "17", this._ultrapeer);
        this.append(params, "18", this._leaf);
        this.append(params, "19", this._activeUploads);
        this.append(params, "20", this._queuedUploads);
        this.append(params, "21", this._activeDownloads);
        this.append(params, "22", this._httpDownloaders);
        this.append(params, "23", this._waitingDownloaders);
        this.append(params, "24", this._acceptedIncoming);
        this.append(params, "25", this._sharedFiles);
        this.append(params, "26", this._otherThreads);
        this.append(params, "27", this._detail);
        this.append(params, "28", this._otherBug);
        this.append(params, "29", this._javaVendor);
        this.append(params, "30", this._threadCount);
        this.append(params, "31", this._bugName);
        this.append(params, "32", this._guessCapable);
        this.append(params, "33", this._solicitedCapable);
        this.append(params, "34", this._latestSIMPP);
        this.append(params, "36", this._portStable);
        this.append(params, "37", this._canDoFWT);
        this.append(params, "38", this._lastReportedPort);
        this.append(params, "39", this._externalPort);
        this.append(params, "40", this._receivedIpPong);
        this.append(params, "41", this._fatalError);
        this.append(params, "42", this._responseSize);
        this.append(params, "43", this._creationCacheSize);
        this.append(params, "45", this._vfByteSize);
        this.append(params, "44", this._vfVerifyingSize);
        this.append(params, "46", this._bbSize);
        this.append(params, "47", this._vfQueueSize);
        this.append(params, "48", this._waitingSockets);
        this.append(params, "49", this._pendingTimeouts);
        this.append(params, "50", this._peakThreads);
        this.append(params, "51", this._sp2Workarounds);
        this.append(params, "52", this._loadAverage);
        this.append(params, "53", this._pendingObjects);
        this.append(params, "54", this._settingsFreeSpace);
        this.append(params, "55", this._incompleteFreeSpace);
        this.append(params, "56", this._downloadFreeSpace);
        this.append(params, "57", this._heapUsage);
        this.append(params, "58", this._nonHeapUsage);
        this.append(params, "59", this._slotManager);
        this.append(params, "60", this._numSelects);
        this.append(params, "61", this._numImmediateSelects);
        this.append(params, "62", this._avgSelectTime);
        this.append(params, "63", this._userComments);
        return params.toArray(new NameValuePair[params.size()]);
    }

    public String getShortParamList() {
        StringBuilder sb = new StringBuilder(2000);
        for (NameValuePair nvp : this.getPostRequestParams()) {
            sb.append(nvp.getName()).append("=").append(nvp.getValue()).append("\n");
        }
        return sb.toString();
    }

    private final void append(List<? super NameValuePair> l, String k, String v) {
        if (v != null) {
            l.add(new BasicNameValuePair(k, v));
        }
    }
}

