/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.RemoteAbstractInfo;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;

public final class RemoteClientInfo
extends RemoteAbstractInfo {
    private static final Log LOG = LogFactory.getLog(RemoteClientInfo.class);
    private static final long FAILURE_TIME = 3600000L;
    private String _nextThisBugTime;
    private String _nextAnyBugTime;

    public final void addRemoteInfo(String infoLine) {
        StringTokenizer st;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding info: " + infoLine);
        }
        if ((st = new StringTokenizer(infoLine, "=&")).countTokens() % 2 != 0) {
            return;
        }
        while (st.hasMoreTokens()) {
            this.handleKeyValuePair(st.nextToken(), st.nextToken());
        }
    }

    private final void handleKeyValuePair(String k, String v) {
        String value = "";
        try {
            value = URLDecoder.decode(v);
        }
        catch (IOException e) {
            ErrorService.error(e);
            return;
        }
        if (k.equalsIgnoreCase("1")) {
            this._nextThisBugTime = value;
        } else if (k.equalsIgnoreCase("2")) {
            this._nextAnyBugTime = value;
        }
    }

    public final void connectFailed() {
        this._nextThisBugTime = "3600000";
        this._nextAnyBugTime = "3600000";
    }

    long getNextThisBugTime() {
        long nextTime;
        if (this._nextThisBugTime == null) {
            return 0L;
        }
        try {
            nextTime = Long.parseLong(this._nextThisBugTime);
        }
        catch (NumberFormatException nfe) {
            nextTime = 0L;
        }
        return nextTime;
    }

    long getNextAnyBugTime() {
        long nextTime;
        if (this._nextAnyBugTime == null) {
            return 0L;
        }
        try {
            nextTime = Long.parseLong(this._nextAnyBugTime);
        }
        catch (NumberFormatException nfe) {
            nextTime = 0L;
        }
        return nextTime;
    }
}

