/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.chat.InstantMessengerFactory;
import com.limegroup.gnutella.chat.InstantMessengerImpl;
import java.net.Socket;
import org.limewire.net.SocketsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class InstantMessengerFactoryImpl
implements InstantMessengerFactory {
    private final Provider<SocketsManager> socketsManager;
    private final Provider<ActivityCallback> activityCallback;

    @Inject
    public InstantMessengerFactoryImpl(Provider<ActivityCallback> activityCallback, Provider<SocketsManager> socketsManager) {
        this.activityCallback = activityCallback;
        this.socketsManager = socketsManager;
    }

    @Override
    public InstantMessenger createIncomingInstantMessenger(Socket socket) {
        return new InstantMessengerImpl(socket, this.activityCallback.get());
    }

    @Override
    public InstantMessenger createOutgoingInstantMessenger(String host, int port) {
        return new InstantMessengerImpl(host, port, this.activityCallback.get(), this.socketsManager.get());
    }
}

