/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionBandwidthStatistics;
import org.limewire.nio.ProtocolBandwidthTracker;

public class ConnectionBandwidthStatisticsImpl
implements ConnectionBandwidthStatistics {
    private volatile boolean useTls;
    private volatile ProtocolBandwidthTracker sslBandwidthTracker;
    private volatile boolean writeDeflated;
    private volatile boolean readDeflated;
    private volatile ProtocolBandwidthTracker compressionBandwidthTracker;
    private volatile ProtocolBandwidthTracker rawBandwidthTracker;

    public void setTlsOption(boolean useTls, ProtocolBandwidthTracker sslBandwidthTracker) {
        this.useTls = useTls;
        this.sslBandwidthTracker = sslBandwidthTracker;
    }

    public void setCompressionOption(boolean writeDeflated, boolean readDeflated, ProtocolBandwidthTracker compressionBandwidthTracker) {
        this.writeDeflated = writeDeflated;
        this.readDeflated = readDeflated;
        this.compressionBandwidthTracker = compressionBandwidthTracker;
    }

    public void setRawBandwidthTracker(ProtocolBandwidthTracker rawBandwidthTracker) {
        this.rawBandwidthTracker = rawBandwidthTracker;
    }

    public long getBytesSent() {
        if (this.useTls) {
            return this.sslBandwidthTracker.getWrittenBytesProduced();
        }
        if (this.writeDeflated) {
            return this.compressionBandwidthTracker.getWrittenBytesProduced();
        }
        return this.rawBandwidthTracker.getWrittenBytesProduced();
    }

    public long getUncompressedBytesSent() {
        return this.rawBandwidthTracker.getWrittenBytesProduced();
    }

    public long getBytesReceived() {
        if (this.useTls) {
            return this.sslBandwidthTracker.getReadBytesConsumed();
        }
        if (this.readDeflated) {
            return this.compressionBandwidthTracker.getReadBytesConsumed();
        }
        return this.rawBandwidthTracker.getReadBytesConsumed();
    }

    public long getUncompressedBytesReceived() {
        return this.rawBandwidthTracker.getReadBytesConsumed();
    }

    public float getSentSavedFromCompression() {
        return ConnectionBandwidthStatisticsImpl.getWriteSavings(this.writeDeflated, this.compressionBandwidthTracker);
    }

    public float getReadSavedFromCompression() {
        return ConnectionBandwidthStatisticsImpl.getReadSavings(this.readDeflated, this.compressionBandwidthTracker);
    }

    public float getSentLostFromSSL() {
        return ConnectionBandwidthStatisticsImpl.getWriteLosings(this.useTls, this.sslBandwidthTracker);
    }

    public float getReadLostFromSSL() {
        return ConnectionBandwidthStatisticsImpl.getReadLosings(this.useTls, this.sslBandwidthTracker);
    }

    private static float getWriteSavings(boolean guard, ProtocolBandwidthTracker tracker) {
        if (!guard) {
            return 0.0f;
        }
        long writtenConsumed = tracker.getWrittenBytesConsumed();
        if (writtenConsumed != 0L) {
            return 1.0f - (float)tracker.getWrittenBytesProduced() / (float)writtenConsumed;
        }
        return 0.0f;
    }

    private static float getReadSavings(boolean guard, ProtocolBandwidthTracker tracker) {
        if (!guard) {
            return 0.0f;
        }
        long readProduced = tracker.getReadBytesProduced();
        if (readProduced != 0L) {
            return 1.0f - (float)tracker.getReadBytesConsumed() / (float)readProduced;
        }
        return 0.0f;
    }

    private static float getWriteLosings(boolean guard, ProtocolBandwidthTracker tracker) {
        if (!guard) {
            return 0.0f;
        }
        long writeProduced = tracker.getWrittenBytesProduced();
        if (writeProduced != 0L) {
            return 1.0f - (float)tracker.getWrittenBytesConsumed() / (float)writeProduced;
        }
        return 0.0f;
    }

    private static float getReadLosings(boolean guard, ProtocolBandwidthTracker tracker) {
        if (!guard) {
            return 0.0f;
        }
        long readConsumed = tracker.getReadBytesConsumed();
        if (readConsumed != 0L) {
            return 1.0f - (float)tracker.getReadBytesProduced() / (float)readConsumed;
        }
        return 0.0f;
    }
}

