/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Provider;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.GuidMap;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.connection.AbstractConnection;
import com.limegroup.gnutella.connection.CompositeQueue;
import com.limegroup.gnutella.connection.CompressionBandwidthTrackerImpl;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.ConnectionMessageStatistics;
import com.limegroup.gnutella.connection.ConnectionRoutingStatistics;
import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.connection.MessageReader;
import com.limegroup.gnutella.connection.MessageReaderFactory;
import com.limegroup.gnutella.connection.MessageReceiver;
import com.limegroup.gnutella.connection.MessageWriter;
import com.limegroup.gnutella.connection.OutputRunner;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.handshaking.AsyncIncomingHandshaker;
import com.limegroup.gnutella.handshaking.AsyncOutgoingHandshaker;
import com.limegroup.gnutella.handshaking.HandshakeObserver;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponderFactory;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.OOBProxyControlVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.UpdateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBThrottle;
import org.limewire.nio.Throttle;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.DeflaterWriter;
import org.limewire.nio.channel.DelayedBufferWriter;
import org.limewire.nio.channel.InflaterReader;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.channel.StatisticGatheringWriter;
import org.limewire.nio.channel.ThrottleWriter;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GnutellaConnection
extends AbstractConnection
implements ReplyHandler,
MessageReceiver,
SentMessageHandler,
Shutdownable,
Inspectable,
RoutedConnection,
ConnectionRoutingStatistics,
ConnectionMessageStatistics {
    private static final Log LOG = LogFactory.getLog(GnutellaConnection.class);
    private long LEAF_QUERY_ROUTE_UPDATE_TIME = 300000L;
    private long ULTRAPEER_QUERY_ROUTE_UPDATE_TIME = 60000L;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 8000;
    private volatile SpamFilter _routeFilter;
    private volatile SpamFilter _personalFilter;
    private final Object QRP_LOCK = new Object();
    private static final Throttle _nbThrottle = new NBThrottle(true, 8000.0f, ConnectionSettings.NUM_CONNECTIONS.getValue(), 5000);
    private volatile OutputRunner _outputRunner;
    private final ConnectionStats _connectionStats = new ConnectionStats();
    private long _nextQRPForwardTime;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isKillable = true;
    private volatile int hopsFlowMax = -1;
    private volatile long _busyTime = -1L;
    private volatile boolean myPushProxy;
    private volatile boolean pushProxyFor;
    private QueryRouteTable _lastQRPTableReceived;
    private QueryRouteTable _lastQRPTableSent;
    private boolean supernodeClientAtLooping = false;
    private volatile Deflater deflater;
    private volatile Inflater inflater;
    private volatile byte[] clientGUID = DataUtils.EMPTY_GUID;
    private volatile boolean _useLocalPreference;
    private boolean receivedCapVM = false;
    private int _maxDisabledOOBProtocolVersion = 0;
    private final ConnectionManager connectionManager;
    private final NetworkManager networkManager;
    private final QueryRequestFactory queryRequestFactory;
    private final HeadersFactory headersFactory;
    private final HandshakeResponderFactory handshakeResponderFactory;
    private final QueryReplyFactory queryReplyFactory;
    private final MessageDispatcher messageDispatcher;
    private final NetworkUpdateSanityChecker networkUpdateSanityChecker;
    private final SearchResultHandler searchResultHandler;
    private final Provider<SimppManager> simppManager;
    private final Provider<UpdateHandler> updateHandler;
    private final Provider<ConnectionServices> connectionServices;
    private final GuidMapManager guidMapManager;
    private final SocketsManager socketsManager;
    private final GuidMap guidMap;
    private final MessageReaderFactory messageReaderFactory;
    private final ApplicationServices applicationServices;
    private final SecureMessageVerifier secureMessageVerifier;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Map<StatsWriters, StatisticGatheringWriter> statsWriters = new HashMap<StatsWriters, StatisticGatheringWriter>();
    private volatile Message.MessageCounter incoming;
    private volatile Message.MessageCounter outgoing;
    private volatile long droppedBadHops;
    private volatile long droppedBadAddress;

    public GnutellaConnection(String host, int port, SocketsManager.ConnectType type, ConnectionManager connectionManager, NetworkManager networkManager, QueryRequestFactory queryRequestFactory, HeadersFactory headersFactory, HandshakeResponderFactory handshakeResponderFactory, QueryReplyFactory queryReplyFactory, MessageDispatcher messageDispatcher, NetworkUpdateSanityChecker networkUpdateSanityChecker, SearchResultHandler searchResultHandler, CapabilitiesVMFactory capabilitiesVMFactory, SocketsManager socketsManager, Acceptor acceptor, MessagesSupportedVendorMessage supportedVendorMessage, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, Provider<ConnectionServices> connectionServices, GuidMapManager guidMapManager, SpamFilterFactory spamFilterFactory, MessageReaderFactory messageReaderFactory, MessageFactory messageFactory, ApplicationServices applicationServices, SecureMessageVerifier secureMessageVerifier, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        super(host, port, type, capabilitiesVMFactory, supportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.headersFactory = headersFactory;
        this.handshakeResponderFactory = handshakeResponderFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.messageDispatcher = messageDispatcher;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.searchResultHandler = searchResultHandler;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
        this.connectionServices = connectionServices;
        this.guidMapManager = guidMapManager;
        this.messageReaderFactory = messageReaderFactory;
        this.applicationServices = applicationServices;
        this.guidMap = guidMapManager.getMap();
        this._routeFilter = spamFilterFactory.createRouteFilter();
        this._personalFilter = spamFilterFactory.createPersonalFilter();
        this.secureMessageVerifier = secureMessageVerifier;
        this.socketsManager = socketsManager;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public GnutellaConnection(Socket socket, ConnectionManager connectionManager, NetworkManager networkManager, QueryRequestFactory queryRequestFactory, HeadersFactory headersFactory, HandshakeResponderFactory handshakeResponderFactory, QueryReplyFactory queryReplyFactory, MessageDispatcher messageDispatcher, NetworkUpdateSanityChecker networkUpdateSanityChecker, SearchResultHandler searchResultHandler, CapabilitiesVMFactory capabilitiesVMFactory, Acceptor acceptor, MessagesSupportedVendorMessage supportedVendorMessage, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler, Provider<ConnectionServices> connectionServices, GuidMapManager guidMapManager, SpamFilterFactory spamFilterFactory, MessageReaderFactory messageReaderFactory, MessageFactory messageFactory, ApplicationServices applicationServices, SecureMessageVerifier secureMessageVerifier, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        super(socket, capabilitiesVMFactory, supportedVendorMessage, networkManager, acceptor, networkInstanceUtils);
        this.connectionManager = connectionManager;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.headersFactory = headersFactory;
        this.handshakeResponderFactory = handshakeResponderFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.messageDispatcher = messageDispatcher;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.searchResultHandler = searchResultHandler;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
        this.connectionServices = connectionServices;
        this.guidMapManager = guidMapManager;
        this.messageReaderFactory = messageReaderFactory;
        this.applicationServices = applicationServices;
        this.guidMap = guidMapManager.getMap();
        this._routeFilter = spamFilterFactory.createRouteFilter();
        this._personalFilter = spamFilterFactory.createPersonalFilter();
        this.secureMessageVerifier = secureMessageVerifier;
        this.socketsManager = null;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void initialize(GnetConnectObserver observer) throws IOException {
        HandshakeResponder responder;
        Properties requestHeaders;
        if (observer == null && this.isOutgoing()) {
            throw new NullPointerException("must have an observer if outgoing!");
        }
        if (this.isOutgoing()) {
            String host = this.getAddress();
            if (this.connectionServices.get().isSupernode()) {
                requestHeaders = this.headersFactory.createUltrapeerHeaders(host);
                responder = this.handshakeResponderFactory.createUltrapeerHandshakeResponder(host);
            } else {
                requestHeaders = this.headersFactory.createLeafHeaders(host);
                responder = this.handshakeResponderFactory.createLeafHandshakeResponder(host);
            }
        } else {
            String host = this.getSocket().getInetAddress().getHostAddress();
            requestHeaders = null;
            responder = this.connectionServices.get().isSupernode() ? this.handshakeResponderFactory.createUltrapeerHandshakeResponder(host) : this.handshakeResponderFactory.createLeafHandshakeResponder(host);
        }
        this.initialize(requestHeaders, responder, 6000, observer);
    }

    void initialize(Properties requestHeaders, HandshakeResponder responder, int timeout, GnetConnectObserver observer) throws IOException {
        responder.setLocalePreferencing(this._useLocalPreference);
        if (this.isOutgoing()) {
            AsyncHandshakeConnecter connectObserver = new AsyncHandshakeConnecter(requestHeaders, responder, observer);
            InetSocketAddress host = new InetSocketAddress(this.getAddress(), this.getPort());
            Socket socket = this.socketsManager.connect(host, timeout, connectObserver, this.getConnectType());
            this.setSocket(socket);
        } else {
            this.startHandshake(requestHeaders, responder, observer);
        }
    }

    private void startHandshake(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) throws IOException {
        this.initializeHandshake();
        HandshakeWatcher shakeObserver = new HandshakeWatcher(observer);
        Handshaker shaker = this.isOutgoing() ? new AsyncOutgoingHandshaker(requestHeaders, responder, this.getSocket(), shakeObserver) : new AsyncIncomingHandshaker(responder, this.getSocket(), shakeObserver);
        shakeObserver.setHandshaker(shaker);
        try {
            shaker.shake();
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
    }

    private void postHandshakeInitialize(Handshaker shaker) {
        this.handshakeInitialized(shaker);
        if (this.isWriteDeflated()) {
            this.deflater = new Deflater();
        }
        if (this.isReadDeflated()) {
            this.inflater = new Inflater();
        }
        this.getConnectionBandwidthStatistics().setCompressionOption(this.isWriteDeflated(), this.isReadDeflated(), new CompressionBandwidthTrackerImpl(this.inflater, this.deflater));
        this.startOutput();
    }

    @Override
    public void resetQueryRouteTable(ResetTableMessage rtm) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable(rtm.getTableSize(), rtm.getInfinity());
        } else {
            this._lastQRPTableReceived.reset(rtm);
        }
    }

    @Override
    public void patchQueryRouteTable(PatchTableMessage ptm) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable();
        }
        try {
            this._lastQRPTableReceived.patch(ptm);
        }
        catch (BadPacketException badPacketException) {
            // empty catch block
        }
    }

    public void setBusy(boolean bSet) {
        if (bSet) {
            if (this._busyTime == -1L) {
                this._busyTime = System.currentTimeMillis();
            }
        } else {
            this._busyTime = -1L;
        }
    }

    private byte getHopsFlowMax() {
        return (byte)this.hopsFlowMax;
    }

    @Override
    public boolean isBusyLeaf() {
        if (!this.isSupernodeClientConnection()) {
            return false;
        }
        byte hfm = this.getHopsFlowMax();
        return hfm >= 0 && hfm < 3;
    }

    @Override
    public boolean shouldForwardQuery(QueryRequest query) {
        if (query.isFeatureQuery()) {
            if (this.isSupernodeClientConnection()) {
                return this.getConnectionCapabilities().getRemoteHostFeatureQuerySelector() >= query.getFeatureSelector();
            }
            if (this.getConnectionCapabilities().isSupernodeSupernodeConnection()) {
                return this.getConnectionCapabilities().getRemoteHostSupportsFeatureQueries();
            }
            return false;
        }
        return this.hitsQueryRouteTable(query);
    }

    protected boolean hitsQueryRouteTable(QueryRequest query) {
        if (this._lastQRPTableReceived == null) {
            return false;
        }
        return this._lastQRPTableReceived.contains(query);
    }

    @Override
    public QueryRouteTable getQueryRouteTableReceived() {
        return this._lastQRPTableReceived;
    }

    @Override
    public double getQueryRouteTablePercentFull() {
        return this._lastQRPTableReceived == null ? 0.0 : this._lastQRPTableReceived.getPercentFull();
    }

    @Override
    public int getQueryRouteTableSize() {
        return this._lastQRPTableReceived == null ? 0 : this._lastQRPTableReceived.getSize();
    }

    @Override
    public int getQueryRouteTableEmptyUnits() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getEmptyUnits();
    }

    @Override
    public int getQueryRouteTableUnitsInUse() {
        return this._lastQRPTableReceived == null ? -1 : this._lastQRPTableReceived.getUnitsInUse();
    }

    private void startOutput() {
        if (LimeWireUtils.isBetaRelease() || LimeWireUtils.isTestingVersion()) {
            this.statsWriters.put(StatsWriters.TOP, new StatisticGatheringWriter());
            this.statsWriters.put(StatsWriters.DEFLATER, new StatisticGatheringWriter());
            this.statsWriters.put(StatsWriters.DELAYER, new StatisticGatheringWriter());
            this.statsWriters.put(StatsWriters.THROTTLE, new StatisticGatheringWriter());
            this.outgoing = new Message.MessageCounter(10);
        } else {
            this.outgoing = new Message.MessageCounter(1);
        }
        CompositeQueue queue = new CompositeQueue();
        MessageWriter messager = new MessageWriter(this._connectionStats, queue, this);
        this._outputRunner = messager;
        ChannelWriter writer = messager;
        if (this.statsWriters.containsKey((Object)StatsWriters.TOP)) {
            writer = this.addWriter(writer, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.TOP));
        }
        if (this.isWriteDeflated()) {
            writer = this.addWriter(writer, new DeflaterWriter(this.deflater));
            if (this.statsWriters.containsKey((Object)StatsWriters.DEFLATER)) {
                writer = this.addWriter(writer, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.DEFLATER));
            }
        }
        writer = this.addWriter(writer, new DelayedBufferWriter(1400));
        if (this.statsWriters.containsKey((Object)StatsWriters.DELAYER)) {
            writer = this.addWriter(writer, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.DELAYER));
        }
        writer = this.addWriter(writer, new ThrottleWriter(_nbThrottle));
        if (this.statsWriters.containsKey((Object)StatsWriters.THROTTLE)) {
            writer = this.addWriter(writer, (InterestWritableByteChannel)this.statsWriters.get((Object)StatsWriters.THROTTLE));
        }
        ((NIOMultiplexor)((Object)this.getSocket())).setWriteObserver(messager);
    }

    private <T extends InterestWritableByteChannel & ChannelWriter> ChannelWriter addWriter(ChannelWriter chain, T newWriter) {
        chain.setWriteChannel(newWriter);
        return newWriter;
    }

    @Override
    public void send(Message m) {
        int smh = this.hopsFlowMax;
        if (smh > -1 && m instanceof QueryRequest && m.getHops() >= smh) {
            return;
        }
        this._outputRunner.send(m);
    }

    @Override
    public void originateQuery(QueryRequest query) {
        query.originate();
        if (LOG.isTraceEnabled()) {
            LOG.trace("do not proxy condition " + this.getConnectionCapabilities().isClientSupernodeConnection() + " " + (this.getConnectionCapabilities().getSupportedOOBProxyControlVersion() == -1) + " " + SearchSettings.DISABLE_OOB_V2.getValueAsString());
        }
        if (this.getConnectionCapabilities().isClientSupernodeConnection() && this.getConnectionCapabilities().getSupportedOOBProxyControlVersion() == -1 && SearchSettings.DISABLE_OOB_V2.getBoolean()) {
            query = this.queryRequestFactory.createDoNotProxyQuery(query);
            query.originate();
        }
        this.send(query);
    }

    @Override
    public void shutdown() {
        this.close();
    }

    @Override
    protected void closeImpl() {
        IOUtils.close(this.deflater);
        IOUtils.close(this.inflater);
        if (this._outputRunner != null) {
            this._outputRunner.shutdown();
        }
        this.guidMapManager.removeMap(this.guidMap);
    }

    @Override
    public void startMessaging() {
        this.incoming = new Message.MessageCounter(LimeWireUtils.isBetaRelease() ? 10 : 1);
        this.supernodeClientAtLooping = this.isSupernodeClientConnection();
        LOG.debug("Starting asynchronous connection");
        try {
            this.getSocket().setSoTimeout(0);
        }
        catch (IOException iox) {
            // empty catch block
        }
        MessageReader reader = this.messageReaderFactory.createMessageReader(this);
        if (this.isReadDeflated()) {
            reader.setReadChannel(new InflaterReader(this.inflater));
        }
        ((NIOMultiplexor)((Object)this.getSocket())).setReadObserver(reader);
    }

    @Override
    public void messagingClosed() {
        if (this.connectionManager != null) {
            this.messageDispatcher.dispatch(new Runnable(){

                public void run() {
                    GnutellaConnection.this.connectionManager.remove(GnutellaConnection.this);
                }
            });
        }
    }

    @Override
    public void processReadMessage(Message m) {
        super.processReadMessage(m);
        this._connectionStats.addReceived();
        this.incoming.countMessage(m);
        this.handleMessageInternal(m);
    }

    @Override
    public void processSentMessage(Message m) {
        this.outgoing.countMessage(m);
        this.processWrittenMessage(m);
    }

    private void handleMessageInternal(Message m) {
        if (this.isSpam(m)) {
            this._connectionStats.addReceivedDropped();
        } else {
            if (m instanceof QueryReply) {
                QueryReply reply = (QueryReply)m;
                this._connectionStats.replyReceived(reply);
                if (m.getHops() == 0) {
                    this.clientGUID = reply.getClientGUID();
                }
                if (MessageSettings.RETURN_PATH_IN_REPLIES.getValue() && this.connectionManager.isActiveSupernode() && !reply.hasSecureData()) {
                    m = this.queryReplyFactory.createWithReturnPathInfo(reply, this.myIp == null ? null : new IpPortImpl(this.myIp, this.networkManager.getPort()), this);
                }
            }
            if (m instanceof QueryRequest) {
                this._connectionStats.queryReceived();
            }
            if (this.supernodeClientAtLooping) {
                if (m instanceof QueryRequest) {
                    m = this.tryToProxy((QueryRequest)m);
                } else if (m instanceof QueryStatusResponse) {
                    m = this.morphToStopQuery((QueryStatusResponse)m);
                }
            }
            this.messageDispatcher.dispatchTCP(m, this);
        }
    }

    @Override
    public long getNumQueryReplies() {
        return this._connectionStats.getRepliesReceived();
    }

    @Override
    public Message.Network getNetwork() {
        return Message.Network.TCP;
    }

    @Override
    public byte getSoftMax() {
        return super.getSoftMax();
    }

    private QueryRequest tryToProxy(QueryRequest query) {
        if (this.getConnectionCapabilities().remoteHostSupportsLeafGuidance() < 1) {
            return query;
        }
        if (query.desiresOutOfBandRepliesV3()) {
            return query;
        }
        if (query.doNotProxy()) {
            return query;
        }
        if (this._maxDisabledOOBProtocolVersion >= 3) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("query not proxied because disabled version is " + this._maxDisabledOOBProtocolVersion);
            }
            return query;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("query might be proxied for max disabled version " + this._maxDisabledOOBProtocolVersion + " " + Arrays.toString(query.getGUID()));
        }
        if (!(this.networkManager.isOOBCapable() && this.outOfBandStatistics.isSuccessRateGreat() && this.outOfBandStatistics.isOOBEffectiveForProxy())) {
            return query;
        }
        byte[] origGUID = query.getGUID();
        byte[] oobGUID = new byte[origGUID.length];
        System.arraycopy(origGUID, 0, oobGUID, 0, origGUID.length);
        GUID.addressEncodeGuid(oobGUID, this.networkManager.getAddress(), this.networkManager.getPort());
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(oobGUID);
        }
        query = this.queryRequestFactory.createProxyQuery(query, oobGUID);
        this.guidMap.addMapping(origGUID, oobGUID);
        this.outOfBandStatistics.addSentQuery();
        return query;
    }

    private QueryStatusResponse morphToStopQuery(QueryStatusResponse resp) {
        GUID oobGUID = this.guidMap.getNewGUID(resp.getQueryGUID());
        if (oobGUID != null) {
            return new QueryStatusResponse(oobGUID, resp.getNumResults());
        }
        return resp;
    }

    boolean isSpam(Message m) {
        QueryReply reply;
        byte[] ip;
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return !this._routeFilter.allow(m);
        }
        if (this.isSupernodeClientConnection() && m.getHops() != 0) {
            ++this.droppedBadHops;
            return true;
        }
        if (m instanceof QueryReply && m.getHops() == 0 && !this.networkInstanceUtils.isPrivateAddress(ip = (reply = (QueryReply)m).getIPBytes()) && !reply.hasSecureData() && !Arrays.equals(ip, this.getAddressBytes())) {
            ++this.droppedBadAddress;
            return true;
        }
        return !this._routeFilter.allow(m);
    }

    @Override
    public void countDroppedMessage() {
        this._connectionStats.addReceivedDropped();
    }

    @Override
    public boolean isPersonalSpam(Message m) {
        return !this._personalFilter.allow(m);
    }

    @Override
    public void setRouteFilter(SpamFilter filter) {
        this._routeFilter = filter;
    }

    @Override
    public void setPersonalFilter(SpamFilter filter) {
        this._personalFilter = filter;
    }

    @Override
    public void handlePingReply(PingReply pingReply, ReplyHandler receivingConnection) {
        this.send(pingReply);
    }

    @Override
    public void handleQueryReply(QueryReply queryReply, ReplyHandler receivingConnection) {
        byte[] origGUID;
        boolean checkOOB = true;
        if (this.guidMap != null && (origGUID = this.guidMap.getOriginalGUID(queryReply.getGUID())) != null) {
            checkOOB = false;
            byte prevHops = queryReply.getHops();
            queryReply = this.queryReplyFactory.createQueryReply(origGUID, queryReply);
            queryReply.setTTL((byte)2);
            queryReply.setHops(prevHops);
        }
        if (checkOOB && queryReply.isUDP() && !queryReply.isReplyToMulticastQuery()) {
            return;
        }
        if (this.myIp != null && queryReply.isLocal() && !this.networkInstanceUtils.isPrivateAddress(queryReply.getIPBytes()) && !queryReply.hasSecureData()) {
            queryReply = this.queryReplyFactory.createWithNewAddress(this.myIp, queryReply);
        }
        this.send(queryReply);
    }

    @Override
    public byte[] getClientGUID() {
        return this.clientGUID;
    }

    @Override
    public void handlePushRequest(PushRequest pushRequest, ReplyHandler receivingConnection) {
        this.send(pushRequest);
    }

    @Override
    public void handleVendorMessage(VendorMessage vm) {
        super.handleVendorMessage(vm);
        if (vm instanceof HopsFlowVendorMessage) {
            HopsFlowVendorMessage hops = (HopsFlowVendorMessage)vm;
            if (this.isSupernodeClientConnection()) {
                this.setBusy(hops.getHopValue() == 0);
            }
            this.hopsFlowMax = hops.getHopValue();
        } else if (vm instanceof PushProxyAcknowledgement) {
            PushProxyAcknowledgement ack = (PushProxyAcknowledgement)vm;
            if (Arrays.equals(ack.getGUID(), this.applicationServices.getMyGUID())) {
                this.myPushProxy = true;
            }
        } else if (vm instanceof CapabilitiesVM) {
            CapabilitiesVM capVM = (CapabilitiesVM)vm;
            int smpV = capVM.supportsSIMPP();
            if (!(smpV == -1 || this.receivedCapVM && smpV <= this.simppManager.get().getVersion())) {
                this.networkUpdateSanityChecker.handleNewRequest(this, NetworkUpdateSanityChecker.RequestType.SIMPP);
                this.send(new SimppRequestVM());
            }
            int latestId = this.updateHandler.get().getLatestId();
            int currentId = capVM.supportsUpdate();
            if (!(currentId == -1 || this.receivedCapVM && currentId <= latestId)) {
                this.networkUpdateSanityChecker.handleNewRequest(this, NetworkUpdateSanityChecker.RequestType.VERSION);
                this.send(new UpdateRequest());
            } else if (currentId == latestId) {
                this.updateHandler.get().handleUpdateAvailable(this, currentId);
            }
            this.receivedCapVM = true;
            this.connectionManager.dispatchEvent(new ConnectionLifecycleEvent(this, ConnectionLifecycleEvent.EventType.CONNECTION_CAPABILITIES, this));
        } else if (vm instanceof MessagesSupportedVendorMessage) {
            if (this.getConnectionCapabilities().isClientSupernodeConnection() && this.getConnectionCapabilities().remoteHostSupportsLeafGuidance() >= 0) {
                List<QueryRequest> queries = this.searchResultHandler.getQueriesToReSend();
                for (QueryRequest qr : queries) {
                    this.send(qr);
                }
            }
            if (this.getConnectionCapabilities().remoteHostSupportsPushProxy() > -1) {
                GUID clientGUID = new GUID(this.applicationServices.getMyGUID());
                PushProxyRequest req = new PushProxyRequest(clientGUID);
                this.send(req);
            }
            if (!this.networkManager.canReceiveUnsolicited() && this.connectionManager.canSendConnectBack(Message.Network.UDP) && this.getConnectionCapabilities().remoteHostSupportsUDPRedirect() > -1) {
                GUID connectBackGUID = this.networkManager.getUDPConnectBackGUID();
                UDPConnectBackVendorMessage udp = new UDPConnectBackVendorMessage(this.networkManager.getPort(), connectBackGUID);
                this.send(udp);
                this.connectionManager.connectBackSent(Message.Network.UDP);
            }
            if (!this.networkManager.acceptedIncomingConnection() && this.connectionManager.canSendConnectBack(Message.Network.TCP) && this.getConnectionCapabilities().remoteHostSupportsTCPRedirect() > -1) {
                TCPConnectBackVendorMessage tcp = new TCPConnectBackVendorMessage(this.networkManager.getPort());
                this.send(tcp);
                this.connectionManager.connectBackSent(Message.Network.TCP);
            }
            if (this.getConnectionCapabilities().isClientSupernodeConnection() && SearchSettings.DISABLE_OOB_V2.getBoolean() && this.getConnectionCapabilities().getSupportedOOBProxyControlVersion() != -1) {
                OOBProxyControlVendorMessage stopv2 = new OOBProxyControlVendorMessage(OOBProxyControlVendorMessage.Control.DISABLE_VERSION_2);
                this.send(stopv2);
            }
        } else if (vm instanceof OOBProxyControlVendorMessage) {
            this._maxDisabledOOBProtocolVersion = ((OOBProxyControlVendorMessage)vm).getMaximumDisabledVersion();
            if (LOG.isTraceEnabled()) {
                LOG.trace("_maxDisabledOOBProtocolVersion set to " + this._maxDisabledOOBProtocolVersion);
            }
        }
    }

    @Override
    public int getNumMessagesSent() {
        return this._connectionStats.getSent();
    }

    @Override
    public int getNumMessagesReceived() {
        return this._connectionStats.getReceived();
    }

    @Override
    public int getNumSentMessagesDropped() {
        return this._connectionStats.getSentDropped();
    }

    @Override
    public long getNumReceivedMessagesDropped() {
        return this._connectionStats.getReceivedDropped();
    }

    @Override
    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getConnectionBandwidthStatistics().getBytesSent()));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getConnectionBandwidthStatistics().getBytesReceived()));
    }

    @Override
    public float getMeasuredUpstreamBandwidth() {
        float retValue = 0.0f;
        try {
            retValue = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
        return retValue;
    }

    @Override
    public float getMeasuredDownstreamBandwidth() {
        float retValue = 0.0f;
        try {
            retValue = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException ide) {
            return 0.0f;
        }
        return retValue;
    }

    @Override
    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    @Override
    public void incrementNextQRPForwardTime(long curTime) {
        this._nextQRPForwardTime = this.isLeafConnection() ? curTime + this.LEAF_QUERY_ROUTE_UPDATE_TIME : curTime + this.ULTRAPEER_QUERY_ROUTE_UPDATE_TIME;
    }

    @Override
    public boolean isKillable() {
        return this._isKillable;
    }

    @Override
    public QueryRouteTable getQueryRouteTableSent() {
        return this._lastQRPTableSent;
    }

    @Override
    public void setQueryRouteTableSent(QueryRouteTable qrt) {
        this._lastQRPTableSent = qrt;
    }

    @Override
    public boolean isMyPushProxy() {
        return this.myPushProxy;
    }

    @Override
    public boolean isPushProxyFor() {
        return this.pushProxyFor;
    }

    @Override
    public void setPushProxyFor(boolean pushProxyFor) {
        this.pushProxyFor = pushProxyFor;
    }

    @Override
    public Object getQRPLock() {
        return this.QRP_LOCK;
    }

    @Override
    public void setLocalePreferencing(boolean b) {
        this._useLocalPreference = b;
    }

    @Override
    public void reply(Message m) {
        this.send(m);
    }

    @Override
    public Map<String, Object> inspect() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("hfm", this.getHopsFlowMax());
        data.put("mdb", Float.valueOf(this.getMeasuredDownstreamBandwidth()));
        data.put("mub", Float.valueOf(this.getMeasuredUpstreamBandwidth()));
        data.put("qrpft", this.getNextQRPForwardTime());
        data.put("nmr", this.getNumMessagesReceived());
        data.put("nms", this.getNumMessagesSent());
        this._connectionStats.addStats(data);
        OutputRunner or = this._outputRunner;
        if (or != null) {
            data.put("or", or.inspect());
        }
        data.put("nrmd", this.getNumReceivedMessagesDropped());
        data.put("nsmd", this.getNumSentMessagesDropped());
        data.put("qrteu", this.getQueryRouteTableEmptyUnits());
        data.put("qrtpf", this.getQueryRouteTablePercentFull());
        data.put("qrts", this.getQueryRouteTableSize());
        data.put("bl", this.isBusyLeaf());
        data.put("k", this.isKillable());
        data.put("pp", this.isPushProxyFor());
        data.put("rhsi", this.getConnectionCapabilities().remoteHostSupportsInspections());
        data.put("tlsc", this.isTLSCapable());
        data.put("tlse", this.isTLSEncoded());
        data.put("br", this.getConnectionBandwidthStatistics().getBytesReceived());
        data.put("bs", this.getConnectionBandwidthStatistics().getBytesSent());
        data.put("ct", this.getConnectionTime());
        data.put("lp", this.getListeningPort());
        data.put("lpref", this.getLocalePref());
        data.put("ubr", this.getConnectionBandwidthStatistics().getUncompressedBytesReceived());
        data.put("ubs", this.getConnectionBandwidthStatistics().getUncompressedBytesSent());
        data.put("ua", this.getConnectionCapabilities().getUserAgent());
        data.put("v", this.getConnectionCapabilities().getVersion());
        data.put("pln", this.getConnectionCapabilities().remoteHostIsPassiveLeafNode());
        data.put("pdn", this.getConnectionCapabilities().remostHostIsPassiveDHTNode());
        data.put("pan", this.getConnectionCapabilities().remostHostIsActiveDHTNode());
        data.put("myip", this.getConnectionCapabilities().getHeadersRead().props().getProperty("Remote-IP"));
        data.put("cguid", this.getClientGUID());
        for (StatsWriters name : this.statsWriters.keySet()) {
            data.put(name.toString(), this.statsWriters.get((Object)name).inspect());
        }
        data.put("incoming", this.incoming.inspect());
        data.put("outgoing", this.outgoing.inspect());
        data.put("badHops", this.droppedBadHops);
        data.put("badAddr", this.droppedBadAddress);
        return data;
    }

    @Override
    public ConnectionRoutingStatistics getRoutedConnectionStatistics() {
        return this;
    }

    @Override
    public final boolean isGoodLeaf() {
        return this.getConnectionCapabilities().isGoodLeaf();
    }

    @Override
    public final boolean isGoodUltrapeer() {
        return this.getConnectionCapabilities().isGoodUltrapeer();
    }

    @Override
    public final boolean isHighDegreeConnection() {
        return this.getConnectionCapabilities().isHighDegreeConnection();
    }

    @Override
    public final boolean isLeafConnection() {
        return this.getConnectionCapabilities().isLeafConnection();
    }

    @Override
    public final boolean isSupernodeClientConnection() {
        return this.getConnectionCapabilities().isSupernodeClientConnection();
    }

    @Override
    public final boolean isUltrapeerQueryRoutingConnection() {
        return this.getConnectionCapabilities().isUltrapeerQueryRoutingConnection();
    }

    @Override
    public final boolean supportsPongCaching() {
        return this.getConnectionCapabilities().supportsPongCaching();
    }

    @Override
    public final ConnectionMessageStatistics getConnectionMessageStatistics() {
        return this;
    }

    private class HandshakeWatcher
    implements HandshakeObserver {
        private Handshaker shaker;
        private GnetConnectObserver observer;

        HandshakeWatcher(GnetConnectObserver observer) {
            this.observer = observer;
        }

        void setHandshaker(Handshaker shaker) {
            this.shaker = shaker;
        }

        public void shutdown() {
            GnutellaConnection.this.setHeaders(this.shaker.getReadHeaders(), this.shaker.getWrittenHeaders());
            GnutellaConnection.this.close();
            this.observer.shutdown();
        }

        public void handleHandshakeFinished(Handshaker shaker) {
            GnutellaConnection.this.postHandshakeInitialize(shaker);
            this.observer.handleConnect();
        }

        public void handleBadHandshake() {
            GnutellaConnection.this.setHeaders(this.shaker.getReadHeaders(), this.shaker.getWrittenHeaders());
            GnutellaConnection.this.close();
            this.observer.handleBadHandshake();
        }

        public void handleNoGnutellaOk(int code, String msg) {
            GnutellaConnection.this.setHeaders(this.shaker.getReadHeaders(), this.shaker.getWrittenHeaders());
            GnutellaConnection.this.close();
            this.observer.handleNoGnutellaOk(code, msg);
        }
    }

    private class AsyncHandshakeConnecter
    implements ConnectObserver {
        private Properties requestHeaders;
        private HandshakeResponder responder;
        private GnetConnectObserver observer;

        AsyncHandshakeConnecter(Properties requestHeaders, HandshakeResponder responder, GnetConnectObserver observer) {
            this.requestHeaders = requestHeaders;
            this.responder = responder;
            this.observer = observer;
        }

        public void handleConnect(Socket socket) throws IOException {
            GnutellaConnection.this.setSocket(socket);
            GnutellaConnection.this.startHandshake(this.requestHeaders, this.responder, this.observer);
        }

        public void shutdown() {
            this.observer.shutdown();
        }

        public void handleIOException(IOException iox) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StatsWriters {
        TOP,
        DEFLATER,
        DELAYER,
        THROTTLE;

    }
}

