/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTBootstrapperFactory;
import com.limegroup.gnutella.dht.DHTBootstrapperImpl;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTNodeFetcherFactory;
import com.limegroup.gnutella.simpp.SimppManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTBootstrapperFactoryImpl
implements DHTBootstrapperFactory {
    private final Provider<SimppManager> simppManager;
    private final DHTNodeFetcherFactory dhtNodeFetcherFactory;

    @Inject
    public DHTBootstrapperFactoryImpl(Provider<SimppManager> simppManager, DHTNodeFetcherFactory dhtNodeFetcherFactory) {
        this.simppManager = simppManager;
        this.dhtNodeFetcherFactory = dhtNodeFetcherFactory;
    }

    @Override
    public DHTBootstrapper createBootstrapper(DHTController dhtController) {
        return new DHTBootstrapperImpl(dhtController, this.simppManager, this.dhtNodeFetcherFactory);
    }
}

