/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTBootstrapperFactory;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.db.AltLocModel;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.db.PushProxiesModel;
import com.limegroup.gnutella.dht.db.PushProxiesValueFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.mojito.db.DHTValueFactory;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.io.MessageDispatcherFactory;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTControllerFacadeImpl
implements DHTControllerFacade {
    private final NetworkManager networkManager;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final SpamServices spamServices;
    private final ScheduledExecutorService backgroundExecutor;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final ConnectionServices connectionServices;
    private final Provider<AltLocValueFactory> altLocValueFactory;
    private final Provider<PushProxiesValueFactory> pushProxyValueFactory;
    private final Provider<AltLocModel> altLocModel;
    private final Provider<PushProxiesModel> pushProxyModel;
    private final Provider<MessageDispatcherFactory> messageDispatcherFactory;
    private final DHTBootstrapperFactory dhtBootstrapperFactory;
    private final Provider<SecurityToken.TokenProvider> securityTokenProvider;
    private final Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager;

    @Inject
    public DHTControllerFacadeImpl(NetworkManager networkManager, Provider<ConnectionManager> connectionManager, Provider<IPFilter> ipFilter, SpamServices spamServices, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, CapabilitiesVMFactory capabilitiesVMFactory, ConnectionServices connectionServices, Provider<AltLocValueFactory> altLocValueFactory, Provider<PushProxiesValueFactory> pushProxyValueFactory, Provider<AltLocModel> altLocModel, Provider<PushProxiesModel> pushProxyModel, Provider<MessageDispatcherFactory> messageDispatcherFactory, DHTBootstrapperFactory dhtBootstrapperFactory, Provider<SecurityToken.TokenProvider> securityTokenProvider, Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager2) {
        this.networkManager = networkManager;
        this.connectionManager = connectionManager;
        this.ipFilter = ipFilter;
        this.spamServices = spamServices;
        this.backgroundExecutor = backgroundExecutor;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.connectionServices = connectionServices;
        this.altLocValueFactory = altLocValueFactory;
        this.pushProxyValueFactory = pushProxyValueFactory;
        this.altLocModel = altLocModel;
        this.pushProxyModel = pushProxyModel;
        this.messageDispatcherFactory = messageDispatcherFactory;
        this.dhtBootstrapperFactory = dhtBootstrapperFactory;
        this.securityTokenProvider = securityTokenProvider;
        this.MACCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
    }

    @Override
    public boolean allow(SocketAddress addr) {
        return this.ipFilter.get().allow(addr);
    }

    @Override
    public byte[] getAddress() {
        return this.networkManager.getAddress();
    }

    @Override
    public StorableModel getAltLocModel() {
        return this.altLocModel.get();
    }

    @Override
    public DHTValueFactory getAltLocValueFactory() {
        return this.altLocValueFactory.get();
    }

    @Override
    public List<RoutedConnection> getInitializedClientConnections() {
        return this.connectionManager.get().getInitializedClientConnections();
    }

    @Override
    public MessageDispatcherFactory getMessageDispatcherFactory() {
        return this.messageDispatcherFactory.get();
    }

    @Override
    public int getPort() {
        return this.networkManager.getPort();
    }

    @Override
    public StorableModel getPushProxyModel() {
        return this.pushProxyModel.get();
    }

    @Override
    public DHTValueFactory getPushProxyValueFactory() {
        return this.pushProxyValueFactory.get();
    }

    @Override
    public boolean isActiveSupernode() {
        return this.connectionServices.isActiveSuperNode();
    }

    @Override
    public boolean isConnected() {
        return this.connectionServices.isConnected();
    }

    @Override
    public void reloadIPFilter() {
        this.spamServices.reloadIPFilter();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runner, long initialDelay, long delay, TimeUnit milliseconds) {
        return this.backgroundExecutor.scheduleWithFixedDelay(runner, initialDelay, delay, milliseconds);
    }

    @Override
    public void sendUpdatedCapabilities() {
        this.connectionManager.get().sendUpdatedCapabilities();
    }

    @Override
    public void updateCapabilities() {
        this.capabilitiesVMFactory.updateCapabilities();
    }

    @Override
    public DHTBootstrapper getDHTBootstrapper(DHTController dhtController) {
        return this.dhtBootstrapperFactory.createBootstrapper(dhtController);
    }

    @Override
    public SecurityToken.TokenProvider getSecurityTokenProvider() {
        return this.securityTokenProvider.get();
    }

    @Override
    public MACCalculatorRepositoryManager getMACCalculatorRespositoryManager() {
        return this.MACCalculatorRepositoryManager.get();
    }
}

