/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.routing.Version;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPushProxiesValue
implements PushProxiesValue {
    public static final DHTValueType PUSH_PROXIES = DHTValueType.valueOf("Gnutella Push Proxy", "PROX");
    public static final Version VERSION = Version.valueOf(0);
    static final String CLIENT_ID = "client-id";
    static final String FWT_VERSION = "fwt-version";
    static final String FEATURES = "features";
    static final String PORT = "port";
    static final String PROXIES = "proxies";
    static final String TLS = "tls";
    private final Version version;

    public AbstractPushProxiesValue(Version version) {
        this.version = version;
    }

    @Override
    public DHTValueType getValueType() {
        return PUSH_PROXIES;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public int size() {
        return this.getValue().length;
    }

    @Override
    public abstract byte[] getGUID();

    @Override
    public abstract int getPort();

    @Override
    public abstract byte getFeatures();

    @Override
    public abstract int getFwtVersion();

    @Override
    public abstract Set<? extends IpPort> getPushProxies();

    @Override
    public abstract BitNumbers getTLSInfo();

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("GUID=").append(new GUID(this.getGUID())).append("\n");
        buffer.append("Features=").append(this.getFeatures()).append("\n");
        buffer.append("FWTVersion=").append(this.getFwtVersion()).append("\n");
        buffer.append("PushProxies=").append(this.getPushProxies()).append("\n");
        return buffer.toString();
    }

    protected static byte[] serialize(PushProxiesValue value) {
        GGEP ggep = new GGEP();
        ggep.put(CLIENT_ID, value.getGUID());
        ggep.put(FEATURES, (int)value.getFeatures());
        ggep.put(FWT_VERSION, value.getFwtVersion());
        byte[] port = new byte[2];
        ByteOrder.short2beb((short)value.getPort(), port, 0);
        ggep.put(PORT, port);
        try {
            Set<? extends IpPort> proxies = value.getPushProxies();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (IpPort ipPort : proxies) {
                byte[] ipp = NetworkUtils.getBytes(ipPort);
                assert (ipp.length == 6 || ipp.length == 18);
                baos.write(ipp.length);
                baos.write(ipp);
            }
            baos.close();
            ggep.put(PROXIES, baos.toByteArray());
            if (!value.getTLSInfo().isEmpty()) {
                ggep.put(TLS, value.getTLSInfo().toByteArray());
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return ggep.toByteArray();
    }

    static BitNumbers getNumbersFromProxies(Set<? extends IpPort> proxies) {
        return BitNumbers.synchronizedBitNumbers(HTTPHeaderUtils.getTLSIndices(proxies));
    }
}

