/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import com.limegroup.gnutella.dht.db.AltLocSearchListener;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.nio.observer.Shutdownable;

@Singleton
public class AltLocFinder {
    private static final Log LOG = LogFactory.getLog(AltLocFinder.class);
    private final DHTManager manager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final PushEndpointFactory pushEndpointFactory;
    private final AltLocManager altLocManager;

    @Inject
    public AltLocFinder(DHTManager manager, AlternateLocationFactory alternateLocationFactory, AltLocManager altLocManager, PushEndpointFactory pushEndpointFactory) {
        this.manager = manager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.altLocManager = altLocManager;
        this.pushEndpointFactory = pushEndpointFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shutdownable findAltLocs(URN urn, AltLocSearchListener listener) {
        if (urn == null) {
            return null;
        }
        DHTManager dHTManager = this.manager;
        synchronized (dHTManager) {
            MojitoDHT dht = this.manager.getMojitoDHT();
            if (dht == null || !dht.isBootstrapped()) {
                return null;
            }
            KUID key = KUIDUtils.toKUID(urn);
            EntityKey lookupKey = EntityKey.createEntityKey(key, AbstractAltLocValue.ALT_LOC);
            final DHTFuture<FindValueResult> future = dht.get(lookupKey);
            future.addDHTFutureListener(new AltLocsHandler(dht, urn, key, listener));
            return new Shutdownable(){

                public void shutdown() {
                    future.cancel(true);
                }
            };
        }
    }

    public boolean findPushAltLocs(GUID guid, URN urn) {
        return this.findPushAltLocs(guid, urn, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findPushAltLocs(GUID guid, URN urn, DHTValueEntity altLocEntity, AltLocSearchListener listener) {
        if (guid == null || urn == null) {
            return false;
        }
        DHTManager dHTManager = this.manager;
        synchronized (dHTManager) {
            MojitoDHT dht = this.manager.getMojitoDHT();
            if (dht == null || !dht.isBootstrapped()) {
                return false;
            }
            KUID key = KUIDUtils.toKUID(guid);
            EntityKey lookupKey = EntityKey.createEntityKey(key, AbstractPushProxiesValue.PUSH_PROXIES);
            DHTFuture<FindValueResult> future = dht.get(lookupKey);
            future.addDHTFutureListener(new PushAltLocsHandler(dht, guid, urn, key, altLocEntity, listener));
            return true;
        }
    }

    private class PushAltLocsHandler
    extends AbstractResultHandler {
        private final GUID guid;
        private final DHTValueEntity altLocEntity;

        private PushAltLocsHandler(MojitoDHT dht, GUID guid, URN urn, KUID key, DHTValueEntity altLocEntity, AltLocSearchListener listener) {
            super(dht, urn, key, listener, AbstractPushProxiesValue.PUSH_PROXIES);
            this.guid = guid;
            this.altLocEntity = altLocEntity;
        }

        protected boolean handleDHTValueEntity(DHTValueEntity entity) {
            DHTValue value = entity.getValue();
            if (!(value instanceof PushProxiesValue)) {
                return false;
            }
            Contact creator = entity.getCreator();
            InetAddress addr = ((InetSocketAddress)creator.getContactAddress()).getAddress();
            PushProxiesValue pushProxies = (PushProxiesValue)value;
            if (this.altLocEntity != null && !creator.equals(this.altLocEntity.getCreator())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Creator of " + this.altLocEntity + " and found " + entity + " do not match!");
                }
                return false;
            }
            byte[] guid = this.guid.bytes();
            if (!Arrays.equals(guid, pushProxies.getGUID())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("The AltLoc and PushProxy GUIDs do not match!");
                }
                return false;
            }
            Set<? extends IpPort> proxies = pushProxies.getPushProxies();
            byte features = pushProxies.getFeatures();
            int fwtVersion = pushProxies.getFwtVersion();
            IpPortImpl ipp = new IpPortImpl(addr, pushProxies.getPort());
            PushEndpoint pe = AltLocFinder.this.pushEndpointFactory.createPushEndpoint(guid, proxies, features, fwtVersion, ipp);
            try {
                AlternateLocation location = AltLocFinder.this.alternateLocationFactory.createPushAltLoc(pe, this.urn);
                AltLocFinder.this.altLocManager.add(location, this);
                return true;
            }
            catch (IOException e) {
                LOG.error("IOException", e);
                return false;
            }
        }
    }

    private class AltLocsHandler
    extends AbstractResultHandler {
        private AltLocsHandler(MojitoDHT dht, URN urn, KUID key, AltLocSearchListener listener) {
            super(dht, urn, key, listener, AbstractAltLocValue.ALT_LOC);
        }

        protected boolean handleDHTValueEntity(DHTValueEntity entity) {
            DHTValue value = entity.getValue();
            if (!(value instanceof AltLocValue)) {
                return false;
            }
            AltLocValue altLoc = (AltLocValue)value;
            if (altLoc.isFirewalled()) {
                if (DHTSettings.ENABLE_PUSH_PROXY_QUERIES.getValue()) {
                    GUID guid = new GUID(altLoc.getGUID());
                    return AltLocFinder.this.findPushAltLocs(guid, this.urn, entity, this.listener);
                }
            } else {
                Contact creator = entity.getCreator();
                InetAddress addr = ((InetSocketAddress)creator.getContactAddress()).getAddress();
                IpPortImpl ipp = new IpPortImpl(addr, altLoc.getPort());
                ConnectableImpl c = new ConnectableImpl(ipp, altLoc.supportsTLS());
                long fileSize = altLoc.getFileSize();
                byte[] ttroot = altLoc.getRootHash();
                try {
                    AlternateLocation location = AltLocFinder.this.alternateLocationFactory.createDirectDHTAltLoc(c, this.urn, fileSize, ttroot);
                    AltLocFinder.this.altLocManager.add(location, this);
                    return true;
                }
                catch (IOException e) {
                    LOG.error("IOException", e);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractResultHandler
    extends DHTFutureAdapter<FindValueResult> {
        protected final MojitoDHT dht;
        protected final URN urn;
        protected final KUID key;
        protected final AltLocSearchListener listener;
        protected final DHTValueType valueType;

        private AbstractResultHandler(MojitoDHT dht, URN urn, KUID key, AltLocSearchListener listener, DHTValueType valueType) {
            this.dht = dht;
            this.urn = urn;
            this.key = key;
            this.listener = listener;
            this.valueType = valueType;
        }

        @Override
        public void handleFutureSuccess(FindValueResult result) {
            boolean success = false;
            if (result.isSuccess()) {
                for (DHTValueEntity dHTValueEntity : result.getEntities()) {
                    if (!this.handleDHTValueEntity(dHTValueEntity)) continue;
                    success = true;
                }
                for (EntityKey entityKey : result.getEntityKeys()) {
                    if (!entityKey.getDHTValueType().equals(this.valueType)) continue;
                    try {
                        DHTFuture<FindValueResult> future = this.dht.get(entityKey);
                        FindValueResult resultFromKey = (FindValueResult)future.get();
                        if (!resultFromKey.isSuccess()) continue;
                        for (DHTValueEntity dHTValueEntity : resultFromKey.getEntities()) {
                            if (!this.handleDHTValueEntity(dHTValueEntity)) continue;
                            success = true;
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.error("ExecutionException", e);
                    }
                    catch (InterruptedException e) {
                        LOG.error("InterruptedException", e);
                    }
                }
            }
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(success);
            }
        }

        protected abstract boolean handleDHTValueEntity(DHTValueEntity var1);

        @Override
        public void handleCancellationException(CancellationException e) {
            LOG.error("CancellationException", e);
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(false);
            }
        }

        @Override
        public void handleExecutionException(ExecutionException e) {
            LOG.error("ExecutionException", e);
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(false);
            }
        }

        @Override
        public void handleInterruptedException(InterruptedException e) {
            LOG.error("InterruptedException", e);
            if (this.listener != null) {
                this.listener.handleAltLocSearchDone(false);
            }
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractResultHandler)) {
                return false;
            }
            AbstractResultHandler other = (AbstractResultHandler)o;
            return this.key.equals(other.key) && this.valueType.equals(other.valueType);
        }
    }
}

