/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.db.PushProxiesValueFactory;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import java.util.Collection;
import java.util.Collections;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.util.DatabaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushProxiesModel
implements StorableModel {
    private Storable localhost = null;
    private final NetworkManager networkManager;
    private final PushProxiesValueFactory pushProxiesValueFactory;
    private final ApplicationServices applicationServices;

    @Inject
    public PushProxiesModel(NetworkManager networkManager, PushProxiesValueFactory pushProxiesValueFactory, ApplicationServices applicationServices) {
        this.networkManager = networkManager;
        this.pushProxiesValueFactory = pushProxiesValueFactory;
        this.applicationServices = applicationServices;
    }

    private synchronized Storable getPushProxyForSelf() {
        if (this.networkManager.acceptedIncomingConnection()) {
            return null;
        }
        if (this.localhost == null) {
            GUID guid = new GUID(this.applicationServices.getMyGUID());
            KUID primaryKey = KUIDUtils.toKUID(guid);
            this.localhost = new Storable(primaryKey, this.pushProxiesValueFactory.createDHTValueForSelf());
        }
        return this.localhost;
    }

    @Override
    public Collection<Storable> getStorables() {
        if (!DHTSettings.PUBLISH_PUSH_PROXIES.getValue()) {
            return Collections.emptySet();
        }
        Storable localhost = this.getPushProxyForSelf();
        if (localhost != null && DatabaseUtils.isPublishingRequired(localhost)) {
            return Collections.singleton(localhost);
        }
        return Collections.emptySet();
    }

    @Override
    public void handleStoreResult(Storable storable, StoreResult result) {
    }

    @Override
    public synchronized void handleContactChange() {
        this.localhost = null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("PushProxiesPublisher: ");
        buffer.append(this.getPushProxyForSelf());
        return buffer.toString();
    }
}

