/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Provider;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadState;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HTTPDownloaderFactory;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.MultiShutdownable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.io.IOUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.statemachine.IOStateObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadWorker {
    private static final Log LOG = LogFactory.getLog(DownloadWorker.class);
    private static final int MIN_SPLIT_SIZE = 16384;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    private static final int UNKNOWN_SPEED = -1;
    private static int NORMAL_CONNECT_TIME = 10000;
    private static int PUSH_CONNECT_TIME = 20000;
    private static final int UDP_PUSH_CONNECT_TIME = 6000;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    public static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    private final DownloadWorkerSupport _manager;
    private final RemoteFileDesc _rfd;
    private final VerifyingFile _commonOutFile;
    private final AtomicBoolean _interrupted = new AtomicBoolean(false);
    private volatile HTTPDownloader _downloader;
    private volatile boolean _shouldRelease;
    private final String _workerName;
    private DirectConnector _connectObserver;
    private DownloadState _currentState;
    private volatile boolean _stealing;
    private final HTTPDownloaderFactory httpDownloaderFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final ScheduledExecutorService nioExecutor;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final SocketsManager socketsManager;

    protected DownloadWorker(DownloadWorkerSupport manager, RemoteFileDesc rfd, VerifyingFile vf, HTTPDownloaderFactory httpDownloaderFactory, ScheduledExecutorService backgroundExecutor, ScheduledExecutorService nioExecutor, Provider<PushDownloadManager> pushDownloadManager, SocketsManager socketsManager) {
        this.httpDownloaderFactory = httpDownloaderFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.nioExecutor = nioExecutor;
        this.pushDownloadManager = pushDownloadManager;
        this.socketsManager = socketsManager;
        this._manager = manager;
        this._rfd = rfd;
        this._commonOutFile = vf;
        this._currentState = new DownloadState();
        this._workerName = LOG.isDebugEnabled() ? "DownloadWorker for " + this._manager.getSaveFile().getName() + " #" + System.identityHashCode(this) : "DownloaderWorker";
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting worker: " + this._workerName);
        }
        this.establishConnection();
    }

    private void initializeAlternateLocations() {
        int count = 0;
        for (AlternateLocation current : this._manager.getValidAlts()) {
            if (count++ >= 10) break;
            this._downloader.addSuccessfulAltLoc(current);
        }
        count = 0;
        for (AlternateLocation current : this._manager.getInvalidAlts()) {
            if (count++ >= 10) break;
            this._downloader.addFailedAltLoc(current);
        }
    }

    private void httpLoop() {
        LOG.debug("Starting HTTP Loop");
        this.incrementState(null);
    }

    public void incrementState(ConnectionStatus status) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("WORKER: " + this + ", State Changed, Current: " + this._currentState + ", status: " + status);
        }
        if (this._interrupted.get()) {
            this.finishHttpLoop();
            return;
        }
        switch (this._currentState.getCurrentState()) {
            case 6: {
                this.releaseRanges();
            }
            case 0: 
            case 5: {
                this._currentState.setHttp11(this._rfd.isHTTP11());
                this._currentState.setState(1);
                if (this.requestTHEXIfNeeded()) break;
            }
            case 1: {
                this._currentState.setState(2);
                if (this.downloadThexIfNeeded()) break;
            }
            case 2: {
                this._currentState.setState(3);
                if (this.consumeBodyIfNeeded()) break;
            }
            case 3: {
                this._downloader.forgetRanges();
                if (status == null || !status.isQueued()) {
                    this._currentState.setState(4);
                    if (this.assignAndRequest()) break;
                    this.finishHttpLoop();
                    break;
                }
            }
            case 4: {
                this.httpRequestFinished(status);
                break;
            }
            default: {
                throw new IllegalStateException("bad state: " + this._currentState);
            }
        }
    }

    private boolean consumeBodyIfNeeded() {
        if (this._downloader.isBodyConsumed()) {
            LOG.debug("Not consuming body.");
            return false;
        }
        this._downloader.consumeBody(new State(){

            protected void handleState(boolean success) {
                if (!success) {
                    DownloadWorker.this.handleRFDFailure();
                }
            }
        });
        return true;
    }

    private void handleRFDFailure() {
        this._rfd.incrementFailedCount();
        LOG.debug("handling rfd failure for " + this._rfd + " with count now " + this._rfd.getFailedCount());
        if (this._rfd.getFailedCount() < 2) {
            LOG.debug("will try again in a minute");
            this._rfd.setRetryAfter(60);
            this._manager.addRFD(this._rfd);
        } else {
            this._manager.informMesh(this._rfd, false);
        }
    }

    private void httpRequestFinished(ConnectionStatus status) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP req finished, status: " + status);
        }
        this._manager.addPossibleSources(this._downloader.getLocationsReceived());
        if (status.isNoData() || status.isNoFile()) {
            this.finishHttpLoop();
        } else {
            if (!status.isConnected()) {
                this.releaseRanges();
            }
            if (!status.isQueued()) {
                this._manager.removeQueuedWorker(this);
            }
            if (status.isPartialData()) {
                this._currentState.setState(0);
                this.incrementState(null);
            } else {
                assert (status.isQueued() || status.isConnected());
                boolean queued = this._manager.killQueuedIfNecessary(this, !status.isQueued() ? -1 : status.getQueuePosition());
                if (status.isConnected()) {
                    this._currentState.setState(6);
                    this.beginDownload();
                } else if (!queued) {
                    this.finishHttpLoop();
                } else {
                    this.handleQueued(status);
                }
            }
        }
    }

    private void beginDownload() {
        try {
            this._downloader.doDownload(new State(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleState(boolean success) {
                    if (success) {
                        DownloadWorker.this._rfd.resetFailedCount();
                    } else {
                        DownloadWorker.this._manager.workerFailed(DownloadWorker.this);
                    }
                    if (DownloadWorker.this._commonOutFile.isHopeless()) {
                        DownloadWorker.this._manager.promptAboutCorruptDownload();
                    }
                    long stop = DownloadWorker.this._downloader.getInitialReadingPoint() + DownloadWorker.this._downloader.getAmountRead();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WORKER: terminating from " + DownloadWorker.this._downloader + " at " + stop + " error? " + !success);
                    }
                    DownloadWorkerSupport downloadWorkerSupport = DownloadWorker.this._manager;
                    synchronized (downloadWorkerSupport) {
                        if (!success) {
                            DownloadWorker.this._downloader.stop();
                            DownloadWorker.this.handleRFDFailure();
                        } else {
                            DownloadWorker.this._manager.informMesh(DownloadWorker.this._rfd, true);
                            if (!DownloadWorker.this._currentState.isHttp11()) {
                                DownloadWorker.this._manager.addRFD(DownloadWorker.this._rfd);
                            }
                        }
                    }
                }
            });
        }
        catch (SocketException se) {
            this.finishHttpLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestTHEXIfNeeded() {
        boolean shouldRequest = false;
        VerifyingFile verifyingFile = this._commonOutFile;
        synchronized (verifyingFile) {
            if (!this._commonOutFile.isHashTreeRequested()) {
                HashTree ourTree = this._commonOutFile.getHashTree();
                boolean bl = shouldRequest = this._downloader.hasHashTree() && this._manager.getSha1Urn() != null && (ourTree == null || !ourTree.isDepthGoodEnough());
                if (shouldRequest) {
                    this._commonOutFile.setHashTreeRequested(true);
                }
            }
        }
        if (shouldRequest) {
            this._downloader.requestHashTree(this._manager.getSha1Urn(), new State(){

                protected void handleState(boolean success) {
                }
            });
        }
        return shouldRequest;
    }

    private boolean downloadThexIfNeeded() {
        if (!this._downloader.isRequestingThex()) {
            return false;
        }
        ConnectionStatus status = this._downloader.parseThexResponseHeaders();
        if (!status.isConnected()) {
            this._rfd.setTHEXFailed();
            this.incrementState(status);
        } else {
            this._manager.removeQueuedWorker(this);
            this._downloader.downloadThexBody(this._manager.getSha1Urn(), new State(){

                protected void handleState(boolean success) {
                    HashTree newTree = DownloadWorker.this._downloader.getHashTree();
                    DownloadWorker.this._manager.hashTreeRead(newTree);
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRanges() {
        long high;
        long low;
        HTTPDownloader downloader;
        if (!this._shouldRelease) {
            return;
        }
        this._shouldRelease = false;
        if (this._commonOutFile.isComplete()) {
            return;
        }
        HTTPDownloader hTTPDownloader = downloader = this._downloader;
        synchronized (hTTPDownloader) {
            low = downloader.getInitialReadingPoint() + downloader.getAmountRead();
            low = Math.max(low, downloader.getInitialWritingPoint());
            high = downloader.getInitialReadingPoint() + downloader.getAmountToRead() - 1L;
        }
        if (high - low >= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releasing ranges " + Range.createRange(low, high));
            }
            try {
                this._commonOutFile.releaseBlock(Range.createRange(low, high));
            }
            catch (AssertFailure bad) {
                downloader.createAssertionReport(bad);
            }
            downloader.forgetRanges();
        } else {
            LOG.debug("nothing to release!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueued(ConnectionStatus status) {
        this._manager.removeActiveWorker(this);
        DownloadState downloadState = this._currentState;
        synchronized (downloadState) {
            if (this._interrupted.get()) {
                LOG.debug("Exiting from queueing");
                return;
            }
            LOG.debug("Queueing");
            this._currentState.setState(5);
        }
        this.backgroundExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.debug("Queue time up");
                DownloadState downloadState = DownloadWorker.this._currentState;
                synchronized (downloadState) {
                    if (DownloadWorker.this._interrupted.get()) {
                        LOG.warn("WORKER: interrupted while waiting in queue " + DownloadWorker.this._downloader);
                        return;
                    }
                }
                DownloadWorker.this.nioExecutor.execute(new Runnable(){

                    public void run() {
                        DownloadWorker.this.incrementState(null);
                    }
                });
            }
        }, (long)status.getQueuePollTime(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("establishConnection(" + this._rfd + ")");
        }
        if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted.get()) {
            this._manager.addRFD(this._rfd);
            this.finishWorker();
            return;
        }
        boolean needsPush = this._rfd.needsPush();
        DownloadWorkerSupport downloadWorkerSupport = this._manager;
        synchronized (downloadWorkerSupport) {
            Downloader.DownloadStatus state = this._manager.getState();
            if (this._manager.getNumDownloaders() == 0 && state != Downloader.DownloadStatus.COMPLETE && state != Downloader.DownloadStatus.ABORTED && state != Downloader.DownloadStatus.GAVE_UP && state != Downloader.DownloadStatus.DISK_PROBLEM && state != Downloader.DownloadStatus.CORRUPT_FILE && state != Downloader.DownloadStatus.HASHING && state != Downloader.DownloadStatus.SAVING) {
                if (this._interrupted.get()) {
                    return;
                }
                this._manager.setState(Downloader.DownloadStatus.CONNECTING);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WORKER: attempting connect to " + this._rfd.getHost() + ":" + this._rfd.getPort());
        }
        this._manager.incrementTriedHostsCount();
        if (this._rfd.isReplyToMulticast()) {
            this.connectWithPush(new PushConnector(false, true));
        } else if (!needsPush) {
            this.connectDirectly(new DirectConnector(true));
        } else {
            this.connectWithPush(new PushConnector(true, false));
        }
    }

    private boolean finishConnect() {
        if (this._downloader == null) {
            this._manager.informMesh(this._rfd, false);
            return false;
        }
        if (this._interrupted.get()) {
            this._downloader.stop();
            this._downloader = null;
            return false;
        }
        return true;
    }

    private void connectDirectly(DirectConnector observer) {
        if (!this._interrupted.get()) {
            SocketsManager.ConnectType type;
            SocketsManager.ConnectType connectType = type = this._rfd.isTLSCapable() && SSLSettings.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
            if (LOG.isTraceEnabled()) {
                LOG.trace("WORKER: attempt asynchronous direct connection w/ " + (Object)((Object)type) + " to: " + this._rfd);
            }
            this._connectObserver = observer;
            try {
                Socket socket = this.socketsManager.connect(new InetSocketAddress(this._rfd.getHost(), this._rfd.getPort()), NORMAL_CONNECT_TIME, observer, type);
                if (!observer.isShutdown()) {
                    observer.setSocket(socket);
                }
            }
            catch (IOException iox) {
                observer.shutdown();
            }
        } else {
            this.finishWorker();
        }
    }

    private void connectWithPush(PushConnector observer) {
        if (!this._interrupted.get()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("WORKER: attempt push connection to: " + this._rfd + " proxies " + this._rfd.getPushProxies());
            }
            this._connectObserver = null;
            final PushDetails details = new PushDetails(this._rfd.getClientGUID(), this._rfd.getHost());
            observer.setPushDetails(details);
            this._manager.registerPushObserver(observer, details);
            this.pushDownloadManager.get().sendPush(this._rfd, observer);
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    DownloadWorker.this._manager.unregisterPushObserver(details, true);
                }
            }, this._rfd.isFromAlternateLocation() ? 6000L : (long)PUSH_CONNECT_TIME, TimeUnit.MILLISECONDS);
        } else {
            this.finishWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInfo() {
        if (this._downloader != null) {
            HTTPDownloader hTTPDownloader = this._downloader;
            synchronized (hTTPDownloader) {
                return this + "hashcode " + System.identityHashCode(this._downloader) + " will release? " + this._shouldRelease + " interrupted? " + this._interrupted.get() + " active? " + this._downloader.isActive() + " victim? " + this._downloader.isVictim() + " initial reading " + this._downloader.getInitialReadingPoint() + " initial writing " + this._downloader.getInitialWritingPoint() + " amount to read " + this._downloader.getAmountToRead() + " amount read " + this._downloader.getAmountRead() + " is in stealing " + this.isStealing() + "\n";
            }
        }
        return "worker not started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignAndRequest() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("assignAndRequest for: " + this._rfd);
        }
        Range interval = null;
        try {
            VerifyingFile verifyingFile = this._commonOutFile;
            synchronized (verifyingFile) {
                if (this._commonOutFile.hasFreeBlocksToAssign() > 0L) {
                    interval = this.pickAvailableInterval();
                }
            }
        }
        catch (NoSuchRangeException nsre) {
            this.handleNoRanges();
            return false;
        }
        if (interval == null) {
            if (!this.assignGrey()) {
                return false;
            }
        } else {
            this.assignWhite(interval);
        }
        return true;
    }

    private void completeAssignAndRequest(IOException x, Range range, DownloadWorker victim) {
        ConnectionStatus status = this.completeAssignAndRequestImpl(x, range, victim);
        if (victim != null) {
            victim.setStealing(false);
            this.setStealing(false);
        }
        this.incrementState(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus completeAssignAndRequestImpl(IOException x, Range range, DownloadWorker victim) {
        try {
            try {
                this._downloader.parseHeaders();
            }
            finally {
                if (x != null) {
                    throw x;
                }
            }
            if (victim == null) {
                this.completeAssignWhite(range);
            } else {
                this.completeAssignGrey(victim, range);
            }
        }
        catch (NoSuchElementException nsex) {
            LOG.debug(this._downloader, nsex);
            return this.handleNoMoreDownloaders();
        }
        catch (NoSuchRangeException nsrx) {
            LOG.debug(this._downloader, nsrx);
            return this.handleNoRanges();
        }
        catch (TryAgainLaterException talx) {
            LOG.debug(this._downloader, talx);
            return this.handleTryAgainLater();
        }
        catch (RangeNotAvailableException rnae) {
            LOG.debug(this._downloader, rnae);
            return this.handleRangeNotAvailable();
        }
        catch (FileNotFoundException fnfx) {
            LOG.debug(this._downloader, fnfx);
            return this.handleFileNotFound();
        }
        catch (NotSharingException nsx) {
            LOG.debug(this._downloader, nsx);
            return this.handleNotSharing();
        }
        catch (QueuedException qx) {
            LOG.debug(this._downloader, qx);
            return this.handleQueued(qx.getQueuePosition(), qx.getMinPollTime());
        }
        catch (ProblemReadingHeaderException prhe) {
            LOG.debug(this._downloader, prhe);
            return this.handleProblemReadingHeader();
        }
        catch (UnknownCodeException uce) {
            LOG.debug(this._downloader, uce);
            return this.handleUnknownCode();
        }
        catch (ContentUrnMismatchException cume) {
            LOG.debug(this._downloader, cume);
            return ConnectionStatus.getNoFile();
        }
        catch (IOException iox) {
            LOG.debug(this._downloader, iox);
            return this.handleIO();
        }
        this._rfd.resetFailedCount();
        DownloadWorkerSupport downloadWorkerSupport = this._manager;
        synchronized (downloadWorkerSupport) {
            if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted.get()) {
                LOG.trace("Stopped in assignAndRequest");
                this._manager.addRFD(this._rfd);
                return ConnectionStatus.getNoData();
            }
            this._manager.workerStarted(this);
        }
        return ConnectionStatus.getConnected();
    }

    private void assignWhite(Range interval) {
        final long low = interval.getLow();
        final long high = interval.getHigh();
        this._shouldRelease = true;
        this._downloader.connectHTTP(low, high + 1L, true, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, Range.createRange(low, high), null);
            }

            public void handleIOException(IOException iox) {
                DownloadWorker.this.completeAssignAndRequest(iox, null, null);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignWhite(Range expectedRange) {
        HTTPDownloader hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader) {
            long low = expectedRange.getLow();
            long high = expectedRange.getHigh();
            long newLow = this._downloader.getInitialReadingPoint();
            long newHigh = this._downloader.getAmountToRead() - 1L + newLow;
            if (newHigh - newLow >= 0L) {
                if (newLow > low) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WORKER: Host gave subrange, different low.  Was: " + low + ", is now: " + newLow);
                    }
                    this._commonOutFile.releaseBlock(Range.createRange(low, newLow - 1L));
                }
                if (newHigh < high) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("WORKER: Host gave subrange, different high.  Was: " + high + ", is now: " + newHigh);
                    }
                    this._commonOutFile.releaseBlock(Range.createRange(newHigh + 1L, high));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WORKER: assigning white " + newLow + "-" + newHigh + " to " + this._downloader);
                }
            } else {
                LOG.debug("debouched at birth");
            }
        }
    }

    private Range pickAvailableInterval() throws NoSuchRangeException {
        Range interval = null;
        if (!this._downloader.getRemoteFileDesc().isPartialSource()) {
            interval = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(this.findChunkSize()) : this._commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet availableRanges = this._downloader.getRemoteFileDesc().getAvailableRanges();
                interval = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(availableRanges, this.findChunkSize()) : this._commonOutFile.leaseWhite(availableRanges);
            }
            catch (NoSuchElementException nsee) {
                throw new NoSuchRangeException();
            }
        }
        return interval;
    }

    private long findChunkSize() {
        long chunkSize = this._commonOutFile.getChunkSize();
        long free = this._commonOutFile.hasFreeBlocksToAssign();
        if (free <= chunkSize && this._manager.getActiveWorkers().size() > 1) {
            chunkSize = Math.max(16384L, free / 2L);
        }
        return chunkSize;
    }

    private boolean assignGrey() {
        if (this.isStealing()) {
            return false;
        }
        if (this._downloader.getRemoteFileDesc().isPartialSource()) {
            this.handleNoRanges();
            return false;
        }
        final DownloadWorker slowest = this.findSlowestDownloader();
        if (slowest == null) {
            LOG.debug("didn't find anybody to steal from");
            this.handleNoMoreDownloaders();
            return false;
        }
        final Range slowestRange = slowest.getDownloadInterval();
        if (slowestRange.getLow() == slowestRange.getHigh()) {
            this.handleNoMoreDownloaders();
            return false;
        }
        slowest.setStealing(true);
        this.setStealing(true);
        this._downloader.connectHTTP(slowestRange.getLow(), slowestRange.getHigh(), false, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, slowestRange, slowest);
            }

            public void handleIOException(IOException iox) {
                DownloadWorker.this.completeAssignAndRequest(iox, null, slowest);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, slowest);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignGrey(DownloadWorker victim, Range slowestRange) throws IOException {
        long newStart;
        HTTPDownloader hTTPDownloader = victim.getDownloader();
        synchronized (hTTPDownloader) {
            if (!victim.getDownloader().isActive()) {
                LOG.debug("victim is no longer active");
                throw new NoSuchElementException();
            }
            Range newSlowestRange = victim.getDownloadInterval();
            if (newSlowestRange.getHigh() != slowestRange.getHigh()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("victim is now downloading something else " + newSlowestRange + " vs. " + slowestRange);
                }
                throw new NoSuchElementException();
            }
            if (newSlowestRange.getLow() > slowestRange.getLow() && LOG.isDebugEnabled()) {
                LOG.debug("victim managed to download " + (newSlowestRange.getLow() - slowestRange.getLow()) + " bytes while stealer was connecting");
            }
            long myLow = this._downloader.getInitialReadingPoint();
            long myHigh = this._downloader.getAmountToRead() + myLow;
            if (myHigh < slowestRange.getHigh()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("WORKER: not stealing because stealer gave a subrange.  Expected low: " + slowestRange.getLow() + ", high: " + slowestRange.getHigh() + ".  Was low: " + myLow + ", high: " + myHigh);
                }
                throw new IOException();
            }
            newStart = Math.max(newSlowestRange.getLow(), myLow);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER: picking stolen grey " + newStart + "-" + slowestRange.getHigh() + " from [" + victim + "] to [" + this + "]");
            }
            victim.getDownloader().stopAt(newStart);
        }
        this._downloader.startAt(newStart);
        this._shouldRelease = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Range getDownloadInterval() {
        HTTPDownloader downloader;
        HTTPDownloader hTTPDownloader = downloader = this._downloader;
        synchronized (hTTPDownloader) {
            long start = Math.max(downloader.getInitialReadingPoint() + downloader.getAmountRead(), downloader.getInitialWritingPoint());
            long stop = downloader.getInitialReadingPoint() + downloader.getAmountToRead();
            return Range.createRange(start, stop);
        }
    }

    private void setStealing(boolean stealing) {
        this._stealing = stealing;
    }

    boolean isStealing() {
        return this._stealing;
    }

    private DownloadWorker findSlowestDownloader() {
        float ourSpeed;
        DownloadWorker slowest = null;
        float slowestSpeed = ourSpeed = this.getOurSpeed();
        Set<DownloadWorker> queuedWorkers = this._manager.getQueuedWorkers().keySet();
        for (DownloadWorker worker : this._manager.getAllWorkers()) {
            HTTPDownloader h;
            if (worker.isStealing() || queuedWorkers.contains(worker) || (h = worker.getDownloader()) == null || h == this._downloader || h.isVictim()) continue;
            if (ourSpeed == -1.0f) {
                if (!worker.isSlow()) continue;
                return worker;
            }
            float hisSpeed = 0.0f;
            try {
                h.getMeasuredBandwidth();
                hisSpeed = h.getAverageBandwidth();
            }
            catch (InsufficientDataException ide) {
                hisSpeed = Math.max(0.0f, ourSpeed - 0.1f);
            }
            if (!(hisSpeed < slowestSpeed)) continue;
            slowestSpeed = hisSpeed;
            slowest = worker;
        }
        return slowest;
    }

    private float getOurSpeed() {
        if (this._downloader == null) {
            return -1.0f;
        }
        try {
            this._downloader.getMeasuredBandwidth();
            return this._downloader.getAverageBandwidth();
        }
        catch (InsufficientDataException bad) {
            return -1.0f;
        }
    }

    boolean isSlow() {
        float ourSpeed = this.getOurSpeed();
        return ourSpeed < MIN_ACCEPTABLE_SPEED && ourSpeed != -1.0f;
    }

    private ConnectionStatus handleNoMoreDownloaders() {
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoData();
    }

    private ConnectionStatus handleNoRanges() {
        this._rfd.setAvailableRanges(null);
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(300);
        }
        this._rfd.resetFailedCount();
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleTryAgainLater() {
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(60);
        }
        if (!this._manager.getActiveWorkers().isEmpty() && this._rfd.getWaitTime(System.currentTimeMillis()) < 600) {
            this._rfd.setRetryAfter(600);
        }
        this._manager.addRFD(this._rfd);
        this._rfd.resetFailedCount();
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleRangeNotAvailable() {
        this._rfd.resetFailedCount();
        this._manager.informMesh(this._rfd, true);
        return ConnectionStatus.getPartialData();
    }

    private ConnectionStatus handleFileNotFound() {
        this._manager.informMesh(this._rfd, false);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleNotSharing() {
        return this.handleFileNotFound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus handleQueued(int position, int pollTime) {
        DownloadWorkerSupport downloadWorkerSupport = this._manager;
        synchronized (downloadWorkerSupport) {
            if (this._manager.getActiveWorkers().isEmpty()) {
                if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted.get()) {
                    return ConnectionStatus.getNoData();
                }
                this._manager.setState(Downloader.DownloadStatus.REMOTE_QUEUED);
            }
            this._rfd.resetFailedCount();
            return ConnectionStatus.getQueued(position, pollTime);
        }
    }

    private ConnectionStatus handleProblemReadingHeader() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleUnknownCode() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleIO() {
        this.handleRFDFailure();
        return ConnectionStatus.getNoFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        boolean finishLoop;
        if (this._interrupted.getAndSet(true)) {
            return;
        }
        DownloadState downloadState = this._currentState;
        synchronized (downloadState) {
            finishLoop = this._currentState.getCurrentState() == 5;
        }
        if (finishLoop) {
            this.finishHttpLoop();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping while state is: " + this._currentState + ", this: " + this.toString());
        }
        if (this._downloader != null) {
            this._downloader.stop();
        } else {
            Socket socket;
            DirectConnector observer = this._connectObserver;
            if (observer != null && (socket = observer.getSocket()) != null) {
                IOUtils.close(socket);
            }
        }
    }

    public RemoteFileDesc getRFD() {
        return this._rfd;
    }

    HTTPDownloader getDownloader() {
        return this._downloader;
    }

    public String toString() {
        return this._workerName + "[" + this._currentState + "] -> " + this._rfd;
    }

    private void finishWorker() {
        this._interrupted.set(true);
        this._manager.workerFinished(this);
    }

    private void startDownload(HTTPDownloader dl) {
        this._downloader = dl;
        if (this.finishConnect()) {
            LOG.trace("Starting download");
            this.initializeAlternateLocations();
            this.httpLoop();
        } else {
            this.finishWorker();
        }
    }

    private void finishHttpLoop() {
        this.releaseRanges();
        this._manager.removeQueuedWorker(this);
        this._downloader.stop();
        this.finishWorker();
    }

    private class DirectConnector
    extends HTTPConnectObserver {
        private boolean pushConnectOnFailure;
        private Socket connectingSocket;
        private boolean shutdown;

        DirectConnector(boolean pushConnectOnFailure) {
            this.pushConnectOnFailure = pushConnectOnFailure;
        }

        public void handleConnect(Socket socket) {
            this.connectingSocket = null;
            HTTPDownloader dl = DownloadWorker.this.httpDownloaderFactory.create(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, DownloadWorker.this._manager instanceof InNetworkDownloader);
            try {
                dl.initializeTCP();
            }
            catch (IOException iox) {
                this.shutdown();
                return;
            }
            DownloadWorker.this.startDownload(dl);
        }

        public void shutdown() {
            this.shutdown = true;
            this.connectingSocket = null;
            if (this.pushConnectOnFailure) {
                DownloadWorker.this.connectWithPush(new PushConnector(false, false));
            } else {
                DownloadWorker.this.finishConnect();
                DownloadWorker.this.finishWorker();
            }
        }

        void setSocket(Socket socket) {
            this.connectingSocket = socket;
        }

        Socket getSocket() {
            return this.connectingSocket;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }

    private class PushConnector
    extends HTTPConnectObserver
    implements MultiShutdownable {
        private boolean forgetOnFailure;
        private boolean directConnectOnFailure;
        private PushDetails pushDetails;
        private volatile Shutdownable toCancel;
        private AtomicBoolean shutdown = new AtomicBoolean(false);

        PushConnector(boolean forgetOnFailure, boolean directConnectOnFailure) {
            this.forgetOnFailure = forgetOnFailure;
            this.directConnectOnFailure = directConnectOnFailure;
        }

        public void addShutdownable(Shutdownable newCancel) {
            this.toCancel = newCancel;
        }

        public void handleConnect(Socket socket) {
            HTTPDownloader dl = DownloadWorker.this.httpDownloaderFactory.create(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, DownloadWorker.this._manager instanceof InNetworkDownloader);
            try {
                dl.initializeTCP();
            }
            catch (IOException iox) {
                this.failed();
                return;
            }
            DownloadWorker.this.startDownload(dl);
        }

        public boolean isCancelled() {
            return this.shutdown.get();
        }

        public void shutdown() {
            if (this.shutdown.getAndSet(true)) {
                return;
            }
            Shutdownable canceller = this.toCancel;
            if (canceller != null) {
                canceller.shutdown();
            }
            this.failed();
        }

        void setPushDetails(PushDetails details) {
            this.pushDetails = details;
        }

        private void failed() {
            DownloadWorker.this._manager.unregisterPushObserver(this.pushDetails, false);
            if (!this.directConnectOnFailure) {
                if (this.forgetOnFailure) {
                    DownloadWorker.this._manager.forgetRFD(DownloadWorker.this._rfd);
                }
                DownloadWorker.this.finishConnect();
                DownloadWorker.this.finishWorker();
            } else {
                DownloadWorker.this.connectDirectly(new DirectConnector(false));
            }
        }
    }

    private abstract class State
    implements IOStateObserver {
        private State() {
        }

        public final void handleIOException(IOException iox) {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        public final void handleStatesFinished() {
            this.handleState(true);
            DownloadWorker.this.incrementState(null);
        }

        public final void shutdown() {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        protected abstract void handleState(boolean var1);
    }
}

