/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Provider;
import com.google.inject.util.Objects;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocUtils;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.NoHTTPOKException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.http.SimpleReadHeaderState;
import com.limegroup.gnutella.http.SimpleWriteHeaderState;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.ThexReader;
import com.limegroup.gnutella.tigertree.ThexReaderFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.Function;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.io.Connectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.channel.ThrottleReader;
import org.limewire.nio.statemachine.IOState;
import org.limewire.nio.statemachine.IOStateMachine;
import org.limewire.nio.statemachine.IOStateObserver;
import org.limewire.nio.statemachine.ReadSkipState;
import org.limewire.nio.statemachine.ReadState;
import org.limewire.rudp.RUDPSocket;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPDownloader
implements BandwidthTracker {
    private static final Log LOG = LogFactory.getLog(HTTPDownloader.class);
    public static final int BUF_LENGTH = 2048;
    private static final int MIN_RETRY_AFTER = 60;
    private static final int MAX_RETRY_AFTER = 3600;
    static volatile int MIN_PARTIAL_FILE_BYTES = 0x100000;
    private RemoteFileDesc _rfd;
    private long _index;
    private String _filename;
    private byte[] _guid;
    private long _totalAmountRead;
    private long _amountRead;
    private long _amountToRead;
    private volatile boolean _disconnect;
    private long _initialReadingPoint;
    private long _initialWritingPoint;
    private long _contentLength;
    private volatile boolean _bodyConsumed = true;
    private Socket _socket;
    private IOStateMachine _stateMachine;
    private Observer observerHandler;
    private SimpleReadHeaderState _headerReader;
    private boolean _requestingThex;
    private ThexReader _thexReader;
    private final VerifyingFile _incompleteFile;
    private Set<RemoteFileDesc> _locationsReceived;
    private Set<DirectAltLoc> _goodLocs;
    private Set<PushAltLoc> _goodPushLocs;
    private Set<PushAltLoc> _badPushLocs;
    private Set<DirectAltLoc> _badLocs;
    private Set<DirectAltLoc> _writtenGoodLocs;
    private Set<DirectAltLoc> _writtenBadLocs;
    private Set<PushAltLoc> _writtenPushLocs;
    private Set<PushAltLoc> _writtenBadPushLocs;
    private int _port;
    private String _host;
    private boolean _chatEnabled = false;
    private boolean _browseEnabled = false;
    private String _server = "";
    private String _thexUri = null;
    private String _root32 = null;
    private boolean _thexSucceeded = false;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isActive = false;
    private Range _requestedInterval = null;
    private boolean _wantsFalts = false;
    private final boolean _inNetwork;
    private final NetworkManager networkManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final DownloadManager downloadManager;
    private final CreationTimeCache creationTimeCache;
    private final BandwidthManager bandwidthManager;
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final PushEndpointFactory pushEndpointFactory;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final ThexReaderFactory thexReaderFactory;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    HTTPDownloader(Socket socket, RemoteFileDesc rfd, VerifyingFile incompleteFile, boolean inNetwork, boolean requireSocket, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, DownloadManager downloadManager, CreationTimeCache creationTimeCache, BandwidthManager bandwidthManager, Provider<PushEndpointCache> pushEndpointCache, PushEndpointFactory pushEndpointFactory, RemoteFileDescFactory remoteFileDescFactory, ThexReaderFactory thexReaderFactory, TcpBandwidthStatistics tcpBandwidthStatistics, NetworkInstanceUtils networkInstanceUtils) {
        if (requireSocket && socket == null) {
            throw new NullPointerException("null socket");
        }
        this.networkManager = networkManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.downloadManager = downloadManager;
        this.creationTimeCache = creationTimeCache;
        this.bandwidthManager = bandwidthManager;
        this.pushEndpointCache = pushEndpointCache;
        this.pushEndpointFactory = pushEndpointFactory;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.thexReaderFactory = thexReaderFactory;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
        this._rfd = Objects.nonNull(rfd, "rfd");
        this._socket = socket;
        this._incompleteFile = incompleteFile;
        this._filename = rfd.getFileName();
        this._index = rfd.getIndex();
        this._guid = rfd.getClientGUID();
        this._amountToRead = 0L;
        this._port = rfd.getPort();
        this._host = rfd.getHost();
        this._chatEnabled = rfd.isChatEnabled();
        this._browseEnabled = rfd.isBrowseHostEnabled();
        this._locationsReceived = new HashSet<RemoteFileDesc>();
        this._goodLocs = new HashSet<DirectAltLoc>();
        this._badLocs = new HashSet<DirectAltLoc>();
        this._goodPushLocs = new HashSet<PushAltLoc>();
        this._badPushLocs = new HashSet<PushAltLoc>();
        this._writtenGoodLocs = new HashSet<DirectAltLoc>();
        this._writtenBadLocs = new HashSet<DirectAltLoc>();
        this._writtenPushLocs = new HashSet<PushAltLoc>();
        this._writtenBadPushLocs = new HashSet<PushAltLoc>();
        this._amountRead = 0L;
        this._totalAmountRead = 0L;
        this._inNetwork = inNetwork;
    }

    Collection<RemoteFileDesc> getLocationsReceived() {
        return this._locationsReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends AlternateLocation> void storeLocation(T loc, Set<T> removeWithLock, Set<T> removeAlso, Set<T> addTo, Set<T> contains) {
        Set<T> set = removeWithLock;
        synchronized (set) {
            removeAlso.remove(loc);
            removeWithLock.remove(loc);
        }
        set = addTo;
        synchronized (set) {
            if (!contains.contains(loc)) {
                addTo.add(loc);
            }
        }
    }

    void addSuccessfulAltLoc(AlternateLocation loc) {
        if (loc instanceof DirectAltLoc) {
            DirectAltLoc direct = (DirectAltLoc)loc;
            HTTPDownloader.storeLocation(direct, this._badLocs, this._writtenBadLocs, this._goodLocs, this._writtenGoodLocs);
        } else if (loc instanceof PushAltLoc) {
            PushAltLoc push = (PushAltLoc)loc;
            HTTPDownloader.storeLocation(push, this._badPushLocs, this._writtenBadPushLocs, this._goodPushLocs, this._writtenPushLocs);
        } else {
            throw new IllegalStateException("bad location of class: " + loc.getClass());
        }
    }

    void addFailedAltLoc(AlternateLocation loc) {
        if (loc instanceof DirectAltLoc) {
            DirectAltLoc direct = (DirectAltLoc)loc;
            HTTPDownloader.storeLocation(direct, this._goodLocs, this._writtenGoodLocs, this._badLocs, this._writtenBadLocs);
        } else if (loc instanceof PushAltLoc) {
            PushAltLoc push = (PushAltLoc)loc;
            HTTPDownloader.storeLocation(push, this._goodPushLocs, this._writtenPushLocs, this._badPushLocs, this._writtenBadPushLocs);
        } else {
            throw new IllegalStateException("bad location of class: " + loc.getClass());
        }
    }

    public void initializeTCP() throws IOException {
        if (this._socket == null) {
            throw new IllegalStateException("no socket!");
        }
        try {
            this._socket.setKeepAlive(true);
        }
        catch (IOException iox) {
            if (!OSUtils.isWindowsVista()) {
                throw iox;
            }
            LOG.warn("couldn't set keepalive");
        }
        this.observerHandler = new Observer();
        this._stateMachine = new IOStateMachine(this.observerHandler, new LinkedList<IOState>(), 2048);
        this._stateMachine.setReadChannel(new ThrottleReader(this.bandwidthManager.getReadThrottle()));
        ((NIOMultiplexor)((Object)this._socket)).setReadObserver(this._stateMachine);
        ((NIOMultiplexor)((Object)this._socket)).setWriteObserver(this._stateMachine);
        this._socket.setSoTimeout(8000);
    }

    public void connectHTTP(long start, long stop, boolean supportQueueing, IOStateObserver observer) {
        this.connectHTTP(start, stop, supportQueueing, -1L, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectHTTP(long start, long stop, boolean supportQueueing, long amountDownloaded, IOStateObserver observer) {
        URN sha1;
        AlternateLocation me;
        if (start < 0L) {
            throw new IllegalArgumentException("invalid start: " + start);
        }
        if (stop <= start) {
            throw new IllegalArgumentException("stop(" + stop + ") <= start(" + start + ")");
        }
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            this._isActive = true;
            this._amountToRead = stop - start;
            this._amountRead = 0L;
            this._initialReadingPoint = start;
            this._initialWritingPoint = start;
            this._bodyConsumed = false;
            this._contentLength = 0L;
            this._requestedInterval = Range.createRange(this._initialReadingPoint, stop - 1L);
        }
        this.observerHandler.setDelegate(observer);
        ArrayList<Header> headers = new ArrayList<Header>();
        HashSet<HTTPHeaderValue> features = new HashSet<HTTPHeaderValue>();
        headers.add(HTTPHeaderName.HOST.create(this._host + ":" + this._port));
        headers.add(HTTPHeaderName.USER_AGENT.create(ConstantHTTPHeaderValue.USER_AGENT));
        if (supportQueueing) {
            headers.add(HTTPHeaderName.QUEUE.create(ConstantHTTPHeaderValue.QUEUE_VERSION));
            features.add(ConstantHTTPHeaderValue.QUEUE_FEATURE);
        }
        if (this.networkManager.acceptedIncomingConnection() || this.networkManager.canDoFWT()) {
            features.add(ConstantHTTPHeaderValue.PUSH_LOCS_FEATURE);
            if (!this.networkManager.acceptedIncomingConnection()) {
                features.add(ConstantHTTPHeaderValue.FWT_PUSH_LOCS_FEATURE);
            }
        }
        if (this.isPartialFileValid() && (this.networkManager.acceptedIncomingConnection() || this._wantsFalts) && (me = this.alternateLocationFactory.create(this._rfd.getSHA1Urn())) != null) {
            this.addSuccessfulAltLoc(me);
        }
        if ((sha1 = this._rfd.getSHA1Urn()) != null) {
            headers.add(HTTPHeaderName.GNUTELLA_CONTENT_URN.create(sha1));
        }
        this.writeAlternateLocations(headers, HTTPHeaderName.ALT_LOCATION, this._goodLocs, this._writtenGoodLocs, true);
        this.writeAlternateLocations(headers, HTTPHeaderName.NALTS, this._badLocs, this._writtenBadLocs, false);
        if (this._wantsFalts) {
            this.writeAlternateLocations(headers, HTTPHeaderName.FALT_LOCATION, this._goodPushLocs, this._writtenPushLocs, false);
            this.writeAlternateLocations(headers, HTTPHeaderName.BFALT_LOCATION, this._badPushLocs, this._writtenBadPushLocs, false);
        }
        headers.add(HTTPHeaderName.RANGE.create("bytes=" + this._initialReadingPoint + "-" + (stop - 1L)));
        if (this.networkManager.acceptedIncomingConnection() && !this.networkInstanceUtils.isPrivateAddress(this.networkManager.getAddress())) {
            int port = this.networkManager.getPort();
            String host = NetworkUtils.ip2string(this.networkManager.getAddress());
            headers.add(HTTPHeaderName.NODE.create(host + ":" + port));
            features.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
            if (ChatSettings.CHAT_ENABLED.getValue()) {
                headers.add(HTTPHeaderName.CHAT.create(host + ":" + port));
                features.add(ConstantHTTPHeaderValue.CHAT_FEATURE);
            }
        }
        if (!this.networkManager.acceptedIncomingConnection()) {
            headers.add(HTTPHeaderName.FW_NODE_INFO.create(this.pushEndpointFactory.createForSelf()));
            features.add(ConstantHTTPHeaderValue.BROWSE_FEATURE);
        }
        if (features.size() > 0) {
            headers.add(HTTPHeaderName.FEATURES.create(new HTTPHeaderValueCollection(features)));
        }
        if (amountDownloaded > 0L) {
            headers.add(HTTPHeaderName.DOWNLOADED.create("" + amountDownloaded));
        }
        SimpleWriteHeaderState writer = new SimpleWriteHeaderState("GET " + this._rfd.getUrl().getFile() + " HTTP/1.1", headers, this._inNetwork ? this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_INNETWORK_UPSTREAM) : this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_UPSTREAM));
        SimpleReadHeaderState reader = new SimpleReadHeaderState(this._inNetwork ? this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_INNETWORK_DOWNSTREAM) : this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_DOWNSTREAM), DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._stateMachine.addStates(writer, reader);
        this._headerReader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends AlternateLocation> void writeAlternateLocations(List<Header> headers, HTTPHeaderName header, Set<T> locs, Set<T> stored, boolean includeTLS) {
        ArrayList<HTTPHeaderValue> valuesToWrite = null;
        BitNumbers bn = null;
        Set<T> set = locs;
        synchronized (set) {
            if (locs.size() > 0) {
                valuesToWrite = new ArrayList<HTTPHeaderValue>(locs.size());
                if (includeTLS) {
                    bn = new BitNumbers(locs.size());
                }
                for (AlternateLocation loc : locs) {
                    if (loc instanceof PushAltLoc) {
                        PushAltLoc pushLoc = (PushAltLoc)loc;
                        if (pushLoc.getPushAddress().getProxies().isEmpty()) {
                            if (pushLoc.getPushAddress().isLocal()) continue;
                            assert (false) : "empty pushloc in downloader";
                        }
                    } else if (loc instanceof DirectAltLoc) {
                        IpPort host = ((DirectAltLoc)loc).getHost();
                        if (includeTLS && host instanceof Connectable && ((Connectable)host).isTLSCapable()) {
                            assert (bn != null);
                            bn.set(valuesToWrite.size());
                        }
                    }
                    valuesToWrite.add(loc);
                    stored.add(loc);
                }
                locs.clear();
            }
        }
        if (valuesToWrite != null) {
            if (bn != null && !bn.isEmpty()) {
                final String hex = bn.toHexString();
                valuesToWrite.add(0, new HTTPHeaderValue(){

                    public String httpStringValue() {
                        return "tls=" + hex;
                    }
                });
            }
            headers.add(header.create(new HTTPHeaderValueCollection(valuesToWrite)));
        }
    }

    void consumeBody(IOStateObserver observer) {
        if (!this._bodyConsumed) {
            if (this._contentLength != -1L) {
                this.consumeBody(this._contentLength, observer);
            } else {
                observer.handleIOException(new IOException("no content length"));
            }
        } else {
            observer.handleStatesFinished();
        }
        this._bodyConsumed = true;
    }

    boolean isBodyConsumed() {
        return this._bodyConsumed;
    }

    public void requestHashTree(URN sha1, IOStateObserver observer) {
        SimpleReadHeaderState reader;
        if (LOG.isDebugEnabled()) {
            LOG.debug("requesting HashTree for " + this._thexUri + " from " + this._host + ":" + this._port);
        }
        this.observerHandler.setDelegate(observer);
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(HTTPHeaderName.HOST.create(this._host + ":" + this._port));
        headers.add(HTTPHeaderName.USER_AGENT.create(ConstantHTTPHeaderValue.USER_AGENT));
        SimpleWriteHeaderState writer = new SimpleWriteHeaderState("GET " + this._thexUri + " HTTP/1.1", headers, this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_UPSTREAM));
        this._headerReader = reader = new SimpleReadHeaderState(this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_DOWNSTREAM), DownloadSettings.MAX_HEADERS.getValue(), DownloadSettings.MAX_HEADER_SIZE.getValue());
        this._requestingThex = true;
        this._bodyConsumed = false;
        this._stateMachine.addStates(writer, reader);
    }

    boolean isRequestingThex() {
        return this._requestingThex;
    }

    public ConnectionStatus parseThexResponseHeaders() {
        this._requestingThex = false;
        try {
            int code = HTTPDownloader.parseHTTPCode(this._headerReader.getConnectLine(), this._rfd);
            boolean failed = false;
            if (code < 200 || code >= 300) {
                failed = true;
            }
            return this.parseThexHeaders(code, failed);
        }
        catch (IOException failed) {
            return ConnectionStatus.getNoFile();
        }
    }

    public void downloadThexBody(URN sha1, IOStateObserver observer) {
        this._thexReader = this.thexReaderFactory.createHashTreeReader(sha1.httpStringValue(), this._root32, this._rfd.getFileSize());
        this.observerHandler.setDelegate(observer);
        this._stateMachine.addState(this._thexReader);
    }

    public HashTree getHashTree() {
        this._contentLength -= this._thexReader.getAmountProcessed();
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        HashTree tree = null;
        try {
            tree = this._thexReader.getHashTree();
        }
        catch (IOException iox) {
            LOG.warn("Failed to create tree", iox);
        }
        if (tree == null) {
            this._rfd.setTHEXFailed();
        } else {
            this._thexSucceeded = true;
        }
        return tree;
    }

    private ConnectionStatus parseThexHeaders(int code, boolean failed) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._rfd + " consuming headers");
        }
        this._contentLength = -1L;
        for (Map.Entry<String, String> entry : this._headerReader.getHeaders().entrySet()) {
            String header = entry.getKey();
            if (HTTPHeaderName.CONTENT_LENGTH.is(header)) {
                this._contentLength = HTTPDownloader.readContentLength(entry.getValue());
            }
            if (code != 503 || !HTTPHeaderName.QUEUE.is(header)) continue;
            String value = entry.getValue();
            int[] queueInfo = new int[]{-1, -1, -1};
            this.parseQueueHeaders(value, queueInfo);
            int min = queueInfo[0];
            int max = queueInfo[1];
            int pos = queueInfo[2];
            if (min == -1 || max == -1 || pos == -1) continue;
            this._bodyConsumed = true;
            return ConnectionStatus.getQueued(pos, min);
        }
        if (this._contentLength == 0L) {
            this._bodyConsumed = true;
        }
        if (failed || this._contentLength == -1L) {
            return ConnectionStatus.getNoFile();
        }
        return ConnectionStatus.getConnected();
    }

    private void consumeBody(long contentLength, IOStateObserver observer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("enter consumeBody(" + contentLength + ")");
        }
        if (contentLength < 0L) {
            observer.handleIOException(new IOException("unknown content-length, can't consume"));
        }
        this.observerHandler.setDelegate(observer);
        this._stateMachine.addState(new ReadSkipState(contentLength));
    }

    public void parseHeaders() throws IOException {
        String connectLine = this._headerReader.getConnectLine();
        Map<String, String> headers = this._headerReader.getHeaders();
        if (connectLine == null || connectLine.equals("")) {
            throw new IOException();
        }
        int code = HTTPDownloader.parseHTTPCode(connectLine, this._rfd);
        this._contentLength = -1L;
        int[] refQueueInfo = new int[]{-1, -1, -1};
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String header = entry.getKey();
            String value = entry.getValue();
            if (HTTPHeaderName.CONTENT_RANGE.is(header)) {
                this.validateContentRange(this.parseContentRange(value));
                continue;
            }
            if (HTTPHeaderName.CONTENT_LENGTH.is(header)) {
                this._contentLength = HTTPDownloader.readContentLength(value);
                continue;
            }
            if (HTTPHeaderName.CONTENT_URN.is(header)) {
                this.checkContentUrnHeader(value, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.GNUTELLA_CONTENT_URN.is(header)) {
                this.checkContentUrnHeader(value, this._rfd.getSHA1Urn());
                continue;
            }
            if (HTTPHeaderName.ALT_LOCATION.is(header)) {
                this.readAlternateLocations(value, true);
                continue;
            }
            if (HTTPHeaderName.QUEUE.is(header)) {
                this.parseQueueHeaders(value, refQueueInfo);
                continue;
            }
            if (HTTPHeaderName.SERVER.is(header)) {
                this._server = value;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Server is: " + value);
                continue;
            }
            if (HTTPHeaderName.AVAILABLE_RANGES.is(header)) {
                this.parseAvailableRangesHeader(value, this._rfd);
                continue;
            }
            if (HTTPHeaderName.RETRY_AFTER.is(header)) {
                HTTPDownloader.parseRetryAfterHeader(value, this._rfd);
                continue;
            }
            if (HTTPHeaderName.CREATION_TIME.is(header)) {
                this.parseCreationTimeHeader(value, this._rfd);
                continue;
            }
            if (HTTPHeaderName.FEATURES.is(header)) {
                this.parseFeatureHeader(value);
                continue;
            }
            if (HTTPHeaderName.THEX_URI.is(header)) {
                this.parseTHEXHeader(value);
                continue;
            }
            if (HTTPHeaderName.FALT_LOCATION.is(header)) {
                this.parseFALTHeader(value);
                continue;
            }
            if (HTTPHeaderName.PROXIES.is(header)) {
                this.parseProxiesHeader(value);
                continue;
            }
            if (!HTTPHeaderName.FWTPORT.is(header)) continue;
            this.parseFWTPortHeader(value);
        }
        if (code < 200 || code >= 300) {
            if (code == 404) {
                throw new FileNotFoundException();
            }
            if (code == 410) {
                throw new NotSharingException();
            }
            if (code == 416) {
                if (this._rfd.isPartialSource()) {
                    for (Range next : this._rfd.getAvailableRanges()) {
                        if (!this._requestedInterval.isSubrange(next)) continue;
                        throw new ProblemReadingHeaderException("Bad ranges sent");
                    }
                } else {
                    throw new ProblemReadingHeaderException("no ranges sent");
                }
                throw new RangeNotAvailableException();
            }
            if (code == 503) {
                int min = refQueueInfo[0];
                int max = refQueueInfo[1];
                int pos = refQueueInfo[2];
                if (min != -1 && max != -1 && pos != -1) {
                    this._bodyConsumed = true;
                    throw new QueuedException(min, max, pos);
                }
                throw new TryAgainLaterException();
            }
            throw new UnknownCodeException(code);
        }
    }

    private void checkContentUrnHeader(String value, URN sha1) throws ContentUrnMismatchException {
        if (this._root32 == null && value.indexOf("urn:bitprint:") > -1) {
            this._root32 = value.substring(value.lastIndexOf(".") + 1).trim();
        }
        if (sha1 == null) {
            return;
        }
        URN contentUrn = null;
        try {
            contentUrn = URN.createSHA1Urn(value);
        }
        catch (IOException ioe) {
            return;
        }
        if (!sha1.equals(contentUrn)) {
            throw new ContentUrnMismatchException();
        }
    }

    private void readAlternateLocations(String altStr, boolean allowTLS) {
        AltLocUtils.parseAlternateLocations(this._rfd.getSHA1Urn(), altStr, allowTLS, this.alternateLocationFactory, new Function<AlternateLocation, Void>(){

            @Override
            public Void apply(AlternateLocation location) {
                RemoteFileDesc rfd = location.createRemoteFileDesc(HTTPDownloader.this._rfd.getSize(), HTTPDownloader.this.remoteFileDescFactory);
                HTTPDownloader.this._locationsReceived.add(rfd);
                return null;
            }
        });
    }

    private boolean isPartialFileValid() {
        return this._rfd.getSHA1Urn() != null && this._incompleteFile.getVerifiedBlockSize() > (long)MIN_PARTIAL_FILE_BYTES && SharingSettings.ALLOW_PARTIAL_SHARING.getValue() && NetworkUtils.isValidPort(this.networkManager.getPort()) && NetworkUtils.isValidAddress(this.networkManager.getAddress());
    }

    public static long readContentLength(String value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    private static int parseHTTPCode(String str, RemoteFileDesc rfd) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        String token = tokenizer.nextToken();
        if (token.toUpperCase().indexOf("HTTP") < 0) {
            throw new NoHTTPOKException("got: " + str);
        }
        rfd.setHTTP11(token.indexOf("1.1") > 0);
        if (!tokenizer.hasMoreTokens()) {
            throw new NoHTTPOKException();
        }
        token = tokenizer.nextToken();
        String num = token.trim();
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
    }

    private void parseQueueHeaders(String str, int[] refQueueInfo) {
        if (str == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, " ,:=");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                String value;
                if (token.equalsIgnoreCase("pollMin")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[0] = Integer.parseInt(value);
                    continue;
                }
                if (token.equalsIgnoreCase("pollMax")) {
                    value = tokenizer.nextToken();
                    refQueueInfo[1] = Integer.parseInt(value);
                    continue;
                }
                if (!token.equalsIgnoreCase("position")) continue;
                value = tokenizer.nextToken();
                refQueueInfo[2] = Integer.parseInt(value);
            }
            catch (NumberFormatException nfx) {
                Arrays.fill(refQueueInfo, -1);
                break;
            }
            catch (NoSuchElementException nsex) {
                Arrays.fill(refQueueInfo, -1);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateContentRange(Range responseRange) throws IOException {
        long low = responseRange.getLow();
        long high = responseRange.getHigh() + 1L;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (this._disconnect) {
                throw new IOException("stolen from");
            }
            if (low < this._initialReadingPoint || high > this._initialReadingPoint + this._amountToRead) {
                throw new ProblemReadingHeaderException("invalid subrange given.  wanted low: " + this._initialReadingPoint + ", high: " + (this._initialReadingPoint + this._amountToRead - 1L) + "... given low: " + low + ", high: " + high);
            }
            this._initialReadingPoint = low;
            this._amountToRead = high - low;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Range parseContentRange(String str) throws IOException {
        long numAfterSlash;
        long numBeforeSlash;
        long numBeforeDash;
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading content range: " + str);
        }
        try {
            int start = str.indexOf("bytes") + 6;
            int slash = str.indexOf(47);
            if (str.substring(start, slash).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this._rfd + " Content-Range like */?, " + str);
                }
                HTTPDownloader hTTPDownloader = this;
                synchronized (hTTPDownloader) {
                    return Range.createRange(0L, this._amountToRead - 1L);
                }
            }
            int dash = str.lastIndexOf("-");
            numBeforeDash = Long.parseLong(str.substring(start, dash));
            numBeforeSlash = Long.parseLong(str.substring(dash + 1, slash));
            if (numBeforeSlash < numBeforeDash) {
                throw new ProblemReadingHeaderException("invalid range, high (" + numBeforeSlash + ") less than low (" + numBeforeDash + ")");
            }
            if (str.substring(slash + 1).equals("*")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this._rfd + " Content-Range like #-#/*, " + str);
                }
                return Range.createRange(numBeforeDash, numBeforeSlash);
            }
            numAfterSlash = Long.parseLong(str.substring(slash + 1));
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProblemReadingHeaderException(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(str);
        }
        if (numBeforeSlash == numAfterSlash) {
            --numBeforeDash;
            --numBeforeSlash;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._rfd + " Content-Range like #-#/#, " + str);
        }
        return Range.createRange(numBeforeDash, numBeforeSlash);
    }

    private void parseAvailableRangesHeader(String line, RemoteFileDesc rfd) throws IOException {
        int stop;
        IntervalSet availableRanges = new IntervalSet();
        line = line.toLowerCase();
        int start = line.indexOf("bytes") + 6;
        while (start != -1 && start < line.length() && (stop = line.indexOf(45, start)) != -1) {
            Range interval = null;
            try {
                long low = Long.parseLong(line.substring(start, stop).trim());
                start = stop + 1;
                stop = line.indexOf(44, start);
                if (stop == -1) {
                    stop = line.length();
                }
                long high = Long.parseLong(line.substring(start, stop).trim());
                start = stop + 1;
                if (high >= rfd.getSize()) {
                    high = rfd.getSize() - 1L;
                }
                if (low > high) continue;
                interval = Range.createRange(low, high);
            }
            catch (NumberFormatException e) {
                throw new ProblemReadingHeaderException(e);
            }
            availableRanges.add(interval);
        }
        rfd.setAvailableRanges(availableRanges);
    }

    private static void parseRetryAfterHeader(String str, RemoteFileDesc rfd) throws IOException {
        int seconds = 0;
        try {
            seconds = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
        seconds = Math.max(seconds, 60);
        seconds = Math.min(seconds, 3600);
        rfd.setRetryAfter(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCreationTimeHeader(String str, RemoteFileDesc rfd) throws IOException {
        long milliSeconds = 0L;
        try {
            milliSeconds = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new ProblemReadingHeaderException(e);
        }
        if (rfd.getSHA1Urn() != null && milliSeconds > 0L) {
            CreationTimeCache creationTimeCache = this.creationTimeCache;
            synchronized (creationTimeCache) {
                Long cTime = this.creationTimeCache.getCreationTime(rfd.getSHA1Urn());
                if (cTime == null || cTime > milliSeconds) {
                    this.creationTimeCache.addTime(rfd.getSHA1Urn(), milliSeconds);
                }
            }
        }
    }

    private void parseFeatureHeader(String str) {
        StringTokenizer tok = new StringTokenizer(str, ",");
        while (tok.hasMoreTokens()) {
            String feature = tok.nextToken();
            String protocol = "";
            int slash = feature.indexOf("/");
            protocol = slash == -1 ? feature.toLowerCase().trim() : feature.substring(0, slash).toLowerCase().trim();
            if (protocol.equals("chat")) {
                this._chatEnabled = true;
                continue;
            }
            if (protocol.equals("browse")) {
                this._browseEnabled = true;
                continue;
            }
            if (protocol.equals("fwalt")) {
                this._wantsFalts = true;
                continue;
            }
            if (!protocol.equals("fwt")) continue;
            int FWTVersion = 0;
            try {
                FWTVersion = (int)HTTPUtils.parseFeatureToken(feature);
                this._wantsFalts = true;
            }
            catch (ProblemReadingHeaderException prhe) {
                continue;
            }
            try {
                this.updatePEAddress();
                this.pushEndpointCache.get().setFWTVersionSupported(this._rfd.getClientGUID(), FWTVersion);
            }
            catch (IOException ignored) {}
        }
    }

    private void parseTHEXHeader(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._host + ":" + this._port + ">" + str);
        }
        if (str.indexOf(";") > 0) {
            StringTokenizer tok = new StringTokenizer(str, ";");
            this._thexUri = tok.nextToken();
            this._root32 = tok.nextToken();
        } else {
            this._thexUri = str;
        }
    }

    private void parseFALTHeader(String str) {
        this._wantsFalts = true;
        this.readAlternateLocations(str, false);
    }

    private void parseProxiesHeader(String str) {
        if (this._rfd.getPushAddr() == null || str == null || str.length() < 12) {
            return;
        }
        try {
            this.pushEndpointCache.get().overwriteProxies(this._rfd.getClientGUID(), str);
            this.updatePEAddress();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseFWTPortHeader(String str) {
        try {
            int port = Integer.parseInt(str);
            if (NetworkUtils.isValidPort(port)) {
                IpPortImpl newAddr = new IpPortImpl(this._socket.getInetAddress(), port);
                this.pushEndpointCache.get().setAddr(this._rfd.getClientGUID(), newAddr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void updatePEAddress() throws IOException {
        IpPortImpl newAddr;
        if (this._socket instanceof RUDPSocket && this.networkInstanceUtils.isValidExternalIpPort(newAddr = new IpPortImpl(this._socket.getInetAddress(), this._socket.getPort()))) {
            this.pushEndpointCache.get().setAddr(this._rfd.getClientGUID(), newAddr);
        }
    }

    public void doDownload(IOStateObserver observer) throws SocketException {
        this._socket.setSoTimeout(60000);
        this.observerHandler.setDelegate(observer);
        this._stateMachine.addState(new DownloadState());
    }

    void createAssertionReport(AssertFailure bad) {
        ManagedDownloaderImpl myDownloader;
        String currentWorker = "current worker " + System.identityHashCode(this);
        String allWorkers = null;
        URN urn = this._rfd.getSHA1Urn();
        allWorkers = urn != null ? ((myDownloader = (ManagedDownloaderImpl)this.downloadManager.getDownloaderForURN(urn)) == null ? "couldn't find my downloader???" : myDownloader.getWorkersInfo()) : " sha1 not available ";
        String errorReport = bad.getMessage() + "\n\n" + currentWorker + "\n\n" + allWorkers;
        AssertFailure failure = new AssertFailure(errorReport);
        failure.setStackTrace(bad.getStackTrace());
        throw failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("WORKER:" + this + " signaled to stop at " + (this._initialReadingPoint + this._amountRead));
            }
            this._isActive = false;
        }
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            public void run() {
                IOUtils.close(HTTPDownloader.this._socket);
            }
        });
    }

    public synchronized void stopAt(long stop) {
        this._disconnect = true;
        this._amountToRead = Math.min(this._amountToRead, stop - this._initialReadingPoint);
    }

    public synchronized void startAt(long start) {
        this._initialWritingPoint = start;
    }

    synchronized void forgetRanges() {
        this._initialWritingPoint = 0L;
        this._initialReadingPoint = 0L;
        this._amountToRead = 0L;
        this._totalAmountRead += this._amountRead;
        this._amountRead = 0L;
    }

    public synchronized long getInitialReadingPoint() {
        return this._initialReadingPoint;
    }

    public synchronized long getInitialWritingPoint() {
        return this._initialWritingPoint;
    }

    public synchronized long getAmountRead() {
        return this._amountRead;
    }

    public synchronized long getTotalAmountRead() {
        return this._totalAmountRead + this._amountRead;
    }

    public synchronized long getAmountToRead() {
        return this._amountToRead;
    }

    public synchronized boolean isActive() {
        return this._isActive;
    }

    synchronized boolean isVictim() {
        return this._disconnect;
    }

    public InetAddress getInetAddress() {
        return this._socket.getInetAddress();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public boolean browseEnabled() {
        return this._browseEnabled;
    }

    public boolean wantsFalts() {
        return this._wantsFalts;
    }

    public String getVendor() {
        return this._server;
    }

    public long getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public byte[] getGUID() {
        return this._guid;
    }

    public int getPort() {
        return this._port;
    }

    public RemoteFileDesc getRemoteFileDesc() {
        return this._rfd;
    }

    public boolean isHTTP11() {
        return this._rfd.isHTTP11();
    }

    public boolean hasHashTree() {
        return this._thexUri != null && this._root32 != null && !this._rfd.hasTHEXFailed() && !this._thexSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        long totalAmountRead = 0L;
        HTTPDownloader hTTPDownloader = this;
        synchronized (hTTPDownloader) {
            if (!this._isActive) {
                return;
            }
            totalAmountRead = this.getTotalAmountRead();
        }
        this.bandwidthTracker.measureBandwidth(totalAmountRead);
    }

    @Override
    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }

    @Override
    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public String toString() {
        return "<" + this._host + ":" + this._port + ", " + this.getFileName() + ">";
    }

    public static void setThrottleSwitching(boolean on) {
    }

    private static class Observer
    implements IOStateObserver {
        private IOStateObserver delegate;
        private boolean handled = false;
        private boolean error = false;

        private Observer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleIOException(IOException iox) {
            IOStateObserver del;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    LOG.warn("Ignoring iox", iox);
                    return;
                }
                this.handled = true;
                del = this.delegate;
            }
            if (del != null) {
                del.handleIOException(iox);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStatesFinished() {
            IOStateObserver del;
            Observer observer = this;
            synchronized (observer) {
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Ignoring states finished", new Exception());
                    }
                    return;
                }
                this.handled = true;
                del = this.delegate;
            }
            if (del != null) {
                del.handleStatesFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IOStateObserver del;
            Observer observer = this;
            synchronized (observer) {
                this.error = true;
                if (this.handled) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Ignoring shutdown.");
                    }
                    return;
                }
                this.handled = true;
                del = this.delegate;
            }
            if (del != null) {
                del.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDelegate(IOStateObserver observer) {
            boolean hadError = false;
            Observer observer2 = this;
            synchronized (observer2) {
                this.handled = false;
                hadError = this.error;
                this.delegate = observer;
            }
            if (hadError) {
                observer.shutdown();
            }
        }
    }

    private static class DownloadRestarter
    implements VerifyingFile.WriteCallback,
    Runnable {
        private final DownloadState downloader;
        private final InterestReadableByteChannel irc;
        private final ByteBuffer buffer;

        DownloadRestarter(InterestReadableByteChannel irc, ByteBuffer buffer, DownloadState downloader) {
            this.irc = irc;
            this.buffer = buffer;
            this.downloader = downloader;
        }

        public void writeScheduled() {
            LOG.debug("Delayed write scheduled");
            NIODispatcher.instance().executeLaterAlways(this);
        }

        public void run() {
            this.buffer.clear();
            this.downloader.writeDone();
            this.irc.interestRead(true);
        }
    }

    private class DownloadState
    extends ReadState {
        private long currPos;
        private volatile boolean doingWrite;

        private DownloadState() {
            this.currPos = HTTPDownloader.this._initialReadingPoint;
        }

        void writeDone() {
            this.doingWrite = false;
            HTTPDownloader.this._stateMachine.handleRead();
        }

        protected boolean processRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
            if (this.doingWrite) {
                return true;
            }
            boolean dataLeft = false;
            try {
                dataLeft = this.readImpl(channel, buffer);
            }
            catch (IOException error) {
                LOG.debug("Error while reading", error);
                this.chunkCompleted();
                throw error;
            }
            if (!dataLeft) {
                this.chunkCompleted();
                if (!HTTPDownloader.this.isHTTP11() || HTTPDownloader.this._disconnect) {
                    throw new IOException("stolen from");
                }
            }
            return dataLeft;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chunkCompleted() {
            HTTPDownloader.this._bodyConsumed = true;
            HTTPDownloader hTTPDownloader = HTTPDownloader.this;
            synchronized (hTTPDownloader) {
                HTTPDownloader.this._isActive = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readImpl(ReadableByteChannel rc, ByteBuffer buffer) throws IOException {
            while (true) {
                long filePosition;
                int dataStart;
                int dataLength;
                long left;
                long read = 0L;
                HTTPDownloader hTTPDownloader = HTTPDownloader.this;
                synchronized (hTTPDownloader) {
                    if (HTTPDownloader.this._amountRead >= HTTPDownloader.this._amountToRead) {
                        LOG.debug("Read >= to needed, done.");
                        HTTPDownloader.this._isActive = false;
                        return false;
                    }
                    left = HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead;
                }
                int preread = (int)Math.min(left, (long)buffer.position());
                if (preread != 0 && LOG.isDebugEnabled()) {
                    LOG.debug("Using preread data of: " + preread);
                }
                if (left - (long)preread > 0L) {
                    if ((long)buffer.limit() > left) {
                        buffer.limit((int)left);
                    }
                    while (buffer.hasRemaining() && (read = (long)rc.read(buffer)) > 0L) {
                    }
                    buffer.limit(buffer.capacity());
                }
                int totalRead = buffer.position();
                if (HTTPDownloader.this._inNetwork) {
                    HTTPDownloader.this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_BODY_INNETWORK_DOWNSTREAM).addData(totalRead);
                } else {
                    HTTPDownloader.this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_BODY_DOWNSTREAM).addData(totalRead);
                }
                if (totalRead == 0) {
                    if (read == -1L) {
                        LOG.debug("EOF while reading");
                        throw new IOException("EOF");
                    }
                    if (read == 0L) {
                        return true;
                    }
                }
                DownloadState downloadState = this;
                synchronized (downloadState) {
                    if (HTTPDownloader.this._isActive) {
                        if ((totalRead = (int)Math.min((long)totalRead, HTTPDownloader.this._amountToRead - HTTPDownloader.this._amountRead)) <= 0) {
                            LOG.debug("Someone stole completely from us while reading");
                            HTTPDownloader.this._isActive = false;
                            buffer.clear();
                            return false;
                        }
                        int skipped = (int)Math.min((long)totalRead, Math.max(0L, HTTPDownloader.this._initialWritingPoint - this.currPos));
                        if (skipped > 0) {
                            LOG.debug("Amount we should skip: " + skipped);
                        }
                        dataLength = totalRead - skipped;
                        dataStart = skipped;
                        filePosition = this.currPos + (long)skipped;
                        HTTPDownloader.this._amountRead += totalRead;
                        this.currPos += (long)totalRead;
                        if (skipped >= totalRead) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("skipped full read of: " + skipped + " bytes");
                            }
                            buffer.clear();
                            continue;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("WORKER:" + this + " stopping at " + (HTTPDownloader.this._initialReadingPoint + HTTPDownloader.this._amountRead));
                        }
                        buffer.clear();
                        return false;
                    }
                }
                try {
                    VerifyingFile.WriteRequest request = new VerifyingFile.WriteRequest(filePosition, dataStart, dataLength, buffer.array());
                    if (!HTTPDownloader.this._incompleteFile.writeBlock(request)) {
                        LOG.debug("Scheduling callback for write.");
                        InterestReadableByteChannel irc = (InterestReadableByteChannel)rc;
                        irc.interestRead(false);
                        this.doingWrite = true;
                        HTTPDownloader.this._incompleteFile.registerWriteCallback(request, new DownloadRestarter(irc, buffer, this));
                        return true;
                    }
                }
                catch (AssertFailure bad) {
                    HTTPDownloader.this.createAssertionReport(bad);
                }
                buffer.clear();
            }
        }

        public long getAmountProcessed() {
            return -1L;
        }
    }
}

