/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.LWSIntegrationServices;
import com.limegroup.gnutella.downloader.LWSIntegrationServicesDelegate;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.lws.server.LWSManager;
import com.limegroup.gnutella.lws.server.LWSManagerCommandResponseHandlerWithCallback;
import com.limegroup.gnutella.lws.server.LWSUtil;
import com.limegroup.gnutella.settings.LWSSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.Tagged;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpException;

@Singleton
public final class LWSIntegrationServicesImpl
implements LWSIntegrationServices {
    private final LWSManager lwsManager;
    private final DownloadServices downloadServices;
    private final LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate;
    private final RemoteFileDescFactory remoteFileDescFactory;

    @Inject
    public LWSIntegrationServicesImpl(LWSManager lwsManager, DownloadServices downloadServices, LWSIntegrationServicesDelegate lwsIntegrationServicesDelegate, RemoteFileDescFactory remoteFileDescFactory) {
        this.lwsManager = lwsManager;
        this.downloadServices = downloadServices;
        this.lwsIntegrationServicesDelegate = lwsIntegrationServicesDelegate;
        this.remoteFileDescFactory = remoteFileDescFactory;
    }

    public void init() {
        this.lwsManager.registerHandler("GetDownloadProgress", new LWSManagerCommandResponseHandlerWithCallback("GetDownloadProgress"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String handleRest(Map<String, String> args) {
                Tagged<String> idsString = LWSUtil.getArg(args, "urns", "GetDownloadProgress");
                if (!idsString.isValid()) {
                    return idsString.getValue();
                }
                StringBuffer res = new StringBuffer();
                String decodedIDs = null;
                try {
                    decodedIDs = URLDecoder.decode(idsString.getValue());
                }
                catch (IOException e) {
                    return "invalid.ids";
                }
                String[] downloaderIDs = decodedIDs.split(" ");
                LWSIntegrationServicesDelegate lWSIntegrationServicesDelegate = LWSIntegrationServicesImpl.this.lwsIntegrationServicesDelegate;
                synchronized (lWSIntegrationServicesDelegate) {
                    block5: for (CoreDownloader d : LWSIntegrationServicesImpl.this.lwsIntegrationServicesDelegate.getAllDownloaders()) {
                        if (d == null) continue;
                        for (String downloaderID : downloaderIDs) {
                            String id = String.valueOf(System.identityHashCode(d));
                            if (!downloaderID.equals(id)) continue;
                            long read = d.getAmountRead();
                            long total = d.getContentLength();
                            String ratio = String.valueOf((float)read / (float)total);
                            res.append(downloaderID);
                            res.append(" ");
                            res.append(ratio);
                            res.append("|");
                            continue block5;
                        }
                    }
                }
                return res.toString();
            }
        });
        this.lwsManager.registerHandler("Download", new LWSManagerCommandResponseHandlerWithCallback("Download"){

            @Override
            protected String handleRest(Map<String, String> args) {
                String fileName;
                Tagged<String> urlString = LWSUtil.getArg(args, "url", "downloading");
                if (!urlString.isValid()) {
                    return urlString.getValue();
                }
                Tagged<String> fileString = LWSUtil.getArg(args, "file", "downloading");
                Tagged<String> idOfTheProgressBarString = LWSUtil.getArg(args, "id", "downloading");
                if (!idOfTheProgressBarString.isValid()) {
                    return idOfTheProgressBarString.getValue();
                }
                Tagged<String> lengthString = LWSUtil.getArg(args, "length", "downloading");
                long length = -1L;
                if (lengthString.isValid()) {
                    try {
                        length = Long.parseLong(lengthString.getValue());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                String baseDir = "http://" + LWSSettings.LWS_DOWNLOAD_HOSTNAME.getValue();
                int port = LWSSettings.LWS_DOWNLOAD_PORT.getValue();
                if (port > 0) {
                    baseDir = baseDir + ":" + port;
                }
                if ((fileName = fileString.getValue()) == null) {
                    fileName = this.fileNameFromURL(urlString.getValue());
                }
                String baseURL = baseDir + urlString.getValue();
                try {
                    String urlStr = URLDecoder.decode(baseURL);
                    URL url = new URL(urlStr);
                    RemoteFileDesc rfd = LWSIntegrationServicesImpl.this.remoteFileDescFactory.createUrlRemoteFileDesc(url, fileName, null, length);
                    File saveDir = SharingSettings.getSaveLWSDirectory();
                    Downloader d = LWSIntegrationServicesImpl.this.downloadServices.downloadFromStore(rfd, true, saveDir, fileName);
                    long idOfTheDownloader = System.identityHashCode(d);
                    return idOfTheDownloader + " " + idOfTheProgressBarString.getValue();
                }
                catch (IOException e) {
                }
                catch (HttpException e) {
                }
                catch (InterruptedException e) {
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                return "invalid.download";
            }

            private String fileNameFromURL(String urlString) {
                int ilast = urlString.lastIndexOf("/");
                if (ilast == -1) {
                    ilast = urlString.lastIndexOf("\\");
                }
                return urlString.substring(ilast + 1);
            }
        });
        this.lwsManager.registerHandler("PauseDownload", new LWSManagerCommandResponseForDownloading("PauseDownload", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.pause();
            }
        });
        this.lwsManager.registerHandler("StopDownload", new LWSManagerCommandResponseForDownloading("StopDownload", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.stop();
            }
        });
        this.lwsManager.registerHandler("ResumeDownload", new LWSManagerCommandResponseForDownloading("ResumeDownload", this.lwsIntegrationServicesDelegate){

            protected void takeAction(Downloader d) {
                d.resume();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LWSManagerCommandResponseForDownloading
    extends LWSManagerCommandResponseHandlerWithCallback {
        private final LWSIntegrationServicesDelegate del;

        LWSManagerCommandResponseForDownloading(String name, LWSIntegrationServicesDelegate del) {
            super(name);
            this.del = del;
        }

        protected abstract void takeAction(Downloader var1);

        @Override
        protected final String handleRest(Map<String, String> args) {
            Tagged<String> idOfTheDownloader = LWSUtil.getArg(args, "id", "downloading");
            if (!idOfTheDownloader.isValid()) {
                return idOfTheDownloader.getValue();
            }
            String id = idOfTheDownloader.getValue();
            for (CoreDownloader downloader : this.del.getAllDownloaders()) {
                if (!String.valueOf(System.identityHashCode(downloader)).equals(id)) continue;
                this.takeAction(downloader);
                break;
            }
            return "OK";
        }
    }
}

