/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.MagnetDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloaderImpl;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMemento;
import com.limegroup.gnutella.downloader.serial.MagnetDownloadMementoImpl;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.util.QueryUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpException;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MagnetDownloaderImpl
extends ManagedDownloaderImpl
implements MagnetDownloader {
    private MagnetOptions magnet;

    @Inject
    MagnetDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, FileManager fileManager, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, SavedFileManager savedFileManager, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider) {
        super(saveLocationManager, downloadManager, fileManager, incompleteFileManager, downloadCallback, networkManager, alternateLocationFactory, requeryManagerFactory, queryRequestFactory, onDemandUnicaster, downloadWorkerFactory, altLocManager, contentManager, sourceRankerFactory, urnCache, savedFileManager, verifyingFileFactory, diskController, ipFilter, backgroundExecutor, messageRouter, tigerTreeCache, applicationServices, remoteFileDescFactory, pushListProvider);
    }

    @Override
    public void initialize() {
        assert (this.getMagnet() != null);
        URN sha1 = this.getMagnet().getSHA1Urn();
        if (sha1 != null) {
            this.setSha1Urn(sha1);
        }
        super.initialize();
    }

    protected synchronized MagnetOptions getMagnet() {
        return this.magnet;
    }

    @Override
    public synchronized void setMagnet(MagnetOptions magnet) {
        if (this.getMagnet() != null) {
            throw new IllegalStateException("magnet already set!");
        }
        this.magnet = magnet;
    }

    @Override
    protected Downloader.DownloadStatus initializeDownload() {
        if (!this.hasRFD()) {
            MagnetOptions magnet = this.getMagnet();
            String[] defaultURLs = magnet.getDefaultURLs();
            if (defaultURLs.length == 0) {
                return Downloader.DownloadStatus.GAVE_UP;
            }
            RemoteFileDesc firstDesc = null;
            for (int i = 0; i < defaultURLs.length && firstDesc == null; ++i) {
                try {
                    firstDesc = this.createRemoteFileDesc(defaultURLs[i], this.getSaveFile().getName(), magnet.getSHA1Urn());
                    this.initPropertiesMap(firstDesc);
                    this.addDownloadForced(firstDesc, true);
                    continue;
                }
                catch (IOException badRFD) {
                    continue;
                }
                catch (HttpException e) {
                    continue;
                }
                catch (URISyntaxException e) {
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (firstDesc == null) {
                return Downloader.DownloadStatus.GAVE_UP;
            }
        }
        return super.initializeDownload();
    }

    private RemoteFileDesc createRemoteFileDesc(String defaultURL, String filename, URN urn) throws IOException, HttpException, InterruptedException, URISyntaxException {
        return this.remoteFileDescFactory.createUrlRemoteFileDesc(new URL(defaultURL), filename, urn, -1L);
    }

    @Override
    public QueryRequest newRequery() throws CantResumeException {
        MagnetOptions magnet = this.getMagnet();
        String textQuery = magnet.getQueryString();
        if (textQuery != null) {
            String q = QueryUtils.createQueryString(textQuery);
            return this.queryRequestFactory.createQuery(q);
        }
        String q = QueryUtils.createQueryString(this.getSaveFile().getName());
        return this.queryRequestFactory.createQuery(q);
    }

    @Override
    protected boolean allowAddition(RemoteFileDesc other) {
        URN otherSHA1 = other.getSHA1Urn();
        if (this.getSha1Urn() != null && otherSHA1 != null) {
            return this.getSha1Urn().equals(otherSHA1);
        }
        return false;
    }

    @Override
    protected synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        if (!this.hasRFD()) {
            this.initPropertiesMap(rfd);
        }
        return super.addDownloadForced(rfd, cache);
    }

    @Override
    protected boolean canSendRequeryNow() {
        return this.getSha1Urn() != null ? super.canSendRequeryNow() : false;
    }

    @Override
    protected void initializeIncompleteFile() throws IOException {
        if (this.getContentLength() != -1L) {
            super.initializeIncompleteFile();
        }
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MAGNET;
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        MagnetDownloadMemento mmem = (MagnetDownloadMemento)memento;
        this.setMagnet(mmem.getMagnet());
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        super.fillInMemento(memento);
        MagnetDownloadMemento mmem = (MagnetDownloadMemento)memento;
        mmem.setMagnet(this.getMagnet());
    }

    @Override
    protected DownloadMemento createMemento() {
        return new MagnetDownloadMementoImpl();
    }
}

