/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.DirectDHTAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryListener;
import com.limegroup.gnutella.downloader.RequeryManager;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.ApproximateMatcher;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.DiskException;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.service.ErrorService;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedDownloaderImpl
extends AbstractCoreDownloader
implements AltLocListener,
ManagedDownloader,
DownloadWorkerSupport {
    private static final Log LOG = LogFactory.getLog(ManagedDownloaderImpl.class);
    private Set<RemoteFileDesc> cachedRFDs;
    private SourceRanker ranker;
    private static final int GUESS_WAIT_TIME = 5000;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private volatile Thread dloaderManagerThread;
    private volatile boolean stopped;
    private volatile boolean paused;
    private volatile boolean invalidated;
    private volatile List<DownloadWorker> _activeWorkers;
    private List<DownloadWorker> _workers;
    private volatile Map<DownloadWorker, Integer> _queuedWorkers;
    private Set<RemoteFileDesc> currentRFDs;
    private volatile URN downloadSHA1;
    private Set<AlternateLocation> validAlts;
    private Set<RemoteHostData> invalidAlts;
    private Set<AlternateLocation> recentInvalidAlts;
    protected VerifyingFile commonOutFile;
    private PushList pushes;
    private Downloader.DownloadStatus state = Downloader.DownloadStatus.INITIALIZING;
    private long stateTime;
    private File incompleteFile;
    private int queuePosition;
    private String queuedVendor;
    private volatile long corruptFileBytes;
    private volatile File corruptFile;
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private volatile int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile GUID originalQueryGUID;
    private boolean triedLocatingSources;
    private volatile boolean receivedNewSources;
    private volatile int triedHosts;
    private long contentLength = -1L;
    protected final DownloadManager downloadManager;
    protected final FileManager fileManager;
    protected final IncompleteFileManager incompleteFileManager;
    protected final DownloadCallback downloadCallback;
    protected final NetworkManager networkManager;
    protected final AlternateLocationFactory alternateLocationFactory;
    protected final RequeryManager requeryManager;
    protected final QueryRequestFactory queryRequestFactory;
    protected final OnDemandUnicaster onDemandUnicaster;
    protected final DownloadWorkerFactory downloadWorkerFactory;
    protected final AltLocManager altLocManager;
    protected final ContentManager contentManager;
    protected final SourceRankerFactory sourceRankerFactory;
    protected final UrnCache urnCache;
    protected final SavedFileManager savedFileManager;
    protected final VerifyingFileFactory verifyingFileFactory;
    protected final DiskController diskController;
    protected final IPFilter ipFilter;
    protected final ScheduledExecutorService backgroundExecutor;
    protected final Provider<MessageRouter> messageRouter;
    protected final Provider<HashTreeCache> tigerTreeCache;
    protected final ApplicationServices applicationServices;
    protected final RemoteFileDescFactory remoteFileDescFactory;
    protected final Provider<PushList> pushListProvider;
    private static boolean initDone = false;

    @Inject
    protected ManagedDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, FileManager fileManager, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, SavedFileManager savedFileManager, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter ipFilter, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<HashTreeCache> tigerTreeCache, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> pushListProvider) {
        super(saveLocationManager);
        this.downloadManager = downloadManager;
        this.fileManager = fileManager;
        this.incompleteFileManager = incompleteFileManager;
        this.downloadCallback = downloadCallback;
        this.networkManager = networkManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.requeryManager = requeryManagerFactory.createRequeryManager(new RequeryListenerImpl());
        this.queryRequestFactory = queryRequestFactory;
        this.onDemandUnicaster = onDemandUnicaster;
        this.downloadWorkerFactory = downloadWorkerFactory;
        this.altLocManager = altLocManager;
        this.contentManager = contentManager;
        this.sourceRankerFactory = sourceRankerFactory;
        this.urnCache = urnCache;
        this.savedFileManager = savedFileManager;
        this.verifyingFileFactory = verifyingFileFactory;
        this.diskController = diskController;
        this.ipFilter = ipFilter;
        this.backgroundExecutor = backgroundExecutor;
        this.messageRouter = messageRouter;
        this.tigerTreeCache = tigerTreeCache;
        this.applicationServices = applicationServices;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.cachedRFDs = new HashSet<RemoteFileDesc>();
        this.pushListProvider = pushListProvider;
    }

    @Override
    public synchronized void addInitialSources(Collection<RemoteFileDesc> rfds, String defaultFileName) {
        if (rfds == null) {
            rfds = Collections.emptyList();
        }
        this.cachedRFDs.addAll(rfds);
        if (rfds.size() > 0) {
            this.initPropertiesMap(rfds.iterator().next());
        }
        assert (rfds.size() > 0 || defaultFileName != null);
        if (!this.hasDefaultFileName()) {
            this.setDefaultFileName(defaultFileName);
        }
    }

    @Override
    public void setQueryGuid(GUID queryGuid) {
        this.originalQueryGUID = queryGuid;
    }

    protected synchronized void initPropertiesMap(RemoteFileDesc rfd) {
        if (!this.hasDefaultFileName()) {
            this.setDefaultFileName(rfd.getFileName());
        }
        if (this.getContentLength() == -1L) {
            this.setContentLength(rfd.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.currentRFDs = new HashSet<RemoteFileDesc>();
        this._activeWorkers = new LinkedList<DownloadWorker>();
        this._workers = new ArrayList<DownloadWorker>();
        this._queuedWorkers = new HashMap<DownloadWorker, Integer>();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stopped = false;
        this.paused = false;
        this.setState(Downloader.DownloadStatus.QUEUED);
        this.pushes = this.pushListProvider.get();
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.queuePosition = Integer.MAX_VALUE;
        this.queuedVendor = "";
        this.triedLocatingSources = false;
        this.ranker = this.getSourceRanker(null);
        this.ranker.setMeshHandler(this);
        Object object = this;
        synchronized (object) {
            for (RemoteFileDesc rfd : this.cachedRFDs) {
                if (this.getSha1Urn() != null) break;
                if (rfd.getSHA1Urn() == null) continue;
                this.setSha1Urn(rfd.getSHA1Urn());
            }
        }
        if (this.getSha1Urn() != null) {
            this.altLocManager.addListener(this.getSha1Urn(), this);
        }
        this.verifyAllFiles();
        object = this.altLock;
        synchronized (object) {
            this.validAlts = new HashSet<AlternateLocation>();
            this.invalidAlts = new FixedSizeExpiringSet<RemoteHostData>(1000, 3600000L);
            this.recentInvalidAlts = new FixedSizeExpiringSet<AlternateLocation>(10, 600000L);
        }
        object = this;
        synchronized (object) {
            if (this.shouldInitAltLocs()) {
                this.initializeAlternateLocations();
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
        }
        catch (IOException bad) {
            this.setState(Downloader.DownloadStatus.DISK_PROBLEM);
            this.reportDiskProblem(bad);
            return;
        }
        this.setState(Downloader.DownloadStatus.QUEUED);
    }

    private void reportDiskProblem(IOException cause) {
        if (DownloadSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            if (!(cause instanceof DiskException)) {
                cause = new DiskException(cause);
            }
            ErrorService.error(cause);
        }
    }

    protected void reportDiskProblem(String cause) {
        if (DownloadSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            ErrorService.error(new DiskException(cause));
        }
    }

    private synchronized void verifyAllFiles() {
        if (this.getSha1Urn() == null) {
            return;
        }
        Iterator<RemoteFileDesc> iter = this.cachedRFDs.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = iter.next();
            if (rfd.getSHA1Urn() == null || this.getSha1Urn().equals(rfd.getSHA1Urn())) continue;
            iter.remove();
        }
    }

    @Override
    public synchronized void startDownload() {
        assert (this.dloaderManagerThread == null) : "already started";
        ThreadExecutor.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ManagedDownloaderImpl.this.dloaderManagerThread = Thread.currentThread();
                    ManagedDownloaderImpl.this.validateDownload();
                    ManagedDownloaderImpl.this.receivedNewSources = false;
                    ManagedDownloaderImpl.this.triedHosts = 0;
                    Downloader.DownloadStatus status = ManagedDownloaderImpl.this.performDownload();
                    ManagedDownloaderImpl.this.completeDownload(status);
                }
                catch (Throwable t) {
                    ManagedDownloaderImpl.this.stop();
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.ABORTED);
                    ManagedDownloaderImpl.this.downloadManager.remove(ManagedDownloaderImpl.this, true);
                    ErrorService.error(t);
                }
                finally {
                    ManagedDownloaderImpl.this.dloaderManagerThread = null;
                }
            }
        }, "ManagedDownload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDownload(Downloader.DownloadStatus status) {
        block34: {
            boolean requery;
            block36: {
                boolean complete;
                boolean clearingNeeded = false;
                int waitTime = 0;
                Object object = this;
                synchronized (object) {
                    switch (status) {
                        case COMPLETE: 
                        case DISK_PROBLEM: 
                        case CORRUPT_FILE: {
                            clearingNeeded = true;
                            this.setState(status);
                            break;
                        }
                        case BUSY: 
                        case GAVE_UP: {
                            if (this.invalidated) {
                                clearingNeeded = true;
                                this.setState(Downloader.DownloadStatus.INVALID);
                                break;
                            }
                            if (this.stopped) {
                                this.setState(Downloader.DownloadStatus.ABORTED);
                                break;
                            }
                            if (this.paused) {
                                this.setState(Downloader.DownloadStatus.PAUSED);
                                break;
                            }
                            this.setState(status);
                            break;
                        }
                        default: {
                            assert (false) : "Bad status from tad2: " + (Object)((Object)status);
                            break;
                        }
                    }
                    complete = this.isCompleted();
                    waitTime = this.ranker.calculateWaitTime();
                    this.ranker.stop();
                    if (clearingNeeded) {
                        this.ranker = null;
                    }
                }
                this.downloadManager.remove(this, complete);
                if (clearingNeeded) {
                    object = this.altLock;
                    synchronized (object) {
                        this.recentInvalidAlts.clear();
                        this.invalidAlts.clear();
                        this.validAlts.clear();
                    }
                    if (complete) {
                        object = this;
                        synchronized (object) {
                            this.cachedRFDs.clear();
                        }
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("MD completing <" + this.getSaveFile().getName() + "> completed download, state: " + (Object)((Object)this.getState()));
                }
                this.diskController.clearCaches();
                if (complete || this.getState() == Downloader.DownloadStatus.PAUSED || this.tryGUESSing()) break block34;
                requery = false;
                ManagedDownloaderImpl managedDownloaderImpl = this;
                synchronized (managedDownloaderImpl) {
                    block37: {
                        block35: {
                            if (this.getState() != Downloader.DownloadStatus.BUSY) break block35;
                            this.setState(Downloader.DownloadStatus.BUSY, waitTime);
                            break block36;
                        }
                        if (!this.requeryManager.isWaitingForResults()) break block37;
                        switch (this.requeryManager.getLastQueryType()) {
                            case DHT: {
                                this.setState(Downloader.DownloadStatus.QUERYING_DHT, this.requeryManager.getTimeLeftInQuery());
                                break block36;
                            }
                            case GNUTELLA: {
                                this.setState(Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS, this.requeryManager.getTimeLeftInQuery());
                                break block36;
                            }
                            default: {
                                throw new IllegalStateException("Not any query type!");
                            }
                        }
                    }
                    if (this.canSendRequeryNow()) {
                        requery = true;
                    } else if (this.requeryManager.canSendQueryAfterActivate()) {
                        this.setState(Downloader.DownloadStatus.WAITING_FOR_USER);
                    } else {
                        this.setState(Downloader.DownloadStatus.GAVE_UP);
                    }
                }
            }
            if (requery) {
                this.requeryManager.sendQuery();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("MD completed <" + this.getSaveFile().getName() + "> completed download, state: " + (Object)((Object)this.getState()));
        }
    }

    @Override
    public synchronized void handleInactivity() {
        switch (this.getState()) {
            case BUSY: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: {
                if (this.getRemainingStateTime() > 0 && !this.hasNewSources()) break;
                this.setState(Downloader.DownloadStatus.QUEUED);
                break;
            }
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: {
                if (this.hasNewSources()) {
                    this.setState(Downloader.DownloadStatus.QUEUED);
                    break;
                }
                if (this.requeryManager.getTimeLeftInQuery() > 0L) break;
                this.setState(Downloader.DownloadStatus.GAVE_UP);
                break;
            }
            case WAITING_FOR_USER: {
                if (!this.hasNewSources() && !this.requeryManager.canSendQueryNow()) break;
                this.setState(Downloader.DownloadStatus.QUEUED);
                break;
            }
            case GAVE_UP: {
                if (this.hasNewSources() || this.requeryManager.canSendQueryAfterActivate()) {
                    this.setState(Downloader.DownloadStatus.QUEUED);
                }
            }
            case QUEUED: 
            case PAUSED: {
                break;
            }
            default: {
                throw new IllegalStateException("invalid state: " + (Object)((Object)this.getState()) + ", workers: " + this._workers.size() + ", _activeWorkers: " + this._activeWorkers.size() + ", _queuedWorkers: " + this._queuedWorkers.size());
            }
        }
    }

    private boolean tryGUESSing() {
        if (this.originalQueryGUID == null || this.triedLocatingSources || this.getSha1Urn() == null) {
            return false;
        }
        Set<GUESSEndpoint> guessLocs = this.messageRouter.get().getQueryLocs(this.originalQueryGUID);
        if (guessLocs.isEmpty()) {
            return false;
        }
        this.setState(Downloader.DownloadStatus.ITERATIVE_GUESSING, 5000L);
        this.triedLocatingSources = true;
        for (GUESSEndpoint ep : guessLocs) {
            this.onDemandUnicaster.query(ep, this.getSha1Urn());
            if (!this.receivedNewSources) continue;
            break;
        }
        return true;
    }

    @Override
    public boolean isAlive() {
        return this.dloaderManagerThread != null;
    }

    @Override
    public boolean isCompleted() {
        switch (this.getState()) {
            case COMPLETE: 
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case ABORTED: 
            case INVALID: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRelocatable() {
        if (this.isInactive()) {
            return true;
        }
        switch (this.getState()) {
            case INITIALIZING: 
            case CONNECTING: 
            case DOWNLOADING: 
            case REMOTE_QUEUED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isActive() {
        switch (this.getState()) {
            case CONNECTING: 
            case DOWNLOADING: 
            case REMOTE_QUEUED: 
            case HASHING: 
            case SAVING: 
            case IDENTIFY_CORRUPTION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInactive() {
        switch (this.getState()) {
            case BUSY: 
            case GAVE_UP: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: 
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: 
            case WAITING_FOR_USER: 
            case QUEUED: 
            case PAUSED: 
            case INITIALIZING: {
                return true;
            }
        }
        return false;
    }

    private synchronized void initializeRanker() {
        this.ranker.setMeshHandler(this);
        this.ranker.addToPool(this.cachedRFDs);
    }

    protected void initializeVerifyingFile() throws IOException {
        if (this.incompleteFile == null) {
            return;
        }
        this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
        if (this.commonOutFile == null) {
            long completedSize = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            if (completedSize > 0xFFFFFFFFFFL) {
                throw new IOException("invalid incomplete file " + completedSize);
            }
            this.commonOutFile = this.verifyingFileFactory.createVerifyingFile(completedSize);
            this.commonOutFile.setScanForExistingBlocks(true, this.incompleteFile.length());
            this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile, this.shouldPublishIFD());
        }
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.incompleteFile != null) {
            return;
        }
        URN sha1 = this.getSha1Urn();
        if (sha1 != null) {
            this.incompleteFile = this.incompleteFileManager.getFileForUrn(sha1);
        }
        if (this.incompleteFile == null) {
            this.incompleteFile = this.getIncompleteFile(this.getSaveFile().getName(), sha1, this.getContentLength());
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("Incomplete File: " + this.incompleteFile);
        }
    }

    protected File getIncompleteFile(String name, URN urn, long length) throws IOException {
        return this.incompleteFileManager.getFile(name, urn, length);
    }

    private synchronized void initializeAlternateLocations() {
        URN hash;
        if (this.incompleteFile == null) {
            return;
        }
        FileDesc fd = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fd != null && fd instanceof IncompleteFileDesc) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
            if (this.getSha1Urn() != null && !this.getSha1Urn().equals(ifd.getSHA1Urn())) {
                ErrorService.error(new IllegalStateException("wrong IFD.\nclass: " + this.getClass().getName() + "\nours  :   " + this.incompleteFile + "\ntheirs: " + ifd.getFile() + "\nour hash    : " + this.getSha1Urn() + "\ntheir hashes: " + ifd.getUrns() + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes()));
                this.fileManager.removeFileIfShared(this.incompleteFile);
            }
        }
        if ((hash = this.incompleteFileManager.getCompletedHash(this.incompleteFile)) != null) {
            long size = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            this.addLocationsToDownload(this.altLocManager.getDirect(hash), this.altLocManager.getPushNoFWT(hash), this.altLocManager.getPushFWT(hash), size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToDownload(AlternateLocationCollection<? extends AlternateLocation> direct, AlternateLocationCollection<? extends AlternateLocation> push, AlternateLocationCollection<? extends AlternateLocation> fwt, long size) {
        ArrayList<RemoteFileDesc> locs = new ArrayList<RemoteFileDesc>(direct.getAltLocsSize() + push.getAltLocsSize() + fwt.getAltLocsSize());
        AlternateLocationCollection<? extends AlternateLocation> alternateLocationCollection = direct;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation alternateLocation : direct) {
                locs.add(alternateLocation.createRemoteFileDesc(size, this.remoteFileDescFactory));
            }
        }
        alternateLocationCollection = push;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation alternateLocation : push) {
                locs.add(alternateLocation.createRemoteFileDesc(size, this.remoteFileDescFactory));
            }
        }
        alternateLocationCollection = fwt;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation alternateLocation : fwt) {
                locs.add(alternateLocation.createRemoteFileDesc(size, this.remoteFileDescFactory));
            }
        }
        this.addPossibleSources(locs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conflictsWithIncompleteFile(File incFile) {
        File iFile = this.incompleteFile;
        if (iFile != null) {
            return iFile.equals(incFile);
        }
        URN urn = this.getSha1Urn();
        if (urn != null) {
            iFile = this.incompleteFileManager.getFileForUrn(urn);
        }
        if (iFile != null) {
            return iFile.equals(incFile);
        }
        RemoteFileDesc rfd = null;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (!this.hasRFD()) {
                return false;
            }
            rfd = this.cachedRFDs.iterator().next();
        }
        if (rfd != null) {
            try {
                File thisFile = this.incompleteFileManager.getFile(rfd);
                return thisFile.equals(incFile);
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean conflicts(URN urn, long fileSize, File ... fileName) {
        if (urn != null && this.getSha1Urn() != null) {
            return urn.equals(this.getSha1Urn());
        }
        if (fileSize > 0L) {
            try {
                File file = this.incompleteFileManager.getFile(fileName[0].getName(), null, fileSize);
                return this.conflictsWithIncompleteFile(file);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized QueryRequest newRequery() throws CantResumeException {
        String queryString = QueryUtils.createQueryString(this.getDefaultFileName());
        if (queryString == null || queryString.equals("")) {
            throw new CantResumeException(this.getSaveFile().getName());
        }
        return this.queryRequestFactory.createQuery(queryString);
    }

    protected boolean shouldInitAltLocs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hostIsAllowed(RemoteFileDesc other) {
        if (!this.ipFilter.allow(other.getHost())) {
            return false;
        }
        if (this.networkManager.acceptedIncomingConnection() || !other.isFirewalled() || other.supportsFWTransfer() && this.networkManager.canDoFWT()) {
            Object object = this.altLock;
            synchronized (object) {
                if (other.isFromAlternateLocation() && this.invalidAlts.contains(other.getRemoteHostData())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc other) {
        if (!initDone) {
            ApproximateMatcher approximateMatcher = matcher;
            synchronized (approximateMatcher) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            initDone = true;
        }
        if (other.getQuality() < 1) {
            return false;
        }
        URN otherUrn = other.getSHA1Urn();
        String otherName = other.getFileName();
        long otherLength = other.getFileSize();
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            long ourLength = this.getContentLength();
            if (ourLength != -1L && ourLength != otherLength) {
                return false;
            }
            if (otherUrn != null && this.getSha1Urn() != null) {
                return otherUrn.equals(this.getSha1Urn());
            }
            for (RemoteFileDesc rfd : this.cachedRFDs) {
                String thisName = rfd.getFileName();
                long thisLength = rfd.getFileSize();
                if (otherLength != thisLength || !this.namesClose(otherName, thisName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String one, String two) {
        boolean retVal = false;
        int allowedDifferences = Math.round(Math.min(0.1f * (float)QueryUtils.ripExtension(one).length(), 0.1f * (float)QueryUtils.ripExtension(two).length()));
        allowedDifferences = Math.min(allowedDifferences, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            retVal = matcher.matches(matcher.process(one), matcher.process(two), allowedDifferences);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MD.namesClose(): one = " + one);
            LOG.debug("MD.namesClose(): two = " + two);
            LOG.debug("MD.namesClose(): retVal = " + retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void locationAdded(AlternateLocation loc) {
        long fileSize;
        assert (loc.getSHA1Urn().equals(this.getSha1Urn()));
        long contentLength = -1L;
        if (loc instanceof DirectDHTAltLoc && (fileSize = ((DirectDHTAltLoc)loc).getFileSize()) >= 0L) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                contentLength = this.getContentLength();
                if (contentLength < 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using file size from AltLocValue: " + fileSize);
                    }
                    if ((contentLength = fileSize) <= 0xFFFFFFFFFFL) {
                        this.setContentLength(contentLength);
                    }
                }
            }
            if (fileSize != contentLength) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("File sizes do not match: " + fileSize + " vs. " + contentLength);
                }
                return;
            }
        }
        if ((contentLength = this.getContentLength()) < 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unknown file size: " + contentLength);
            }
            return;
        }
        if (contentLength > 0xFFFFFFFFFFL) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Content length is too big: " + contentLength);
            }
            return;
        }
        this.addDownload(loc.createRemoteFileDesc(contentLength, this.remoteFileDescFactory), false);
    }

    @Override
    public synchronized boolean addDownload(RemoteFileDesc rfd, boolean cache) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        if (!this.allowAddition(rfd)) {
            return false;
        }
        rfd.setDownloading(true);
        if (!this.hostIsAllowed(rfd)) {
            return false;
        }
        return this.addDownloadForced(rfd, cache);
    }

    @Override
    public synchronized boolean addDownload(Collection<? extends RemoteFileDesc> c, boolean cache) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        ArrayList<RemoteFileDesc> l = new ArrayList<RemoteFileDesc>(c.size());
        for (RemoteFileDesc remoteFileDesc : c) {
            if (!this.hostIsAllowed(remoteFileDesc) || !this.allowAddition(remoteFileDesc)) continue;
            l.add(remoteFileDesc);
        }
        return this.addDownloadForced(l, cache);
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc rfd, boolean cache) {
        if (rfd.isMe(this.applicationServices.getMyGUID())) {
            return true;
        }
        if (this.currentRFDs.contains(rfd)) {
            return true;
        }
        this.prepareRFD(rfd, cache);
        if (this.ranker.addToPool(rfd)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    protected final synchronized boolean addDownloadForced(Collection<? extends RemoteFileDesc> c, boolean cache) {
        c.removeAll(this.currentRFDs);
        Iterator<? extends RemoteFileDesc> iter = c.iterator();
        while (iter.hasNext()) {
            RemoteFileDesc rfd = iter.next();
            if (rfd.isMe(this.applicationServices.getMyGUID())) {
                iter.remove();
                continue;
            }
            this.prepareRFD(rfd, cache);
        }
        if (this.ranker.addToPool(c)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    private void prepareRFD(RemoteFileDesc rfd, boolean cache) {
        if (this.getSha1Urn() == null && rfd.getSHA1Urn() != null) {
            this.setSha1Urn(rfd.getSHA1Urn());
            this.altLocManager.addListener(this.getSha1Urn(), this);
        }
        if (cache) {
            this.cachedRFDs.add(rfd);
        }
    }

    @Override
    public boolean hasNewSources() {
        return !this.paused && this.receivedNewSources;
    }

    @Override
    public boolean shouldBeRestarted() {
        Downloader.DownloadStatus status = this.getState();
        return this.hasNewSources() || this.getRemainingStateTime() <= 0 && status != Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS && status != Downloader.DownloadStatus.QUERYING_DHT;
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.isCancelled() || this.isCompleted();
    }

    @Override
    public boolean isQueuable() {
        return !this.isPaused();
    }

    @Override
    public boolean acceptDownload(String file, Socket socket, int index, byte[] clientGUID) {
        if (this.stopped) {
            return false;
        }
        HTTPConnectObserver observer = this.pushes.getHostFor(clientGUID, socket.getInetAddress().getHostAddress());
        if (observer != null) {
            observer.handleConnect(socket);
        }
        return observer != null;
    }

    @Override
    public void registerPushObserver(HTTPConnectObserver observer, PushDetails details) {
        this.pushes.addPushHost(details, observer);
    }

    @Override
    public void unregisterPushObserver(PushDetails details, boolean shutdown) {
        HTTPConnectObserver observer = this.pushes.getExactHostFor(details);
        if (observer != null && shutdown) {
            observer.shutdown();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.stopped;
    }

    @Override
    public synchronized void pause() {
        if (!this.stopped && !this.isCompleted()) {
            this.stop();
            this.stopped = false;
            this.paused = true;
            if (this.isInactive()) {
                this.setState(Downloader.DownloadStatus.PAUSED);
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isPausable() {
        Downloader.DownloadStatus state = this.getState();
        return !this.isPaused() && !this.isCompleted() && state != Downloader.DownloadStatus.SAVING && state != Downloader.DownloadStatus.HASHING;
    }

    @Override
    public boolean isResumable() {
        return this.isInactive() && this.state != Downloader.DownloadStatus.QUEUED;
    }

    @Override
    public boolean isLaunchable() {
        return this.state == Downloader.DownloadStatus.COMPLETE || this.amountForPreview() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.paused) {
            this.stopped = true;
            this.paused = false;
        }
        if (this.stopped || this.paused) {
            return;
        }
        LOG.debug("STOPPING ManagedDownloader");
        this.stopped = true;
        this.killAllWorkers();
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            Thread dlMan = this.dloaderManagerThread;
            if (dlMan != null) {
                dlMan.interrupt();
            } else {
                LOG.warn("MANAGER: no thread to interrupt");
            }
        }
    }

    private void killAllWorkers() {
        List<DownloadWorker> workers = this.getAllWorkers();
        for (DownloadWorker doomed : workers) {
            doomed.interrupt();
        }
        List<HTTPConnectObserver> pushObservers = this.pushes.getAllAndClear();
        for (HTTPConnectObserver next : pushObservers) {
            next.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void informMesh(RemoteFileDesc rfd, boolean good) {
        AlternateLocation local;
        AlternateLocation loc;
        if (LOG.isDebugEnabled()) {
            LOG.debug("informing mesh that " + rfd + " is " + good);
        }
        if (good) {
            this.cachedRFDs.add(rfd);
        }
        if (!rfd.isAltLocCapable()) {
            return;
        }
        assert (this.getSha1Urn() != null) : "null hash.";
        assert (this.getSha1Urn().equals(rfd.getSHA1Urn())) : "wrong loc SHA1";
        try {
            loc = this.alternateLocationFactory.create(rfd);
        }
        catch (IOException iox) {
            return;
        }
        if (loc instanceof PushAltLoc) {
            local = loc.createClone();
            PushAltLoc ploc = (PushAltLoc)loc;
            if (ploc.getPushAddress().getProxies().isEmpty()) {
                return;
            }
            ploc.updateProxies(good);
        } else {
            local = loc;
        }
        if (good) {
            this.altLocManager.add(loc, this);
        } else {
            this.altLocManager.remove(loc, this);
        }
        for (DownloadWorker worker : this.getActiveWorkers()) {
            HTTPDownloader httpDloader = worker.getDownloader();
            RemoteFileDesc r = httpDloader.getRemoteFileDesc();
            if (local instanceof PushAltLoc ? r.getPushAddr() != null && r.getPushAddr().equals(rfd.getPushAddr()) : r.getHost().equals(rfd.getHost()) && r.getPort() == rfd.getPort()) continue;
            if (!(local instanceof DirectAltLoc) && !httpDloader.wantsFalts()) continue;
            if (good) {
                httpDloader.addSuccessfulAltLoc(local);
                continue;
            }
            httpDloader.addFailedAltLoc(local);
        }
        Object object = this.altLock;
        synchronized (object) {
            if (good) {
                if (!this.validAlts.contains(local)) {
                    this.validAlts.add(local);
                }
            } else {
                this.validAlts.remove(local);
                this.invalidAlts.add(rfd.getRemoteHostData());
                this.recentInvalidAlts.add(local);
            }
        }
    }

    @Override
    public synchronized void addPossibleSources(Collection<? extends RemoteFileDesc> c) {
        this.addDownload(c, false);
    }

    protected boolean canSendRequeryNow() {
        return this.requeryManager.canSendQueryNow();
    }

    @Override
    public synchronized boolean resume() {
        if (!this.isInactive()) {
            return false;
        }
        if (this.getState() == Downloader.DownloadStatus.WAITING_FOR_USER) {
            this.requeryManager.activate();
        }
        for (RemoteFileDesc rfd : this.cachedRFDs) {
            rfd.setRetryAfter(0);
        }
        if (this.paused) {
            this.paused = false;
            this.stopped = false;
        }
        this.setState(Downloader.DownloadStatus.QUEUED);
        return true;
    }

    @Override
    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == Downloader.DownloadStatus.COMPLETE) {
            return this.getSaveFile();
        }
        return this.incompleteFile;
    }

    @Override
    public URN getSha1Urn() {
        return this.downloadSHA1;
    }

    protected void setSha1Urn(URN sha1) {
        if (!sha1.isSHA1()) {
            throw new IllegalArgumentException("not sha1: " + sha1);
        }
        if (this.downloadSHA1 != null && !sha1.equals(this.downloadSHA1)) {
            throw new IllegalStateException("sha1 already set to: " + this.downloadSHA1);
        }
        this.downloadSHA1 = sha1;
    }

    @Override
    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == Downloader.DownloadStatus.CORRUPT_FILE) {
            return this.corruptFile;
        }
        if (this.state != Downloader.DownloadStatus.COMPLETE) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            long size = this.amountForPreview();
            if (size <= 0L) {
                return null;
            }
            if (FileUtils.copy(this.incompleteFile, size, file) <= 0L) {
                return null;
            }
            return file;
        }
        return this.getSaveFile();
    }

    private synchronized long amountForPreview() {
        if (this.commonOutFile == null) {
            return 0L;
        }
        return this.commonOutFile.getOffsetForPreview();
    }

    @Override
    protected File getDefaultSaveFile() {
        String fileName = this.getDefaultFileName();
        return new File(SharingSettings.getSaveDirectory(fileName), fileName);
    }

    @Override
    public synchronized void finish() {
        if (this.getSha1Urn() != null) {
            this.altLocManager.removeListener(this.getSha1Urn(), this);
        }
        this.requeryManager.cleanUp();
        if (this.cachedRFDs != null) {
            for (RemoteFileDesc rfd : this.cachedRFDs) {
                rfd.setDownloading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Downloader.DownloadStatus performDownload() {
        Downloader.DownloadStatus status;
        block14: {
            if (this.checkHosts()) {
                this.setState(Downloader.DownloadStatus.GAVE_UP);
                return Downloader.DownloadStatus.GAVE_UP;
            }
            status = this.initializeDownload();
            if (status == Downloader.DownloadStatus.CONNECTING) {
                try {
                    try {
                        status = this.fireDownloadWorkers();
                    }
                    finally {
                        this.commonOutFile.close();
                    }
                    if (status == Downloader.DownloadStatus.COMPLETE) {
                        status = this.verifyAndSave();
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("stopping early with status: " + (Object)((Object)status));
                    }
                }
                catch (InterruptedException e) {
                    if (!this.stopped && !this.paused) {
                        ErrorService.error(e);
                    } else {
                        status = Downloader.DownloadStatus.GAVE_UP;
                    }
                    if (this.corruptState != 2) break block14;
                    this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
                    status = Downloader.DownloadStatus.CORRUPT_FILE;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MANAGER: TAD2 returned: " + (Object)((Object)status));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Downloader.DownloadStatus initializeDownload() {
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (this.cachedRFDs.size() == 0 && !this.ranker.hasMore()) {
                return Downloader.DownloadStatus.GAVE_UP;
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
            this.openVerifyingFile();
        }
        catch (IOException iox) {
            this.reportDiskProblem(iox);
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        if (this.getSha1Urn() != null) {
            this.initializeHashTree();
        }
        this.initializeRanker();
        return Downloader.DownloadStatus.CONNECTING;
    }

    private Downloader.DownloadStatus verifyAndSave() throws InterruptedException {
        URN fileHash = this.scanForCorruption();
        if (this.corruptState == 2) {
            this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
            return Downloader.DownloadStatus.CORRUPT_FILE;
        }
        return this.saveFile(fileHash);
    }

    private void validateDownload() {
        if (this.shouldValidate() && this.getSha1Urn() != null) {
            this.contentManager.request(this.getSha1Urn(), new ContentResponseObserver(){

                public void handleResponse(URN urn, ContentResponseData response) {
                    if (response != null && !response.isOK()) {
                        ManagedDownloaderImpl.this.invalidated = true;
                        ManagedDownloaderImpl.this.stop();
                    }
                }
            }, 5000L);
        }
    }

    protected boolean shouldValidate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private URN scanForCorruption() throws InterruptedException {
        if (this.corruptState == 2) {
            return null;
        }
        URN fileHash = null;
        try {
            this.setState(Downloader.DownloadStatus.HASHING);
            fileHash = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.getSha1Urn() == null) {
            return fileHash;
        }
        if (this.getSha1Urn().equals(fileHash)) {
            return fileHash;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("hash verification problem, fileHash=" + fileHash + ", ourHash=" + this.getSha1Urn());
        }
        if (this.commonOutFile.getHashTree() == null) {
            this.fileManager.removeFileIfShared(this.incompleteFile);
        }
        this.tigerTreeCache.get().purgeTree(this.getSha1Urn());
        this.commonOutFile.setHashTree(null);
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        return fileHash;
    }

    private void initializeHashTree() {
        HashTree tree = this.tigerTreeCache.get().getHashTree(this.getSha1Urn());
        if (tree != null && tree.isDepthGoodEnough()) {
            this.commonOutFile.setHashTree(tree);
        }
    }

    protected Downloader.DownloadStatus saveFile(URN fileHash) {
        this.setState(Downloader.DownloadStatus.SAVING);
        if (!FileUtils.setWriteable(this.getSaveFile().getParentFile())) {
            this.reportDiskProblem("could not set file writeable " + this.getSaveFile().getParentFile());
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        File saveFile = this.getSaveFile();
        saveFile.delete();
        try {
            saveFile = this.getSuggestedSaveLocation(saveFile);
        }
        catch (IOException e) {
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        boolean success = FileUtils.forceRename(this.incompleteFile, saveFile);
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (!success) {
            this.reportDiskProblem("forceRename failed " + this.incompleteFile + " -> " + saveFile);
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        if (saveFile.exists()) {
            this.fileManager.removeFileIfShared(saveFile);
        }
        this.addFileHash(fileHash, saveFile);
        this.shareSavedFile();
        return Downloader.DownloadStatus.COMPLETE;
    }

    protected File getSuggestedSaveLocation(File saveFile) throws IOException {
        return saveFile;
    }

    private void addFileHash(URN fileHash, File saveFile) {
        if (fileHash != null) {
            UrnSet urns = new UrnSet(fileHash);
            File file = saveFile;
            try {
                file = FileUtils.getCanonicalFile(saveFile);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            URN ttroot = this.saveTreeHash(fileHash);
            if (ttroot != null) {
                urns.add(ttroot);
            }
            this.urnCache.addUrns(file, urns);
            this.savedFileManager.addSavedFile(file, urns);
        }
    }

    protected URN saveTreeHash(URN fileHash) {
        if (this.getSha1Urn() != null && this.getSha1Urn().equals(fileHash) && this.commonOutFile.getHashTree() != null) {
            this.tigerTreeCache.get().addHashTree(this.getSha1Urn(), this.commonOutFile.getHashTree());
            return this.commonOutFile.getHashTree().getTreeRootUrn();
        }
        return null;
    }

    protected void shareSavedFile() {
        if (SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
            this.fileManager.addFileAlways(this.getSaveFile(), this.getXMLDocuments());
        } else {
            this.fileManager.addFileIfShared(this.getSaveFile(), this.getXMLDocuments());
        }
    }

    private void cleanupCorrupt(File incFile, String name) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(incFile);
        boolean renamed = false;
        for (int i = 0; i < 10 && !renamed; ++i) {
            this.corruptFile = new File(incFile.getParent(), "CORRUPT-" + i + "-" + name);
            if (this.corruptFile.exists()) continue;
            renamed = incFile.renameTo(this.corruptFile);
        }
        if (!renamed) {
            incFile.delete();
            this.corruptFile = null;
        }
    }

    private void openVerifyingFile() throws IOException {
        try {
            this.commonOutFile.open(this.incompleteFile);
        }
        catch (IOException e) {
            IOUtils.handleException(e, IOUtils.ErrorType.DOWNLOAD);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(RemoteFileDesc rfd) {
        DownloadWorker worker = this.downloadWorkerFactory.create(this, rfd, this.commonOutFile);
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            this._workers.add(worker);
            this.currentRFDs.add(rfd);
        }
        worker.start();
    }

    @Override
    public synchronized void workerFinished(DownloadWorker finished) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("worker " + finished + " finished.");
        }
        this.removeWorker(finished);
        this.notify();
    }

    @Override
    public synchronized void workerStarted(DownloadWorker worker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("worker " + worker + " started.");
        }
        if (!this._workers.contains(worker)) {
            throw new IllegalStateException("attempting to start invalid worker: " + worker);
        }
        this.setState(Downloader.DownloadStatus.DOWNLOADING);
        this.addActiveWorker(worker);
        this.chatList.addHost(worker.getDownloader());
        this.browseList.addHost(worker.getDownloader());
    }

    @Override
    public void workerFailed(DownloadWorker failed) {
        HTTPDownloader downloader = failed.getDownloader();
        if (downloader != null) {
            this.chatList.removeHost(downloader);
            this.browseList.removeHost(downloader);
        }
    }

    synchronized void removeWorker(DownloadWorker worker) {
        boolean rA = this.removeActiveWorker(worker);
        this.workerFailed(worker);
        boolean rW = this._workers.remove(worker);
        if (rA && !rW) {
            throw new IllegalStateException("active removed but not in workers");
        }
    }

    @Override
    public synchronized boolean removeActiveWorker(DownloadWorker worker) {
        this.currentRFDs.remove(worker.getRFD());
        ArrayList<DownloadWorker> l = new ArrayList<DownloadWorker>(this.getActiveWorkers());
        boolean removed = l.remove(worker);
        this._activeWorkers = Collections.unmodifiableList(l);
        return removed;
    }

    synchronized void addActiveWorker(DownloadWorker worker) {
        if (!this.getActiveWorkers().contains(worker)) {
            ArrayList<DownloadWorker> l = new ArrayList<DownloadWorker>(this.getActiveWorkers());
            l.add(worker);
            this._activeWorkers = Collections.unmodifiableList(l);
        }
    }

    synchronized String getWorkersInfo() {
        String workerState = "";
        for (DownloadWorker worker : this._workers) {
            workerState = workerState + worker.getInfo();
        }
        return workerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AlternateLocation> getValidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            Set<AlternateLocation> ret;
            if (this.validAlts != null) {
                ret = new HashSet();
                for (AlternateLocation next : this.validAlts) {
                    ret.add(next);
                }
            } else {
                ret = Collections.emptySet();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AlternateLocation> getInvalidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            Set<AlternateLocation> ret;
            if (this.invalidAlts != null) {
                ret = new HashSet();
                for (AlternateLocation next : this.recentInvalidAlts) {
                    ret.add(next);
                }
            } else {
                ret = Collections.emptySet();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Downloader.DownloadStatus fireDownloadWorkers() throws InterruptedException {
        LOG.trace("MANAGER: entered fireDownloadWorkers");
        while (true) {
            if (this.stopped || this.paused) {
                LOG.warn("MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            try {
                this.commonOutFile.waitForPendingIfNeeded();
            }
            catch (DiskException dio) {
                if (this.stopped || this.paused) {
                    LOG.warn("MANAGER: terminating because of stop|pause");
                    throw new InterruptedException();
                }
                this.stop();
                this.reportDiskProblem(dio);
                return Downloader.DownloadStatus.DISK_PROBLEM;
            }
            if (this.commonOutFile.isComplete()) {
                this.killAllWorkers();
                LOG.trace("MANAGER: terminating because of completion");
                return Downloader.DownloadStatus.COMPLETE;
            }
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                if (this._workers.size() == 0 && !this.ranker.hasNonBusy()) {
                    this.receivedNewSources = false;
                    if (this.ranker.calculateWaitTime() > 0) {
                        LOG.trace("MANAGER: terminating with busy");
                        return Downloader.DownloadStatus.BUSY;
                    }
                    LOG.trace("MANAGER: terminating w/o hope");
                    return Downloader.DownloadStatus.GAVE_UP;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("MANAGER: kicking off workers.  state: " + (Object)((Object)this.getState()) + ", allWorkers: " + this._workers.size() + ", activeWorkers: " + this._activeWorkers.size() + ", queuedWorkers: " + this._queuedWorkers.size() + ", swarm cap: " + this.getSwarmCapacity());
                }
                if (this.shouldStartWorker()) {
                    this.ranker = this.getSourceRanker(this.ranker);
                    RemoteFileDesc rfd = this.ranker.getBest();
                    if (rfd != null) {
                        if (rfd.isBusy()) {
                            this.addRFD(rfd);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Staring worker for RFD: " + rfd);
                            }
                            this.startWorker(rfd);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("no blocks but can't steal - sleeping.");
                }
                try {
                    this.wait(DownloadSettings.WORKER_INTERVAL.getValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected SourceRanker getSourceRanker(SourceRanker ranker) {
        return this.sourceRankerFactory.getAppropriateRanker(ranker);
    }

    private boolean shouldStartWorker() {
        return (this.commonOutFile.hasFreeBlocksToAssign() > 0L || this.victimsExist()) && this._workers.size() - this._queuedWorkers.size() < this.getSwarmCapacity() && this.ranker.hasMore();
    }

    private boolean victimsExist() {
        if (this._workers.isEmpty()) {
            return false;
        }
        for (DownloadWorker victim : this._workers) {
            if (victim.isStealing() || !victim.isSlow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addRFD(RemoteFileDesc rfd) {
        if (this.ranker != null) {
            this.ranker.addToPool(rfd);
        }
    }

    @Override
    public synchronized void forgetRFD(RemoteFileDesc rfd) {
        if (this.cachedRFDs.remove(rfd) && this.cachedRFDs.isEmpty()) {
            rfd.setSerializeProxies();
            this.cachedRFDs.add(rfd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.validAlts == null) {
                return 0;
            }
            return this.validAlts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfInvalidAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.invalidAlts == null) {
                return 0;
            }
            return this.invalidAlts.size();
        }
    }

    @Override
    public synchronized int getPossibleHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumKnownHosts();
    }

    @Override
    public synchronized int getBusyHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumBusyHosts();
    }

    @Override
    public synchronized int getQueuedHostCount() {
        return this._queuedWorkers.size();
    }

    int getSwarmCapacity() {
        int capacity = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (capacity <= 56) {
            return 2;
        }
        if (capacity <= 1000) {
            return 8;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            if (this.corruptState == 0) {
                this.corruptState = 1;
                this.sendCorruptCallback();
            }
        }
    }

    protected void sendCorruptCallback() {
        this.downloadCallback.promptAboutCorruptDownload(this);
    }

    @Override
    public void discardCorruptDownload(final boolean delete) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("User chose to delete corrupt " + delete);
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ManagedDownloaderImpl.this.corruptStateLock;
                synchronized (object) {
                    if (delete) {
                        ManagedDownloaderImpl.this.corruptState = 2;
                    } else {
                        ManagedDownloaderImpl.this.corruptState = 3;
                    }
                }
                if (delete) {
                    ManagedDownloaderImpl.this.stop();
                } else {
                    ManagedDownloaderImpl.this.commonOutFile.setDiscardUnverified(false);
                }
                object = ManagedDownloaderImpl.this.corruptStateLock;
                synchronized (object) {
                    ManagedDownloaderImpl.this.corruptStateLock.notify();
                }
            }
        };
        this.backgroundExecutor.execute(r);
    }

    private synchronized List<LimeXMLDocument> getXMLDocuments() {
        ArrayList<LimeXMLDocument> allDocs = new ArrayList<LimeXMLDocument>();
        for (RemoteFileDesc rfd : this.cachedRFDs) {
            LimeXMLDocument doc = rfd.getXMLDocument();
            if (doc == null) continue;
            allDocs.add(doc);
        }
        return allDocs;
    }

    @Override
    public synchronized void setState(Downloader.DownloadStatus newState) {
        this.setState(newState, Long.MAX_VALUE);
    }

    synchronized void setState(Downloader.DownloadStatus newState, long time) {
        this.state = newState;
        this.stateTime = System.currentTimeMillis() + time;
    }

    synchronized boolean setStateIfExistingStateIs(Downloader.DownloadStatus newState, Downloader.DownloadStatus oldState) {
        if (this.getState() == oldState) {
            this.setState(newState);
            return true;
        }
        return false;
    }

    @Override
    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    @Override
    public synchronized Downloader.DownloadStatus getState() {
        return this.state;
    }

    @Override
    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case BUSY: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: 
            case CONNECTING: {
                long remaining = this.stateTime - System.currentTimeMillis();
                return (int)Math.ceil((float)Math.max(remaining, 0L) / 1000.0f);
            }
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: {
                return (int)Math.ceil((float)Math.max(this.requeryManager.getTimeLeftInQuery(), 0L) / 1000.0f);
            }
            case QUEUED: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected synchronized boolean hasRFD() {
        return this.cachedRFDs != null && !this.cachedRFDs.isEmpty();
    }

    @Override
    public synchronized long getContentLength() {
        return this.contentLength;
    }

    protected synchronized void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountRead() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (this.state == Downloader.DownloadStatus.CORRUPT_FILE) {
                return this.corruptFileBytes;
            }
            if (this.state == Downloader.DownloadStatus.HASHING) {
                if (this.incompleteFile == null) {
                    return 0L;
                }
                return URN.getHashingProgress(this.incompleteFile);
            }
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0L : ourFile.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAmountPending() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return (int)(ourFile == null ? 0L : ourFile.getPendingSize());
    }

    @Override
    public int getNumHosts() {
        return this._activeWorkers.size();
    }

    @Override
    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    @Override
    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    @Override
    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    @Override
    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    @Override
    public synchronized int getQueuePosition() {
        return this.queuePosition;
    }

    @Override
    public int getNumDownloaders() {
        return this.getActiveWorkers().size() + this.getQueuedWorkers().size();
    }

    @Override
    public List<DownloadWorker> getActiveWorkers() {
        return this._activeWorkers;
    }

    @Override
    public synchronized List<DownloadWorker> getAllWorkers() {
        return new ArrayList<DownloadWorker>(this._workers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueuedWorker(DownloadWorker unQueued) {
        if (this.getQueuedWorkers().containsKey(unQueued)) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                HashMap<DownloadWorker, Integer> m = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
                m.remove(unQueued);
                this._queuedWorkers = Collections.unmodifiableMap(m);
            }
        }
    }

    private synchronized void addQueuedWorker(DownloadWorker queued, int position) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding queued worker " + queued + " at position " + position + " current queued workers:\n" + this._queuedWorkers);
        }
        if (!this._workers.contains(queued)) {
            throw new IllegalStateException("attempting to queue invalid worker: " + queued);
        }
        if (position < this.queuePosition) {
            this.queuePosition = position;
            this.queuedVendor = queued.getDownloader().getVendor();
        }
        HashMap<DownloadWorker, Integer> m = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
        m.put(queued, new Integer(position));
        this._queuedWorkers = Collections.unmodifiableMap(m);
    }

    @Override
    public Map<DownloadWorker, Integer> getQueuedWorkers() {
        return this._queuedWorkers;
    }

    int getWorkerQueuePosition(DownloadWorker worker) {
        Integer i = this.getQueuedWorkers().get(worker);
        return i == null ? -1 : i;
    }

    @Override
    public synchronized boolean killQueuedIfNecessary(DownloadWorker worker, int queuePos) {
        int swarmCapacity;
        if (LOG.isDebugEnabled()) {
            LOG.debug("deciding whether to kill a queued host for (" + queuePos + ") worker " + worker);
        }
        DownloadWorker doomed = null;
        int numDownloaders = this.getNumDownloaders();
        if (numDownloaders <= (swarmCapacity = this.getSwarmCapacity()) && queuePos == -1) {
            return true;
        }
        if (this._queuedWorkers.containsKey(worker) && queuePos > -1) {
            this.addQueuedWorker(worker, queuePos);
            return true;
        }
        if (numDownloaders >= swarmCapacity) {
            int highest = queuePos;
            for (Map.Entry<DownloadWorker, Integer> current : this._queuedWorkers.entrySet()) {
                int currQueue = current.getValue();
                if (currQueue <= highest) continue;
                doomed = current.getKey();
                highest = currQueue;
            }
            if (doomed == null) {
                LOG.debug("not queueing myself");
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("will replace " + doomed);
            }
            doomed.interrupt();
        }
        if (queuePos > -1) {
            this.addQueuedWorker(worker, queuePos);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hashTreeRead(HashTree tree) {
        boolean set = false;
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            HashTree oldTree;
            this.commonOutFile.setHashTreeRequested(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Downloaded tree: " + tree);
            }
            if (tree != null && tree.isBetterTree(oldTree = this.commonOutFile.getHashTree())) {
                set = this.commonOutFile.setHashTree(tree);
            }
        }
        if (set && tree != null) {
            URN sha1 = this.getSha1Urn();
            URN ttroot = tree.getTreeRootUrn();
            this.tigerTreeCache.get().addRoot(sha1, ttroot);
            FileManager fileManager = this.fileManager;
            synchronized (fileManager) {
                FileDesc fd = this.fileManager.getFileDescForUrn(sha1);
                if (fd == null) {
                    return;
                }
                if (fd.setTTRoot(ttroot)) {
                    this.fileManager.fileURNSUpdated(fd);
                }
            }
        }
    }

    @Override
    public synchronized String getVendor() {
        List<DownloadWorker> active = this.getActiveWorkers();
        if (active.size() > 0) {
            HTTPDownloader dl = active.get(0).getDownloader();
            return dl.getVendor();
        }
        if (this.getState() == Downloader.DownloadStatus.REMOTE_QUEUED) {
            return this.queuedVendor;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        float currentTotal = 0.0f;
        boolean c = false;
        for (DownloadWorker worker : this.getActiveWorkers()) {
            c = true;
            HTTPDownloader dloader = worker.getDownloader();
            dloader.measureBandwidth();
            currentTotal += dloader.getAverageBandwidth();
        }
        if (c) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + currentTotal) / (float)(++this.numMeasures);
            }
        }
    }

    @Override
    public float getMeasuredBandwidth() {
        float retVal = 0.0f;
        for (DownloadWorker worker : this.getActiveWorkers()) {
            HTTPDownloader dloader = worker.getDownloader();
            float curr = 0.0f;
            try {
                curr = dloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException ide) {
                curr = 0.0f;
            }
            retVal += curr;
        }
        return retVal;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountVerified() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0L : ourFile.getVerifiedBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountLost() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return ourFile == null ? 0L : ourFile.getAmountLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkSize() {
        VerifyingFile ourFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            ourFile = this.commonOutFile;
        }
        return ourFile != null ? ourFile.getChunkSize() : 131072;
    }

    private boolean checkHosts() {
        String s = "LimeWire";
        return s.hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    @Override
    public synchronized void incrementTriedHostsCount() {
        ++this.triedHosts;
    }

    @Override
    public int getTriedHostCount() {
        return this.triedHosts;
    }

    @Override
    public String getCustomIconDescriptor() {
        return null;
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MANAGED;
    }

    protected synchronized void setIncompleteFile(File incompleteFile) {
        this.incompleteFile = incompleteFile;
    }

    protected synchronized File getIncompleteFile() {
        return this.incompleteFile;
    }

    @Override
    protected DownloadMemento createMemento() {
        return new GnutellaDownloadMementoImpl();
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento memento) throws InvalidDataException {
        super.initFromMemento(memento);
        GnutellaDownloadMemento gmem = (GnutellaDownloadMemento)memento;
        this.setContentLength(gmem.getContentLength());
        if (gmem.getSha1Urn() != null) {
            this.setSha1Urn(gmem.getSha1Urn());
        }
        this.setIncompleteFile(gmem.getIncompleteFile());
        if (gmem.getRemoteHosts().isEmpty() && gmem.getDefaultFileName() == null) {
            throw new InvalidDataException("must have a name!");
        }
        this.addInitialSources(this.toRfds(gmem.getRemoteHosts()), gmem.getDefaultFileName());
        if (this.getIncompleteFile() != null) {
            this.incompleteFileManager.initEntry(this.getIncompleteFile(), gmem.getSavedBlocks(), this.getSha1Urn(), this.shouldPublishIFD());
        }
    }

    protected boolean shouldPublishIFD() {
        return true;
    }

    @Override
    protected void fillInMemento(DownloadMemento memento) {
        GnutellaDownloadMemento gmem = (GnutellaDownloadMemento)memento;
        super.fillInMemento(gmem);
        gmem.setContentLength(this.getContentLength());
        gmem.setSha1Urn(this.getSha1Urn());
        if (this.commonOutFile != null) {
            gmem.setSavedBlocks(this.commonOutFile.getSerializableBlocks());
        }
        gmem.setIncompleteFile(this.getIncompleteFile());
        gmem.setRemoteHosts(this.getRemoteHostMementos());
    }

    private Set<RemoteHostMemento> getRemoteHostMementos() {
        HashSet<RemoteHostMemento> mementos = new HashSet<RemoteHostMemento>(this.cachedRFDs.size());
        for (RemoteFileDesc rfd : this.cachedRFDs) {
            mementos.add(rfd.toMemento());
        }
        return mementos;
    }

    private Collection<RemoteFileDesc> toRfds(Collection<? extends RemoteHostMemento> mementos) throws InvalidDataException {
        if (mementos == null) {
            return Collections.emptyList();
        }
        ArrayList<RemoteFileDesc> rfds = new ArrayList<RemoteFileDesc>(mementos.size());
        for (RemoteHostMemento remoteHostMemento : mementos) {
            rfds.add(this.remoteFileDescFactory.createFromMemento(remoteHostMemento));
        }
        return rfds;
    }

    private class RequeryListenerImpl
    implements RequeryListener {
        private RequeryListenerImpl() {
        }

        public QueryRequest createQuery() {
            try {
                return ManagedDownloaderImpl.this.newRequery();
            }
            catch (CantResumeException cre) {
                return null;
            }
        }

        public URN getSHA1Urn() {
            return ManagedDownloaderImpl.this.getSha1Urn();
        }

        public void lookupFinished(RequeryManager.QueryType queryType) {
            switch (queryType) {
                case DHT: {
                    ManagedDownloaderImpl.this.setStateIfExistingStateIs(Downloader.DownloadStatus.GAVE_UP, Downloader.DownloadStatus.QUERYING_DHT);
                    break;
                }
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.GAVE_UP);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }

        public void lookupPending(RequeryManager.QueryType queryType, int length) {
            switch (queryType) {
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.WAITING_FOR_CONNECTIONS, length);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }

        public void lookupStarted(RequeryManager.QueryType queryType, long length) {
            switch (queryType) {
                case DHT: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.QUERYING_DHT, length);
                    break;
                }
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS, length);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }
    }
}

