/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SocketProcessor;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.downloader.PushedSocketHandler;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.util.MultiShutdownable;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.collection.IntWrapper;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.Connectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.AbstractChannelInterestReader;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.rudp.UDPSelectorProvider;
import org.limewire.util.Base32;
import org.limewire.util.BufferUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushDownloadManager
implements ConnectionAcceptor,
PushedSocketHandlerRegistry {
    private static final Log LOG = LogFactory.getLog(PushDownloadManager.class);
    private static long UDP_PUSH_FAILTIME = 5000L;
    private final ExecutorService PUSH_THREAD_POOL = ExecutorsHelper.newFixedSizeThreadPool(10, "PushProxy Requests");
    private final Map<byte[], IntWrapper> UDP_FAILOVER = new TreeMap<byte[], IntWrapper>(new GUID.GUIDByteComparator());
    private final Provider<SocketProcessor> socketProcessor;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final ScheduledExecutorService backgroundExecutor;
    private final NetworkManager networkManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<IPFilter> ipFilter;
    private final Provider<UDPService> udpService;
    private final CopyOnWriteArrayList<PushedSocketHandler> pushHandlers = new CopyOnWriteArrayList();
    private final Provider<UDPSelectorProvider> udpSelectorProvider;

    @Inject
    public PushDownloadManager(Provider<MessageRouter> router, Provider<HttpExecutor> executor, @Named(value="defaults") Provider<HttpParams> defaultParams, @Named(value="backgroundExecutor") ScheduledExecutorService scheduler, Provider<SocketProcessor> processor, NetworkManager networkManager, Provider<IPFilter> ipFilter, Provider<UDPService> udpService, Provider<UDPSelectorProvider> udpSelectorProvider) {
        this.messageRouter = router;
        this.httpExecutor = executor;
        this.defaultParams = defaultParams;
        this.backgroundExecutor = scheduler;
        this.socketProcessor = processor;
        this.networkManager = networkManager;
        this.ipFilter = ipFilter;
        this.udpService = udpService;
        this.udpSelectorProvider = udpSelectorProvider;
    }

    @Override
    public void register(PushedSocketHandler handler) {
        this.pushHandlers.add(handler);
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public void acceptConnection(String word, Socket socket) {
        ((NIOMultiplexor)((Object)socket)).setReadObserver(new GivParser(socket));
    }

    public void sendPush(RemoteFileDesc file) {
        this.sendPush(file, new NullMultiShutdownable());
    }

    public void sendPush(RemoteFileDesc file, MultiShutdownable observer) {
        byte[] addr = this.networkManager.getAddress();
        int port = this.networkManager.getPort();
        if (!NetworkUtils.isValidAddress(addr) || !NetworkUtils.isValidPort(port)) {
            if (observer != null) {
                observer.shutdown();
            }
            return;
        }
        byte[] guid = GUID.makeGuid();
        if (this.sendPushMulticast(file, guid)) {
            return;
        }
        if (!this.networkManager.acceptedIncomingConnection()) {
            if (this.networkManager.canDoFWT()) {
                this.sendPushTCP(file, guid, observer);
            } else if (observer != null) {
                observer.shutdown();
            }
            return;
        }
        if (!file.isFromAlternateLocation()) {
            this.addUDPFailover(file);
            this.backgroundExecutor.schedule(new PushFailoverRequestor(file, guid, observer), UDP_PUSH_FAILTIME, TimeUnit.MILLISECONDS);
        }
        this.sendPushUDP(file, guid);
    }

    private boolean sendPushMulticast(RemoteFileDesc file, byte[] guid) {
        if (file.isReplyToMulticast()) {
            byte[] addr = this.networkManager.getNonForcedAddress();
            int port = this.networkManager.getNonForcedPort();
            if (NetworkUtils.isValidAddress(addr) && NetworkUtils.isValidPort(port)) {
                PushRequestImpl pr = new PushRequestImpl(guid, 1, file.getClientGUID(), file.getIndex(), addr, port, Message.Network.MULTICAST, SSLSettings.isIncomingTLSEnabled());
                this.messageRouter.get().sendMulticastPushRequest(pr);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Sending push request through multicast " + pr);
                }
                return true;
            }
        }
        return false;
    }

    private boolean sendPushUDP(RemoteFileDesc file, byte[] guid) {
        PushRequestImpl pr = new PushRequestImpl(guid, 2, file.getClientGUID(), file.getIndex(), this.networkManager.getAddress(), this.networkManager.getPort(), Message.Network.UDP, SSLSettings.isIncomingTLSEnabled());
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through udp " + pr);
        }
        UDPService udpService = this.udpService.get();
        try {
            InetAddress address = InetAddress.getByName(file.getHost());
            if (NetworkUtils.isValidAddress(address) && NetworkUtils.isValidPort(file.getPort())) {
                udpService.send(pr, address, file.getPort());
            }
        }
        catch (UnknownHostException notCritical) {
            // empty catch block
        }
        for (IpPort ipPort : file.getPushProxies()) {
            if (!this.ipFilter.get().allow(ipPort.getAddress())) continue;
            udpService.send((Message)pr, ipPort.getInetSocketAddress());
        }
        return true;
    }

    private void sendPushTCP(RemoteFileDesc file, byte[] guid, MultiShutdownable observer) {
        boolean shouldDoFWTransfer = file.supportsFWTransfer() && this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection();
        PushData data = new PushData(observer, file, guid, shouldDoFWTransfer);
        Set<? extends IpPort> proxies = file.getPushProxies();
        if (proxies.isEmpty()) {
            this.sendPushThroughNetwork(data);
            return;
        }
        this.sendPushThroughProxies(data, proxies);
    }

    private void sendPushThroughNetwork(PushData data) {
        int port;
        data.getMultiShutdownable().addShutdownable(null);
        if (data.isFWTransfer() && !this.networkManager.acceptedIncomingConnection()) {
            data.getMultiShutdownable().shutdown();
            return;
        }
        byte[] addr = this.networkManager.getAddress();
        if (!NetworkUtils.isValidAddressAndPort(addr, port = this.networkManager.getPort())) {
            data.getMultiShutdownable().shutdown();
            return;
        }
        PushRequestImpl pr = new PushRequestImpl(data.getGuid(), ConnectionSettings.TTL.getValue(), data.getFile().getClientGUID(), data.getFile().getIndex(), addr, port, Message.Network.TCP, SSLSettings.isIncomingTLSEnabled());
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending push request through Gnutella: " + pr);
        }
        try {
            this.messageRouter.get().sendPushRequest(pr);
        }
        catch (IOException e) {
            data.getMultiShutdownable().shutdown();
        }
    }

    private void sendPushThroughProxies(PushData data, Set<? extends IpPort> proxies) {
        byte[] externalAddr = this.networkManager.getExternalAddress();
        if (data.isFWTransfer() && !NetworkUtils.isValidAddress(externalAddr)) {
            data.getMultiShutdownable().shutdown();
            return;
        }
        byte[] addr = this.networkManager.getAddress();
        int port = this.networkManager.getPort();
        String request = "/gnutella/push-proxy?ServerID=" + Base32.encode(data.getFile().getClientGUID()) + (data.isFWTransfer() ? "&file=2147483645" : "") + (SSLSettings.isIncomingTLSEnabled() ? "&tls=true" : "");
        String nodeString = "X-Node";
        String nodeValue = NetworkUtils.ip2string(data.isFWTransfer() ? externalAddr : addr) + ":" + port;
        ArrayList<HttpHead> methods = new ArrayList<HttpHead>();
        for (IpPort ipPort : proxies) {
            if (!this.ipFilter.get().allow(ipPort.getAddress())) continue;
            String protocol = "http://";
            if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                protocol = "tls://";
            }
            String connectTo = protocol + ipPort.getAddress() + ":" + ipPort.getPort() + request;
            HttpHead head = null;
            try {
                head = new HttpHead(connectTo);
                head.addHeader("X-Node", nodeValue);
                head.addHeader("Cache-Control", "no-cache");
                methods.add(head);
            }
            catch (URISyntaxException e) {
                LOG.error(e);
            }
        }
        if (!methods.isEmpty()) {
            PushHttpClientListener l = new PushHttpClientListener(methods, data);
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout(basicHttpParams, 5000);
            HttpConnectionParams.setSoTimeout(basicHttpParams, 5000);
            DefaultedHttpParams defaultedHttpParams = new DefaultedHttpParams(basicHttpParams, this.defaultParams.get());
            Shutdownable s = this.httpExecutor.get().executeAny(l, this.PUSH_THREAD_POOL, methods, defaultedHttpParams, data.getMultiShutdownable());
            data.getMultiShutdownable().addShutdownable(s);
        } else {
            this.sendPushThroughNetwork(data);
        }
    }

    void handleGIV(Socket socket, GIVLine line) {
        String file = line.file;
        int index = 0;
        byte[] clientGUID = line.clientGUID;
        this.cancelUDPFailover(clientGUID);
        boolean accepted = false;
        for (PushedSocketHandler handler : this.pushHandlers) {
            if (!handler.acceptPushedSocket(file, index, clientGUID, socket)) continue;
            accepted = true;
            break;
        }
        if (!accepted) {
            IOUtils.close(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUDPFailover(RemoteFileDesc file) {
        Map<byte[], IntWrapper> map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] key = file.getClientGUID();
            IntWrapper requests = this.UDP_FAILOVER.get(key);
            if (requests == null) {
                requests = new IntWrapper(0);
                this.UDP_FAILOVER.put(key, requests);
            }
            requests.addInt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUDPFailover(byte[] clientGUID) {
        Map<byte[], IntWrapper> map = this.UDP_FAILOVER;
        synchronized (map) {
            byte[] key = clientGUID;
            IntWrapper requests = this.UDP_FAILOVER.get(key);
            if (requests != null) {
                requests.addInt(-1);
                if (requests.getInt() <= 0) {
                    this.UDP_FAILOVER.remove(key);
                }
            }
        }
    }

    private static class NullMultiShutdownable
    implements MultiShutdownable {
        private NullMultiShutdownable() {
        }

        public void shutdown() {
        }

        public void addShutdownable(Shutdownable newCancel) {
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static class FWTConnectObserver
    implements ConnectObserver {
        private final SocketProcessor processor;

        FWTConnectObserver(SocketProcessor processor) {
            this.processor = processor;
        }

        public void handleIOException(IOException iox) {
        }

        public void handleConnect(Socket socket) throws IOException {
            this.processor.processSocket(socket, "GIV");
        }

        public void shutdown() {
        }
    }

    static final class GIVLine {
        final String file;
        final int index;
        final byte[] clientGUID;

        GIVLine(String file, int index, byte[] clientGUID) {
            this.file = file;
            this.index = index;
            this.clientGUID = clientGUID;
        }
    }

    private class GivParser
    extends AbstractChannelInterestReader {
        private final Socket socket;
        private final StringBuilder givSB;
        private final StringBuilder blankSB;
        private boolean readBlank;
        private GIVLine giv;

        GivParser(Socket socket) {
            super(1024);
            this.givSB = new StringBuilder();
            this.blankSB = new StringBuilder();
            this.socket = socket;
        }

        public void handleRead() throws IOException {
            block6: {
                do {
                    int read = 0;
                    while (this.buffer.hasRemaining() && (read = this.source.read(this.buffer)) > 0) {
                    }
                    if (this.buffer.position() == 0) {
                        if (read != -1) break block6;
                        this.close();
                        break block6;
                    }
                    this.buffer.flip();
                    if (this.giv == null && BufferUtils.readLine(this.buffer, this.givSB)) {
                        this.giv = this.parseLine(this.givSB.toString());
                    }
                    if (this.giv != null && !this.readBlank) {
                        this.readBlank = BufferUtils.readLine(this.buffer, this.blankSB);
                        if (this.blankSB.length() > 0) {
                            throw new IOException("didn't read blank line");
                        }
                    }
                    this.buffer.compact();
                } while (!this.readBlank);
                PushDownloadManager.this.handleGIV(this.socket, this.giv);
            }
        }

        private GIVLine parseLine(String command) throws IOException {
            try {
                int i = command.indexOf(":");
                int index = Integer.parseInt(command.substring(0, i));
                int j = command.indexOf("/", i);
                byte[] guid = GUID.fromHexString(command.substring(i + 1, j));
                String filename = URLDecoder.decode(command.substring(j + 1));
                return new GIVLine(filename, index, guid);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException();
            }
            catch (NumberFormatException e) {
                throw new IOException();
            }
            catch (IllegalArgumentException e) {
                throw new IOException();
            }
        }
    }

    private class PushFailoverRequestor
    implements Runnable {
        final RemoteFileDesc _file;
        final byte[] _guid;
        final MultiShutdownable connector;

        public PushFailoverRequestor(RemoteFileDesc file, byte[] guid, MultiShutdownable connector) {
            this._file = file;
            this._guid = guid;
            this.connector = connector;
        }

        public void run() {
            if (this.shouldProceed()) {
                PushDownloadManager.this.sendPushTCP(this._file, this._guid, this.connector);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean shouldProceed() {
            byte[] key = this._file.getClientGUID();
            Map map = PushDownloadManager.this.UDP_FAILOVER;
            synchronized (map) {
                IntWrapper requests = (IntWrapper)PushDownloadManager.this.UDP_FAILOVER.get(key);
                if (requests != null && requests.getInt() > 0) {
                    requests.addInt(-1);
                    if (requests.getInt() == 0) {
                        PushDownloadManager.this.UDP_FAILOVER.remove(key);
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private class PushData {
        private final MultiShutdownable observer;
        private final RemoteFileDesc file;
        private final byte[] guid;
        private final boolean shouldDoFWTransfer;

        PushData(MultiShutdownable observer, RemoteFileDesc file, byte[] guid, boolean shouldDoFWTransfer) {
            this.observer = observer;
            this.file = file;
            this.guid = guid;
            this.shouldDoFWTransfer = shouldDoFWTransfer;
        }

        public RemoteFileDesc getFile() {
            return this.file;
        }

        public byte[] getGuid() {
            return this.guid;
        }

        public MultiShutdownable getMultiShutdownable() {
            return this.observer;
        }

        public boolean isFWTransfer() {
            return this.shouldDoFWTransfer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PushHttpClientListener
    implements HttpClientListener {
        private final Collection<HttpUriRequest> methods;
        private final PushData data;

        PushHttpClientListener(Collection<? extends HttpUriRequest> methods, PushData data) {
            this.methods = new LinkedList<HttpUriRequest>(methods);
            this.data = data;
        }

        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            LOG.warn("PushProxy request exception", exc);
            ((HttpExecutor)PushDownloadManager.this.httpExecutor.get()).releaseResources(response);
            this.methods.remove(request);
            if (this.methods.isEmpty()) {
                PushDownloadManager.this.sendPushThroughNetwork(this.data);
            }
            return true;
        }

        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            this.methods.remove(request);
            int statusCode = response.getStatusLine().getStatusCode();
            ((HttpExecutor)PushDownloadManager.this.httpExecutor.get()).releaseResources(response);
            if (statusCode == 202) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Succesful push proxy: " + request);
                }
                if (this.data.isFWTransfer()) {
                    AbstractNBSocket socket = ((UDPSelectorProvider)PushDownloadManager.this.udpSelectorProvider.get()).openSocketChannel().socket();
                    this.data.getMultiShutdownable().addShutdownable(socket);
                    socket.connect(this.data.getFile().getInetSocketAddress(), 20000, new FWTConnectObserver((SocketProcessor)PushDownloadManager.this.socketProcessor.get()));
                }
                return false;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid push proxy: " + request + ", response: " + response.getStatusLine().getStatusCode());
            }
            if (this.methods.isEmpty()) {
                PushDownloadManager.this.sendPushThroughNetwork(this.data);
            }
            return true;
        }
    }
}

