/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.PushDetails;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkInstanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushList {
    private static final Log LOG = LogFactory.getLog(PushList.class);
    private final TreeMap<byte[], List<Push>> pushers = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public PushList(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPushHost(PushDetails details, HTTPConnectObserver observer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding observer for details: " + details);
        }
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] clientGUID = details.getClientGUID();
            List<Push> perGUID = this.pushers.get(clientGUID);
            if (perGUID == null) {
                perGUID = new LinkedList<Push>();
                this.pushers.put(clientGUID, perGUID);
            }
            perGUID.add(new Push(details, observer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getExactHostFor(PushDetails details) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving exact match for details: " + details);
        }
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] clientGUID = details.getClientGUID();
            List<Push> perGUID = this.pushers.get(clientGUID);
            if (perGUID == null) {
                LOG.debug("No pushes waiting on those exact details.");
                return null;
            }
            Push best = this.getExactHost(perGUID, details);
            if (perGUID.isEmpty()) {
                this.pushers.remove(clientGUID);
            }
            if (best != null) {
                return best.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getHostFor(byte[] clientGUID, String address) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving best match for address: " + address + ", guid: " + new GUID(clientGUID));
        }
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            List<Push> perGUID = this.pushers.get(clientGUID);
            if (perGUID == null) {
                LOG.debug("No pushes waiting on that GUID.");
                return null;
            }
            Push best = this.getBestHost(perGUID, address);
            if (perGUID.isEmpty()) {
                this.pushers.remove(clientGUID);
            }
            if (best != null) {
                return best.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HTTPConnectObserver> getAllAndClear() {
        LinkedList<HTTPConnectObserver> allConnectors = new LinkedList<HTTPConnectObserver>();
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            for (List<Push> list : this.pushers.values()) {
                if (list == null) continue;
                for (Push next : list) {
                    allConnectors.add(next.observer);
                }
            }
            this.pushers.clear();
        }
        return allConnectors;
    }

    private Push getBestHost(List<? extends Push> hosts, String address) {
        Push next;
        if (hosts.isEmpty()) {
            return null;
        }
        Iterator<? extends Push> i = hosts.iterator();
        while (i.hasNext()) {
            next = i.next();
            if (!next.details.getAddress().equals(address)) continue;
            LOG.debug("Found an exact match!");
            i.remove();
            return next;
        }
        LOG.debug("No exact match, using first private|bogus address.");
        i = hosts.iterator();
        while (i.hasNext()) {
            next = i.next();
            if (!this.networkInstanceUtils.isPrivateAddress(next.details.getAddress()) && !next.details.getAddress().equals("1.1.1.1")) continue;
            i.remove();
            return next;
        }
        LOG.debug("No private address to use!");
        return null;
    }

    private Push getExactHost(List<? extends Push> hosts, PushDetails details) {
        if (hosts.isEmpty()) {
            return null;
        }
        Iterator<? extends Push> i = hosts.iterator();
        while (i.hasNext()) {
            Push next = i.next();
            if (!next.details.equals(details)) continue;
            i.remove();
            return next;
        }
        LOG.debug("No exact match!");
        return null;
    }

    private static class Push {
        private final PushDetails details;
        private final HTTPConnectObserver observer;

        Push(PushDetails details, HTTPConnectObserver observer) {
            this.details = details;
            this.observer = observer;
        }
    }
}

