/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RemoteFileDescImpl;
import com.limegroup.gnutella.downloader.UrlRemoteFileDescImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.http.URIUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.limewire.http.LimeHttpClient;
import org.limewire.io.Connectable;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class RemoteFileDescFactoryImpl
implements RemoteFileDescFactory {
    private static final int COPY_INDEX = Integer.MAX_VALUE;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final PushEndpointFactory pushEndpointFactory;
    private final Provider<LimeHttpClient> httpClientProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public RemoteFileDescFactoryImpl(LimeXMLDocumentFactory limeXMLDocumentFactory, PushEndpointFactory pushEndpointFactory, Provider<LimeHttpClient> httpClientProvider, NetworkInstanceUtils networkInstanceUtils) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.pushEndpointFactory = pushEndpointFactory;
        this.httpClientProvider = httpClientProvider;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(RemoteFileDesc rfd, IpPort ep) {
        return this.createRemoteFileDesc(ep.getAddress(), ep.getPort(), Integer.MAX_VALUE, rfd.getFileName(), rfd.getSize(), rfd.getClientGUID(), 0, false, 2, false, rfd.getXMLDocument(), rfd.getUrns(), false, false, "ALT", IpPort.EMPTY_SET, rfd.getCreationTime(), 0, null, ep instanceof Connectable ? ((Connectable)ep).isTLSCapable() : false);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(RemoteFileDesc rfd, PushEndpoint pe) {
        return this.createRemoteFileDesc(pe.getAddress(), pe.getPort(), Integer.MAX_VALUE, rfd.getFileName(), rfd.getSize(), DataUtils.EMPTY_GUID, rfd.getSpeed(), false, rfd.getQuality(), false, rfd.getXMLDocument(), rfd.getUrns(), false, true, "ALT", null, rfd.getCreationTime(), 0, pe, false);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, Set<? extends IpPort> proxies, long createTime, boolean tlsCapable) {
        return this.createRemoteFileDesc(host, port, index, filename, size, clientGUID, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, proxies, createTime, 0, null, tlsCapable);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, Set<? extends IpPort> proxies, long createTime, int FWTVersion, boolean tlsCapable) {
        return this.createRemoteFileDesc(host, port, index, filename, size, clientGUID, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, proxies, createTime, FWTVersion, null, tlsCapable);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, long createTime, PushEndpoint pe) {
        return this.createRemoteFileDesc(host, port, index, filename, size, null, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, null, createTime, 0, pe, false);
    }

    private RemoteFileDesc createRemoteFileDesc(String host, int port, long index, String filename, long size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, Set<? extends IpPort> proxies, long createTime, int FWTVersion, PushEndpoint pe, boolean tlsCapable) {
        if (firewalled) {
            if (pe == null) {
                try {
                    pe = this.pushEndpointFactory.createPushEndpoint(clientGUID, proxies, (byte)0, FWTVersion, new IpPortImpl(host, port));
                }
                catch (UnknownHostException uhe) {
                    throw new IllegalArgumentException(uhe);
                }
            }
            clientGUID = pe.getClientGUID();
        } else assert (pe == null);
        if (urns == null) {
            urns = Collections.emptySet();
        }
        boolean http11 = !urns.isEmpty();
        return new RemoteFileDescImpl(host, port, index, filename, size, clientGUID, speed, chat, quality, browseHost, xmlDoc, urns, replyToMulticast, firewalled, vendor, proxies, createTime, FWTVersion, pe, tlsCapable, http11, this.networkInstanceUtils);
    }

    @Override
    public RemoteFileDesc createUrlRemoteFileDesc(String host, int port, String filename, long size, Set<? extends URN> urns, URL url) {
        return new UrlRemoteFileDescImpl(host, port, filename, size, urns, url, this.networkInstanceUtils);
    }

    @Override
    public RemoteFileDesc createUrlRemoteFileDesc(URL url, String filename, URN urn, long size) throws IOException, URISyntaxException, HttpException, InterruptedException {
        int port = url.getPort();
        if (port < 0) {
            port = 80;
        }
        UrnSet urns = new UrnSet();
        if (urn != null) {
            urns.add(urn);
        }
        URI uri = URIUtils.toURI(url.toExternalForm());
        return this.createUrlRemoteFileDesc(url.getHost(), port, filename != null ? filename : MagnetOptions.extractFileName(uri), size <= 0L ? this.contentLength(uri) : size, urns, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long contentLength(URI uri) throws HttpException, IOException, InterruptedException {
        HttpHead head = new HttpHead(uri);
        head.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        HttpResponse response = null;
        LimeHttpClient client = this.httpClientProvider.get();
        try {
            response = client.execute(head);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Got " + response.getStatusLine().getStatusCode() + " instead of 200 for URL: " + uri);
            }
            long length = -1L;
            if (response.getEntity() != null) {
                length = response.getEntity().getContentLength();
            }
            if (length < 0L) {
                throw new IOException("No content length");
            }
            long l = length;
            return l;
        }
        finally {
            client.releaseConnection(response);
        }
    }

    @Override
    public RemoteFileDesc createFromMemento(RemoteHostMemento remoteHostMemento) throws InvalidDataException {
        if (remoteHostMemento.getCustomUrl() != null) {
            return this.createUrlRemoteFileDesc(remoteHostMemento.getHost(), remoteHostMemento.getPort(), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getUrns(), remoteHostMemento.getCustomUrl());
        }
        try {
            return this.createRemoteFileDesc(remoteHostMemento.getHost(), remoteHostMemento.getPort(), remoteHostMemento.getIndex(), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getClientGuid(), remoteHostMemento.getSpeed(), remoteHostMemento.isChat(), remoteHostMemento.getQuality(), remoteHostMemento.isBrowseHost(), this.xml(remoteHostMemento.getXml()), remoteHostMemento.getUrns(), remoteHostMemento.isReplyToMulticast(), remoteHostMemento.isFirewalled(), remoteHostMemento.getVendor(), IpPort.EMPTY_SET, -1L, -1, this.pe(remoteHostMemento.getPushAddr()), remoteHostMemento.isTls());
        }
        catch (SAXException e) {
            throw new InvalidDataException(e);
        }
        catch (SchemaNotFoundException e) {
            throw new InvalidDataException(e);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
    }

    private PushEndpoint pe(String pushAddr) throws IOException {
        if (pushAddr != null) {
            return this.pushEndpointFactory.createPushEndpoint(pushAddr);
        }
        return null;
    }

    private LimeXMLDocument xml(String xml) throws SAXException, SchemaNotFoundException, IOException {
        if (xml != null) {
            return this.limeXMLDocumentFactory.createLimeXMLDocument(xml);
        }
        return null;
    }
}

