/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.util.Objects;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.UrlRemoteFileDescImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteFileDescImpl
implements RemoteFileDesc {
    private static final Log LOG = LogFactory.getLog(RemoteFileDesc.class);
    private final String _host;
    private final int _port;
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final int _speed;
    private final boolean _chatEnabled;
    private final int _quality;
    private final boolean _replyToMulticast;
    private final LimeXMLDocument _xmlDoc;
    private final Set<URN> _urns;
    private final boolean _browseHostEnabled;
    private final boolean _firewalled;
    private final String _vendor;
    private boolean _http11;
    private boolean _tlsCapable;
    private final PushEndpoint _pushAddr;
    private IntervalSet _availableRanges = null;
    private int _queueStatus = Integer.MAX_VALUE;
    private int _failedCount = 0;
    private volatile long _earliestRetryTime = 0L;
    private int _hashCode = 0;
    private boolean _THEXFailed = false;
    private RemoteHostData _hostData = null;
    private volatile boolean _isDownloading = false;
    private final long _creationTime;
    private volatile boolean _serializeProxies = false;
    private float _spamRating = 0.0f;
    private int _secureStatus = 0;
    private final long _size;
    private final NetworkInstanceUtils networkInstanceUtils;

    RemoteFileDescImpl(String host, int port, long index, String filename, long size, byte[] clientGUID, int speed, boolean chat, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, boolean firewalled, String vendor, Set<? extends IpPort> proxies, long createTime, int FWTVersion, PushEndpoint pe, boolean tlsCapable, boolean http11, NetworkInstanceUtils networkInstanceUtils) {
        Objects.nonNull(filename, "filename");
        Objects.nonNull(host, "host");
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (((long)speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (filename.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (size < 0L || size > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        this._speed = speed;
        this._host = host;
        this._port = port;
        this._index = index;
        this._filename = filename;
        this._size = size;
        this._firewalled = firewalled;
        this._pushAddr = pe;
        this._clientGUID = clientGUID;
        this._chatEnabled = chat;
        this._quality = quality;
        this._browseHostEnabled = browseHost;
        this._replyToMulticast = replyToMulticast;
        this._vendor = vendor;
        this._creationTime = createTime;
        this._tlsCapable = tlsCapable;
        this._xmlDoc = xmlDoc;
        this._http11 = http11;
        this._urns = Collections.unmodifiableSet(urns);
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public void setSerializeProxies() {
        this._serializeProxies = true;
    }

    @Override
    public boolean isTLSCapable() {
        return this._tlsCapable;
    }

    @Override
    public void setTLSCapable(boolean tlsCapable) {
        this._tlsCapable = tlsCapable;
    }

    @Override
    public boolean isHTTP11() {
        return this._http11;
    }

    @Override
    public void setHTTP11(boolean http11) {
        this._http11 = http11;
    }

    @Override
    public boolean isPartialSource() {
        return this._availableRanges != null;
    }

    @Override
    public boolean isMe(byte[] myClientGUID) {
        return this.needsPush() ? Arrays.equals(this._clientGUID, myClientGUID) : this.networkInstanceUtils.isMe(this.getHost(), this.getPort());
    }

    @Override
    public IntervalSet getAvailableRanges() {
        return this._availableRanges.clone();
    }

    @Override
    public void setAvailableRanges(IntervalSet availableRanges) {
        this._availableRanges = availableRanges;
    }

    @Override
    public int getFailedCount() {
        return this._failedCount;
    }

    @Override
    public void incrementFailedCount() {
        ++this._failedCount;
    }

    @Override
    public void resetFailedCount() {
        this._failedCount = 0;
    }

    @Override
    public boolean isFromAlternateLocation() {
        return "ALT".equals(this._vendor);
    }

    @Override
    public boolean isBusy() {
        return this.isBusy(System.currentTimeMillis());
    }

    @Override
    public boolean isBusy(long now) {
        return now < this._earliestRetryTime;
    }

    @Override
    public int getWaitTime(long now) {
        return this.isBusy(now) ? (int)(this._earliestRetryTime - now) / 1000 + 1 : 0;
    }

    @Override
    public void setRetryAfter(int seconds) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting retry after to be [" + seconds + "] seconds for " + this);
        }
        this._earliestRetryTime = System.currentTimeMillis() + (long)(seconds * 1000);
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public boolean hasTHEXFailed() {
        return this._THEXFailed;
    }

    @Override
    public void setTHEXFailed() {
        this._THEXFailed = true;
    }

    @Override
    public void setDownloading(boolean dl) {
        this._isDownloading = dl;
    }

    @Override
    public boolean isDownloading() {
        return this._isDownloading;
    }

    @Override
    public final String getHost() {
        return this._host;
    }

    @Override
    public final int getPort() {
        return this._port;
    }

    @Override
    public final long getIndex() {
        return this._index;
    }

    @Override
    public final long getSize() {
        return this._size;
    }

    @Override
    public final long getFileSize() {
        return this._size;
    }

    @Override
    public final String getFileName() {
        return this._filename;
    }

    @Override
    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    @Override
    public final int getSpeed() {
        return this._speed;
    }

    @Override
    public final String getVendor() {
        return this._vendor;
    }

    @Override
    public final boolean isChatEnabled() {
        return this._chatEnabled;
    }

    @Override
    public final boolean isBrowseHostEnabled() {
        return this._browseHostEnabled;
    }

    @Override
    public final int getQuality() {
        return this._quality;
    }

    @Override
    public final LimeXMLDocument getXMLDocument() {
        return this._xmlDoc;
    }

    @Override
    public final Set<URN> getUrns() {
        return this._urns;
    }

    @Override
    public final URN getSHA1Urn() {
        for (URN urn : this._urns) {
            if (urn == null || !urn.isSHA1()) continue;
            return urn;
        }
        return null;
    }

    @Override
    public URL getUrl() {
        try {
            String fileName = "";
            URN urn = this.getSHA1Urn();
            fileName = urn == null ? "/get/" + this._index + "/" + this._filename : "/uri-res/N2R?" + urn.httpStringValue();
            return new URL("http", this._host, this._port, fileName);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    @Override
    public final boolean isPrivate() {
        return this.networkInstanceUtils.isPrivateAddress(this._host);
    }

    @Override
    public boolean isFirewalled() {
        return this._firewalled;
    }

    @Override
    public final Set<? extends IpPort> getPushProxies() {
        if (this._pushAddr != null) {
            return this._pushAddr.getProxies();
        }
        return Collections.emptySet();
    }

    @Override
    public final boolean supportsFWTransfer() {
        if (this._host.equals("1.1.1.1") || !NetworkUtils.isValidAddress(this._host) || this.networkInstanceUtils.isPrivateAddress(this._host)) {
            return false;
        }
        return this._pushAddr == null ? false : this._pushAddr.supportsFWTVersion() > 0;
    }

    @Override
    public final RemoteHostData getRemoteHostData() {
        if (this._hostData == null) {
            this._hostData = new RemoteHostData(this._host, this._port, this._clientGUID);
        }
        return this._hostData;
    }

    @Override
    public final boolean isAltLocCapable() {
        boolean ret;
        boolean bl = ret = this.getSHA1Urn() != null && !this._replyToMulticast;
        ret = this._firewalled ? ret && this._pushAddr != null && this._pushAddr.getProxies().size() > 0 : ret && NetworkUtils.isValidPort(this._port) && !this.networkInstanceUtils.isPrivateAddress(this._host) && NetworkUtils.isValidAddress(this._host);
        return ret;
    }

    @Override
    public boolean needsPush() {
        if (this.isReplyToMulticast()) {
            return true;
        }
        if (this.isPrivate()) {
            return !(this instanceof UrlRemoteFileDescImpl);
        }
        if (!NetworkUtils.isValidPort(this.getPort())) {
            return true;
        }
        return this.isFirewalled();
    }

    @Override
    public PushEndpoint getPushAddr() {
        return this._pushAddr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc other = (RemoteFileDesc)o;
        if (!this.nullEquals(this._host, other.getHost()) || this._port != other.getPort()) {
            return false;
        }
        if (this._size != other.getSize()) {
            return false;
        }
        if (this._clientGUID == null != (other.getClientGUID() == null)) {
            return false;
        }
        if (this._clientGUID != null && !Arrays.equals(this._clientGUID, other.getClientGUID())) {
            return false;
        }
        if (this._urns.isEmpty() && other.getUrns().isEmpty()) {
            return this.nullEquals(this._filename, other.getFileName());
        }
        return ((Object)this._urns).equals(other.getUrns());
    }

    private boolean nullEquals(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int result = 17;
            result = 37 * result + this._host.hashCode();
            result = 37 * result + this._port;
            result = (int)((long)(37 * result) + this._size);
            result = 37 * result + ((Object)this._urns).hashCode();
            if (this._clientGUID != null) {
                result = 37 * result + new GUID(this._clientGUID).hashCode();
            }
            this._hashCode = result;
        }
        return this._hashCode;
    }

    public String toString() {
        return "<" + this.getHost() + ":" + this.getPort() + ", " + this.getFileName().toLowerCase() + ">";
    }

    @Override
    public String getAddress() {
        return this.getHost();
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public void setQueueStatus(int status) {
        this._queueStatus = status;
    }

    @Override
    public int getQueueStatus() {
        return this._queueStatus;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        InetAddress addr = this.getInetAddress();
        if (addr != null) {
            return new InetSocketAddress(addr, this.getPort());
        }
        return null;
    }

    @Override
    public void setSpamRating(float rating) {
        this._spamRating = rating;
    }

    @Override
    public float getSpamRating() {
        return this._spamRating;
    }

    @Override
    public int getSecureStatus() {
        return this._secureStatus;
    }

    @Override
    public void setSecureStatus(int secureStatus) {
        this._secureStatus = secureStatus;
    }

    @Override
    public RemoteHostMemento toMemento() {
        return new RemoteHostMemento(this._host, this._port, this._filename, this._index, this._clientGUID, this._speed, this._size, this._chatEnabled, this._quality, this._replyToMulticast, this.xmlString(), this._urns, this._browseHostEnabled, this._firewalled, this._vendor, this._http11, this._tlsCapable, this.pushAddrString());
    }

    private String xmlString() {
        if (this._xmlDoc == null) {
            return null;
        }
        return this._xmlDoc.getXMLString();
    }

    private String pushAddrString() {
        if (this._serializeProxies && this._pushAddr != null) {
            return this._pushAddr.httpStringValue();
        }
        return null;
    }
}

