/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.serial.conversion.SerialDiskManagerData;
import com.limegroup.gnutella.downloader.serial.conversion.SerialOldURI;
import com.limegroup.gnutella.downloader.serial.conversion.SerialTorrentFileSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialBTMetaInfo
implements Serializable {
    private static final long serialVersionUID = -2693983731217045071L;
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.NO_FIELDS;
    private List<byte[]> hashes;
    private SerialTorrentFileSystem fileSystem;
    private byte[] infoHash;
    private URN infoHashURN;
    private SerialOldURI[] trackers;
    private SerialDiskManagerData diskManagerData;
    private int pieceLength;
    private boolean isPrivate;
    private float historicRatio;

    private void writeObject(ObjectOutputStream out) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object read = in.readObject();
        Map<SerialKeys, Serializable> toRead = GenericsUtils.scanForMap(read, SerialKeys.class, Serializable.class, GenericsUtils.ScanMode.EXCEPTION);
        this.hashes = GenericsUtils.scanForList(toRead.get((Object)SerialKeys.HASHES), byte[].class, GenericsUtils.ScanMode.EXCEPTION);
        Integer pieceLength = (Integer)toRead.get((Object)SerialKeys.PIECE_LENGTH);
        this.fileSystem = (SerialTorrentFileSystem)toRead.get((Object)SerialKeys.FILE_SYSTEM);
        this.infoHash = (byte[])toRead.get((Object)SerialKeys.INFO_HASH);
        this.infoHashURN = URN.createSHA1UrnFromBytes(this.infoHash);
        this.trackers = (SerialOldURI[])toRead.get((Object)SerialKeys.TRACKERS);
        Float ratio = (Float)toRead.get((Object)SerialKeys.RATIO);
        this.diskManagerData = (SerialDiskManagerData)toRead.get((Object)SerialKeys.FOLDER_DATA);
        this.historicRatio = ratio.floatValue();
        this.pieceLength = pieceLength;
        if (toRead.containsKey((Object)SerialKeys.PRIVATE)) {
            this.isPrivate = true;
        }
    }

    public List<byte[]> getHashes() {
        return this.hashes;
    }

    public SerialTorrentFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public byte[] getInfoHash() {
        return this.infoHash;
    }

    public URN getInfoHashURN() {
        return this.infoHashURN;
    }

    public URI[] getTrackers() throws URISyntaxException {
        URI[] uris = new URI[this.trackers.length];
        for (int i = 0; i < this.trackers.length; ++i) {
            uris[i] = this.trackers[i].toURI();
        }
        return uris;
    }

    public SerialDiskManagerData getDiskManagerData() {
        return this.diskManagerData;
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public float getHistoricRatio() {
        return this.historicRatio;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SerialKeys {
        HASHES,
        PIECE_LENGTH,
        FILE_SYSTEM,
        INFO_HASH,
        TRACKERS,
        RATIO,
        FOLDER_DATA,
        PRIVATE;

    }
}

