/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.filters.AbstractIPFilter;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.filters.IPList;
import com.limegroup.gnutella.filters.MultiIPList;
import com.limegroup.gnutella.settings.FilterSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.io.IP;
import org.limewire.util.CommonUtils;

@Singleton
public final class LocalIPFilter
extends AbstractIPFilter {
    private static final Log LOG = LogFactory.getLog(LocalIPFilter.class);
    private volatile IPList badHosts;
    private volatile IPList goodHosts;
    private final IPList hostilesTXTHosts = new IPList();
    private final IPFilter hostileNetworkFilter;
    private final ScheduledExecutorService ipLoader;
    private volatile boolean shouldLoadHostiles;
    private volatile long whitelistings;
    private volatile long blacklistings;
    private volatile long netblockings;
    private volatile long implicitings;

    @Inject
    public LocalIPFilter(@Named(value="hostileFilter") IPFilter hostileNetworkFilter, @Named(value="backgroundExecutor") ScheduledExecutorService ipLoader) {
        this.hostileNetworkFilter = hostileNetworkFilter;
        this.ipLoader = ipLoader;
        File hostiles = new File(CommonUtils.getUserSettingsDir(), "hostiles.txt");
        this.shouldLoadHostiles = hostiles.exists();
        hostileNetworkFilter.refreshHosts();
        this.refreshHosts();
    }

    public void refreshHosts() {
        this.refreshHosts(null);
    }

    public void refreshHosts(final IPFilter.IPFilterCallback callback) {
        Runnable load = new Runnable(){

            public void run() {
                LocalIPFilter.this.hostileNetworkFilter.refreshHosts();
                LocalIPFilter.this.refreshHostsImpl();
                if (callback != null) {
                    callback.ipFiltersLoaded();
                }
            }
        };
        if (!this.shouldLoadHostiles) {
            load.run();
        } else {
            this.ipLoader.execute(load);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshHostsImpl() {
        LOG.debug("refreshing hosts");
        IPList newBad = new IPList();
        String[] allHosts = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        for (int i = 0; i < allHosts.length; ++i) {
            newBad.add(allHosts[i]);
        }
        IPList newGood = new IPList();
        allHosts = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
        for (int i = 0; i < allHosts.length; ++i) {
            newGood.add(allHosts[i]);
        }
        if (this.shouldLoadHostiles) {
            this.shouldLoadHostiles = false;
            LOG.debug("loading hostiles");
            File hostiles = new File(CommonUtils.getUserSettingsDir(), "hostiles.txt");
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(hostiles));
                String read = null;
                while ((read = reader.readLine()) != null) {
                    this.hostilesTXTHosts.add(read);
                }
            }
            catch (IOException ignored) {
                try {
                    LOG.debug("iox loading hostiles", ignored);
                }
                catch (Throwable throwable) {
                    IOUtils.close(reader);
                    throw throwable;
                }
                IOUtils.close(reader);
            }
            IOUtils.close(reader);
        }
        this.badHosts = new MultiIPList(newBad, this.hostilesTXTHosts);
        this.goodHosts = newGood;
    }

    public boolean hasBlacklistedHosts() {
        return FilterSettings.USE_NETWORK_FILTER.getValue() && this.hostileNetworkFilter.hasBlacklistedHosts() || !this.badHosts.isEmpty();
    }

    public int logMinDistanceTo(IP ip) {
        int minDistance = this.badHosts.logMinDistanceTo(ip);
        if (FilterSettings.USE_NETWORK_FILTER.getValue()) {
            minDistance = Math.min(minDistance, this.hostileNetworkFilter.logMinDistanceTo(ip));
        }
        return minDistance;
    }

    protected boolean allowImpl(IP ip) {
        if (this.goodHosts.contains(ip)) {
            ++this.whitelistings;
            return true;
        }
        if (this.badHosts.contains(ip)) {
            ++this.blacklistings;
            return false;
        }
        if (FilterSettings.USE_NETWORK_FILTER.getValue() && !this.hostileNetworkFilter.allow(ip)) {
            ++this.netblockings;
            return false;
        }
        ++this.implicitings;
        return true;
    }

    @InspectableContainer
    private class IPFilterInspectable {
        @InspectionPoint(value="ip filter counts")
        private final Inspectable counts = new Inspectable(){

            public Object inspect() {
                HashMap<String, Long> ret = new HashMap<String, Long>();
                ret.put("white", LocalIPFilter.this.whitelistings);
                ret.put("block", LocalIPFilter.this.blacklistings);
                ret.put("netblock", LocalIPFilter.this.netblockings);
                ret.put("implicit", LocalIPFilter.this.implicitings);
                return ret;
            }
        };

        private IPFilterInspectable() {
        }
    }
}

