/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.ScrollingTextPane;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.limewire.util.OSUtils;
import org.limewire.util.VersionUtils;

final class AboutWindow {
    private final JDialog DIALOG;
    private final ScrollingTextPane SCROLLING_PANE;
    private final JCheckBox SCROLL_CHECK_BOX = new JCheckBox(I18n.tr("Automatically Scroll"));

    AboutWindow() {
        this.DIALOG = new JDialog(GUIMediator.getAppFrame());
        if (!OSUtils.isMacOSX()) {
            this.DIALOG.setModal(true);
        }
        this.DIALOG.setSize(new Dimension(450, 400));
        this.DIALOG.setResizable(false);
        this.DIALOG.setTitle(I18n.tr("About FrostWire"));
        this.DIALOG.setDefaultCloseOperation(2);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent we) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }

            public void windowClosing(WindowEvent we) {
                AboutWindow.this.SCROLLING_PANE.stopScroll();
            }
        });
        this.SCROLLING_PANE = this.createScrollingPane();
        this.SCROLLING_PANE.addHyperlinkListener(GUIUtils.getHyperlinkListener());
        JLabel client = new JLabel(I18n.tr("FrostWire") + " " + LimeWireUtils.getLimeWireVersion());
        client.setHorizontalAlignment(0);
        JLabel java = new JLabel("Java " + VersionUtils.getJavaVersion());
        java.setHorizontalAlignment(0);
        URLLabel url = new URLLabel("http://www.frostwire.com");
        url.setHorizontalAlignment(0);
        this.SCROLL_CHECK_BOX.setSelected(true);
        this.SCROLL_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                    AboutWindow.this.SCROLLING_PANE.startScroll();
                } else {
                    AboutWindow.this.SCROLLING_PANE.stopScroll();
                }
            }
        });
        JButton button = new JButton(I18n.tr("Close"));
        this.DIALOG.getRootPane().setDefaultButton(button);
        button.setToolTipText(I18n.tr("Close This Window"));
        button.addActionListener(GUIUtils.getDisposeAction());
        JComponent pane = (JComponent)this.DIALOG.getContentPane();
        GUIUtils.addHideAction(pane);
        pane.setLayout(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        LogoPanel logo = new LogoPanel();
        logo.setSearching(true);
        pane.add((Component)logo, gbc);
        gbc.gridy = 1;
        pane.add(Box.createVerticalStrut(6), gbc);
        gbc.fill = 2;
        gbc.gridy = 2;
        pane.add((Component)client, gbc);
        gbc.gridy = 3;
        pane.add((Component)java, gbc);
        gbc.gridy = 4;
        pane.add((Component)url, gbc);
        gbc.gridy = 5;
        pane.add(Box.createVerticalStrut(6), gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridy = 6;
        pane.add((Component)this.SCROLLING_PANE, gbc);
        gbc.gridy = 7;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        pane.add(Box.createVerticalStrut(6), gbc);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridy = 8;
        pane.add((Component)this.SCROLL_CHECK_BOX, gbc);
        gbc.gridwidth = 0;
        gbc.anchor = 13;
        pane.add((Component)button, gbc);
    }

    private ScrollingTextPane createScrollingPane() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        Color color = new JLabel().getForeground();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String hex = this.toHex(r) + this.toHex(g) + this.toHex(b);
        sb.append("<body text='#" + hex + "'>");
        sb.append(I18n.tr("<h1>FrostWire Developers</h1>"));
        sb.append("<ul><li>Angel '<strong>Gubatron</strong>' Leon<br>Venezuela - <a href='http://www.gubatron.com'>Gubatron.com</a></li>");
        sb.append("<li>Ian '<strong>the man</strong>' Walker<br>United States - <a href='http://www.myspace.com/BraceForTheRide'>MySpace.com/BraceForTheRide</a> </li>");
        sb.append("<li>Fernando '<strong>FTA</strong>' Toussaint<br>Venezuela - <a href='http://www.cybercultura.net'>CyberCultura.net</a></li>");
        sb.append("</ul><br><br>");
        sb.append(I18n.tr("<h1>FrostWire Logo Designer</h1>"));
        sb.append("<ul><li>Luis Ramirez (Venezuela - <a href='http://www.elblogo.com'>ElBlogo.com</a>)</li></ul>");
        sb.append(I18n.tr("<h1>FrostWire Graphics Designer</h1>"));
        sb.append("<ul><li>Shelby Allen - Splash 4.13 / Web (New Zealand - <a href='http://www.stitzu.com'>Stitzu.com</a>)</li></ul>");
        sb.append("<ul><li>Scott Kellum - Splash 4.17 (New York - <a href='http://www.scottkellum.net'>ScottKellum.net</a>)</li></ul>");
        sb.append("<ul><li>Cecko Hanssen - <a href='http://www.flickr.com/photos/cecko/95013472/'>Frozen Brothers</a> CC Photograph for 4.17 Splash (Tilburg, Netherlands)</li></ul>");
        sb.append(I18n.tr("<h1>Thanks to Former FrostWire Developers</h1>"));
        sb.append("<li>Gregorio Roper (Germany)</li>");
        sb.append("<br><br>");
        sb.append(I18n.tr("<h1>Thanks to the FrostWire Chat Community!</h1>"));
        sb.append(I18n.tr("Thanks to everybody that has helped us everyday in the forums and chatrooms, you not only help new users but you also warn the FrostWire team of any problem that occur on our networks. Thank you all, without you this wouldn't be possible!"));
        sb.append(I18n.tr("<br><br>In Special we give thanks to the Chatroom Operators and Forum Moderators"));
        sb.append("<ul>");
        sb.append(I18n.tr("<h1>FrostWire Chat Operators</h1>"));
        sb.append("<li>AlleyCat</li>");
        sb.append("<li>Calliope</li>");
        sb.append("<li>Casper</li>");
        sb.append("<li>Coelacanth</li>");
        sb.append("<li>Gollum</li>");
        sb.append("<li>Gummo</li>");
        sb.append("<li>Jewels</li>");
        sb.append("<li>Jordan</li>");
        sb.append("<li>Kaapeli</li>");
        sb.append("<li>Malachi</li>");
        sb.append("<li>Maya</li>");
        sb.append("<li>Sabladowah</li>");
        sb.append("<li>Sweet_Songbird</li>");
        sb.append("<li>THX1138</li>");
        sb.append("<li>UB4T</li>");
        sb.append("<li>jwb</li>");
        sb.append("<li>luna_moon</li>");
        sb.append("<li>nonproffessional</li>");
        sb.append("<li>spuggy</li>");
        sb.append("<li>stief</li>");
        sb.append("<li>sug</li>");
        sb.append("<li>the-jack</li>");
        sb.append("<li>wyrdjax</li>");
        sb.append("<li>yummy-brummy</li>");
        sb.append("</ul>");
        sb.append(I18n.tr("<h1>FrostWire Forum Moderators</h1>"));
        sb.append("<li>Only a Hobo (<em>The voice of the people</em>)</li>");
        sb.append("<li>cootmaster</li>");
        sb.append("<li>nonprofessional</li>");
        sb.append("<li>et voil&agrave;</li>");
        sb.append(I18n.tr("And also to the Support Volunteer Helpers:"));
        sb.append("<ul>");
        sb.append("<li>Only a Hobo</li>");
        sb.append("<li>Lelu</li>");
        sb.append("<li>dutchboy</li>");
        sb.append("<li>udsteve</li>");
        sb.append("</ul>");
        sb.append(I18n.tr("<h1>Thanks to the LimeWire Developer Team</h1>"));
        sb.append("<ul>\n  <li>Greg Bildson</li>\n  <li>Sam Berlin</li>\n  <li>Zlatin Balevsky</li>\n  <li>Felix Berger</li>\n  <li>Mike Everett</li>\n  <li>Kevin Faaborg</li>\n  <li>Jay Jeyaratnam</li>\n  <li>Curtis Jones</li>\n  <li>Tim Julien</li>\n  <li>Akshay Kumar</li>\n  <li>Jeff Palm</li>\n  <li>Mike Sorvillo</li>\n  <li>Dan Sullivan</li>\n</ul>");
        sb.append(I18n.tr("Several colleagues in the Gnutella community merit special thanks. These include:"));
        sb.append("<ul>\n  <li>Vincent Falco -- Free Peers, Inc.</li>\n  <li>Gordon Mohr -- Bitzi, Inc.</li>\n  <li>John Marshall -- Gnucleus</li>\n  <li>Jason Thomas -- Swapper</li>\n  <li>Brander Lien -- ToadNode</li>\n  <li>Angelo Sotira -- www.gnutella.com</li>\n  <li>Marc Molinaro -- www.gnutelliums.com</li>\n  <li>Simon Bellwood -- www.gnutella.co.uk</li>\n  <li>Serguei Osokine</li>\n  <li>Justin Chapweske</li>\n  <li>Mike Green</li>\n  <li>Raphael Manfredi</li>\n  <li>Tor Klingberg</li>\n  <li>Mickael Prinkey</li>\n  <li>Sean Ediger</li>\n  <li>Kath Whittle</li>\n</ul>");
        sb.append(I18n.tr("<h1>Thanks to the PJIRC Staff</h1>"));
        sb.append("<ul>");
        sb.append("<li>Plouf</li>");
        sb.append("<li>Jiquera</li>");
        sb.append("<li>Ezequiel</li>");
        sb.append("<li>Superchatbar.nl</li>");
        sb.append("<li>Thema</li>");
        sb.append("</ul>");
        sb.append(I18n.tr("<h1>Thanks to the Automatix Team</h1>"));
        sb.append("<p>For helping distribute Frostwire to opensource communities in a very simple manner.");
        sb.append("<ul>");
        sb.append("<li>Arnieboy</li>");
        sb.append("<li>JimmyJazz</li>");
        sb.append("<li>Mstlyevil</li>");
        sb.append("<li>WildTangent</li>");
        sb.append("</ul>");
        sb.append(I18n.tr("<h1>Thanks to Ubuntu/Kubuntu Teams</h1>"));
        sb.append(I18n.tr("<p>For making the world a better place with such an excellent distro, you'll be the ones to make a difference on the desktop.</p>"));
        sb.append(I18n.tr("<h1>Thanks to the NSIS Project</h1>"));
        sb.append(I18n.tr("<p>Thanks for such an awesome installer builder system and documentation.</p>"));
        sb.append(I18n.tr("<h1>Thanks to our families</h1>"));
        sb.append(I18n.tr("For being patient during our many sleepless nights"));
        sb.append("<small>");
        sb.append("<br><br>");
        sb.append(I18n.tr("BitTorrent, the BitTorrent Logo, and Torrent are trademarks of BitTorrent, Inc."));
        sb.append("</small>");
        sb.append("</body></html>");
        return new ScrollingTextPane(sb.toString());
    }

    private String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    void showDialog() {
        GUIUtils.centerOnScreen(this.DIALOG);
        if (this.SCROLL_CHECK_BOX.isSelected()) {
            ActionListener startTimerListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                        AboutWindow.this.SCROLLING_PANE.startScroll();
                    }
                }
            };
            Timer startTimer = new Timer(10000, startTimerListener);
            startTimer.setRepeats(false);
            startTimer.start();
        }
        this.DIALOG.setVisible(true);
    }
}

