/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import javax.swing.AbstractListModel;
import org.limewire.collection.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferListModel<T>
extends AbstractListModel {
    private Buffer<T> buffer;

    public BufferListModel(int size) {
        this.buffer = new Buffer(size);
    }

    @Override
    public T getElementAt(int idx) {
        return this.buffer.get(idx);
    }

    @Override
    public int getSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.getSize();
    }

    public void changeSize(int size) {
        if (size == 0) {
            int oldSize = 0;
            if (this.buffer != null) {
                oldSize = this.buffer.getSize();
            }
            this.buffer = null;
            this.fireContentsChanged(this, 0, oldSize);
            return;
        }
        Buffer<T> nbuffer = new Buffer<T>(size);
        for (int i = 0; this.buffer != null && i < Math.min(this.buffer.getSize(), size); ++i) {
            nbuffer.addFirst(this.buffer.get(i));
        }
        this.buffer = nbuffer;
    }

    public void removeAllElements() {
        if (this.buffer == null) {
            return;
        }
        this.buffer.clear();
        this.fireContentsChanged(this, 0, this.buffer.getCapacity());
    }

    public void addFirst(T val) {
        if (this.buffer == null) {
            return;
        }
        this.buffer.addFirst(val);
        this.fireContentsChanged(this, 0, this.buffer.getSize());
    }
}

