/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearableAutoCompleteTextField
extends AutoCompleteTextField {
    protected AutoCompleteList entryList;
    protected JPanel entryPanel;
    protected Popup popup;
    protected boolean showPending;

    public ClearableAutoCompleteTextField() {
        this.init();
    }

    public ClearableAutoCompleteTextField(Document a, String b, int c) {
        super(a, b, c);
        this.init();
    }

    public ClearableAutoCompleteTextField(int a) {
        super(a);
        this.init();
    }

    public ClearableAutoCompleteTextField(String a) {
        super(a);
        this.init();
    }

    public ClearableAutoCompleteTextField(String a, int b) {
        super(a, b);
        this.init();
    }

    private void init() {
        this.enableEvents(8L);
        this.enableEvents(32768L);
        this.enableEvents(4L);
    }

    @Override
    protected void fireActionPerformed() {
        if (this.popup != null) {
            String selection = (String)this.entryList.getSelectedValue();
            this.hidePopup();
            if (selection != null) {
                this.setText(selection);
                return;
            }
        }
        super.fireActionPerformed();
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40) {
            evt.consume();
        }
        super.processKeyEvent(evt);
        if (this.dict != null) {
            block0 : switch (evt.getID()) {
                case 401: {
                    switch (evt.getKeyCode()) {
                        case 38: {
                            if (this.popup != null) {
                                this.entryList.decrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 40: {
                            if (this.popup != null) {
                                this.entryList.incrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                        }
                    }
                    break;
                }
                case 400: {
                    switch (evt.getKeyChar()) {
                        case '\u001b': {
                            if (this.popup == null) break block0;
                            this.hidePopup();
                            this.selectAll();
                            break block0;
                        }
                        case '\n': {
                            break block0;
                        }
                    }
                    this.autoCompleteInput();
                }
            }
        }
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent evt) {
        super.processHierarchyEvent(evt);
        if ((evt.getChangeFlags() & 4L) == 4L) {
            boolean showing = this.isShowing();
            if (!showing && this.popup != null) {
                this.hidePopup();
            } else if (showing && this.popup == null && this.showPending) {
                this.autoCompleteInput();
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent evt) {
        super.processFocusEvent(evt);
        if (evt.getID() == 1005 && this.popup != null) {
            this.hidePopup();
        }
    }

    @Override
    protected void setUp() {
    }

    protected JComponent getPopupComponent() {
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        this.entryList = new AutoCompleteList();
        JScrollPane entryScrollPane = new JScrollPane(this.entryList);
        entryScrollPane.setVerticalScrollBarPolicy(20);
        entryScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)entryScrollPane, c);
        this.entryPanel.add((Component)new ClearHistory(), c);
        return this.entryPanel;
    }

    protected void showPopup(Iterator<String> iter) {
        this.getPopupComponent();
        boolean different = false;
        Vector<String> v = new Vector<String>();
        ListModel model = this.entryList.getModel();
        int i = 0;
        while (iter.hasNext()) {
            String next = iter.next();
            v.add(next);
            if (!different && i < model.getSize()) {
                different |= !next.equals(model.getElementAt(i));
            }
            ++i;
        }
        if (different |= model.getSize() != v.size()) {
            this.entryList.setListData(v);
            this.entryList.clearSelection();
        }
        this.entryList.setCurrentText(this.getText());
        this.showPopup();
    }

    public void showPopup() {
        if (this.popup == null && this.entryList.getModel().getSize() > 0) {
            if (this.isShowing()) {
                Point origin = this.getLocationOnScreen();
                PopupFactory pf = PopupFactory.getSharedInstance();
                JComponent parent = this;
                if (OSUtils.isMacOSX()) {
                    parent = new JPanel();
                    new MyPopup(this, parent, 0, 0);
                }
                this.popup = pf.getPopup(parent, this.getPopupComponent(), origin.x, origin.y + this.getHeight() + 1);
                this.showPending = false;
                this.popup.show();
            } else {
                this.showPending = true;
            }
        }
    }

    public void hidePopup() {
        this.showPending = false;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public void autoCompleteInput() {
        String input = this.getText();
        if (input != null && input.length() > 0) {
            Iterator<String> it = this.dict.iterator(input);
            if (it.hasNext()) {
                this.showPopup(it);
            } else {
                this.hidePopup();
            }
        } else {
            this.hidePopup();
        }
    }

    private static class MyPopup
    extends Popup {
        public MyPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
        }
    }

    private class AutoCompleteList
    extends JList {
        private String currentText;

        AutoCompleteList() {
            this.enableEvents(16L);
            this.setSelectionMode(0);
            this.setFocusable(false);
        }

        protected void processMouseEvent(MouseEvent me) {
            int idx;
            super.processMouseEvent(me);
            if (me.getID() == 500 && (idx = this.locationToIndex(me.getPoint())) != -1 && this.isSelectedIndex(idx)) {
                String selection = (String)this.getSelectedValue();
                ClearableAutoCompleteTextField.this.setText(selection);
                ClearableAutoCompleteTextField.this.hidePopup();
            }
        }

        void setCurrentText(String text) {
            this.currentText = text;
        }

        void incrementSelection() {
            if (this.getSelectedIndex() == this.getModel().getSize() - 1) {
                ClearableAutoCompleteTextField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex() + 1;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                ClearableAutoCompleteTextField.this.setText((String)this.getSelectedValue());
            }
        }

        void decrementSelection() {
            if (this.getSelectedIndex() == 0) {
                ClearableAutoCompleteTextField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex();
                selectedIndex = selectedIndex == -1 ? this.getModel().getSize() - 1 : --selectedIndex;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                ClearableAutoCompleteTextField.this.setText((String)this.getSelectedValue());
            }
        }

        public Dimension getPreferredScrollableViewportSize() {
            int width = ClearableAutoCompleteTextField.this.getSize().width - 2;
            int rows = Math.min(this.getModel().getSize(), 8);
            int height = rows * this.getCellBounds((int)0, (int)0).height;
            return new Dimension(width, height);
        }
    }

    private class ClearHistory
    extends JButton {
        ClearHistory() {
            super(I18n.tr("Clear History"));
            this.enableEvents(16L);
            this.setFocusable(false);
        }

        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (me.getID() == 500) {
                ClearableAutoCompleteTextField.this.dict.clear();
                ClearableAutoCompleteTextField.this.hidePopup();
            }
        }
    }
}

