/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ConsoleSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggerRepository;
import org.limewire.i18n.I18nMarker;
import org.limewire.mojito.MojitoDHT;
import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;

public class Console
extends JPanel
implements ThemeObserver {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;
    private final int idealSize = ConsoleSettings.CONSOLE_IDEAL_SIZE.getValue();
    private final int maxExcess = ConsoleSettings.CONSOLE_MAX_EXCESS.getValue();
    private JScrollPane scrollPane;
    private JTextArea output = new JTextArea();
    private JButton apply;
    private JButton clear;
    private JButton save;
    private JComboBox loggerComboBox;
    private JComboBox levelComboBox;
    private WholeNumberField delayTxt;
    private boolean scroll = true;
    private boolean altCtrlDown = false;
    private List<ConsoleListener> listeners = null;
    private int delay;
    private StringBuffer delayBuf;
    private Timer delayTimer;

    public Console() {
        this.output.setEditable(false);
        this.scrollPane = new JScrollPane(this.output);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (e.getValueIsAdjusting()) {
                    Console.this.scroll = false;
                } else {
                    Console.this.scroll = true;
                }
            }
        });
        this.loggerComboBox = new JComboBox(new LoggerComboBoxModel());
        this.levelComboBox = new JComboBox(new LevelComboBoxModel());
        this.loggerComboBox.setAutoscrolls(true);
        this.loggerComboBox.setMaximumRowCount(20);
        this.loggerComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Console.this.selectLoggerLevel();
            }
        });
        this.loggerComboBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                Console.this.refreshLoggers();
            }

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }
        });
        this.levelComboBox.setAutoscrolls(true);
        this.apply = new JButton(I18n.tr("Apply"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.applyLevel();
            }
        });
        this.clear = new JButton(I18n.tr("Clear"));
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.clear();
            }
        });
        this.save = new JButton(I18n.tr("Save"));
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.save();
            }
        });
        JLabel delayLabel = new JLabel(I18n.tr("Delay: "));
        delayLabel.setMinimumSize(new Dimension(50, 23));
        delayLabel.setHorizontalAlignment(4);
        this.delay = 0;
        this.delayBuf = new StringBuffer();
        this.delayTimer = null;
        this.delayTxt = new WholeNumberField(0, 3);
        this.delayTxt.setText("0");
        this.delayTxt.setHorizontalAlignment(4);
        this.delayTxt.setMinimumSize(new Dimension(50, 23));
        this.delayTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Console.this.setDelay();
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Console.this.altCtrlDown = e.isAltDown() && e.isControlDown();
            }

            public void keyReleased(KeyEvent e) {
                Console.this.altCtrlDown = false;
            }
        };
        this.addKeyListener(keyListener);
        this.scrollPane.addKeyListener(keyListener);
        this.output.addKeyListener(keyListener);
        this.loggerComboBox.addKeyListener(keyListener);
        this.levelComboBox.addKeyListener(keyListener);
        this.apply.addKeyListener(keyListener);
        this.clear.addKeyListener(keyListener);
        this.save.addKeyListener(keyListener);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Console.this.altCtrlDown = false;
            }
        });
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        controlsPanel.add((Component)this.loggerComboBox, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 2;
        controlsPanel.add((Component)this.levelComboBox, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        controlsPanel.add((Component)delayLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        controlsPanel.add((Component)this.delayTxt, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 2;
        controlsPanel.add((Component)this.apply, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        controlsPanel.add((Component)this.clear, gbc);
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        controlsPanel.add((Component)this.save, gbc);
        if (ConsoleSettings.SHOW_INPUT_FIELD.getValue()) {
            this.listeners = new ArrayList<ConsoleListener>();
            JTextField inputField = new JTextField();
            inputField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JTextField textField = (JTextField)evt.getSource();
                    String command = textField.getText().trim();
                    if (command.length() == 0) {
                        return;
                    }
                    textField.setText("");
                    try {
                        ConsoleWriter writer = new ConsoleWriter();
                        PrintWriter out = new PrintWriter(writer);
                        for (ConsoleListener l : Console.this.listeners) {
                            if (!l.handleCommand(command, out)) continue;
                            return;
                        }
                        Console.this.appendText("Unknown command: " + command + "\n");
                    }
                    catch (IOException err) {
                        Console.this.appendText(err.getMessage());
                    }
                }
            });
            this.addConsoleListener(new ConsoleListener(){

                public boolean handleCommand(final String command, final PrintWriter out) throws IOException {
                    Runnable task = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DHTManager manager = GuiCoreMediator.getDHTManager();
                                MojitoDHT dht = manager.getMojitoDHT();
                                if (dht == null) {
                                    out.println("Mojito is not running");
                                    return;
                                }
                                Class<?> cmdHandler = Class.forName("org.limewire.mojito.CommandHandler");
                                Method handle = cmdHandler.getMethod("handle", MojitoDHT.class, String.class, PrintWriter.class);
                                ((Boolean)handle.invoke(null, dht, command, out)).booleanValue();
                            }
                            catch (SecurityException e) {
                                e.printStackTrace(out);
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace(out);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace(out);
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace(out);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace(out);
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace(out);
                            }
                            finally {
                                out.flush();
                            }
                        }
                    };
                    new Thread(task).start();
                    return true;
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            controlsPanel.add((Component)inputField, gbc);
        }
        this.add("South", controlsPanel);
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
        this.refreshLoggers();
        this.attachLogs();
    }

    public void addConsoleListener(ConsoleListener l) {
        if (this.listeners != null && l != null) {
            this.listeners.add(l);
        }
    }

    private void attachLogs() {
        WriterAppender append = new WriterAppender((Layout)new PatternLayout(ConsoleSettings.CONSOLE_PATTERN_LAYOUT.getValue()), new ConsoleWriter());
        LogManager.getRootLogger().addAppender(append);
    }

    private void refreshLoggers() {
        LoggerRepository repository = LogManager.getLoggerRepository();
        Enumeration currentLoggers = repository.getCurrentLoggers();
        LoggerComboBoxModel loggerModel = (LoggerComboBoxModel)this.loggerComboBox.getModel();
        int loggerIndex = this.loggerComboBox.getSelectedIndex();
        LoggerNode currentLogger = loggerIndex >= 0 ? loggerModel.getLogger(loggerIndex) : null;
        ArrayList<PackageNode> pkgList = new ArrayList<PackageNode>();
        HashMap<String, PackageNode> pkgMap = new HashMap<String, PackageNode>();
        while (currentLoggers.hasMoreElements()) {
            Logger lggr = (Logger)currentLoggers.nextElement();
            String pkg = PackageNode.getPackage(lggr);
            PackageNode node = (PackageNode)pkgMap.get(pkg);
            if (node == null) {
                node = new PackageNode(pkg);
                pkgMap.put(pkg, node);
                pkgList.add(node);
            }
            node.add(lggr);
        }
        Collections.sort(pkgList, new Comparator<PackageNode>(){

            @Override
            public int compare(PackageNode o1, PackageNode o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        loggerIndex = -1;
        ArrayList<LoggerNode> nodes = new ArrayList<LoggerNode>();
        for (PackageNode pkgNode : pkgList) {
            pkgNode.sort();
            nodes.add(pkgNode);
            if (loggerIndex == -1 && pkgNode.equals(currentLogger)) {
                loggerIndex = nodes.size() - 1;
            }
            for (ClassNode classNode : pkgNode.getNodes()) {
                nodes.add(classNode);
                if (loggerIndex != -1 || !classNode.equals(currentLogger)) continue;
                loggerIndex = nodes.size() - 1;
            }
        }
        loggerModel.refreshLoggers(nodes);
        boolean empty = nodes.isEmpty();
        this.loggerComboBox.setEnabled(!empty);
        this.levelComboBox.setEnabled(!empty);
        this.apply.setEnabled(!empty);
        if (!empty) {
            this.loggerComboBox.setSelectedIndex(loggerIndex >= 0 ? loggerIndex : 0);
            this.selectLoggerLevel();
        }
    }

    private void selectLoggerLevel() {
        LoggerComboBoxModel loggerModel = (LoggerComboBoxModel)this.loggerComboBox.getModel();
        LevelComboBoxModel levelModel = (LevelComboBoxModel)this.levelComboBox.getModel();
        int loggerIndex = this.loggerComboBox.getSelectedIndex();
        if (loggerIndex < 0) {
            return;
        }
        Level level = Console.getLevel(loggerModel.getLogger(loggerIndex));
        levelModel.setSelectedItem(level);
    }

    private void applyLevel() {
        Level newLevel;
        this.setDelay();
        LoggerComboBoxModel loggerModel = (LoggerComboBoxModel)this.loggerComboBox.getModel();
        LevelComboBoxModel levelModel = (LevelComboBoxModel)this.levelComboBox.getModel();
        int loggerIndex = this.loggerComboBox.getSelectedIndex();
        if (loggerIndex < 0) {
            return;
        }
        LoggerNode logger = loggerModel.getLogger(loggerIndex);
        Level currentLevel = Console.getLevel(logger);
        int levelIndex = this.levelComboBox.getSelectedIndex();
        Level level = newLevel = levelIndex > 0 ? levelModel.getLevel(levelIndex) : null;
        if (!currentLevel.equals(newLevel)) {
            logger.setLevel(newLevel);
            this.loggerComboBox.setSelectedIndex(loggerIndex);
            loggerModel.updateIndex(loggerIndex);
        }
    }

    public void appendText(String text) {
        if (!this.output.isEnabled()) {
            return;
        }
        if (0 != this.delay) {
            this.delayBuf.append(text);
            return;
        }
        this.invokeLaterConsoleAppend(text);
    }

    public void clear() {
        this.output.setText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.output.setEnabled(this.altCtrlDown);
            String log = this.output.getText().trim();
            String traces = CommonUtils.getAllStackTraces();
            if (log.length() == 0 && traces.length() == 0) {
                return;
            }
            if (this.altCtrlDown) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("-- BEGIN STACK TRACES --\n");
                buffer.append(traces.length() > 0 ? traces : "NONE");
                buffer.append("\n-- END STACK TRACES --\n");
                this.appendText(buffer.toString());
            } else {
                StringBuilder buffer = new StringBuilder();
                buffer.append(new Date()).append("\n\n");
                Exception e = new Exception(){

                    public void printStackTrace(PrintWriter out) {
                    }
                };
                LocalClientInfo info = localClientInfoFactory.createLocalClientInfo(e, Thread.currentThread().getName(), "Console Log", false);
                buffer.append(info.toBugReport());
                buffer.append("-- BEGIN STACK TRACES --\n");
                buffer.append(traces.length() > 0 ? traces : "NONE");
                buffer.append("\n-- END STACK TRACES --\n");
                buffer.append("\n-- BEGIN LOG --\n");
                buffer.append(log.length() > 0 ? log : "NONE");
                buffer.append("\n-- END LOG --\n");
                File file = FileChooserHandler.getSaveAsFile(GUIMediator.getAppFrame(), I18nMarker.marktr("Save As"), new File(FileChooserHandler.getLastInputDirectory(), "limewire-log.txt"));
                if (file == null) {
                    return;
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write(buffer.toString());
                out.close();
            }
        }
        catch (IOException err) {
            ErrorService.error(err);
        }
        finally {
            this.output.setEnabled(true);
        }
    }

    public void invokeLaterConsoleAppend(final String consoleTxt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Console.this._appendText(consoleTxt);
            }
        });
    }

    public void _appendText(String consoleTxt) {
        this.output.append(consoleTxt);
        int excess = this.output.getDocument().getLength() - this.idealSize;
        if (excess >= this.maxExcess) {
            this.output.replaceRange("", 0, excess);
        }
        if (this.scroll) {
            this.output.setCaretPosition(this.output.getText().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay() {
        this.delay = this.delayTxt.getValue();
        if (0 == this.delay) {
            StringBuffer stringBuffer = this.delayBuf;
            synchronized (stringBuffer) {
                if (0 != this.delayBuf.length()) {
                    String strbuf = this.delayBuf.toString();
                    this.delayBuf.delete(0, strbuf.length());
                    this.invokeLaterConsoleAppend(strbuf);
                }
            }
            if (this.delayTimer != null) {
                this.delayTimer.stop();
                this.delayTimer = null;
            }
        } else if (null == this.delayTimer) {
            this.delayTimer = new Timer(this.delay * 1000, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent evt) {
                    if (0 == Console.this.delayBuf.length()) {
                        return;
                    }
                    StringBuffer stringBuffer = Console.this.delayBuf;
                    synchronized (stringBuffer) {
                        String strbuf = Console.this.delayBuf.toString();
                        Console.this.delayBuf.delete(0, strbuf.length());
                        Console.this._appendText(strbuf);
                    }
                }
            });
            this.delayTimer.start();
        } else {
            this.delayTimer.setDelay(this.delay * 1000);
        }
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.scrollPane.getViewport().setBackground(tableColor);
    }

    private static final Level getLevel(LoggerNode logger) {
        Level level = logger.getLevel();
        if (level == null) {
            level = Level.OFF;
        }
        return level;
    }

    public static interface ConsoleListener {
        public boolean handleCommand(String var1, PrintWriter var2) throws IOException;
    }

    private static class ClassNode
    implements LoggerNode {
        private PackageNode parent;
        private Logger logger;

        private ClassNode(PackageNode parent, Logger logger) {
            this.parent = parent;
            this.logger = logger;
        }

        public PackageNode getParent() {
            return this.parent;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public Level getLevel() {
            return this.logger.getLevel();
        }

        public void setLevel(Level level) {
            this.logger.setLevel(level);
        }

        public boolean isLeaf() {
            return true;
        }

        public String getName() {
            return this.logger.getName();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassNode)) {
                return false;
            }
            return this.getName().equals(((ClassNode)o).getName());
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageNode
    implements LoggerNode {
        private String pkg;
        private List<ClassNode> classNodes = new ArrayList<ClassNode>();

        private PackageNode(String pkg) {
            this.pkg = pkg;
        }

        public void add(Logger logger) {
            this.classNodes.add(new ClassNode(this, logger));
        }

        @Override
        public Level getLevel() {
            return Level.OFF;
        }

        @Override
        public void setLevel(Level level) {
            for (int i = this.classNodes.size() - 1; i >= 0; --i) {
                this.classNodes.get(i).setLevel(level);
            }
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public void sort() {
            Collections.sort(this.classNodes, new Comparator<ClassNode>(){

                @Override
                public int compare(ClassNode o1, ClassNode o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }

        public List<ClassNode> getNodes() {
            return this.classNodes;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PackageNode)) {
                return false;
            }
            return this.pkg.equals(((PackageNode)o).pkg);
        }

        @Override
        public String getName() {
            return this.pkg;
        }

        public String toString() {
            return this.getName();
        }

        private static String getPackage(Logger logger) {
            String name = logger.getName();
            int i = name.lastIndexOf(46);
            return i != -1 ? name.substring(0, i) + ".*" : name + ".*";
        }
    }

    private static interface LoggerNode {
        public boolean isLeaf();

        public Level getLevel();

        public void setLevel(Level var1);

        public String getName();
    }

    private class LevelComboBoxModel
    extends DefaultComboBoxModel {
        private final Level[] levels = new Level[]{Level.OFF, Level.ALL, Level.DEBUG, Level.ERROR, Level.FATAL, Level.INFO, Level.WARN};

        private LevelComboBoxModel() {
        }

        public int getSize() {
            return this.levels.length;
        }

        private Level getLevel(int index) {
            return this.levels[index];
        }

        public Object getElementAt(int index) {
            return this.getLevel(index).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggerComboBoxModel
    extends DefaultComboBoxModel {
        private static final String SPACER = "    ";
        private List<LoggerNode> nodes = Collections.emptyList();

        private LoggerComboBoxModel() {
        }

        private void updateIndex(int index) {
            this.fireContentsChanged(this, index, index);
        }

        private void refreshLoggers(List<LoggerNode> nodes) {
            this.nodes = nodes;
            this.fireContentsChanged(this, 0, nodes.size());
        }

        @Override
        public int getSize() {
            return this.nodes.size();
        }

        private LoggerNode getLogger(int index) {
            return this.nodes.get(index);
        }

        @Override
        public Object getElementAt(int index) {
            LoggerNode logger = this.getLogger(index);
            Level level = Console.getLevel(logger);
            if (level.equals(Level.OFF)) {
                if (logger.isLeaf()) {
                    return SPACER + logger.getName();
                }
                return logger.getName();
            }
            if (logger.isLeaf()) {
                return SPACER + logger.getName() + " [" + level + "]";
            }
            return logger.getName();
        }
    }

    private final class ConsoleWriter
    extends Writer {
        private StringBuilder buffer = new StringBuilder();

        private ConsoleWriter() {
        }

        public void write(char[] cbuf, int off, int len) {
            this.buffer.append(cbuf, off, len);
        }

        public void close() {
            this.buffer = null;
        }

        public void flush() {
            Console.this.appendText(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

