/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeDaapServerNIO;
import com.limegroup.gnutella.settings.DaapSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import de.kapsi.net.daap.AutoCommitTransaction;
import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class DaapManager
implements FinalizeListener {
    private static final Log LOG = LogFactory.getLog(DaapManager.class);
    private static final boolean USE_LIME_NIO = true;
    private static DaapManager instance = null;
    private Library library;
    private Database database;
    private Playlist masterPlaylist;
    private Playlist whatsNew;
    private Playlist creativecommons;
    private Playlist videos;
    private DaapServer server;
    private BonjourService bonjour;
    private AutoCommitTransaction autoCommitTxn;
    private boolean enabled = false;
    private int maxPlaylistSize;
    private Map<URN, Song> urnToSong;

    public static synchronized DaapManager instance() {
        if (instance == null) {
            instance = new DaapManager();
        }
        return instance;
    }

    private DaapManager() {
        GUIMediator.addFinalizeListener(this);
    }

    public synchronized void init() {
        if (this.isServerRunning()) {
            this.setEnabled(this.enabled);
        }
    }

    public synchronized void start() throws IOException {
        if (!this.isServerRunning()) {
            try {
                InetAddress addr = NetworkUtils.getLocalAddress();
                this.bonjour = new BonjourService(addr);
                this.urnToSong = new HashMap<URN, Song>();
                this.maxPlaylistSize = DaapSettings.DAAP_MAX_LIBRARY_SIZE.getValue();
                String name = DaapSettings.DAAP_LIBRARY_NAME.getValue();
                this.library = new Library(name);
                this.autoCommitTxn = new AutoCommitTransaction(this.library);
                this.database = new Database(name);
                this.whatsNew = new Playlist(I18n.tr("What's New"));
                this.creativecommons = new Playlist(I18n.tr("Creative Commons"));
                this.videos = new Playlist(I18n.tr("Video"));
                this.library.addDatabase(null, this.database);
                this.database.addPlaylist(null, this.creativecommons);
                this.database.addPlaylist(null, this.whatsNew);
                this.creativecommons.setSmartPlaylist(null, true);
                this.whatsNew.setSmartPlaylist(null, true);
                this.masterPlaylist = this.database.getMasterPlaylist();
                LimeConfig config = new LimeConfig(addr);
                if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
                    if (DaapSettings.DAAP_REQUIRES_USERNAME.getValue()) {
                        config.setAuthenticationMethod(DaapConfig.USERNAME_AND_PASSWORD);
                        config.setAuthenticationScheme(DaapConfig.DIGEST_SCHEME);
                    } else {
                        config.setAuthenticationMethod(DaapConfig.PASSWORD);
                        config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                    }
                } else {
                    config.setAuthenticationMethod(DaapConfig.NO_PASSWORD);
                    config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                }
                this.server = new LimeDaapServerNIO(this.library, config);
                this.server.setAuthenticator(new LimeAuthenticator());
                this.server.setStreamSource(new LimeStreamSource());
                this.server.setFilter(new LimeFilter());
                int maxAttempts = 10;
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.server.bind();
                        break;
                    }
                    catch (BindException bindErr) {
                        if (i >= 9) {
                            throw bindErr;
                        }
                        config.nextPort();
                        continue;
                    }
                }
                this.server.run();
                this.bonjour.registerService();
            }
            catch (IOException err) {
                this.stop();
                throw err;
            }
        }
    }

    public synchronized void stop() {
        if (this.bonjour != null) {
            this.bonjour.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.urnToSong != null) {
            this.urnToSong.clear();
        }
        this.bonjour = null;
        this.server = null;
        this.urnToSong = null;
        this.library = null;
        this.whatsNew = null;
        this.creativecommons = null;
        this.database = null;
        this.autoCommitTxn = null;
    }

    public synchronized void restart() throws IOException {
        if (this.isServerRunning()) {
            this.stop();
        }
        this.start();
        this.init();
    }

    public void doFinalize() {
        this.stop();
    }

    public synchronized void updateService() throws IOException {
        if (this.isServerRunning()) {
            this.bonjour.updateService();
            Transaction txn = this.library.beginTransaction();
            String name = DaapSettings.DAAP_LIBRARY_NAME.getValue();
            this.library.setName(txn, name);
            this.masterPlaylist.setName(txn, name);
            this.database.setName(txn, name);
            DaapConfig config = this.server.getConfig();
            if (DaapSettings.DAAP_REQUIRES_PASSWORD.getValue()) {
                if (DaapSettings.DAAP_REQUIRES_USERNAME.getValue()) {
                    config.setAuthenticationMethod(DaapConfig.USERNAME_AND_PASSWORD);
                    config.setAuthenticationScheme(DaapConfig.DIGEST_SCHEME);
                } else {
                    config.setAuthenticationMethod(DaapConfig.PASSWORD);
                    config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
                }
            } else {
                config.setAuthenticationMethod(DaapConfig.NO_PASSWORD);
                config.setAuthenticationScheme(DaapConfig.BASIC_SCHEME);
            }
            txn.commit();
        }
    }

    public synchronized void disconnectAll() {
        if (this.isServerRunning()) {
            this.server.disconnectAll();
        }
    }

    public synchronized boolean isServerRunning() {
        if (this.server != null) {
            return this.server.isRunning();
        }
        return false;
    }

    private boolean handleError(Throwable t) {
        if (t == null) {
            return false;
        }
        String msg = t.getMessage();
        if (msg == null || msg.indexOf("Unable to establish loopback connection") == -1) {
            return this.handleError(t.getCause());
        }
        if (OSUtils.isWindowsXP() || OSUtils.isWindowsVista()) {
            DialogOption answer = GUIMediator.showYesNoCancelMessage(I18n.tr("FrostWire was unable to start the Digital Audio Access Protocol (for sharing files in iTunes) because a Microsoft patch is required or a firewall is blocking access. LimeWire can direct you to Microsoft's page with information if you want to use this feature. Click 'Yes' to go to the patch, 'No' to disable this feature, or 'Cancel' to decide later."));
            switch (answer) {
                case YES: {
                    GUIMediator.openURL("http://support.microsoft.com/default.aspx?kbid=884020");
                    break;
                }
                case NO: {
                    DaapSettings.DAAP_ENABLED.setValue(false);
                }
            }
        } else {
            DialogOption answer = GUIMediator.showYesNoMessage(I18n.tr("FrostWire was unable to start the Digital Audio Access Protocol (for sharing files in iTunes) because a firewall is blocking access. To continue using this feature, click 'Yes' and change your firewall to allow 'LimeWire.exe' full access to incoming and outgoing connections. To disable this feature, click 'No'."), DialogOption.YES);
            if (answer == DialogOption.NO) {
                DaapSettings.DAAP_ENABLED.setValue(false);
            }
        }
        return true;
    }

    private static boolean isSupportedAudioFormat(String name) {
        return DaapManager.isSupportedFormat(DaapSettings.DAAP_SUPPORTED_AUDIO_FILE_TYPES.getValue(), name);
    }

    private static boolean isSupportedVideoFormat(String name) {
        return DaapManager.isSupportedFormat(DaapSettings.DAAP_SUPPORTED_VIDEO_FILE_TYPES.getValue(), name);
    }

    private static boolean isSupportedFormat(String[] types, String name) {
        for (int i = 0; i < types.length; ++i) {
            if (!name.endsWith(types[i])) continue;
            return true;
        }
        return false;
    }

    private void handleChangeEvent(FileManagerEvent evt) {
        FileDesc oldDesc = evt.getFileDescs()[0];
        Song song = this.urnToSong.remove(oldDesc.getSHA1Urn());
        if (song != null) {
            FileDesc newDesc = evt.getFileDescs()[1];
            this.urnToSong.put(newDesc.getSHA1Urn(), song);
            String name = newDesc.getFileName().toLowerCase(Locale.US);
            if (DaapManager.isSupportedAudioFormat(name)) {
                this.updateSongAudioMeta(this.autoCommitTxn, song, newDesc);
            } else if (DaapManager.isSupportedVideoFormat(name)) {
                this.updateSongVideoMeta(this.autoCommitTxn, song, newDesc);
            } else {
                this.database.removeSong(this.autoCommitTxn, song);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAddEvent(FileManagerEvent evt) {
        Library library = this.library;
        synchronized (library) {
            if (this.database.getSongCount() >= this.maxPlaylistSize) {
                return;
            }
        }
        FileDesc file = evt.getFileDescs()[0];
        if (!(file instanceof IncompleteFileDesc)) {
            String name = file.getFileName().toLowerCase(Locale.US);
            Song song = null;
            if (DaapManager.isSupportedAudioFormat(name)) {
                song = this.createSong(file, true);
            } else if (DaapManager.isSupportedVideoFormat(name)) {
                song = this.createSong(file, false);
            }
            if (song != null) {
                this.urnToSong.put(file.getSHA1Urn(), song);
                this.database.getMasterPlaylist().addSong(this.autoCommitTxn, song);
                this.whatsNew.addSong(this.autoCommitTxn, song);
                if (file.isLicensed()) {
                    this.creativecommons.addSong(this.autoCommitTxn, song);
                }
                if (DaapManager.isSupportedVideoFormat(name)) {
                    this.videos.addSong(this.autoCommitTxn, song);
                }
            }
        }
    }

    private void handleRenameEvent(FileManagerEvent evt) {
        FileDesc oldDesc = evt.getFileDescs()[0];
        Song song = this.urnToSong.remove(oldDesc.getSHA1Urn());
        if (song != null) {
            FileDesc newDesc = evt.getFileDescs()[1];
            this.urnToSong.put(newDesc.getSHA1Urn(), song);
            song.setAttachment(newDesc);
        }
    }

    private void handleRemoveEvent(FileManagerEvent evt) {
        FileDesc file = evt.getFileDescs()[0];
        Song song = this.urnToSong.remove(file.getSHA1Urn());
        if (song != null) {
            this.database.removeSong(this.autoCommitTxn, song);
            song.setAttachment(null);
        }
    }

    public synchronized void handleFileManagerEvent(FileManagerEvent evt) {
        if (!this.enabled || !this.isServerRunning()) {
            return;
        }
        if (evt.isChangeEvent()) {
            this.handleChangeEvent(evt);
        } else if (evt.isAddEvent()) {
            this.handleAddEvent(evt);
        } else if (evt.isRenameEvent()) {
            this.handleRenameEvent(evt);
        } else if (evt.isRemoveEvent()) {
            this.handleRemoveEvent(evt);
        }
    }

    public void fileManagerLoading() {
        this.setEnabled(false);
    }

    public void fileManagerLoaded() {
        this.setEnabled(true);
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    private synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled || !this.isServerRunning()) {
            return;
        }
        HashMap<URN, Song> tmpUrnToSong = new HashMap<URN, Song>();
        int size = this.masterPlaylist.getSongCount();
        Transaction txn = this.library.beginTransaction();
        FileDesc[] files = GuiCoreMediator.getFileManager().getAllSharedFileDescriptors();
        for (int i = 0; i < files.length; ++i) {
            String name;
            boolean audio;
            FileDesc file = files[i];
            if (file instanceof IncompleteFileDesc || !(audio = DaapManager.isSupportedAudioFormat(name = file.getFileName().toLowerCase(Locale.US))) && !DaapManager.isSupportedVideoFormat(name)) continue;
            URN urn = file.getSHA1Urn();
            Song song = this.urnToSong.remove(urn);
            if (tmpUrnToSong.containsKey(urn)) continue;
            if (song != null) {
                tmpUrnToSong.put(urn, song);
                if (audio) {
                    this.updateSongAudioMeta(txn, song, file);
                    continue;
                }
                this.updateSongVideoMeta(txn, song, file);
                continue;
            }
            if (size >= this.maxPlaylistSize) continue;
            song = this.createSong(file, audio);
            tmpUrnToSong.put(urn, song);
            this.database.getMasterPlaylist().addSong(txn, song);
            if (file.isLicensed()) {
                this.creativecommons.addSong(txn, song);
            }
            if (DaapManager.isSupportedVideoFormat(name)) {
                this.videos.addSong(txn, song);
            }
            ++size;
        }
        for (Song song : this.urnToSong.values()) {
            this.database.removeSong(txn, song);
            song.setAttachment(null);
        }
        this.urnToSong.clear();
        this.urnToSong = tmpUrnToSong;
        txn.commit();
    }

    private Song createSong(FileDesc desc, boolean audio) {
        Song song = new Song(desc.getFileName());
        song.setSize(null, desc.getFileSize() & 0xFFFFFFFFL);
        song.setDateAdded(null, System.currentTimeMillis() / 1000L);
        File file = desc.getFile();
        String ext = FileUtils.getFileExtension(file);
        if (!audio) {
            song.setHasVideo(null, true);
        }
        if (ext != null) {
            if (!(ext = ext.toLowerCase(Locale.US)).endsWith("mp3")) {
                song.setFormat(null, ext);
            }
            if (audio) {
                this.updateSongAudioMeta(null, song, desc);
            } else {
                this.updateSongVideoMeta(null, song, desc);
            }
        } else {
            song.setAttachment(desc);
        }
        return song;
    }

    private boolean updateSongVideoMeta(Transaction txn, Song song, FileDesc desc) {
        String currentTitle;
        song.setAttachment(desc);
        SchemaReplyCollectionMapper map = GuiCoreMediator.getSchemaReplyCollectionMapper();
        LimeXMLReplyCollection collection = map.getReplyCollection("http://www.limewire.com/schemas/video.xsd");
        if (collection == null) {
            LOG.error("LimeXMLReplyCollection is null");
            return false;
        }
        LimeXMLDocument doc = collection.getDocForHash(desc.getSHA1Urn());
        if (doc == null) {
            return false;
        }
        boolean update = false;
        String title = doc.getValue("videos__video__title__");
        String year = doc.getValue("videos__video__year__");
        String rating = doc.getValue("videos__video__rating__");
        String length = doc.getValue("videos__video__length__");
        String license = doc.getValue("videos__video__license__");
        String bitrate = doc.getValue("videos__video__bitrate__");
        String director = doc.getValue("videos__video__director__");
        if (!(title == null || (currentTitle = song.getName()) != null && title.equals(currentTitle))) {
            update = true;
            song.setName(txn, title);
        }
        int currentBitrate = song.getBitrate();
        if (bitrate != null) {
            try {
                int num = Integer.parseInt(bitrate);
                if (num > 0 && num != currentBitrate) {
                    update = true;
                    song.setBitrate(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentBitrate != 0) {
            update = true;
            song.setBitrate(txn, 0);
        }
        long currentLength = song.getTime();
        if (length != null) {
            try {
                int num = (int)((long)Integer.parseInt(length) * 1000L);
                if (num > 0 && (long)num != currentLength) {
                    update = true;
                    song.setTime(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentLength != 0L) {
            update = true;
            song.setTime(txn, 0L);
        }
        int currentYear = song.getYear();
        if (year != null) {
            try {
                int num = Integer.parseInt(year);
                if (num > 0 && num != currentYear) {
                    update = true;
                    song.setYear(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentYear != 0) {
            update = true;
            song.setYear(txn, 0);
        }
        String currentGenre = song.getGenre();
        if (license != null) {
            if (currentGenre == null || !license.equals(currentGenre)) {
                update = true;
                song.setGenre(txn, license);
            }
        } else if (currentGenre != null) {
            update = true;
            song.setGenre(txn, null);
        }
        String currentArtist = song.getArtist();
        if (director != null) {
            if (currentArtist == null || !director.equals(currentArtist)) {
                update = true;
                song.setArtist(txn, director);
            }
        } else if (currentArtist != null) {
            update = true;
            song.setArtist(txn, null);
        }
        String currentAlbum = song.getAlbum();
        if (rating != null) {
            if (currentAlbum == null || !rating.equals(currentAlbum)) {
                update = true;
                song.setAlbum(txn, rating);
            }
        } else if (currentAlbum != null) {
            update = true;
            song.setAlbum(txn, null);
        }
        return update;
    }

    private boolean updateSongAudioMeta(Transaction txn, Song song, FileDesc desc) {
        String currentTitle;
        song.setAttachment(desc);
        SchemaReplyCollectionMapper map = GuiCoreMediator.getSchemaReplyCollectionMapper();
        LimeXMLReplyCollection collection = map.getReplyCollection("http://www.limewire.com/schemas/audio.xsd");
        if (collection == null) {
            LOG.error("LimeXMLReplyCollection is null");
            return false;
        }
        LimeXMLDocument doc = collection.getDocForHash(desc.getSHA1Urn());
        if (doc == null) {
            return false;
        }
        boolean update = false;
        String title = doc.getValue("audios__audio__title__");
        String track = doc.getValue("audios__audio__track__");
        String artist = doc.getValue("audios__audio__artist__");
        String album = doc.getValue("audios__audio__album__");
        String genre = doc.getValue("audios__audio__genre__");
        String bitrate = doc.getValue("audios__audio__bitrate__");
        String time = doc.getValue("audios__audio__seconds__");
        String year = doc.getValue("audios__audio__year__");
        if (!(title == null || (currentTitle = song.getName()) != null && title.equals(currentTitle))) {
            update = true;
            song.setName(txn, title);
        }
        int currentTrack = song.getTrackNumber();
        if (track != null) {
            try {
                int num = Integer.parseInt(track);
                if (num > 0 && num != currentTrack) {
                    update = true;
                    song.setTrackNumber(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentTrack != 0) {
            update = true;
            song.setTrackNumber(txn, 0);
        }
        String currentArtist = song.getArtist();
        if (artist != null) {
            if (currentArtist == null || !artist.equals(currentArtist)) {
                update = true;
                song.setArtist(txn, artist);
            }
        } else if (currentArtist != null) {
            update = true;
            song.setArtist(txn, null);
        }
        String currentAlbum = song.getAlbum();
        if (album != null) {
            if (currentAlbum == null || !album.equals(currentAlbum)) {
                update = true;
                song.setAlbum(txn, album);
            }
        } else if (currentAlbum != null) {
            update = true;
            song.setAlbum(txn, null);
        }
        String currentGenre = song.getGenre();
        if (genre != null) {
            if (currentGenre == null || !genre.equals(currentGenre)) {
                update = true;
                song.setGenre(txn, genre);
            }
        } else if (currentGenre != null) {
            update = true;
            song.setGenre(txn, null);
        }
        int currentBitrate = song.getBitrate();
        if (bitrate != null) {
            try {
                int num = Integer.parseInt(bitrate);
                if (num > 0 && num != currentBitrate) {
                    update = true;
                    song.setBitrate(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentBitrate != 0) {
            update = true;
            song.setBitrate(txn, 0);
        }
        long currentTime = song.getTime();
        if (time != null) {
            try {
                long num = (long)Integer.parseInt(time) * 1000L;
                if (num > 0L && num != currentTime) {
                    update = true;
                    song.setTime(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentTime != 0L) {
            update = true;
            song.setTime(txn, 0L);
        }
        int currentYear = song.getYear();
        if (year != null) {
            try {
                int num = Integer.parseInt(year);
                if (num > 0 && num != currentYear) {
                    update = true;
                    song.setYear(txn, num);
                }
            }
            catch (NumberFormatException err) {}
        } else if (currentYear != 0) {
            update = true;
            song.setYear(txn, 0);
        }
        int mod = (int)(desc.lastModified() / 1000L);
        if (song.getDateModified() != (long)mod) {
            update = true;
            song.setDateModified(txn, mod);
        }
        return update;
    }

    private final class BonjourService {
        private static final String VERSION = "Version";
        private static final String MACHINE_NAME = "Machine Name";
        private static final String PASSWORD = "Password";
        private final JmDNS zeroConf;
        private ServiceInfo serviceInfo;

        public BonjourService(InetAddress addr) throws IOException {
            this.zeroConf = new JmDNS(addr);
        }

        public boolean isRegistered() {
            return this.serviceInfo != null;
        }

        private ServiceInfo createServiceInfo() {
            String type = DaapSettings.DAAP_TYPE_NAME.getValue();
            String name = DaapSettings.DAAP_SERVICE_NAME.getValue();
            int port = DaapSettings.DAAP_PORT.getValue();
            int weight = DaapSettings.DAAP_WEIGHT.getValue();
            int priority = DaapSettings.DAAP_PRIORITY.getValue();
            boolean password = DaapSettings.DAAP_REQUIRES_PASSWORD.getValue();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(VERSION, Integer.toString(196608));
            props.put(MACHINE_NAME, name);
            props.put(PASSWORD, Boolean.toString(password));
            String qualifiedName = null;
            qualifiedName = password ? name + "_PW." + type : name + "." + type;
            ServiceInfo serviceInfo = new ServiceInfo(type, qualifiedName, port, weight, priority, props);
            return serviceInfo;
        }

        public void registerService() throws IOException {
            if (this.isRegistered()) {
                throw new IOException();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.serviceInfo = serviceInfo;
        }

        public void unregisterService() {
            if (!this.isRegistered()) {
                return;
            }
            this.zeroConf.unregisterService(this.serviceInfo);
            this.serviceInfo = null;
        }

        public void updateService() throws IOException {
            if (!this.isRegistered()) {
                throw new IOException();
            }
            if (this.serviceInfo.getPort() != DaapSettings.DAAP_PORT.getValue()) {
                this.unregisterService();
            }
            ServiceInfo serviceInfo = this.createServiceInfo();
            this.zeroConf.registerService(serviceInfo);
            this.serviceInfo = serviceInfo;
        }

        public void close() {
            this.unregisterService();
            this.zeroConf.close();
        }
    }

    private final class LimeConfig
    extends DaapConfig {
        private InetAddress addr;

        public LimeConfig(InetAddress addr) {
            this.addr = addr;
            DaapSettings.DAAP_PORT.revertToDefault();
        }

        public String getServerName() {
            return LimeWireUtils.getHttpServer();
        }

        public void nextPort() {
            int port = DaapSettings.DAAP_PORT.getValue();
            DaapSettings.DAAP_PORT.setValue(port + 1);
        }

        public int getBacklog() {
            return 0;
        }

        public InetSocketAddress getInetSocketAddress() {
            int port = DaapSettings.DAAP_PORT.getValue();
            return new InetSocketAddress(this.addr, port);
        }

        public int getMaxConnections() {
            return DaapSettings.DAAP_MAX_CONNECTIONS.getValue();
        }
    }

    private final class LimeFilter
    implements DaapFilter {
        private LimeFilter() {
        }

        public boolean accept(InetAddress address) {
            try {
                if (!GuiCoreMediator.getNetworkInstanceUtils().isVeryCloseIP(address) && GuiCoreMediator.getNetworkInstanceUtils().isPrivateAddress(address)) {
                    return false;
                }
            }
            catch (IllegalArgumentException err) {
                LOG.error(err);
                return false;
            }
            return GuiCoreMediator.getIpFilter().allow(address.getAddress());
        }
    }

    private final class LimeAuthenticator
    implements DaapAuthenticator {
        private LimeAuthenticator() {
        }

        public byte[] getPassword(String username, Object scheme) {
            String password = DaapSettings.DAAP_PASSWORD.getValue();
            if (password.startsWith("MD5/")) {
                password = password.substring(4);
            }
            return DaapUtil.parseHexString(password);
        }

        public boolean authenticate(String username, String password, String uri, String nonce) {
            if (uri == null && nonce == null) {
                return DaapSettings.DAAP_PASSWORD.equals(password);
            }
            if (uri != null && nonce != null) {
                String ha1 = DaapSettings.DAAP_PASSWORD.getValue();
                if (ha1.startsWith("MD5/")) {
                    ha1 = ha1.substring(4);
                }
                String ha2 = DaapUtil.calculateHA2(uri);
                String digest = DaapUtil.digest(ha1, ha2, nonce);
                return digest.equalsIgnoreCase(password);
            }
            if (LOG.isErrorEnabled()) {
                LOG.error("Unknown scheme!");
            }
            return false;
        }
    }

    private final class LimeStreamSource
    implements DaapStreamSource {
        private LimeStreamSource() {
        }

        public Object getSource(Song song) throws IOException {
            FileDesc fileDesc = (FileDesc)song.getAttachment();
            if (fileDesc != null) {
                return new FileInputStream(fileDesc.getFile());
            }
            return null;
        }
    }
}

