/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.bugs.FatalBugManager;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.JavaVersionNotice;
import com.limegroup.gnutella.gui.SplashWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.limewire.util.VersionUtils;

public class GUILoader {
    public static void load(String[] args, Frame frame) {
        try {
            if (JavaVersionNotice.upgradeRequired(VersionUtils.getJavaVersion())) {
                GUILoader.hideSplash(frame);
                JavaVersionNotice.showUpgradeRequiredDialog();
            }
            GUILoader.sanityCheck();
            Initializer initializer = new Initializer();
            initializer.initialize(args, frame);
        }
        catch (StartupFailedException sfe) {
            GUILoader.hideSplash(frame);
            GUILoader.showCorruptionError(sfe);
            System.exit(1);
        }
        catch (Throwable err) {
            GUILoader.hideSplash(frame);
            try {
                FatalBugManager.handleFatalBug(err);
            }
            catch (Throwable t) {
                Throwable error = err;
                try {
                    t.initCause(err);
                    error = t;
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                GUILoader.showCorruptionError(error);
                System.exit(1);
            }
        }
    }

    private static void hideSplash(Frame frame) {
        try {
            if (frame != null) {
                frame.dispose();
            }
            if (SplashWindow.isSplashConstructed()) {
                SplashWindow.instance().setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final void showCorruptionError(Throwable err) {
        err.printStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("FrostWire version 4.17");
        pw.print("Java version ");
        pw.print(System.getProperty("java.version", "?"));
        pw.print(" from ");
        pw.println(System.getProperty("java.vendor", "?"));
        pw.print(System.getProperty("os.name", "?"));
        pw.print(" v. ");
        pw.print(System.getProperty("os.version", "?"));
        pw.print(" on ");
        pw.println(System.getProperty("os.arch", "?"));
        Runtime runtime = Runtime.getRuntime();
        pw.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        pw.println();
        err.printStackTrace(pw);
        pw.println();
        pw.println("STARTUP ERROR!");
        pw.println();
        File propsFile = new File(GUILoader.getUserSettingsDir(), "frostwire.props");
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            fis.close();
            props.list(pw);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        pw.flush();
        GUILoader.displayError(sw.toString());
    }

    private static File getUserSettingsDir() {
        File dir = new File(System.getProperty("user.home"));
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac os") && os.endsWith("x")) {
            return new File(dir, "/Library/Preferences/FrostWire");
        }
        return new File(dir, ".frostwire");
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("windows");
    }

    private static final void displayError(String error) {
        System.out.println("Error: " + error);
        final JDialog DIALOG = new JDialog();
        DIALOG.setModal(true);
        Dimension DIALOG_DIMENSION = new Dimension(350, 200);
        Dimension INNER_SIZE = new Dimension(300, 150);
        DIALOG.setSize(DIALOG_DIMENSION);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BorderLayout());
        String instr0 = "One or more necessary files appear to be invalid.";
        String instr1 = "This is generally caused by a corrupted installation.";
        String instr2 = "Please try downloading and installing FrostWire again.";
        String instr3 = "If the problem persists, please visit www.frostwire.com ";
        String instr4 = "and click the 'Support' link.  ";
        String instr5 = "Thank you.";
        JLabel label0 = new JLabel(instr0);
        JLabel label1 = new JLabel(instr1);
        JLabel label2 = new JLabel(instr2);
        JLabel label3 = new JLabel(instr3);
        JLabel label4 = new JLabel(instr4);
        JLabel label5 = new JLabel(instr5);
        JPanel labelPanel = new JPanel();
        JPanel innerLabelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        innerLabelPanel.setLayout(new BoxLayout(innerLabelPanel, 1));
        innerLabelPanel.add(label0);
        innerLabelPanel.add(label1);
        innerLabelPanel.add(label2);
        innerLabelPanel.add(label3);
        innerLabelPanel.add(label4);
        innerLabelPanel.add(label5);
        innerLabelPanel.add(Box.createVerticalStrut(6));
        labelPanel.add(innerLabelPanel);
        labelPanel.add(Box.createHorizontalGlue());
        final JTextArea textArea = new JTextArea(error);
        textArea.selectAll();
        textArea.copy();
        textArea.setColumns(50);
        textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setBorder(BorderFactory.createEtchedBorder());
        scroller.setPreferredSize(INNER_SIZE);
        JPanel buttonPanel = new JPanel();
        JButton copyButton = new JButton("Copy Report");
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textArea.selectAll();
                textArea.copy();
            }
        });
        JButton quitButton = new JButton("Ok");
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DIALOG.dispose();
            }
        });
        buttonPanel.add(copyButton);
        buttonPanel.add(quitButton);
        mainPanel.add((Component)labelPanel, "North");
        mainPanel.add((Component)scroller, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        DIALOG.getContentPane().add(mainPanel);
        DIALOG.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = DIALOG.getSize();
        DIALOG.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        DIALOG.setVisible(true);
    }

    private static void sanityCheck() throws StartupFailedException {
        File test = new File("iscvs.txt");
        boolean isCVS = false;
        isCVS = test.exists() && test.isFile();
        String root = isCVS ? "../lib/jars" : ".";
        File themesJar = new File(root, "themes.jar");
        try {
            GUILoader.verifyHashes(root);
        }
        catch (IOException e) {
            throw new StartupFailedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyHashes(String root) throws IOException, StartupFailedException {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(root, "hashes"));
            props.load(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException ignored) {}
            }
        }
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String storedHash = props.getProperty(name);
            String realHash = GUILoader.hash(new File(root, name));
            if (realHash.equals(storedHash)) continue;
            throw new StartupFailedException("file [" + name + "] has hash of [" + realHash + "] instead of expected [" + storedHash + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hash(File f) throws IOException {
        FileInputStream fis = null;
        try {
            int read;
            fis = new FileInputStream(f);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Unknown algorithm: MD5");
            }
            byte[] buffer = new byte[16384];
            while ((read = fis.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
            String string = GUILoader.toHexString(md.digest());
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < data.length; ++i) {
            int asInt = data[i] & 0xFF;
            String x = Integer.toHexString(asInt);
            if (x.length() == 1) {
                sb.append("0");
            }
            sb.append(x);
        }
        return sb.toString().toUpperCase();
    }

    private static class StartupFailedException
    extends Exception {
        StartupFailedException(String msg) {
            super(msg);
        }

        StartupFailedException() {
        }
    }
}

