/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.PlaylistMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class GUIUtils {
    private static final Log LOG = LogFactory.getLog(GUIUtils.class);
    private static NumberFormat NUMBER_FORMAT0;
    private static NumberFormat NUMBER_FORMAT1;
    private static DateFormat DATETIME_FORMAT;
    private static DateFormat FULL_DATETIME_FORMAT;
    public static String GENERAL_UNIT_KILOBYTES;
    public static String GENERAL_UNIT_MEGABYTES;
    public static String GENERAL_UNIT_GIGABYTES;
    public static String GENERAL_UNIT_TERABYTES;
    public static String GENERAL_UNIT_KBPSEC;
    public static final HyperlinkListener HYPER_LISTENER;
    public static Action ACTION_DISPOSE;

    private GUIUtils() {
    }

    static void resetLocale() {
        NUMBER_FORMAT0 = NumberFormat.getNumberInstance(GUIMediator.getLocale());
        NUMBER_FORMAT0.setMaximumFractionDigits(0);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance(GUIMediator.getLocale());
        NUMBER_FORMAT1.setMaximumFractionDigits(1);
        NUMBER_FORMAT1.setMinimumFractionDigits(1);
        NUMBER_FORMAT1.setGroupingUsed(true);
        DATETIME_FORMAT = DateFormat.getDateTimeInstance(2, 2, GUIMediator.getLocale());
        FULL_DATETIME_FORMAT = new SimpleDateFormat("EEE, MMM. d, yyyy h:mm a", GUIMediator.getLocale());
        GENERAL_UNIT_KILOBYTES = I18n.tr("KB");
        GENERAL_UNIT_MEGABYTES = I18n.tr("MB");
        GENERAL_UNIT_GIGABYTES = I18n.tr("GB");
        GENERAL_UNIT_TERABYTES = I18n.tr("TB");
        GENERAL_UNIT_KBPSEC = I18n.tr("KB/s");
    }

    public static String toLocalizedInteger(long value) {
        return NUMBER_FORMAT0.format(value);
    }

    public static String toKilobytes(long bytes) {
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        long kbytes = bytes / 1024L;
        if ((bytes & 0x200L) != 0L || bytes > 0L && bytes < 1024L) {
            ++kbytes;
        }
        return NUMBER_FORMAT0.format(kbytes) + GENERAL_UNIT_KILOBYTES;
    }

    public static String toUnitbytes(long bytes) {
        String unitName;
        long unitValue;
        if (bytes < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        if (bytes < 0xA00000L) {
            unitValue = 1024L;
            unitName = GENERAL_UNIT_KILOBYTES;
        } else if (bytes < 0x280000000L) {
            unitValue = 0x100000L;
            unitName = GENERAL_UNIT_MEGABYTES;
        } else if (bytes < 0xA0000000000L) {
            unitValue = 0x40000000L;
            unitName = GENERAL_UNIT_GIGABYTES;
        } else {
            unitValue = 0x10000000000L;
            unitName = GENERAL_UNIT_TERABYTES;
        }
        NumberFormat numberFormat = (double)bytes * 100.0 / (double)unitValue < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        try {
            return numberFormat.format((double)bytes / (double)unitValue) + " " + unitName;
        }
        catch (ArithmeticException ae) {
            return "0 " + unitName;
        }
    }

    public static MultiLineLabel getSizedLabel(String msg) {
        Dimension dim = new Dimension();
        MultiLineLabel label = new MultiLineLabel(msg);
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int width = fm.stringWidth(msg);
        dim.setSize(Integer.MAX_VALUE, width / 9);
        label.setPreferredSize(dim);
        return label;
    }

    public static String speed2name(int rate) {
        if (rate <= 56) {
            return GUIConstants.MODEM_SPEED;
        }
        if (rate <= 350) {
            return GUIConstants.CABLE_SPEED;
        }
        if (rate <= 1000) {
            return GUIConstants.T1_SPEED;
        }
        if (rate == 0x7FFFFFFD) {
            return "--";
        }
        if (rate < 0x7FFFFFFE) {
            return GUIConstants.T3_SPEED;
        }
        return GUIConstants.MULTICAST_SPEED;
    }

    public static String rate2speed(double rate) {
        return NUMBER_FORMAT0.format(rate) + " " + GENERAL_UNIT_KBPSEC;
    }

    public static String msec2DateTime(long milliseconds) {
        Date d = new Date(milliseconds);
        return DATETIME_FORMAT.format(d);
    }

    public static DateFormat getFullDateTimeFormat() {
        return FULL_DATETIME_FORMAT;
    }

    public static void setOpaque(boolean op, JComponent c) {
        c.setOpaque(op);
        Component[] cs = c.getComponents();
        for (int i = 0; i < cs.length; ++i) {
            if (!(cs[i] instanceof JComponent) || cs[i] instanceof JTextField || !ThemeSettings.isNativeOSXTheme() && cs[i] instanceof JButton) continue;
            ((JComponent)cs[i]).setOpaque(op);
            GUIUtils.setOpaque(op, (JComponent)cs[i]);
        }
    }

    public static JPanel center(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(1, 0, 0));
        p.add(c);
        return p;
    }

    public static JPanel left(JComponent c) {
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(c);
        return p;
    }

    public static int width(JLabel c) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        return fm.stringWidth(c.getText()) + 3;
    }

    public static boolean canDisplay(Font f, String s) {
        int upTo = f.canDisplayUpTo(s);
        return upTo >= s.length() || upTo == -1;
    }

    public static void addHideAction(JDialog jd) {
        GUIUtils.addHideAction((JComponent)jd.getContentPane());
    }

    public static void addHideAction(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        map.put(GUIUtils.getHideKeystroke(), "limewire.hideWindow");
        jc.getActionMap().put("limewire.hideWindow", GUIUtils.getDisposeAction());
    }

    public static KeyStroke getHideKeystroke() {
        if (OSUtils.isMacOSX()) {
            return KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        }
        return KeyStroke.getKeyStroke(27, 0);
    }

    public static void bindKeyToAction(JComponent c, KeyStroke key, Action a, int focusScope) {
        InputMap inputMap = c.getInputMap(focusScope);
        ActionMap actionMap = c.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(key, a);
            actionMap.put(a, a);
        }
    }

    public static void bindKeyToAction(JComponent c, KeyStroke key, Action a) {
        GUIUtils.bindKeyToAction(c, key, a, 0);
    }

    public static Action getDisposeAction() {
        if (ACTION_DISPOSE == null) {
            ACTION_DISPOSE = new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    Window parent = ae.getSource() instanceof Window ? (Window)ae.getSource() : SwingUtilities.getWindowAncestor((Component)ae.getSource());
                    if (parent != null) {
                        parent.dispatchEvent(new WindowEvent(parent, 201));
                    }
                }
            };
        }
        return ACTION_DISPOSE;
    }

    public static void fixInputMap(JComponent jc) {
        InputMap map = jc.getInputMap(1);
        if (OSUtils.isMacOSX()) {
            GUIUtils.replaceAction(map, 'A');
            GUIUtils.replaceAction(map, 'C');
            GUIUtils.replaceAction(map, 'V');
            GUIUtils.replaceAction(map, 'X');
        }
    }

    private static void replaceAction(InputMap map, char c) {
        KeyStroke ctrl = KeyStroke.getKeyStroke("control pressed " + c);
        KeyStroke meta = KeyStroke.getKeyStroke("meta pressed " + c);
        if (ctrl == null || meta == null) {
            return;
        }
        Object action = map.get(ctrl);
        if (action != null) {
            map.remove(ctrl);
            map.put(meta, action);
        }
    }

    public static HyperlinkListener getHyperlinkListener() {
        return HYPER_LISTENER;
    }

    public static MouseListener getURLInputListener(final ActionListener actionListener) {
        return new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JComponent comp = (JComponent)e.getComponent();
                comp.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                JComponent comp = (JComponent)e.getComponent();
                comp.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
            }

            public void mouseClicked(MouseEvent e) {
                actionListener.actionPerformed(new ActionEvent(e.getComponent(), 0, null));
            }
        };
    }

    public static MouseListener getURLInputListener(final String url) {
        return GUIUtils.getURLInputListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.openURL(url);
            }
        });
    }

    public static boolean shouldShowStartOnStartupWindow() {
        return OSUtils.isMacOSX() && OSUtils.isCocoaFoundationAvailable() || WindowsUtils.isLoginStatusAvailable();
    }

    public static String convertToNonBreakingSpaces(int preSpaces, String s) {
        StringBuilder b = new StringBuilder(preSpaces + s.length());
        for (int i = 0; i < preSpaces; ++i) {
            b.append('\u00a0');
        }
        b.append(s.replace(' ', '\u00a0'));
        return b.toString();
    }

    public static String colorToHex(Color colorCode) {
        int r = colorCode.getRed();
        int g = colorCode.getGreen();
        int b = colorCode.getBlue();
        return GUIUtils.toHex(r) + GUIUtils.toHex(g) + GUIUtils.toHex(b);
    }

    private static String toHex(int i) {
        String hex = Integer.toHexString(i).toUpperCase();
        if (hex.length() == 1) {
            return "0" + hex;
        }
        return hex;
    }

    public static Color hexToColor(String hexString) {
        int decimalColor = Integer.parseInt(hexString, 16);
        return new Color(decimalColor);
    }

    public static boolean launchOrEnqueueFile(File file, boolean audioLaunched) {
        return GUIUtils.launchFile(file, false, audioLaunched);
    }

    public static boolean launchOneTimeFile(File file) {
        return GUIUtils.launchFile(file, true, false);
    }

    private static boolean launchFile(final File file, boolean playOneTime, boolean isPlaying) {
        String extension = FileUtils.getFileExtension(file);
        if (extension != null && extension.equals("torrent")) {
            GUIMediator.instance().openTorrent(file);
            return false;
        }
        if (GUIMediator.isPlaylistVisible()) {
            if (PlaylistMediator.getInstance().openIfPlaylist(file)) {
                return false;
            }
            if (PlaylistMediator.isPlayableFile(file)) {
                if (playOneTime) {
                    BackgroundExecutorService.schedule(new Runnable(){

                        public void run() {
                            final PlayListItem item = new PlayListItem(file);
                            GUIMediator.safeInvokeAndWait(new Runnable(){

                                public void run() {
                                    GUIMediator.instance().launchAudio(item, false);
                                }
                            });
                        }
                    });
                } else if (!isPlaying) {
                    BackgroundExecutorService.schedule(new Runnable(){

                        public void run() {
                            final PlayListItem item = new PlayListItem(file);
                            GUIMediator.safeInvokeAndWait(new Runnable(){

                                public void run() {
                                    GUIMediator.instance().launchAudio(item);
                                }
                            });
                        }
                    });
                } else {
                    PlaylistMediator.getInstance().addFileToPlaylist(file);
                }
                return true;
            }
        }
        GUIMediator.launchFile(file);
        return false;
    }

    public static boolean launchAndEnqueueFile(File file, boolean audioLaunched) {
        if (PlaylistMediator.isPlayableFile(file) && GUIMediator.isPlaylistVisible()) {
            GUIMediator.instance().attemptStopAudio();
            PlayListItem item = new PlayListItem(file);
            GUIMediator.instance().launchAudio(item);
            PlaylistMediator.getInstance().addFileToPlaylist(file);
            return true;
        }
        return GUIUtils.launchFile(file, false, audioLaunched);
    }

    public static void centerOnScreen(JDialog dialog) {
        if (GUIMediator.isAppVisible()) {
            dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            dialog.setLocation(GUIMediator.getScreenCenterPoint(dialog));
        }
    }

    public static String restrictWidth(String text, int width) {
        return "<html><table width=\"" + width + "\"><tr><td>" + text + "</td></tr></table></html>";
    }

    public static void restrictSize(JComponent component, SizePolicy sizePolicy) {
        GUIUtils.restrictSize(component, sizePolicy, false);
    }

    public static void restrictSize(JComponent component, SizePolicy sizePolicy, boolean addClientProperty) {
        switch (sizePolicy) {
            case RESTRICT_HEIGHT: {
                int height = component.getPreferredSize().height;
                int width = component.getPreferredSize().width;
                component.setMinimumSize(new Dimension(width, height));
                component.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
                break;
            }
            case RESTRICT_BOTH: {
                int height = component.getPreferredSize().height;
                int width = component.getPreferredSize().width;
                component.setMinimumSize(new Dimension(width, height));
                component.setMaximumSize(new Dimension(width, height));
                break;
            }
            case RESTRICT_NONE: {
                component.setMinimumSize(null);
                component.setMaximumSize(null);
            }
        }
        if (addClientProperty) {
            component.putClientProperty(SizePolicy.class, (Object)sizePolicy);
        }
    }

    public static int getCodeForCharKey(String str) {
        int charCode = -1;
        String charStr = str.toUpperCase(Locale.US);
        if (charStr.length() > 1) {
            return -1;
        }
        try {
            Field charField = KeyEvent.class.getField("VK_" + charStr);
            charCode = charField.getInt(KeyEvent.class);
        }
        catch (NoSuchFieldException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        catch (SecurityException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        catch (IllegalAccessException e) {
            LOG.error("can't get key for: " + charStr, e);
        }
        return charCode;
    }

    private static int getAmpersandPosition(String text) {
        int index = -1;
        while (!((index = text.indexOf(38, index + 1)) == -1 || index < text.length() - 1 && Character.isLetterOrDigit(text.charAt(index + 1)))) {
        }
        return index;
    }

    public static String stripAmpersand(String text) {
        int index = GUIUtils.getAmpersandPosition(text);
        if (index >= 0) {
            return text.substring(0, index) + text.substring(index + 1);
        }
        return text;
    }

    public static int getMnemonicKeyCode(String text) {
        int index = GUIUtils.getAmpersandPosition(text);
        if (index >= 0) {
            return GUIUtils.getCodeForCharKey(text.substring(index + 1, index + 2));
        }
        return -1;
    }

    static {
        HYPER_LISTENER = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent he) {
                URL url;
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = he.getURL()) != null) {
                    GUIMediator.openURL(url.toExternalForm());
                }
            }
        };
        GUIUtils.resetLocale();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SizePolicy {
        RESTRICT_NONE,
        RESTRICT_HEIGHT,
        RESTRICT_BOTH;

    }

    public static class EmptyIcon
    implements Icon {
        private final String name;
        private final int width;
        private final int height;

        public EmptyIcon(String name, int width, int height) {
            this.name = name;
            this.width = width;
            this.height = height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public String toString() {
            return this.name;
        }
    }
}

