/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageUtils {
    private static Log LOG = LogFactory.getLog(LanguageUtils.class);
    private static final String BUNDLE_PREFIX = "org/limewire/i18n/Messages_";
    private static final String BUNDLE_POSTFIX = ".class";
    private static final String BUNDLE_MARKER = "org/limewire/i18n/Messages.class";
    private static final String CVS_BUNDLE_FILE = "../lib/jars/compile/messages.jar";

    public static void setLocale(Locale locale) {
        ApplicationSettings.LANGUAGE.setValue(locale.getLanguage());
        ApplicationSettings.COUNTRY.setValue(locale.getCountry());
        ApplicationSettings.LOCALE_VARIANT.setValue(locale.getVariant());
        GUIMediator.resetLocale();
    }

    public static Locale[] getLocales(Font font) {
        LinkedList<Locale> locales = new LinkedList<Locale>();
        File jar = FileUtils.getJarFromClasspath(LanguageUtils.class.getClassLoader(), BUNDLE_MARKER);
        if (jar != null) {
            LanguageUtils.addLocalesFromJar(locales, jar);
        } else {
            LOG.warn("Could not find bundle jar to determine locales");
        }
        if (LimeWireUtils.isTestingVersion()) {
            LanguageUtils.addLocalesFromJar(locales, new File(CVS_BUNDLE_FILE));
        }
        Collections.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.getDisplayName(o1).compareToIgnoreCase(o2.getDisplayName(o2));
            }
        });
        locales.remove(Locale.ENGLISH);
        locales.add(0, Locale.ENGLISH);
        if (font != null && !OSUtils.isMacOSX()) {
            Iterator it = locales.iterator();
            while (it.hasNext()) {
                Locale locale = (Locale)it.next();
                if (GUIUtils.canDisplay(font, locale.getDisplayName(locale))) continue;
                it.remove();
            }
        }
        return locales.toArray(new Locale[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addLocalesFromJar(List<Locale> locales, File jar) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String iso;
                ArrayList<String> tokens;
                String name = entries.nextElement().getName();
                if (!name.startsWith(BUNDLE_PREFIX) || !name.endsWith(BUNDLE_POSTFIX) || name.indexOf("$") != -1 || (tokens = new ArrayList<String>(Arrays.asList((iso = name.substring(BUNDLE_PREFIX.length(), name.length() - BUNDLE_POSTFIX.length())).split("_", 3)))).size() < 1) continue;
                while (tokens.size() < 3) {
                    tokens.add("");
                }
                Locale locale = new Locale((String)tokens.get(0), (String)tokens.get(1), (String)tokens.get(2));
                locales.add(locale);
            }
        }
        catch (IOException e) {
            LOG.warn("Could not determine locales", e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isEnglishLocale(Locale locale) {
        return Locale.ENGLISH.getLanguage().equals(locale.getLanguage());
    }

    public static int getMatchScore(Locale specificLocale, Locale genericLocale) {
        int i = 0;
        if (specificLocale.getLanguage().equals(genericLocale.getLanguage())) {
            ++i;
        } else if (genericLocale.getLanguage().length() > 0) {
            return -1;
        }
        if (specificLocale.getCountry().equals(genericLocale.getCountry())) {
            ++i;
        } else if (genericLocale.getCountry().length() > 0) {
            return -1;
        }
        if (specificLocale.getVariant().equals(genericLocale.getVariant())) {
            ++i;
        } else if (genericLocale.getVariant().length() > 0) {
            return -1;
        }
        return i;
    }

    public static boolean matchesDefaultLocale(Locale locale) {
        Locale systemLocale = Locale.getDefault();
        return LanguageUtils.matchesOrIsMoreSpecific(systemLocale.getLanguage(), locale.getLanguage()) && LanguageUtils.matchesOrIsMoreSpecific(systemLocale.getCountry(), locale.getCountry()) && LanguageUtils.matchesOrIsMoreSpecific(systemLocale.getVariant(), locale.getVariant());
    }

    private static boolean matchesOrIsMoreSpecific(String detailed, String generic) {
        return generic.length() == 0 || detailed.equals(generic);
    }
}

