/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class LicenseWindow
extends JDialog
implements VerificationListener {
    protected final URN URN;
    protected final LimeXMLDocument DOCUMENT;
    protected final License LICENSE;
    protected final JPanel DETAILS;
    protected final VerificationListener LISTENER;
    protected final String KEY_VALUE;

    public static LicenseWindow create(License l, URN u, LimeXMLDocument d, VerificationListener v) {
        String name = l.getLicenseName();
        if ("Creative Commons License".equals(name)) {
            return new CCWindow(l, u, d, v);
        }
        if ("Weed License".equals(name)) {
            return new WeedWindow(l, u, d, v);
        }
        return new UnknownWindow(l, u, d, v);
    }

    private LicenseWindow(License license, URN urn, LimeXMLDocument document, VerificationListener listener, String keyValue) {
        super(GUIMediator.getAppFrame());
        this.URN = urn;
        this.LICENSE = license;
        this.DETAILS = new JPanel(new GridBagLayout());
        this.LISTENER = listener;
        this.KEY_VALUE = keyValue;
        this.DOCUMENT = document;
        this.setModal(false);
        this.setResizable(false);
        this.setTitle(this.getTitleString());
        this.setDefaultCloseOperation(2);
        JComponent pane = (JComponent)this.getContentPane();
        GUIUtils.addHideAction(pane);
        pane.setPreferredSize(new Dimension(400, 230));
        this.DETAILS.setPreferredSize(new Dimension(400, 210));
        this.getContentPane().setLayout(new GridBagLayout());
        this.constructDialog(this.getContentPane());
        this.validate();
    }

    public void licenseVerified(License license) {
        if (license == this.LICENSE) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LicenseWindow.this.buildDetails();
                }
            });
        }
        if (this.LISTENER != null) {
            this.LISTENER.licenseVerified(license);
        }
    }

    protected void createVerifying() {
        GridBagConstraints c = new GridBagConstraints();
        JTextArea text = this.newTextArea(this.getLocatingString());
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.DETAILS.add((Component)text, c);
    }

    protected void createNotVerified() {
        GridBagConstraints c = new GridBagConstraints();
        JTextArea text = this.newTextArea(this.getNotVerifiedString());
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        this.DETAILS.add((Component)text, c);
        JButton button = new JButton(this.getVerifyString());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                GuiCoreMediator.getLicenseVerifier().verify(LicenseWindow.this.LICENSE, LicenseWindow.this);
                LicenseWindow.this.buildDetails();
            }
        });
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 16;
        this.DETAILS.add((Component)button, c);
    }

    protected void createNotValid() {
        GridBagConstraints c = new GridBagConstraints();
        URI licenseURI = this.LICENSE.getLicenseURI();
        JComponent comp = new JLabel(this.getWarningIcon());
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 5);
        this.DETAILS.add((Component)comp, c);
        String invalidText = this.getInvalidString();
        if (licenseURI != null && this.allowRetryLink()) {
            invalidText = invalidText + "  " + this.getRetryString();
        }
        comp = this.newTextArea(invalidText);
        c.gridwidth = 0;
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(7, 0, 0, 0);
        this.DETAILS.add((Component)comp, c);
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.DETAILS.add(Box.createGlue(), c);
        JButton button = new JButton(this.getVerifyString());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                GuiCoreMediator.getLicenseVerifier().verify(LicenseWindow.this.LICENSE, LicenseWindow.this);
                LicenseWindow.this.buildDetails();
            }
        });
        button.setVisible(licenseURI != null && this.allowVerifyLookup());
        c.gridwidth = -1;
        c.gridheight = 2;
        c.fill = 0;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 100);
        this.DETAILS.add((Component)button, c);
        if (this.LICENSE.getLicenseDeed(this.URN) == null || !this.allowClaimedDeedLink()) {
            comp = new JLabel();
            comp.setVisible(false);
        } else {
            comp = new URLLabel(this.LICENSE.getLicenseDeed(this.URN), this.getClaimedDeedString());
        }
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 3, 0);
        this.DETAILS.add((Component)comp, c);
        if (licenseURI == null || !this.allowVerificationLink()) {
            comp = new JLabel();
            comp.setVisible(false);
        } else {
            comp = new URLLabel(licenseURI, this.getVerificationString());
        }
        c.insets = new Insets(0, 0, 3, 0);
        this.DETAILS.add((Component)comp, c);
    }

    protected void createValid() {
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(this.getDetailsString());
        Font f = label.getFont();
        label.setFont(new Font(f.getName(), 1, f.getSize()));
        c.fill = 2;
        c.gridwidth = 0;
        c.anchor = 18;
        this.DETAILS.add((Component)label, c);
        JTextArea text = this.newTextArea(this.LICENSE.getLicenseDescription(this.URN));
        c.gridwidth = -1;
        c.gridheight = 2;
        c.weighty = 1.0;
        c.weightx = 0.7;
        c.anchor = 18;
        c.fill = 1;
        this.DETAILS.add((Component)text, c);
        if (this.LICENSE.getLicenseDeed(this.URN) != null) {
            label = new URLLabel(this.LICENSE.getLicenseDeed(this.URN), this.getDeedString());
        } else {
            label = new JLabel();
            label.setVisible(false);
        }
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.weightx = 0.3;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 3, 0);
        this.DETAILS.add((Component)label, c);
        label = new URLLabel(this.LICENSE.getLicenseURI(), this.getVerificationString());
        this.DETAILS.add((Component)label, c);
    }

    protected void buildDetails() {
        this.DETAILS.removeAll();
        if (this.LICENSE.isVerifying()) {
            this.createVerifying();
        } else if (!this.LICENSE.isVerified()) {
            this.createNotVerified();
        } else if (!this.LICENSE.isValid(this.URN)) {
            this.createNotValid();
        } else {
            this.createValid();
        }
        this.validate();
        this.repaint();
    }

    protected void createTopOfWindow(Container parent) {
        GridBagConstraints c = new GridBagConstraints();
        URLLabel img = new URLLabel(this.getLargeLicenseURLString(), this.getLargeLicenseIcon());
        c.insets = new Insets(4, 4, 2, 0);
        parent.add((Component)img, c);
        Line line = new Line();
        c.insets = new Insets(0, 2, 0, 2);
        c.gridwidth = -1;
        c.fill = 3;
        parent.add((Component)line, c);
        JTextArea text = this.newTextArea(this.LICENSE.getLicense());
        c.gridwidth = 0;
        c.fill = 1;
        c.insets = new Insets(4, 0, 2, 4);
        parent.add((Component)text, c);
    }

    protected void constructDialog(Container parent) {
        this.createTopOfWindow(parent);
        GridBagConstraints c = new GridBagConstraints();
        Line line = new Line();
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 2, 0);
        parent.add((Component)line, c);
        this.buildDetails();
        c.gridwidth = 0;
        c.fill = 1;
        c.insets = new Insets(4, 4, 0, 4);
        c.weighty = 1.0;
        c.weightx = 1.0;
        parent.add((Component)this.DETAILS, c);
        line = new Line();
        c.gridwidth = 0;
        c.gridheight = -1;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 0);
        c.ipady = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        parent.add((Component)line, c);
        JButton button = new JButton(I18n.tr("OK"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LicenseWindow.this.dispose();
                LicenseWindow.this.setVisible(false);
            }
        });
        c.gridheight = 0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 4, 4);
        c.fill = 0;
        c.anchor = 13;
        parent.add((Component)button, c);
        this.pack();
    }

    private JTextArea newTextArea(String msg) {
        JTextArea text = new JTextArea();
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setEditable(false);
        text.setFont(UIManager.getFont("Table.font"));
        JLabel label = new JLabel();
        text.setForeground(label.getForeground());
        text.setBackground(label.getBackground());
        text.setText(msg);
        return text;
    }

    protected abstract String getTitleString();

    protected abstract String getLocatingString();

    protected abstract String getNotVerifiedString();

    protected String getVerifyString() {
        return I18n.tr("Verify");
    }

    protected Icon getWarningIcon() {
        return GUIMediator.getThemeImage("warning");
    }

    protected abstract String getInvalidString();

    protected abstract String getRetryString();

    protected abstract String getClaimedDeedString();

    protected abstract String getVerificationString();

    protected abstract String getDetailsString();

    protected abstract String getDeedString();

    protected Icon getLargeLicenseIcon() {
        return GUIMediator.getThemeImage(this.KEY_VALUE.toLowerCase() + "_window");
    }

    protected boolean allowRetryLink() {
        return true;
    }

    protected boolean allowVerificationLink() {
        return true;
    }

    protected boolean allowClaimedDeedLink() {
        return true;
    }

    protected boolean allowVerifyLookup() {
        return true;
    }

    protected abstract String getLargeLicenseURLString();

    private static class UnknownWindow
    extends LicenseWindow {
        UnknownWindow(License l, URN u, LimeXMLDocument d, VerificationListener v) {
            super(l, u, d, v, "UNKNOWN");
        }

        protected String getLargeLicenseURLString() {
            return "http://www.frostwire.com";
        }

        protected String getInvalidString() {
            return I18n.tr("This file may require a license in order to open and view.");
        }

        protected String getRetryString() {
            return I18n.tr("You can try validating this license again by clicking 'Verify'.");
        }

        protected String getClaimedDeedString() {
            return I18n.tr("View Claimed License Deed");
        }

        protected String getVerificationString() {
            return I18n.tr("View Verification Page");
        }

        protected String getDetailsString() {
            return I18n.tr("License Details:");
        }

        protected String getDeedString() {
            return I18n.tr("View License Deed");
        }

        protected String getLocatingString() {
            return I18n.tr("FrostWire is currently locating the details of this license.");
        }

        protected String getNotVerifiedString() {
            return I18n.tr("FrostWire has not yet verified this license.\nClick 'verify' to locate the details of this Creative Commons license.");
        }

        protected String getTitleString() {
            return I18n.tr("License Details");
        }

        protected Icon getLargeLicenseIcon() {
            return GUIMediator.getThemeImage("logo");
        }

        protected void createTopOfWindow(Container parent) {
            GridBagConstraints c = new GridBagConstraints();
            URLLabel img = new URLLabel(this.getLargeLicenseURLString(), this.getLargeLicenseIcon());
            c.insets = new Insets(4, 4, 2, 4);
            c.gridwidth = 0;
            c.fill = 1;
            parent.add((Component)img, c);
        }

        protected void buildDetails() {
            this.DETAILS.removeAll();
            this.createNotValid();
            this.validate();
            this.repaint();
        }

        protected boolean allowRetryLink() {
            return false;
        }

        protected boolean allowVerificationLink() {
            return false;
        }

        protected boolean allowClaimedDeedLink() {
            return false;
        }

        protected boolean allowVerifyLookup() {
            return false;
        }
    }

    private static class WeedWindow
    extends LicenseWindow {
        WeedWindow(License l, URN u, LimeXMLDocument d, VerificationListener v) {
            super(l, u, d, v, "WEED");
        }

        protected String getLargeLicenseURLString() {
            return "http://www.weedshare.com";
        }

        protected String getInvalidString() {
            return I18n.tr("FrostWire was unable to locate the details of this Weed file.");
        }

        protected String getRetryString() {
            return I18n.tr("You can try looking up the details again by clicking 'Verify'.");
        }

        protected String getClaimedDeedString() {
            return I18n.tr("View Weedshare Usage Rights");
        }

        protected String getVerificationString() {
            return I18n.tr("View Verification Page");
        }

        protected String getDetailsString() {
            return I18n.tr("License Details:");
        }

        protected String getDeedString() {
            return I18n.tr("View Usage Rights");
        }

        protected String getLocatingString() {
            return I18n.tr("FrostWire is contacting www.weedshare.com for the details of this file.");
        }

        protected String getNotVerifiedString() {
            return I18n.tr("FrostWire has not yet verified this license.\nClick 'verify' to locate the details of this file.");
        }

        protected String getTitleString() {
            return I18n.tr("Weedshare Details");
        }

        protected void createTopOfWindow(Container parent) {
            GridBagConstraints c = new GridBagConstraints();
            URLLabel img = new URLLabel(this.getLargeLicenseURLString(), this.getLargeLicenseIcon());
            c.insets = new Insets(4, 4, 2, 4);
            c.gridwidth = 0;
            c.fill = 1;
            parent.add((Component)img, c);
        }
    }

    private static class CCWindow
    extends LicenseWindow {
        CCWindow(License l, URN u, LimeXMLDocument d, VerificationListener v) {
            super(l, u, d, v, "CC");
        }

        protected String getLargeLicenseURLString() {
            return "http://www.creativecommons.org";
        }

        protected String getInvalidString() {
            return I18n.tr("FrostWire was unable to locate the details of this license.");
        }

        protected String getRetryString() {
            return I18n.tr("You can try validating this license again by clicking 'Verify'.");
        }

        protected String getClaimedDeedString() {
            return I18n.tr("View Claimed License Deed");
        }

        protected String getVerificationString() {
            return I18n.tr("View Verification Page");
        }

        protected String getDetailsString() {
            return I18n.tr("License Details:");
        }

        protected String getDeedString() {
            return I18n.tr("View License Deed");
        }

        protected String getLocatingString() {
            return I18n.tr("FrostWire is currently locating the details of this license.");
        }

        protected String getNotVerifiedString() {
            return I18n.tr("FrostWire has not yet verified this license.\nClick 'verify' to locate the details of this Creative Commons license.");
        }

        protected String getTitleString() {
            return I18n.tr("Creative Commons Details");
        }
    }
}

